/*
 * Decompiled with CFR 0.152.
 */
package relaxer.pdoc;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.pdoc.RStack;
import relaxer.pdoc.UJAXP;
import relaxer.pdoc.URelaxer;

public class PdocToken
implements Serializable,
Cloneable {
    private String content_;
    private String phoneme_;
    private String sym_;

    public PdocToken() {
        this.phoneme_ = "";
    }

    public PdocToken(PdocToken pdocToken) {
        this.setup(pdocToken);
    }

    public PdocToken(RStack rStack) {
        this.setup(rStack);
    }

    public PdocToken(Document document) {
        this.setup(document.getDocumentElement());
    }

    public PdocToken(Element element) {
        this.setup(element);
    }

    public PdocToken(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public PdocToken(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(string);
    }

    public PdocToken(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uRL);
    }

    public PdocToken(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputStream);
    }

    public PdocToken(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputSource);
    }

    public PdocToken(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(PdocToken pdocToken) {
        this.setContent(pdocToken.getContent());
        this.setPhoneme(pdocToken.getPhoneme());
        this.setSym(pdocToken.getSym());
    }

    public void setup(Document document) {
        this.setup(document.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack rStack) {
        this.init(rStack.popElement());
    }

    private void init(Element element) {
        RStack rStack = new RStack(element);
        this.content_ = URelaxer.getElementPropertyAsString(element);
        this.phoneme_ = URelaxer.getAttributePropertyAsString(element, "phoneme");
        this.sym_ = URelaxer.getAttributePropertyAsString(element, "sym");
    }

    public Object clone() {
        return new PdocToken(this);
    }

    public void makeElement(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElement("token");
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.phoneme_ != null) {
            URelaxer.setAttributePropertyByString(element, "phoneme", this.phoneme_);
        }
        if (this.sym_ != null) {
            URelaxer.setAttributePropertyByString(element, "sym", this.sym_);
        }
        node.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(string, 0));
    }

    public void setup(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uRL, 0));
    }

    public void setup(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputStream, 0));
    }

    public void setup(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputSource, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document document = UJAXP.makeDocument();
        this.makeElement(document);
        return document;
    }

    public final String getContent() {
        return this.content_;
    }

    public final void setContent(String string) {
        this.content_ = string;
    }

    public final String getPhoneme() {
        return this.phoneme_;
    }

    public final void setPhoneme(String string) {
        this.phoneme_ = string;
    }

    public final String getSym() {
        return this.sym_;
    }

    public final void setSym(String string) {
        this.sym_ = string;
    }

    public String makeTextDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeTextElement(stringBuffer);
        return new String(stringBuffer);
    }

    public void makeTextElement(StringBuffer stringBuffer) {
        stringBuffer.append("<token");
        if (this.phoneme_ != null) {
            stringBuffer.append(" phoneme=\"");
            stringBuffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPhoneme())));
            stringBuffer.append("\"");
        }
        if (this.sym_ != null) {
            stringBuffer.append(" sym=\"");
            stringBuffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSym())));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        stringBuffer.append("</token>");
    }

    public void makeTextElement(Writer writer) throws IOException {
        writer.write("<token");
        if (this.phoneme_ != null) {
            writer.write(" phoneme=\"");
            writer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPhoneme())));
            writer.write("\"");
        }
        if (this.sym_ != null) {
            writer.write(" sym=\"");
            writer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSym())));
            writer.write("\"");
        }
        writer.write(">");
        writer.write(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        writer.write("</token>");
    }

    public void makeTextElement(PrintWriter printWriter) {
        printWriter.print("<token");
        if (this.phoneme_ != null) {
            printWriter.print(" phoneme=\"");
            printWriter.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPhoneme())));
            printWriter.print("\"");
        }
        if (this.sym_ != null) {
            printWriter.print(" sym=\"");
            printWriter.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSym())));
            printWriter.print("\"");
        }
        printWriter.print(">");
        printWriter.print(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        printWriter.print("</token>");
    }

    public void makeTextAttribute(StringBuffer stringBuffer) {
    }

    public void makeTextAttribute(Writer writer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter printWriter) {
    }

    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getPhonemeAsString() {
        return URelaxer.getString(this.getPhoneme());
    }

    public String getSymAsString() {
        return URelaxer.getString(this.getSym());
    }

    public void setContentByString(String string) {
        this.setContent(string);
    }

    public void setPhonemeByString(String string) {
        this.setPhoneme(string);
    }

    public void setSymByString(String string) {
        this.setSym(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "token")) {
            return false;
        }
        RStack rStack = new RStack(element);
        boolean bl = false;
        if (!URelaxer.hasAttributeHungry(rStack, "phoneme")) {
            return false;
        }
        bl = true;
        return rStack.isEmptyElement();
    }

    public static boolean isMatch(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        return PdocToken.isMatch(element);
    }

    public static boolean isMatchHungry(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        if (PdocToken.isMatch(element)) {
            rStack.popElement();
            return true;
        }
        return false;
    }
}

