/*
 * Decompiled with CFR 0.152.
 */
package relaxer.vxml20;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import relaxer.vxml20.IGramItemMixed;
import relaxer.vxml20.IGramItemMixedChoice;
import relaxer.vxml20.IGramRuleMixed;
import relaxer.vxml20.IGramRuleMixedChoice;
import relaxer.vxml20.IRNSContainer;
import relaxer.vxml20.IRNode;
import relaxer.vxml20.IRVisitable;
import relaxer.vxml20.IRVisitor;
import relaxer.vxml20.RNSContext;
import relaxer.vxml20.RStack;
import relaxer.vxml20.UJAXP;
import relaxer.vxml20.URelaxer;
import relaxer.vxml20.URelaxer2;

public class GramToken
implements Serializable,
Cloneable,
IRNSContainer,
IRVisitable,
IRNode,
IGramItemMixed,
IGramItemMixedChoice,
IGramRuleMixed,
IGramRuleMixedChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS");
    private String content_;
    private String phoneme_;
    private String sym_;
    private IRNode parentRNode_;

    public GramToken() {
    }

    public GramToken(GramToken gramToken) {
        this.setup(gramToken);
    }

    public GramToken(RStack rStack) {
        this.setup(rStack);
    }

    public GramToken(Document document) {
        this.setup(document.getDocumentElement());
    }

    public GramToken(Element element) {
        this.setup(element);
    }

    public GramToken(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public GramToken(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(string);
    }

    public GramToken(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uRL);
    }

    public GramToken(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputStream);
    }

    public GramToken(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(inputSource);
    }

    public GramToken(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(GramToken gramToken) {
        this.setContent(gramToken.getContent());
        this.setPhoneme(gramToken.getPhoneme());
        this.setSym(gramToken.getSym());
    }

    public void setup(Document document) {
        this.setup(document.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack rStack) {
        this.init(rStack.popElement());
    }

    private void init(Element element) {
        RStack rStack = new RStack(element);
        this.rNSContext_.declareNamespace(element);
        this.content_ = URelaxer.getElementPropertyAsString(element);
        this.phoneme_ = URelaxer.getAttributePropertyAsString(element, "phoneme");
        this.sym_ = URelaxer.getAttributePropertyAsString(element, "sym");
    }

    public Object clone() {
        return new GramToken(this);
    }

    public void makeElement(Node node) {
        Document document = node instanceof Document ? (Document)node : node.getOwnerDocument();
        Element element = document.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS", "token");
        this.rNSContext_.setupNamespace(element);
        URelaxer.setElementPropertyByString(element, this.content_);
        if (this.phoneme_ != null) {
            URelaxer.setAttributePropertyByString(element, "phoneme", this.phoneme_);
        }
        if (this.sym_ != null) {
            URelaxer.setAttributePropertyByString(element, "sym", this.sym_);
        }
        node.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String string) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(string, 2));
    }

    public void setup(URL uRL) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uRL, 2));
    }

    public void setup(InputStream inputStream) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputStream, 2));
    }

    public void setup(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(inputSource, 2));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 2));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document document = UJAXP.makeDocument();
        this.makeElement(document);
        return document;
    }

    public final RNSContext rGetRNSContext() {
        return this.rNSContext_;
    }

    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    public final String getContent() {
        return this.content_;
    }

    public final void setContent(String string) {
        this.content_ = string;
    }

    public final String getPhoneme() {
        return this.phoneme_;
    }

    public final void setPhoneme(String string) {
        this.phoneme_ = string;
    }

    public final String getSym() {
        return this.sym_;
    }

    public final void setSym(String string) {
        this.sym_ = string;
    }

    public String makeTextDocument() {
        StringBuffer stringBuffer = new StringBuffer();
        this.makeTextElement(stringBuffer);
        return new String(stringBuffer);
    }

    public void makeTextElement(StringBuffer stringBuffer) {
        String string = this.rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS");
        stringBuffer.append("<");
        URelaxer.makeQName(string, "token", stringBuffer);
        this.rNSContext_.makeNSMappings(stringBuffer);
        if (this.phoneme_ != null) {
            stringBuffer.append(" ");
            stringBuffer.append("phoneme");
            stringBuffer.append("=\"");
            stringBuffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPhoneme())));
            stringBuffer.append("\"");
        }
        if (this.sym_ != null) {
            stringBuffer.append(" ");
            stringBuffer.append("sym");
            stringBuffer.append("=\"");
            stringBuffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSym())));
            stringBuffer.append("\"");
        }
        stringBuffer.append(">");
        stringBuffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        stringBuffer.append("</");
        URelaxer.makeQName(string, "token", stringBuffer);
        stringBuffer.append(">");
    }

    public void makeTextElement(Writer writer) throws IOException {
        String string = this.rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS");
        writer.write("<");
        URelaxer.makeQName(string, "token", writer);
        this.rNSContext_.makeNSMappings(writer);
        if (this.phoneme_ != null) {
            writer.write(" ");
            writer.write("phoneme");
            writer.write("=\"");
            writer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPhoneme())));
            writer.write("\"");
        }
        if (this.sym_ != null) {
            writer.write(" ");
            writer.write("sym");
            writer.write("=\"");
            writer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSym())));
            writer.write("\"");
        }
        writer.write(">");
        writer.write(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        writer.write("</");
        URelaxer.makeQName(string, "token", writer);
        writer.write(">");
    }

    public void makeTextElement(PrintWriter printWriter) {
        String string = this.rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS");
        printWriter.print("<");
        URelaxer.makeQName(string, "token", printWriter);
        this.rNSContext_.makeNSMappings(printWriter);
        if (this.phoneme_ != null) {
            printWriter.print(" ");
            printWriter.print("phoneme");
            printWriter.print("=\"");
            printWriter.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getPhoneme())));
            printWriter.print("\"");
        }
        if (this.sym_ != null) {
            printWriter.print(" ");
            printWriter.print("sym");
            printWriter.print("=\"");
            printWriter.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getSym())));
            printWriter.print("\"");
        }
        printWriter.print(">");
        printWriter.print(URelaxer.escapeCharData(URelaxer.getString(this.getContent())));
        printWriter.print("</");
        URelaxer.makeQName(string, "token", printWriter);
        printWriter.print(">");
    }

    public void makeTextAttribute(StringBuffer stringBuffer) {
    }

    public void makeTextAttribute(Writer writer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter printWriter) {
    }

    public String getContentAsString() {
        return URelaxer.getString(this.getContent());
    }

    public String getPhonemeAsString() {
        return URelaxer.getString(this.getPhoneme());
    }

    public String getSymAsString() {
        return URelaxer.getString(this.getSym());
    }

    public void setContentByString(String string) {
        this.setContent(string);
    }

    public void setPhonemeByString(String string) {
        this.setPhoneme(string);
    }

    public void setSymByString(String string) {
        this.setSym(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception exception) {
            return super.toString();
        }
    }

    public boolean enter(IRVisitor iRVisitor) {
        return iRVisitor.enter(this);
    }

    public void leave(IRVisitor iRVisitor) {
        iRVisitor.leave(this);
    }

    public final IRNode rGetParentRNode() {
        return this.parentRNode_;
    }

    public final void rSetParentRNode(IRNode iRNode) {
        this.parentRNode_ = iRNode;
    }

    public IRNode[] rGetRNodes() {
        ArrayList arrayList = new ArrayList();
        IRNode[] iRNodeArray = new IRNode[arrayList.size()];
        return arrayList.toArray(iRNodeArray);
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/SRGS", "token")) {
            return false;
        }
        RStack rStack = new RStack(element);
        boolean bl = false;
        return rStack.isEmptyElement();
    }

    public static boolean isMatch(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        return GramToken.isMatch(element);
    }

    public static boolean isMatchHungry(RStack rStack) {
        Element element = rStack.peekElement();
        if (element == null) {
            return false;
        }
        if (GramToken.isMatch(element)) {
            rStack.popElement();
            return true;
        }
        return false;
    }
}

