/* -*- Mode: java; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 *
 *  $Id: Phoenix.java,v 1.38 2003/08/18 06:53:22 nishi Exp $
 */

import java.util.*;
import java.io.*;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import main.*;
import util.*;
import document.*;

public class Phoenix
{
    public static final String COPYRIGHT = 
        "(c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)\n"
        + "Uses Mozilla Rhino from mozilla.org.\n"
        + "See http://www.mozilla.org/rhino/.\n";

    public static final String NAME = "Galatea Dialog Manager 1.0.1 ";

    public static void showVersion() {
	System.out.println(NAME + Tstamp.TSTAMP);
	System.out.print(COPYRIGHT);
	System.out.println();
    }

    public static void showUsage() {
        // System.out.println("Usage:\tjava Phoenix -c phoenix.conf document.vxml");
        System.out.println("Usage:\tgalatea [options] document.vxml");
        System.out.println("\t -v : show version");
        System.out.println("\t -p : print translation results");
        System.out.println();
    }

    public static void main(String argv[])
    {
	String conf = "phoenix.conf";
	boolean isPrintOnly = false;

	Getopt g = new Getopt("", argv, "c:p");
	g.setOpterr(false);
	int c;
	while ((c = g.getopt()) != -1){
	    switch (c)	{
	    case 'c':
		conf = g.getOptarg();
		break;
	    case 'p':
		isPrintOnly = true;
		break;
	    }
	}

	File conffile = new File(conf);
	if(!conffile.canRead()) {
	    System.err.println("Cannot read configration file.");
	    System.exit(1);
	}

	if (argv.length - g.getOptind() != 1){
	    showVersion();
	    showUsage();
	    System.exit(1);
	}

	try {
	    Properties props = new Properties(System.getProperties());
	    props.load(new FileInputStream(conffile));
	    System.setProperties(props);
	} catch(Exception e) {
	    e.printStackTrace();
	    System.exit(1);
	}

	if ( isPrintOnly ) {
	    DocLoader.convert(argv[g.getOptind()]);
	    System.exit(0);
	}

	String s;
	s = System.getProperty("ShowVersion", "1");
	if ( Integer.parseInt(s) != 0 ) {
	    showVersion();
	}

	s = System.getProperty("EnableTerminate", "0");
	boolean enableTerminate = false;
	if ( Integer.parseInt(s) != 0 ) {
	    enableTerminate = true;
	}

	Debug dbg = new Debug("Phoenix");

	try {
	    String filename = argv[g.getOptind()];
	    InteractionControler ic = new InteractionControler();
	    while ( filename.length() > 0 ) {
		// todo: app_root Υƥȴ
		dbg.print("Phoenix: filename:" + filename);
		ic.loadDocument(filename);
		ic.mainLoop();
		String nf = ic.getNextDocFile();
		if ( nf.length() > 0 ) {
		    dbg.print("Phoenix: nf:" + nf);
		    filename = Util.resolveAdrs(filename, nf);
		} else {
		    filename = "";
		}
	    }
	    if ( enableTerminate ) {
		ic.terminate();
	    }
	} catch(DocError e){
	    System.err.println();
	    System.err.println(e);
	    System.err.println("Document error.");
	} catch(org.xml.sax.SAXParseException e){
	    e.printStackTrace();
	} catch(java.io.FileNotFoundException e){
	    System.err.println();
	    System.err.println("File not found.");
	} catch(java.lang.Exception e){
	    e.printStackTrace();
	}

	if ( enableTerminate ) {
	    System.err.println("Dialog Manager Terminated.");
	    System.exit(0);
	} else {
	    Util.halt();
	}
    }

}
