/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: GotoCommand.java,v 1.3 2003/07/25 09:56:33 nishi Exp $
 */

package command;
import outitem.*;
import scripting.*;
import main.*;

public class GotoCommand extends Command
{
    private Debug dbg = new Debug(1);

    private String next_;

    public GotoCommand(String next)
    {
	next_ = next;
    }

    public GotoCommand(String next, String cond)
    {
	next_ = next;
	setCondition(cond);
    }

    public String getNext()
    {
	return(next_);
    }


    public String toString()
    {
	String s = "  <goto";
	if ( hasCondition() ) {
	    s += " cond=\"" + getConditionAsEncodedString() + "\"";
	}
	s += ">";
	s += next_ + "</goto>";
	return s;
    }


    public void execute(InteractionControler ic)
    {
	String state = scripting.ECMAScript.doEvaluate(next_);
	
	if ( evaluateCondition() == true ) {
	    ic.gotoState(state);
	}
    }

}
