/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: AMThread.java,v 1.19 2003/08/21 07:32:16 nishi Exp $
 */
package main;

import java.util.regex.*;
import java.io.*;
import relaxer.vxml20.*;
import util.*;
import outitem.*;

public class AMThread extends Thread implements OutputDevice, InputDevice
{
    private int srmstate = 30; // not prepared
    //
    // 30 : initRecog ¹ 
    // 20 : initRecog ¹Ը LISTEN Ե
    // 10 : to @SIM set SRM_XXX ¹Ը LISTEN Ե
    //  0 : LISTEN λ
    //

    private Debug dbg = new Debug("AMThread", 0);
    private DeviceListener recoglistener_;
    private DeviceListener synthlistener_;
    private SubProcess sp_;
    private String grammar_path = "";
    private boolean showStdErr_ = false;

    private String AMCom_;

    private VxmlBlock initOutputCmd_ = null;
    private VxmlBlock initRecogCmd_ = null;

    private void _loadSubmoduleConfigFile(String scfile)
    {
	try { 
	    //dbg.print("AMT:scfile " + scfile);
	    VxmlVxml vxml = new VxmlVxml(scfile);
	    //dbg.print("AMT:scfile.vxml " + vxml.toString());
	    for ( int i = 0; i < vxml.sizeContent(); i++ ) {
		if ( vxml.getContent(i) instanceof VxmlForm ) {
		    VxmlForm form = (VxmlForm)vxml.getContent(i);
		    if (form.getId().equals("initOutput")) {
			dbg.print("AMT: loadSubmoduleConfig: initOutput");
			initOutputCmd_ = (VxmlBlock)(form.getContent(0));
		    } else if (form.getId().equals("initRecog")) {
			dbg.print("AMT: loadSubmoduleConfig: initRecog");
			initRecogCmd_ = (VxmlBlock)(form.getContent(0));
		    } 
		}
	    }
	} catch (Exception e) {e.printStackTrace();}
    }

    public AMThread()
    {
	String scfile = System.getProperty("SubmoduleConfigFile");
	if (scfile != null) {
	    _loadSubmoduleConfigFile(scfile);
	}

	String showerr = System.getProperty("AMThread.ShowStdErr");
	if (showerr != null && showerr.equals("1")) {
	    showStdErr_ = true;
	    dbg.print("AMT: ShowStdErr = true");
	}

	String amcom = System.getProperty("AMCommand");
	if (amcom == null) {
	    Util.halt("AMThread(): Cannot run AM");
	}
	dbg.print("AMT: AMCommand = "+ amcom);
	AMCom_ = amcom;
	sp_ = new SubProcess(AMCom_);

	if(!sp_.Run()) {
	    Util.halt("AMThread(): Cannot run AM; " + AMCom_);
	}

	setName("Thread-AM");

	_initAgent();

	if ( srmstate == 30 ) {
	    _initRecog();
	    srmstate = 20;
	}

	String s = System.getProperty("AMThread.StartupWait", "10.0");
	int waitms = (int)(Double.parseDouble(s) * 1000.0);
	dbg.print("AMT: StartupWait " + waitms);
	try { 
	    Thread.sleep(waitms);
 	} catch (Exception e) {e.printStackTrace();}

    }


    public boolean isReady()
    {
	if ( srmstate == 20 )
	    return false;
	return true;
    }

    public boolean isListening()
    {
	if ( srmstate != 0 )
	    return false;
	return true;
    }

    private String _getNativeAsString(IVxmlBlockMixed bm)
    {
	String ret = "";
	if ( bm instanceof VxmlNative ) {
	    VxmlNative nt = (VxmlNative)bm;
	    for ( int i = 0; i < nt.sizeContent(); i++ ) {
		if (nt.getContent(i) instanceof RString) {
		    ret += ((RString)(nt.getContent(i))).getText();
		}
	    }
	}
	return ret;
    }

    private void _outputNative(VxmlBlock block)
    {
	//dbg.print(block.toString());
	for ( int i = 0; i < block.sizeContent(); i++ ) {
	    String str = _getNativeAsString(block.getContent(i));
	    if (str.length() > 0) {
		outputNative(str);
	    }
	}
    }

    // SSM/FSM 
    //
    private void _initAgent()
    {
	_outputNative(initOutputCmd_);
    }
	
    // SRM 
    //
    private void _initRecog() 
    {
	_outputNative(initRecogCmd_);
    }

    public void setInputListener(DeviceListener l)
    {
	recoglistener_ = l;
    }

    public void setOutputListener(DeviceListener l)
    {
	synthlistener_ = l;
    }

    public void outputDeviceStart(OutItem obj)
    {
	if (obj instanceof VoiceOutItem) {
	    VoiceOutItem o = (VoiceOutItem)obj;
	    outputSpeak(o.getArg());
	} else if (obj instanceof AudioOutItem) {
	    AudioOutItem o = (AudioOutItem)obj;
	    outputAudio(o.getArg());
	} else if (obj instanceof LogOutItem) {
	    LogOutItem o = (LogOutItem)obj;
	    outputLog(o.getArg());
	} else if (obj instanceof NativeOutItem) {
	    NativeOutItem o = (NativeOutItem)obj;
	    outputNative(o.getArg());
	}
    }

    public void outputNative(String str)
    {
	dbg.print(str);
	sp_.ToStdin(str);

	// outputNative  Syslog ˽Ϥ
	String lines[] = str.split("\n");
	for (int i = 0; i < lines.length; i++) {
	    sp_.ToStdin("to @MON set SysLogText = " + lines[i]);
	}
    }

    public void outputSpeak(String str)
    {
	outputNative("to @AM-MCL set Speak = " + str);
    }

    public void outputAudio(String str)
    {
	outputNative("to @SND set Play = " + str);
    }

    public void outputLog(String str)
    {
	outputNative("to @MON set AppLogText = " + str);
    }

    public void outputDeviceStop()
    {
	outputNative("to @AM-MCL set Speak = STOP");
    }

    public void setSpeaker(String str)
    {
	outputNative("to @SSM set Speaker = " + str);
    }

    /**
     * return true : wait for ready needed.
     * return false: ignored
     */
    public synchronized boolean prepareGrammar(GrammarSet gs)
    {
	dbg.print("AMT: prepareGrammar: " + gs);

	if (srmstate == 30 || srmstate == 20) {
	    dbg.print("AMT: prepareGrammar: ignored (srmstate" + srmstate +")");
	    return false;
	}

	if ( gs.getJulian() == true ) {
	    String gram = gs.getJulianGramName();
	    if (gram == null) {
		//dbg.print("AMT: prepareGrammar: gram == null");
		return false;
	    } 
	    outputNative("to @SIM set SRM_Julian = " + gram);
	    srmstate = 10;

	} else {

	    String gramStr = gs.getSRMGramStr();
	    if ( gramStr == null ) {
		//dbg.print("AMT: prepareGrammar: gramStr == null");
		return false;
	    }
	    outputNative("to @SIM set SRM_XML_String = " + gramStr);
	    srmstate = 10;
	}
	dbg.print("AMT: prepareGrammar: waiting for LISTEN");
	return true;
    }

    // returns
    //  true  : repeat
    //  false : quit 
    private synchronized boolean iteration()
    {
	if(recoglistener_ == null) {
	    dbg.err("AMThread.run(): recoglistener not set");
	    return false;
	}
	if(synthlistener_ == null) {
	    dbg.err("AMThread.run(): synthlistener not set");
	    return false;
	}

	String str;
	String srmtag = "", srmgrp;

	while((str = sp_.FromStderrNB()) != "") {
	    if(str == null) {
		dbg.print("AMT: *** sp_.FromStdoutNB() == null ***",2);
		return false;
	    } else {
		if (showStdErr_) {
		    dbg.print("AMT: (err) " + str);
		}
		if ( str.startsWith("Error:") ) {
		    return false;
		}
	    }
	}

	str = sp_.FromStdoutNB();
	if(str == null) {
	    dbg.print("AMT: *** sp_.FromStdout() == null ***",2);
	    return false;
	}
	if ( str.length() > 0 ) 
	    dbg.print("AMT: " + str);

	Pattern pListen = Pattern.compile("From \\@SIM\\s+tell\\s+status\\s+LISTEN$");
	if (pListen.matcher(str).matches()) {
	    if ( srmstate == 10 ) {
		dbg.print("AMT: SRM READY");
		srmstate = 0;
	    } 
	    if ( srmstate == 20 ) {
		dbg.print("AMT: SRM default grammar active");
		srmstate = 15;
	    }
	}

	/*
	if (srmstate == 20) {
	    dbg.print("AMT: still waiting for SRM READY",2);
	    return true;
	}
	*/

	Pattern pGrammarError = Pattern.compile("From \\@SIM\\s+tell\\s+status\\s+GRAMMAR_ERROR$");
	if (pGrammarError.matcher(str).matches()) {
	    Util.halt("GRAMMAR_ERROR");
	}

	// From @SIM tell status input start from XXX
	// perl.match("/From \\@SIM\\s+tell\\s+status INPUT_START(.*)$/", str)
	// str = perl.group(1);
	Pattern pSIMStart = Pattern.compile
	    ("From \\@SIM\\s+tell\\s+status INPUT_START (.*)$");
	Matcher mSIMStart = pSIMStart.matcher(str);
	if (mSIMStart.matches()) {
	    String g1 = mSIMStart.group(1);
	    dbg.print("AMT:SIM tell status INPUT_START " + g1);
	    recoglistener_.update
		(new DeviceEvent
		    (this, 
		     DeviceEvent.Type.INPUT,
		     DeviceEvent.State.BUSY,
		     g1)
		    );
	    notify();
	}
	
	// From @SIM tell result ǧ
	// perl.match("/From \\@SIM\\s+tell\\s+result\\s+(.*)$/", str)
	// srmsentence = perl.group(1);
	Pattern pSIMResult = Pattern.compile
	    ("From \\@SIM\\s+tell\\s+result\\s+(.*)$");
	Matcher mSIMResult = pSIMResult.matcher(str);
	if (mSIMResult.matches()) {
	    String srmsentence = mSIMResult.group(1);
	    dbg.print("AMT:SIM tell result " + srmsentence);
	    recoglistener_.update
		(new DeviceEvent
		    (this,
		     DeviceEvent.Type.INPUT,
		     DeviceEvent.State.READY,
		     srmsentence)
		    );
	    notify();
	    dbg.print("AMT:SIM tell result done.");
	}
	
	//
	// From @SSM rep Speak.stat = SPEAKING
	// From @SSM rep Speak.len = 2210
	// From @SSM rep Speak.utt = sil[290] i[75] ch[100] i[60] i[85] ...
	// From @SSM rep Speak.stat = IDLE
	//
	// perl.match("/From \\@SSM\\s+(.*)$/", str)
	// str = perl.group(1);
	// perl.match("/rep Speak.stat = (.*)$/", str)
	//
	Pattern pSSMSpeakStat = Pattern.compile
	    ("From \\@SSM\\s+rep Speak.stat = (.*)$");
	Matcher mSSMSpeakStat = pSSMSpeakStat.matcher(str);
	if (mSSMSpeakStat.matches()) {
	    String g1 = mSSMSpeakStat.group(1);
	    if ( g1.equals("IDLE") ) {
		synthlistener_.update
		    (new DeviceEvent
			(this,
			 DeviceEvent.Type.OUTPUT,
			 DeviceEvent.State.READY,
			 null)
			);
	    } else if ( g1.equals("ERROR") ) {
		synthlistener_.update
		    (new DeviceEvent
			(this,
			 DeviceEvent.Type.OUTPUT,
			 DeviceEvent.State.READY,
			 null)
			);
	    } else if ( g1.equals("PROCESSING") ) {
		synthlistener_.update
		    (new DeviceEvent
			(this,
			 DeviceEvent.Type.OUTPUT,
			 DeviceEvent.State.BUSY,
			 null)
			);
	    }
	}

	//
	// From @SND tell start sample.au
	// From @SND tell end sample.au
	//
	// perl.match("/From \\@SND tell start/", str)
	// perl.match("/From \\@SND tell end/", str)
	//
	Pattern pSNDTell = Pattern.compile
	    ("From \\@SND tell (\\S+) (.*)$");
	Matcher mSNDTell = pSNDTell.matcher(str);
	if (mSNDTell.matches()) {
	    String g1 = mSNDTell.group(1);
	    String g2 = mSNDTell.group(2);
	    if ( g1.equals("start") ) {
		synthlistener_.update
		    (new DeviceEvent
			(this,
			 DeviceEvent.Type.OUTPUT,
			 DeviceEvent.State.BUSY,
			 g2)
			);
	    } else if ( g1.equals("end") ) {
		synthlistener_.update
		    (new DeviceEvent
			(this,
			 DeviceEvent.Type.OUTPUT,
			 DeviceEvent.State.READY,
			 g2)
			);
	    }
	}
	return true;
    }

    // Runnable Interface
    public void run()
    {
	while(iteration()) {
	    try { 
		Thread.sleep(0, 1);
	    } catch (Exception e) {e.printStackTrace();}
	}
    }


    public void terminate()
    {
    /*
        // outputNative("to @SRM set Run = STOP");
	// outputNative("to @AM-MCL AM quit");

	_outputNative(terminateCmd_);

	try { 
	    Thread.sleep(2000);
 	} catch (Exception e) {e.printStackTrace();}

	sp_.destroy();
    */
    }

}
