/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: ConsoleThread.java,v 1.2 2003/07/25 09:56:34 nishi Exp $
 */
package main;

import java.io.*;

public class ConsoleThread extends Thread implements InputDevice
{

    Debug dbg = new Debug(9);
    private DeviceListener consolelistener_;
    private boolean term_;
    private BufferedReader reader_;

    public ConsoleThread()
    {

	reader_ = new BufferedReader(new InputStreamReader(System.in));

	setName("Thread-Console");
	
    }

    public void setInputListener(DeviceListener l)
    {

	consolelistener_ = l;

    }

    public void terminate()
    {
	
	try{System.in.close();}catch(Exception e){e.printStackTrace();}

    }

    public void run()
    {

	String str;

	for(;;) {

	    try{
		str = reader_.readLine();
	    }
	    catch(IOException e){
		str = null;
	    }
	    if(str == null)
		break;

	    consolelistener_.update(new DeviceEvent(this,
						    DeviceEvent.Type.INPUT,
						    DeviceEvent.State.BUSY,
						    null));
	    consolelistener_.update(new DeviceEvent(this,
						    DeviceEvent.Type.INPUT,
						    DeviceEvent.State.READY,
						    str));

	}

	dbg.print("ConsoleThread exitting...");

    }

}
