/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: Debug.java,v 1.3 2003/07/25 09:56:34 nishi Exp $
 */

package main;

public class Debug
{

    private int debuglevel;

    // level 0: most shallow
    public Debug(int level)
    {
	this.debuglevel = level;
    }

    public Debug(String name, int defaultLevel)
    {
	String s = System.getProperty("Debug." + name);
	if (s == null) {
	    this.debuglevel = defaultLevel;
	} else {
	    this.debuglevel = Integer.parseInt(s);
	}
    }

    public Debug(String name)
    {
	String s = System.getProperty("Debug." + name);
	if (s == null) {
	    this.debuglevel = 0;
	} else {
	    this.debuglevel = Integer.parseInt(s);
	}
    }

    public void Debug()
    {
	this.debuglevel = 0;
    }

    public void setLevel(int level)
    {

	this.debuglevel = level;

    }

    public int getLevel()
    {

	return(this.debuglevel);

    }


    public void print(String msg)
    {

	if(this.debuglevel != 0)
	    System.out.println(msg);

    }

    // level 0: most important
    public void print(String msg, int level)
    {

	if(this.debuglevel >= level)
	    System.out.println(msg);

    }

    public void err(String msg)
    {

	if(this.debuglevel != 0)
	    System.err.println(msg);

    }

    public void err(String msg, int level)
    {

	if(this.debuglevel >= level)
	    System.err.println(msg);

    }

    public void DIE(Exception e)
    {
	if(this.debuglevel != 0) {
	    System.out.println("DIE:");
	    e.printStackTrace();
	    System.exit(1);
	}
    }

    public void DIE(String msg)
    {
	if(this.debuglevel != 0) {
	    System.out.println("DIE: "+msg);
	    System.exit(1);
	}
    }

    public void ASSERT(boolean bool, String msg)
    {

	if(this.debuglevel != 0) {
	    if (bool == false) {
		System.out.println("ASSERTION FAILED: " + msg);
		System.exit(1);
	    }
	}
    }

    public void ASSERT(boolean bool, String msg, int level)
    {

	if(this.debuglevel >= level) {
	    if (bool == false) {
		System.out.println("ASSERTION FAILED: " + msg);
		System.exit(1);
	    }
	}
    }


    //
    // 1: this is shown.
    // 2: this is shown.
    // ASSERTION FAILED: 5: this is shown.
    //
    public static void main(String args[]) throws Exception
    {
	Debug dbg = new Debug(5);

	dbg.print("1: this is shown.", 4);
	dbg.print("2: this is shown.", 5);
	dbg.print("3: not shown.", 6);

	int a = 1;
	int b = 2;
	dbg.ASSERT( a == a, "4: not shown." );
	dbg.ASSERT( a == b, "5: this is shown.", 4 );
	dbg.ASSERT( a == b, "6: not shown.", 5 ); // not executed
	dbg.ASSERT( a == b, "7: not shown.", 6);  // not executed
    }
}
