/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: HttpManager.java,v 1.3 2003/07/25 09:56:34 nishi Exp $
 */

package main;

/*********************************** Ȥ ***********************************

SomeClass implements HttpManagerListener {

  HttpManager aHttpManager = HttpManager.getInstance(); // 󥹥󥹼

  someMethod1() {

    URL aURL = new URL("http://some/where/some.file");

    if(aHttpManager.isCached(aURL)) {   // å夵Ƥ뤫Ĵ٤
      // File f = aHttpManager.getFile(aURL);       // File
      String fn = aHttpManager.getFileName(aURL);   // ե̾
      doSomeThing(fn);
    }
    else {                              // å夵Ƥʤ
      httpm.fetchStart(aURL, this);     // եå
    }

  }

  someMethod2() {
    httpm.maskEvent(aURL); // եåλ٥ȤɬפʤʤХޥ
  }

  public updateHTTPMStatus(HttpManagerEvent evt) {
    URL aURL = evt.getUrl();
    String fn = aHttpManager.getFileName(aURL);  // ե̾
    doSomeThing(fn);
  }

******************************************************************************/

import java.util.*;
import java.net.*;
import java.io.*;

public class HttpManager
{

    private Map cacheMap_;
    private Map fetchingMap_;
    private static HttpManager httpm_;

    private HttpManager()
    {
	cacheMap_ = new HashMap(100);
	fetchingMap_ = new HashMap(10);
    }

    public static HttpManager getInstance()
    {

	if(httpm_ == null) {
	    httpm_ = new HttpManager();
	}
	
	return httpm_;

    }

    /*
    protected synchronized HttpManagerListener getListener()
    {
	return listener_;
    }
    
    public synchronized void setListener(HttpManagerListener l)
    {
	listener_ = l;
    }
    */
    public synchronized void store(URL url, String type, File file)
    {
	System.out.println("Stored file: " + url + " " + file.getPath());
	cacheMap_.put(url, new CachedFile(url, type, file));
	fetchingMap_.remove(url);
    }

    public synchronized boolean isCached(URL url)
    {
	return cacheMap_.containsKey(url);
    }

    public synchronized void purge(URL url)
    {
	if(cacheMap_.containsKey(url)) {
	    File f = ((CachedFile)cacheMap_.remove(url)).getFile();
	    if(f.isFile()) {
		f.delete();
	    }
	}
    }

    public synchronized File getFile(URL url)
    {
	CachedFile cf = (CachedFile)cacheMap_.get(url);
	if(cf != null)
	    return cf.getFile();
	else
	    return null;
    }

    public synchronized String getFileName(URL url)
    {
	CachedFile cf = (CachedFile)cacheMap_.get(url);
	if(cf != null)
	    return cf.getFile().getPath();
	else
	    return null;
    }

    public synchronized String getContentType(URL url)
    {
	CachedFile cf = (CachedFile)cacheMap_.get(url);
	if(cf != null)
	    return cf.getContentType();
	else {
	    return null;
	}
    }

    // public InputStream getDirectInputStream(URL) {}

    public synchronized void fetchStart(URL url, HttpManagerListener l)
    {
	FetchThread ft;
	Thread thd;

	ft = new FetchThread(url, this, l);
	fetchingMap_.put(url, ft);
	thd = new Thread(ft);
	thd.start();
	
    }

    public synchronized void maskEvent(URL url)
    {
	FetchThread ft;

	if((ft = (FetchThread)fetchingMap_.get(url)) != null)
	    ft.maskEvent();
    }

    public static void main(String[] args) throws Exception
    {

	URL url;
	Thread thd;
	FetchThread ft;

	if(args.length > 0) {

	    url = new URL(args[0]);
	    ft = new FetchThread(url);
	    thd = new Thread(ft);
	    thd.start();
	    thd.join();
	    System.in.read();

	}
	else {
	    System.out.println("No arg");
	}
    }
}

class CachedFile
{
    
    private URL url_;
    private String contentType_;
    private File file_;
    
    public CachedFile(URL url, String type, File file)
    {
	url_ = url;
	contentType_ = type;
	file_ = file;
    }

    public URL getUrl() { return url_; }
    public String getContentType() { return contentType_; }
    public File getFile() { return file_; }
    
}

class FetchThread implements Runnable
{
    
    private URL url_;
    private HttpManagerListener listener_;
    private HttpManager parent_;
    
    public FetchThread(URL url, HttpManager parent, HttpManagerListener l)
    {
	url_ = url;
	parent_ = parent;
	listener_ = l;
    }
    
    public FetchThread(URL url)  // for debug only
    {
	url_ = url;
    }

    public void maskEvent()
    {

	listener_ = null;

    }
    
    public void run()
    {
	
	File file;
	HttpURLConnection huc;
	BufferedInputStream is;
	BufferedOutputStream os;
	final int bufsize = 1024;
	byte[] buf = new byte[bufsize];
	int count = 0;
	
	try{
	    
	    file = File.createTempFile("PNX", ".tmp");
	    file.deleteOnExit();
	    System.out.println(file.getPath());
	    os = new BufferedOutputStream(new FileOutputStream(file), bufsize);
	    
	    huc = (HttpURLConnection) url_.openConnection();
	    huc.setRequestMethod("GET");
	    System.out.println(huc.getResponseCode());
	    is = new BufferedInputStream(huc.getInputStream(), bufsize);
	    
	    while(count != -1) {
		
		count = is.read(buf, 0, bufsize);
		
		if(count >= 0) {
		    os.write(buf, 0, count);
		}
		
	    }
	    
	    os.close();
	    is.close();
	    if(parent_ != null) {
		parent_.store(url_, huc.getContentType(), file);
		if(listener_ != null){
		    listener_.updateHTTPMStatus(
		      new HttpManagerEvent(parent_, url_));
		}	   
	    }
	    else {
		System.out.println("\n" + url_);
		System.out.println(huc.getContentType());
		System.out.println(file);
	    }
	    
	} 
	catch(Exception e) {
	    e.printStackTrace();
	}
	
    }

}
