/*
 * Galatea Dialog Manager:
 * (c)2003 Takuya NISHIMOTO (nishi@hil.t.u-tokyo.ac.jp)
 * Based on Phoenix By Takuya NISHIMOTO and Mitsuhiro KIZU
 *
 * $Id: OutQueueManager.java,v 1.3 2003/07/25 09:56:34 nishi Exp $
 */
package main;

import outitem.*;
import util.*;
import java.util.*;

public class OutQueueManager            
{
    private Debug dbg = new Debug("OQM", 0);

    private Vector queue_;                 // ϥ塼 Vector<OutItem>

    public OutQueueManager()               // 
    {

	queue_ = new Vector();

    }

    public synchronized void discard()     // 塼˴
    {

	queue_.clear();

    }

    // 塼˽ϥƥɲ
    public synchronized void enqueue(OutItem o)
    {
	queue_.add((Object)o);
	dbg.print("OQM: added " + o.getClass().getName() 
		  + ", total:" + queue_.size() );
    }

    // 塼ϥƥ
    public synchronized OutItem dequeue()  
    {

	OutItem ret;

	if(queue_.isEmpty()) {
	    return null;
	} else {
	    ret = (OutItem)queue_.remove(0);
	    dbg.print("OQM: removed " + ret.getClass().getName() 
		      + ", total:" + queue_.size() );
	    return ret;
	}

    }

    public synchronized void removeDelayedItems()
    {
	Vector newvec = new Vector();
	for (int i = 0; i < queue_.size(); i++ ) {
	    OutItem o = (OutItem)queue_.get(i);
	    if (o.isInstant()) {
		newvec.add(o);
	    }
	}
	queue_ = newvec;
    }

}
