package relaxer.pdoc;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PdocCatch</b> is generated from pdoc.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="catch">
 *   <optional>
 *     <attribute name="text">
 *       <data type="token"/>
 *     </attribute>
 *   </optional>
 *   <optional>
 *     <attribute name="object">
 *       <data type="token"/>
 *     </attribute>
 *   </optional>
 *   <zeroOrMore>
 *     <choice>
 *       <ref name="assign"/>
 *       <ref name="script"/>
 *       <ref name="goto"/>
 *     </choice>
 *   </zeroOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="catch"&gt;
 *   &lt;optional&gt;
 *     &lt;attribute name="text"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/attribute&gt;
 *   &lt;/optional&gt;
 *   &lt;optional&gt;
 *     &lt;attribute name="object"&gt;
 *       &lt;data type="token"/&gt;
 *     &lt;/attribute&gt;
 *   &lt;/optional&gt;
 *   &lt;zeroOrMore&gt;
 *     &lt;choice&gt;
 *       &lt;ref name="assign"/&gt;
 *       &lt;ref name="script"/&gt;
 *       &lt;ref name="goto"/&gt;
 *     &lt;/choice&gt;
 *   &lt;/zeroOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version pdoc.rng (Thu Aug 14 17:30:13 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class PdocCatch implements java.io.Serializable, Cloneable {
    private String text_;
    private String object_;
    // List<IPdocCatchChoice>
    private java.util.List content_ = new java.util.ArrayList();

    /**
     * Creates a <code>PdocCatch</code>.
     *
     */
    public PdocCatch() {
    }

    /**
     * Creates a <code>PdocCatch</code>.
     *
     * @param source
     */
    public PdocCatch(PdocCatch source) {
        setup(source);
    }

    /**
     * Creates a <code>PdocCatch</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PdocCatch(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PdocCatch</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PdocCatch(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PdocCatch</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PdocCatch(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PdocCatch</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCatch(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PdocCatch</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCatch(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PdocCatch</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCatch(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PdocCatch</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCatch(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PdocCatch</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCatch(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PdocCatch</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocCatch(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PdocCatch</code> by the PdocCatch <code>source</code>.
     *
     * @param source
     */
    public void setup(PdocCatch source) {
        int size;
        setText(source.getText());
        setObject(source.getObject());
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IPdocCatchChoice)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>PdocCatch</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PdocCatch</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PdocCatch</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        text_ = URelaxer.getAttributePropertyAsString(element, "text");
        object_ = URelaxer.getAttributePropertyAsString(element, "object");
        content_.clear();
        while (true) {
            if (PdocAssign.isMatch(stack)) {
                addContent(new PdocAssign(stack));
            } else if (PdocScript.isMatch(stack)) {
                addContent(new PdocScript(stack));
            } else if (PdocGoto.isMatch(stack)) {
                addContent(new PdocGoto(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new PdocCatch(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("catch");
        int size;
        if (this.text_ != null) {
            URelaxer.setAttributePropertyByString(element, "text", this.text_);
        }
        if (this.object_ != null) {
            URelaxer.setAttributePropertyByString(element, "object", this.object_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocCatchChoice value = (IPdocCatchChoice)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PdocCatch</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PdocCatch</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocCatch</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocCatch</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocCatch</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocCatch</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>text</b>.
     *
     * @return String
     */
    public final String getText() {
        return (text_);
    }

    /**
     * Sets the String property <b>text</b>.
     *
     * @param text
     */
    public final void setText(String text) {
        this.text_ = text;
    }

    /**
     * Gets the String property <b>object</b>.
     *
     * @return String
     */
    public final String getObject() {
        return (object_);
    }

    /**
     * Sets the String property <b>object</b>.
     *
     * @param object
     */
    public final void setObject(String object) {
        this.object_ = object;
    }

    /**
     * Gets the IPdocCatchChoice property <b>content</b>.
     *
     * @return IPdocCatchChoice[]
     */
    public final IPdocCatchChoice[] getContent() {
        IPdocCatchChoice[] array = new IPdocCatchChoice[content_.size()];
        return ((IPdocCatchChoice[])content_.toArray(array));
    }

    /**
     * Sets the IPdocCatchChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IPdocCatchChoice[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
    }

    /**
     * Sets the IPdocCatchChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IPdocCatchChoice content) {
        this.content_.clear();
        addContent(content);
    }

    /**
     * Adds the IPdocCatchChoice property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IPdocCatchChoice content) {
        this.content_.add(content);
    }

    /**
     * Adds the IPdocCatchChoice property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IPdocCatchChoice[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
    }

    /**
     * Gets number of the IPdocCatchChoice property <b>content</b>.
     *
     * @return int
     */
    public final int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IPdocCatchChoice property <b>content</b> by index.
     *
     * @param index
     * @return IPdocCatchChoice
     */
    public final IPdocCatchChoice getContent(int index) {
        return ((IPdocCatchChoice)content_.get(index));
    }

    /**
     * Sets the IPdocCatchChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void setContent(int index, IPdocCatchChoice content) {
        this.content_.set(index, content);
    }

    /**
     * Adds the IPdocCatchChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void addContent(int index, IPdocCatchChoice content) {
        this.content_.add(index, content);
    }

    /**
     * Remove the IPdocCatchChoice property <b>content</b> by index.
     *
     * @param index
     */
    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IPdocCatchChoice property <b>content</b> by object.
     *
     * @param content
     */
    public final void removeContent(IPdocCatchChoice content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IPdocCatchChoice property <b>content</b>.
     *
     */
    public final void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<catch");
        if (text_ != null) {
            buffer.append(" text=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getText())));
            buffer.append("\"");
        }
        if (object_ != null) {
            buffer.append(" object=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getObject())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocCatchChoice value = (IPdocCatchChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocCatchChoice value = (IPdocCatchChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</catch>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<catch");
        if (text_ != null) {
            buffer.write(" text=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getText())));
            buffer.write("\"");
        }
        if (object_ != null) {
            buffer.write(" object=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getObject())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocCatchChoice value = (IPdocCatchChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocCatchChoice value = (IPdocCatchChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</catch>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<catch");
        if (text_ != null) {
            buffer.print(" text=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getText())));
            buffer.print("\"");
        }
        if (object_ != null) {
            buffer.print(" object=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getObject())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocCatchChoice value = (IPdocCatchChoice)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IPdocCatchChoice value = (IPdocCatchChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</catch>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getTextAsString() {
        return (URelaxer.getString(getText()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getObjectAsString() {
        return (URelaxer.getString(getObject()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setTextByString(String string) {
        setText(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setObjectByString(String string) {
        setObject(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PdocCatch</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "catch")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (PdocAssign.isMatchHungry(target)) {
                $match$ = true;
            } else if (PdocScript.isMatchHungry(target)) {
                $match$ = true;
            } else if (PdocGoto.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocCatch</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocCatch</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
