package relaxer.pdoc;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>PdocGrammar</b> is generated from pdoc.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="grammar">
 *   <attribute name="version">
 *     <data type="float"/>
 *   </attribute>
 *   <oneOrMore>
 *     <ref name="rule"/>
 *   </oneOrMore>
 * </element>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;element name="grammar"&gt;
 *   &lt;attribute name="version"&gt;
 *     &lt;data type="float"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;oneOrMore&gt;
 *     &lt;ref name="rule"/&gt;
 *   &lt;/oneOrMore&gt;
 * &lt;/element&gt;
 * </pre>
 *
 * @version pdoc.rng (Thu Aug 14 17:30:12 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class PdocGrammar implements java.io.Serializable, Cloneable, IPdocHeadChoice {
    private float version_;
    // List<PdocRule>
    private java.util.List rule_ = new java.util.ArrayList();

    /**
     * Creates a <code>PdocGrammar</code>.
     *
     */
    public PdocGrammar() {
    }

    /**
     * Creates a <code>PdocGrammar</code>.
     *
     * @param source
     */
    public PdocGrammar(PdocGrammar source) {
        setup(source);
    }

    /**
     * Creates a <code>PdocGrammar</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public PdocGrammar(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>PdocGrammar</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public PdocGrammar(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>PdocGrammar</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public PdocGrammar(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>PdocGrammar</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocGrammar(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>PdocGrammar</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocGrammar(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>PdocGrammar</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocGrammar(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>PdocGrammar</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocGrammar(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>PdocGrammar</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocGrammar(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>PdocGrammar</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public PdocGrammar(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>PdocGrammar</code> by the PdocGrammar <code>source</code>.
     *
     * @param source
     */
    public void setup(PdocGrammar source) {
        int size;
        setVersion(source.getVersion());
        this.rule_.clear();
        size = source.rule_.size();
        for (int i = 0;i < size;i++) {
            addRule((PdocRule)source.getRule(i).clone());
        }
    }

    /**
     * Initializes the <code>PdocGrammar</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>PdocGrammar</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>PdocGrammar</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        version_ = URelaxer.getAttributePropertyAsFloat(element, "version");
        rule_.clear();
        while (true) {
            if (PdocRule.isMatch(stack)) {
                addRule(new PdocRule(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new PdocGrammar(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("grammar");
        int size;
        URelaxer.setAttributePropertyByFloat(element, "version", this.version_);
        size = this.rule_.size();
        for (int i = 0;i < size;i++) {
            PdocRule value = (PdocRule)this.rule_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>PdocGrammar</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>PdocGrammar</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocGrammar</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocGrammar</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocGrammar</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>PdocGrammar</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the float property <b>version</b>.
     *
     * @return float
     */
    public final float getVersion() {
        return (version_);
    }

    /**
     * Sets the float property <b>version</b>.
     *
     * @param version
     */
    public final void setVersion(float version) {
        this.version_ = version;
    }

    /**
     * Gets the PdocRule property <b>rule</b>.
     *
     * @return PdocRule[]
     */
    public final PdocRule[] getRule() {
        PdocRule[] array = new PdocRule[rule_.size()];
        return ((PdocRule[])rule_.toArray(array));
    }

    /**
     * Sets the PdocRule property <b>rule</b>.
     *
     * @param rule
     */
    public final void setRule(PdocRule[] rule) {
        this.rule_.clear();
        for (int i = 0;i < rule.length;i++) {
            addRule(rule[i]);
        }
    }

    /**
     * Sets the PdocRule property <b>rule</b>.
     *
     * @param rule
     */
    public final void setRule(PdocRule rule) {
        this.rule_.clear();
        addRule(rule);
    }

    /**
     * Adds the PdocRule property <b>rule</b>.
     *
     * @param rule
     */
    public final void addRule(PdocRule rule) {
        this.rule_.add(rule);
    }

    /**
     * Adds the PdocRule property <b>rule</b>.
     *
     * @param rule
     */
    public final void addRule(PdocRule[] rule) {
        for (int i = 0;i < rule.length;i++) {
            addRule(rule[i]);
        }
    }

    /**
     * Gets number of the PdocRule property <b>rule</b>.
     *
     * @return int
     */
    public final int sizeRule() {
        return (rule_.size());
    }

    /**
     * Gets the PdocRule property <b>rule</b> by index.
     *
     * @param index
     * @return PdocRule
     */
    public final PdocRule getRule(int index) {
        return ((PdocRule)rule_.get(index));
    }

    /**
     * Sets the PdocRule property <b>rule</b> by index.
     *
     * @param index
     * @param rule
     */
    public final void setRule(int index, PdocRule rule) {
        this.rule_.set(index, rule);
    }

    /**
     * Adds the PdocRule property <b>rule</b> by index.
     *
     * @param index
     * @param rule
     */
    public final void addRule(int index, PdocRule rule) {
        this.rule_.add(index, rule);
    }

    /**
     * Remove the PdocRule property <b>rule</b> by index.
     *
     * @param index
     */
    public final void removeRule(int index) {
        this.rule_.remove(index);
    }

    /**
     * Remove the PdocRule property <b>rule</b> by object.
     *
     * @param rule
     */
    public final void removeRule(PdocRule rule) {
        this.rule_.remove(rule);
    }

    /**
     * Clear the PdocRule property <b>rule</b>.
     *
     */
    public final void clearRule() {
        this.rule_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<grammar");
        buffer.append(" version=\"");
        buffer.append(URelaxer.getString(getVersion()));
        buffer.append("\"");
        buffer.append(">");
        size = this.rule_.size();
        for (int i = 0;i < size;i++) {
            PdocRule value = (PdocRule)this.rule_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</grammar>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<grammar");
        buffer.write(" version=\"");
        buffer.write(URelaxer.getString(getVersion()));
        buffer.write("\"");
        buffer.write(">");
        size = this.rule_.size();
        for (int i = 0;i < size;i++) {
            PdocRule value = (PdocRule)this.rule_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</grammar>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<grammar");
        buffer.print(" version=\"");
        buffer.print(URelaxer.getString(getVersion()));
        buffer.print("\"");
        buffer.print(">");
        size = this.rule_.size();
        for (int i = 0;i < size;i++) {
            PdocRule value = (PdocRule)this.rule_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</grammar>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getVersionAsString() {
        return (URelaxer.getString(getVersion()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setVersionByString(String string) {
        setVersion(Float.parseFloat(string));
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>PdocGrammar</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "grammar")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        if (!URelaxer.hasAttributeHungry(target, "version")) {
            return (false);
        }
        $match$ = true;
        if (!PdocRule.isMatchHungry(target)) {
            return (false);
        }
        $match$ = true;
        while (true) {
            if (!PdocRule.isMatchHungry(target)) {
                break;
            }
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocGrammar</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>PdocGrammar</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
