package relaxer.vxml20;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>VxmlChoice</b> is generated from vxml20.rxg by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="choice">
 *   <mixed>
 *     <choice occurs="*">
 *       <ref label="audio"/>
 *       <ref label="enumerate"/>
 *       <ref label="value"/>
 *       <hedgeRef label="grammarExtension"/>
 *       <ref label="break"/>
 *       <ref label="emphasis"/>
 *       <ref label="mark"/>
 *       <ref label="phoneme"/>
 *       <ref label="prosody"/>
 *       <ref label="say-as"/>
 *       <ref label="voice"/>
 *       <ref label="paragraph"/>
 *       <ref label="p"/>
 *       <ref label="sentence"/>
 *       <ref label="s"/>
 *       <ref label="emotion"/>
 *       <ref label="BOOKMARK"/>
 *       <ref label="CONTEXT"/>
 *       <ref label="EMPH"/>
 *       <ref label="LANG"/>
 *       <ref label="PARTOFSP"/>
 *       <ref label="PITCH"/>
 *       <ref label="PRON"/>
 *       <ref label="RATE"/>
 *       <ref label="REGWORD"/>
 *       <ref label="RESET"/>
 *       <ref label="SPELL"/>
 *       <ref label="SILENCE"/>
 *       <ref label="SPEECH"/>
 *       <ref label="VOICE"/>
 *       <ref label="VOLUME"/>
 *     </choice>
 *   </mixed>
 * </elementRule>
 * 
 * <tag name="choice">
 *   <attribute name="fetchhint" type="NMTOKEN">
 *     <enumeration value="prefetch"/>
 *     <enumeration value="safe"/>
 *   </attribute>
 *   <attribute name="fetchtimeout" type="string"/>
 *   <attribute name="maxage" type="string"/>
 *   <attribute name="maxstale" type="string"/>
 *   <attribute name="accept" type="NMTOKEN">
 *     <enumeration value="exact"/>
 *     <enumeration value="approximate"/>
 *   </attribute>
 *   <attribute name="dtmf" type="string"/>
 *   <attribute name="event" type="NMTOKEN"/>
 *   <attribute name="fetchaudio" type="string"/>
 *   <attribute name="next" type="string"/>
 *   <attribute name="expr" type="string"/>
 *   <attribute name="image" type="string"/>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="choice"&gt;
 *   &lt;mixed&gt;
 *     &lt;choice occurs="*"&gt;
 *       &lt;ref label="audio"/&gt;
 *       &lt;ref label="enumerate"/&gt;
 *       &lt;ref label="value"/&gt;
 *       &lt;hedgeRef label="grammarExtension"/&gt;
 *       &lt;ref label="break"/&gt;
 *       &lt;ref label="emphasis"/&gt;
 *       &lt;ref label="mark"/&gt;
 *       &lt;ref label="phoneme"/&gt;
 *       &lt;ref label="prosody"/&gt;
 *       &lt;ref label="say-as"/&gt;
 *       &lt;ref label="voice"/&gt;
 *       &lt;ref label="paragraph"/&gt;
 *       &lt;ref label="p"/&gt;
 *       &lt;ref label="sentence"/&gt;
 *       &lt;ref label="s"/&gt;
 *       &lt;ref label="emotion"/&gt;
 *       &lt;ref label="BOOKMARK"/&gt;
 *       &lt;ref label="CONTEXT"/&gt;
 *       &lt;ref label="EMPH"/&gt;
 *       &lt;ref label="LANG"/&gt;
 *       &lt;ref label="PARTOFSP"/&gt;
 *       &lt;ref label="PITCH"/&gt;
 *       &lt;ref label="PRON"/&gt;
 *       &lt;ref label="RATE"/&gt;
 *       &lt;ref label="REGWORD"/&gt;
 *       &lt;ref label="RESET"/&gt;
 *       &lt;ref label="SPELL"/&gt;
 *       &lt;ref label="SILENCE"/&gt;
 *       &lt;ref label="SPEECH"/&gt;
 *       &lt;ref label="VOICE"/&gt;
 *       &lt;ref label="VOLUME"/&gt;
 *     &lt;/choice&gt;
 *   &lt;/mixed&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="choice"&gt;
 *   &lt;attribute name="fetchhint" type="NMTOKEN"&gt;
 *     &lt;enumeration value="prefetch"/&gt;
 *     &lt;enumeration value="safe"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="fetchtimeout" type="string"/&gt;
 *   &lt;attribute name="maxage" type="string"/&gt;
 *   &lt;attribute name="maxstale" type="string"/&gt;
 *   &lt;attribute name="accept" type="NMTOKEN"&gt;
 *     &lt;enumeration value="exact"/&gt;
 *     &lt;enumeration value="approximate"/&gt;
 *   &lt;/attribute&gt;
 *   &lt;attribute name="dtmf" type="string"/&gt;
 *   &lt;attribute name="event" type="NMTOKEN"/&gt;
 *   &lt;attribute name="fetchaudio" type="string"/&gt;
 *   &lt;attribute name="next" type="string"/&gt;
 *   &lt;attribute name="expr" type="string"/&gt;
 *   &lt;attribute name="image" type="string"/&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version vxml20.rxg (Thu Aug 14 17:30:01 JST 2003)
 * @author  Relaxer 1.0rc3b (http://www.relaxer.org)
 */
public class VxmlChoice implements java.io.Serializable, Cloneable, IRNSContainer, IRVisitable, IRNode, IVxmlMenuMixed, IVxmlMenuMixedChoice {
    private RNSContext rNSContext_ = new RNSContext(this, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
    private String fetchhint_;
    private String fetchtimeout_;
    private String maxage_;
    private String maxstale_;
    private String accept_;
    private String dtmf_;
    private String event_;
    private String fetchaudio_;
    private String next_;
    private String expr_;
    private String image_;
    // List<IVxmlChoiceMixed>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>VxmlChoice</code>.
     *
     */
    public VxmlChoice() {
    }

    /**
     * Creates a <code>VxmlChoice</code>.
     *
     * @param source
     */
    public VxmlChoice(VxmlChoice source) {
        setup(source);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public VxmlChoice(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public VxmlChoice(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>VxmlChoice</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public VxmlChoice(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlChoice(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>VxmlChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlChoice(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlChoice(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlChoice(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlChoice(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>VxmlChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public VxmlChoice(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the VxmlChoice <code>source</code>.
     *
     * @param source
     */
    public void setup(VxmlChoice source) {
        int size;
        setFetchhint(source.getFetchhint());
        setFetchtimeout(source.getFetchtimeout());
        setMaxage(source.getMaxage());
        setMaxstale(source.getMaxstale());
        setAccept(source.getAccept());
        setDtmf(source.getDtmf());
        setEvent(source.getEvent());
        setFetchaudio(source.getFetchaudio());
        setNext(source.getNext());
        setExpr(source.getExpr());
        setImage(source.getImage());
        this.content_.clear();
        size = source.content_.size();
        for (int i = 0;i < size;i++) {
            addContent((IVxmlChoiceMixed)source.getContent(i).clone());
        }
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        fetchhint_ = URelaxer.getAttributePropertyAsString(element, "fetchhint");
        fetchtimeout_ = URelaxer.getAttributePropertyAsString(element, "fetchtimeout");
        maxage_ = URelaxer.getAttributePropertyAsString(element, "maxage");
        maxstale_ = URelaxer.getAttributePropertyAsString(element, "maxstale");
        accept_ = URelaxer.getAttributePropertyAsString(element, "accept");
        dtmf_ = URelaxer.getAttributePropertyAsString(element, "dtmf");
        event_ = URelaxer.getAttributePropertyAsString(element, "event");
        fetchaudio_ = URelaxer.getAttributePropertyAsString(element, "fetchaudio");
        next_ = URelaxer.getAttributePropertyAsString(element, "next");
        expr_ = URelaxer.getAttributePropertyAsString(element, "expr");
        image_ = URelaxer.getAttributePropertyAsString(element, "image");
        this.content_.clear();
        while (true) {
            if (RString.isMatch(stack)) {
                addContent(new RString(stack));
            } else if (GramGrammar.isMatch(stack)) {
                addContent(new GramGrammar(stack));
            } else if (VxmlAudio.isMatch(stack)) {
                addContent(new VxmlAudio(stack));
            } else if (VxmlProsody.isMatch(stack)) {
                addContent(new VxmlProsody(stack));
            } else if (VxmlVoice.isMatch(stack)) {
                addContent(new VxmlVoice(stack));
            } else if (VxmlEmotion.isMatch(stack)) {
                addContent(new VxmlEmotion(stack));
            } else if (VxmlCONTEXT.isMatch(stack)) {
                addContent(new VxmlCONTEXT(stack));
            } else if (VxmlREGWORD.isMatch(stack)) {
                addContent(new VxmlREGWORD(stack));
            } else if (VxmlJVOICE.isMatch(stack)) {
                addContent(new VxmlJVOICE(stack));
            } else if (VxmlPITCH.isMatch(stack)) {
                addContent(new VxmlPITCH(stack));
            } else if (VxmlBreak.isMatch(stack)) {
                addContent(new VxmlBreak(stack));
            } else if (VxmlEmphasis.isMatch(stack)) {
                addContent(new VxmlEmphasis(stack));
            } else if (VxmlPhoneme.isMatch(stack)) {
                addContent(new VxmlPhoneme(stack));
            } else if (VxmlSayAs.isMatch(stack)) {
                addContent(new VxmlSayAs(stack));
            } else if (VxmlParagraph.isMatch(stack)) {
                addContent(new VxmlParagraph(stack));
            } else if (VxmlP.isMatch(stack)) {
                addContent(new VxmlP(stack));
            } else if (VxmlSentence.isMatch(stack)) {
                addContent(new VxmlSentence(stack));
            } else if (VxmlS.isMatch(stack)) {
                addContent(new VxmlS(stack));
            } else if (VxmlLANG.isMatch(stack)) {
                addContent(new VxmlLANG(stack));
            } else if (VxmlPARTOFSP.isMatch(stack)) {
                addContent(new VxmlPARTOFSP(stack));
            } else if (VxmlPRON.isMatch(stack)) {
                addContent(new VxmlPRON(stack));
            } else if (VxmlRATE.isMatch(stack)) {
                addContent(new VxmlRATE(stack));
            } else if (VxmlVOLUME.isMatch(stack)) {
                addContent(new VxmlVOLUME(stack));
            } else if (VxmlEnumerate.isMatch(stack)) {
                addContent(new VxmlEnumerate(stack));
            } else if (VxmlValue.isMatch(stack)) {
                addContent(new VxmlValue(stack));
            } else if (VxmlMark.isMatch(stack)) {
                addContent(new VxmlMark(stack));
            } else if (VxmlBOOKMARK.isMatch(stack)) {
                addContent(new VxmlBOOKMARK(stack));
            } else if (VxmlEMPH.isMatch(stack)) {
                addContent(new VxmlEMPH(stack));
            } else if (VxmlSPELL.isMatch(stack)) {
                addContent(new VxmlSPELL(stack));
            } else if (VxmlSILENCE.isMatch(stack)) {
                addContent(new VxmlSILENCE(stack));
            } else if (VxmlSPEECH.isMatch(stack)) {
                addContent(new VxmlSPEECH(stack));
            } else if (VxmlRESET.isMatch(stack)) {
                addContent(new VxmlRESET(stack));
            } else {
                break;
            }
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new VxmlChoice(this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "choice");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.fetchhint_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchhint", this.fetchhint_);
        }
        if (this.fetchtimeout_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchtimeout", this.fetchtimeout_);
        }
        if (this.maxage_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxage", this.maxage_);
        }
        if (this.maxstale_ != null) {
            URelaxer.setAttributePropertyByString(element, "maxstale", this.maxstale_);
        }
        if (this.accept_ != null) {
            URelaxer.setAttributePropertyByString(element, "accept", this.accept_);
        }
        if (this.dtmf_ != null) {
            URelaxer.setAttributePropertyByString(element, "dtmf", this.dtmf_);
        }
        if (this.event_ != null) {
            URelaxer.setAttributePropertyByString(element, "event", this.event_);
        }
        if (this.fetchaudio_ != null) {
            URelaxer.setAttributePropertyByString(element, "fetchaudio", this.fetchaudio_);
        }
        if (this.next_ != null) {
            URelaxer.setAttributePropertyByString(element, "next", this.next_);
        }
        if (this.expr_ != null) {
            URelaxer.setAttributePropertyByString(element, "expr", this.expr_);
        }
        if (this.image_ != null) {
            URelaxer.setAttributePropertyByString(element, "image", this.image_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>VxmlChoice</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Initializes the <code>VxmlChoice</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NAMESPACE_AWARE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param text
     */
    public void setContent(String text) {
        setContent(new RString(text));
    }

    /**
     * Sets a mixed content by <code>String</code>.
     *
     * @param text
     */
    public void setContentByString(String text) {
        setContent(new RString(text));
    }

    /**
     * Gets the RNSContext property <b>RNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext rGetRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>RNSContext</b>.
     *
     * @param rNSContext
     */
    public final void rSetRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>fetchhint</b>.
     *
     * @return String
     */
    public final String getFetchhint() {
        return (fetchhint_);
    }

    /**
     * Sets the String property <b>fetchhint</b>.
     *
     * @param fetchhint
     */
    public final void setFetchhint(String fetchhint) {
        this.fetchhint_ = fetchhint;
    }

    /**
     * Gets the String property <b>fetchtimeout</b>.
     *
     * @return String
     */
    public final String getFetchtimeout() {
        return (fetchtimeout_);
    }

    /**
     * Sets the String property <b>fetchtimeout</b>.
     *
     * @param fetchtimeout
     */
    public final void setFetchtimeout(String fetchtimeout) {
        this.fetchtimeout_ = fetchtimeout;
    }

    /**
     * Gets the String property <b>maxage</b>.
     *
     * @return String
     */
    public final String getMaxage() {
        return (maxage_);
    }

    /**
     * Sets the String property <b>maxage</b>.
     *
     * @param maxage
     */
    public final void setMaxage(String maxage) {
        this.maxage_ = maxage;
    }

    /**
     * Gets the String property <b>maxstale</b>.
     *
     * @return String
     */
    public final String getMaxstale() {
        return (maxstale_);
    }

    /**
     * Sets the String property <b>maxstale</b>.
     *
     * @param maxstale
     */
    public final void setMaxstale(String maxstale) {
        this.maxstale_ = maxstale;
    }

    /**
     * Gets the String property <b>accept</b>.
     *
     * @return String
     */
    public final String getAccept() {
        return (accept_);
    }

    /**
     * Sets the String property <b>accept</b>.
     *
     * @param accept
     */
    public final void setAccept(String accept) {
        this.accept_ = accept;
    }

    /**
     * Gets the String property <b>dtmf</b>.
     *
     * @return String
     */
    public final String getDtmf() {
        return (dtmf_);
    }

    /**
     * Sets the String property <b>dtmf</b>.
     *
     * @param dtmf
     */
    public final void setDtmf(String dtmf) {
        this.dtmf_ = dtmf;
    }

    /**
     * Gets the String property <b>event</b>.
     *
     * @return String
     */
    public final String getEvent() {
        return (event_);
    }

    /**
     * Sets the String property <b>event</b>.
     *
     * @param event
     */
    public final void setEvent(String event) {
        this.event_ = event;
    }

    /**
     * Gets the String property <b>fetchaudio</b>.
     *
     * @return String
     */
    public final String getFetchaudio() {
        return (fetchaudio_);
    }

    /**
     * Sets the String property <b>fetchaudio</b>.
     *
     * @param fetchaudio
     */
    public final void setFetchaudio(String fetchaudio) {
        this.fetchaudio_ = fetchaudio;
    }

    /**
     * Gets the String property <b>next</b>.
     *
     * @return String
     */
    public final String getNext() {
        return (next_);
    }

    /**
     * Sets the String property <b>next</b>.
     *
     * @param next
     */
    public final void setNext(String next) {
        this.next_ = next;
    }

    /**
     * Gets the String property <b>expr</b>.
     *
     * @return String
     */
    public final String getExpr() {
        return (expr_);
    }

    /**
     * Sets the String property <b>expr</b>.
     *
     * @param expr
     */
    public final void setExpr(String expr) {
        this.expr_ = expr;
    }

    /**
     * Gets the String property <b>image</b>.
     *
     * @return String
     */
    public final String getImage() {
        return (image_);
    }

    /**
     * Sets the String property <b>image</b>.
     *
     * @param image
     */
    public final void setImage(String image) {
        this.image_ = image;
    }

    /**
     * Gets the IVxmlChoiceMixed property <b>content</b>.
     *
     * @return IVxmlChoiceMixed[]
     */
    public final IVxmlChoiceMixed[] getContent() {
        IVxmlChoiceMixed[] array = new IVxmlChoiceMixed[content_.size()];
        return ((IVxmlChoiceMixed[])content_.toArray(array));
    }

    /**
     * Sets the IVxmlChoiceMixed property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IVxmlChoiceMixed[] content) {
        this.content_.clear();
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Sets the IVxmlChoiceMixed property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IVxmlChoiceMixed content) {
        this.content_.clear();
        addContent(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlChoiceMixed property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IVxmlChoiceMixed content) {
        this.content_.add(content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlChoiceMixed property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IVxmlChoiceMixed[] content) {
        for (int i = 0;i < content.length;i++) {
            addContent(content[i]);
        }
        for (int i = 0;i < content.length;i++) {
            content[i].rSetParentRNode(this);
        }
    }

    /**
     * Gets number of the IVxmlChoiceMixed property <b>content</b>.
     *
     * @return int
     */
    public final int sizeContent() {
        return (content_.size());
    }

    /**
     * Gets the IVxmlChoiceMixed property <b>content</b> by index.
     *
     * @param index
     * @return IVxmlChoiceMixed
     */
    public final IVxmlChoiceMixed getContent(int index) {
        return ((IVxmlChoiceMixed)content_.get(index));
    }

    /**
     * Sets the IVxmlChoiceMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void setContent(int index, IVxmlChoiceMixed content) {
        this.content_.set(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Adds the IVxmlChoiceMixed property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void addContent(int index, IVxmlChoiceMixed content) {
        this.content_.add(index, content);
        if (content != null) {
            content.rSetParentRNode(this);
        }
    }

    /**
     * Remove the IVxmlChoiceMixed property <b>content</b> by index.
     *
     * @param index
     */
    public final void removeContent(int index) {
        this.content_.remove(index);
    }

    /**
     * Remove the IVxmlChoiceMixed property <b>content</b> by object.
     *
     * @param content
     */
    public final void removeContent(IVxmlChoiceMixed content) {
        this.content_.remove(content);
    }

    /**
     * Clear the IVxmlChoiceMixed property <b>content</b>.
     *
     */
    public final void clearContent() {
        this.content_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.append("<");
        URelaxer.makeQName(prefix, "choice", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (fetchhint_ != null) {
            buffer.append(" ");
            buffer.append("fetchhint");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.append("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.append(" ");
            buffer.append("fetchtimeout");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.append("\"");
        }
        if (maxage_ != null) {
            buffer.append(" ");
            buffer.append("maxage");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.append("\"");
        }
        if (maxstale_ != null) {
            buffer.append(" ");
            buffer.append("maxstale");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.append("\"");
        }
        if (accept_ != null) {
            buffer.append(" ");
            buffer.append("accept");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getAccept())));
            buffer.append("\"");
        }
        if (dtmf_ != null) {
            buffer.append(" ");
            buffer.append("dtmf");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getDtmf())));
            buffer.append("\"");
        }
        if (event_ != null) {
            buffer.append(" ");
            buffer.append("event");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.append("\"");
        }
        if (fetchaudio_ != null) {
            buffer.append(" ");
            buffer.append("fetchaudio");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchaudio())));
            buffer.append("\"");
        }
        if (next_ != null) {
            buffer.append(" ");
            buffer.append("next");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getNext())));
            buffer.append("\"");
        }
        if (expr_ != null) {
            buffer.append(" ");
            buffer.append("expr");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.append("\"");
        }
        if (image_ != null) {
            buffer.append(" ");
            buffer.append("image");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getImage())));
            buffer.append("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "choice", buffer);
        buffer.append(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.write("<");
        URelaxer.makeQName(prefix, "choice", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (fetchhint_ != null) {
            buffer.write(" ");
            buffer.write("fetchhint");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.write("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.write(" ");
            buffer.write("fetchtimeout");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.write("\"");
        }
        if (maxage_ != null) {
            buffer.write(" ");
            buffer.write("maxage");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.write("\"");
        }
        if (maxstale_ != null) {
            buffer.write(" ");
            buffer.write("maxstale");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.write("\"");
        }
        if (accept_ != null) {
            buffer.write(" ");
            buffer.write("accept");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getAccept())));
            buffer.write("\"");
        }
        if (dtmf_ != null) {
            buffer.write(" ");
            buffer.write("dtmf");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getDtmf())));
            buffer.write("\"");
        }
        if (event_ != null) {
            buffer.write(" ");
            buffer.write("event");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.write("\"");
        }
        if (fetchaudio_ != null) {
            buffer.write(" ");
            buffer.write("fetchaudio");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchaudio())));
            buffer.write("\"");
        }
        if (next_ != null) {
            buffer.write(" ");
            buffer.write("next");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getNext())));
            buffer.write("\"");
        }
        if (expr_ != null) {
            buffer.write(" ");
            buffer.write("expr");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.write("\"");
        }
        if (image_ != null) {
            buffer.write(" ");
            buffer.write("image");
            buffer.write("=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getImage())));
            buffer.write("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.write(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.write("</");
        URelaxer.makeQName(prefix, "choice", buffer);
        buffer.write(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://hil.t.u-tokyo.ac.jp/XML/2002/VXML");
        buffer.print("<");
        URelaxer.makeQName(prefix, "choice", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (fetchhint_ != null) {
            buffer.print(" ");
            buffer.print("fetchhint");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchhint())));
            buffer.print("\"");
        }
        if (fetchtimeout_ != null) {
            buffer.print(" ");
            buffer.print("fetchtimeout");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchtimeout())));
            buffer.print("\"");
        }
        if (maxage_ != null) {
            buffer.print(" ");
            buffer.print("maxage");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxage())));
            buffer.print("\"");
        }
        if (maxstale_ != null) {
            buffer.print(" ");
            buffer.print("maxstale");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getMaxstale())));
            buffer.print("\"");
        }
        if (accept_ != null) {
            buffer.print(" ");
            buffer.print("accept");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getAccept())));
            buffer.print("\"");
        }
        if (dtmf_ != null) {
            buffer.print(" ");
            buffer.print("dtmf");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getDtmf())));
            buffer.print("\"");
        }
        if (event_ != null) {
            buffer.print(" ");
            buffer.print("event");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getEvent())));
            buffer.print("\"");
        }
        if (fetchaudio_ != null) {
            buffer.print(" ");
            buffer.print("fetchaudio");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getFetchaudio())));
            buffer.print("\"");
        }
        if (next_ != null) {
            buffer.print(" ");
            buffer.print("next");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getNext())));
            buffer.print("\"");
        }
        if (expr_ != null) {
            buffer.print(" ");
            buffer.print("expr");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getExpr())));
            buffer.print("\"");
        }
        if (image_ != null) {
            buffer.print(" ");
            buffer.print("image");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getImage())));
            buffer.print("\"");
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeTextAttribute(buffer);
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IVxmlChoiceMixed value = (IVxmlChoiceMixed)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "choice", buffer);
        buffer.print(">");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchhintAsString() {
        return (URelaxer.getString(getFetchhint()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchtimeoutAsString() {
        return (URelaxer.getString(getFetchtimeout()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaxageAsString() {
        return (URelaxer.getString(getMaxage()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaxstaleAsString() {
        return (URelaxer.getString(getMaxstale()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getAcceptAsString() {
        return (URelaxer.getString(getAccept()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDtmfAsString() {
        return (URelaxer.getString(getDtmf()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getEventAsString() {
        return (URelaxer.getString(getEvent()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getFetchaudioAsString() {
        return (URelaxer.getString(getFetchaudio()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNextAsString() {
        return (URelaxer.getString(getNext()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getExprAsString() {
        return (URelaxer.getString(getExpr()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getImageAsString() {
        return (URelaxer.getString(getImage()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchhintByString(String string) {
        setFetchhint(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchtimeoutByString(String string) {
        setFetchtimeout(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaxageByString(String string) {
        setMaxage(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaxstaleByString(String string) {
        setMaxstale(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setAcceptByString(String string) {
        setAccept(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDtmfByString(String string) {
        setDtmf(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setEventByString(String string) {
        setEvent(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setFetchaudioByString(String string) {
        setFetchaudio(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNextByString(String string) {
        setNext(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setExprByString(String string) {
        setExpr(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setImageByString(String string) {
        setImage(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Accepts the Visitor for enter behavior.
     *
     * @param visitor
     * @return boolean
     */
    public boolean enter(IRVisitor visitor) {
        return (visitor.enter(this));
    }

    /**
     * Accepts the Visitor for leave behavior.
     *
     * @param visitor
     */
    public void leave(IRVisitor visitor) {
        visitor.leave(this);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode rGetParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void rSetParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] rGetRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>VxmlChoice</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://hil.t.u-tokyo.ac.jp/XML/2002/VXML", "choice")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while (true) {
            if (GramGrammar.isMatchHungry(target)) {
                $match$ = true;
                while (GramGrammar.isMatchHungry(target)) {
                }
            } else if (VxmlAudio.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlProsody.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVoice.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmotion.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlCONTEXT.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlREGWORD.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlJVOICE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPITCH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBreak.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEmphasis.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPhoneme.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSayAs.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlParagraph.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSentence.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlS.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlLANG.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPARTOFSP.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlPRON.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRATE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlVOLUME.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEnumerate.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlValue.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlMark.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlBOOKMARK.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlEMPH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPELL.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSILENCE.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlSPEECH.isMatchHungry(target)) {
                $match$ = true;
            } else if (VxmlRESET.isMatchHungry(target)) {
                $match$ = true;
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlChoice</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>VxmlChoice</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
