/* Copyright (c) 1991-2002 Doshita Lab. Speech Group, Kyoto University */
/* Copyright (c) 2000-2002 Speech and Acoustics Processing Lab., NAIST */
/*   All rights reserved   */

/* tcpip.h --- defines for TCP/IP commication for each server */
/* original from ~speech/src/sent/tcpip.h */

/* $Id: tcpip.h,v 1.2 2002/09/11 22:01:50 ri Exp $ */

#ifndef __SENT_SPEECH_TCPIP__
#define __SENT_SPEECH_TCPIP__

#include	<errno.h>
#if !defined(_WIN32) || defined(__CYGWIN32__)
#include	<netdb.h>
#include	<sys/file.h>
#include	<sys/types.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<sys/un.h>
#include	<fcntl.h>
#include	<arpa/inet.h>
#endif

/* default adin server port number */
#define         ADINNET_PORT 5530

/* default dialog manager port num (bogus) */
#define		DM_PORT_NUM   5506 

/* server-client connection retry parameters */
#define		CONNECTION_RETRY_INTERVAL 2 /* sec. */
#define		CONNECTION_RETRY_TIMES    5 /* retry times */

/* net/dialog.c (bogus) */
void dm_connect(char *hostname);
void dm_send_sentence(WORD_ID words[], short num);
int  dm_receive_ack();
/* net/rdwt.c */
int rd(int fd, char *data, int *len, int maxlen);
int wt(int fd, char *data, int len);
/* net/server_client.c */
int ready_as_server(int port_num);
int ready_as_server_nonblock(int port_num);
int accept_from(int sd);
int make_connection(char *hostname, int port_num);
int make_connection_unix(char *address);
int close_socket(int sd);
void cleanup_socket();

#endif /* __SENT_SPEECH_TCPIP__ */
