//
// SLR(1)\͊vO
// LR(0)W
//
// CanonicalLR0Collection.h / CanonicalLR0Collection.cpp
//
// ̃vÓCMMIVXeɈˑȂvOłB
//
// 2002/07/13 Sat. G
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#ifndef _CANONICAL_LR0_COLLECTION_H_
#define _CANONICAL_LR0_COLLECTION_H_

#include <list>

#include "SymbolTable.h"
#include "Grammar.h"

using namespace std;

//
// ̃t@CŐ錾NX́CSLR(0)\͕\ߒŕKvɂȂ鐳LR(0)W𐶐CǗsB
// LR(0)W\ŏPLR(0)́CCLR0ItemNX
// LR(0)WÍCNXCLR0ItemSet
// LR(0)ẂCNXCCLR0Collection
// ŊǗB
// LR(0)W̐́CNXCCLR0CollectionCreators
//
// 2001/11/01 Thu.
//

#define MARKER_END		-1			// LR}[J[K̖ɂƂm_nMarkerPos̒l

//
// 񋓌^ CREATEOPERATION
// LR(0)W)Ix(CLR0ItemSet)𐶐ƂɗpZʂ邽߂ɗp
//  CLOSURE --- closureZ
//  GOTL  ----- gotoZ
//
enum CREATEOPERATION
{
	UNKNOWN_OPERATION = -1,		// s
	CLOSURE_OPERATION,			// closureZ
	GOTO_OPERATION,				// gotoZ
};


//
// NX CLR0Item
//
// LR(0)̏Ǘ
//

class CLR0Item
{
private:
	CProduction m_Production;		// K
	int			m_nMarkerPos;		// LR}[J[
	int			m_nSetNumber;		// LR(0)W̔ԍ

public:
	CLR0Item();
	CLR0Item( CProduction &pro, int setnumber, int marker = MARKER_END );
	CLR0Item( CLR0Item &item );

	virtual ~CLR0Item();

public:
	CProduction &GetProduction();
	CProduction *GetProductionPtr();
	int  GetCurrentMarkerPos();
	int  GetSetNumber();

public:
	int ShiftMarker();

public:
	CLR0Item &operator = ( CLR0Item &item );
	bool operator == ( CLR0Item &item );
};

//
// NX CLR0ItemList
//
class CLR0ItemList
{
private:
	list < CLR0Item * > m_List;

public:
	CLR0ItemList();
	CLR0ItemList( CLR0ItemList &lst );

	virtual ~ CLR0ItemList();

public:
	void RemoveAll();

	int GetSize();

	int AddItem( CProduction &pro, int setnumber, int marker = MARKER_END );
	int AddItem( CLR0Item &item );
	int MergeList( CLR0ItemList &lst );

	int GetItem( int setnumber, CLR0ItemList &lst );
	CLR0Item &GetItem( int index );
	CLR0Item *GetItemPtr( int index );

	bool IsExistItem( CLR0Item &item );

public:
	CLR0ItemList &operator = ( CLR0ItemList &lst );
};

//
// NX CLR0ItemSet
//
// LR(0)̏WǗB
//

class CLR0ItemSet
{
private:
	int m_nSetNumber;				// W̔ԍ=Ԕԍ( >= 0 )
	CREATEOPERATION m_nOperation;	// W̐ɗpZ

	union {		// W̉Zɗpp[^

		int m_nRootProduction;			// closureZ̈:KS'=S̔ԍ(WI0̂ɗp)

		// ȉ̓gotoZɗp
		struct {
			int m_nOriginalSet;				// W̐ɗpLR(0)Wim_nSetNumber != 0)
			CSymbol *m_pInputSymbol;			// W̐ɗp͋L (m_nSetNumber != 0)
		} GotoParam;

	} m_Parameter;

public:
	CLR0ItemSet();
	CLR0ItemSet( int number, int root );
	CLR0ItemSet( int number, int original, CSymbol &sym );
	CLR0ItemSet( CLR0ItemSet &itemset );

	virtual ~CLR0ItemSet();

public:
	int GetSetNumber();
	CREATEOPERATION GetOperation();

	int GetRootProduction();
	
	int GetOriginalSet();
	int GetInputSymbol( CSymbol &sym );
	
	void SetClosureInfo( int number, int root );
	void SetGotoInfo( int number, int original, CSymbol &sym );

public:
	CLR0ItemSet &operator = ( CLR0ItemSet &itemset );

};

//
// NX CLR0ItemSetList
//
class CLR0ItemSetList
{
private:
	list < CLR0ItemSet * > m_List;

public:
	CLR0ItemSetList();
	CLR0ItemSetList( CLR0ItemSetList &lst );

	virtual ~CLR0ItemSetList();

public:
	void RemoveAll();

	int GetSize();

	int AddSet( int number, int root );
	int AddSet( int number, int original, CSymbol &sym );
	int AddSet( CLR0ItemSet &set );

	int MergeList( CLR0ItemSetList &lst );

	int GetSet( int numindex, CLR0ItemSet &set, bool flag = true );

public:
	CLR0ItemSetList &operator = ( CLR0ItemSetList &lst );
	
};

//
// NX CCLR0Collection
//

class CCLR0Collection
{
private:
	CContextFreeGrammar			m_Grammar;			// @f[^
	CLR0ItemList				m_Collection;		// LR(0)̃Xg
	CLR0ItemSetList				m_SetList;			// LR(0)W̃Xg

public:
	CCLR0Collection();

	virtual ~CCLR0Collection();

public:
	void ClearCollection();

public:
	CContextFreeGrammar &GetGrammar();
	CLR0ItemList &GetLR0ItemList();
	CLR0ItemList *GetLR0ItemListPtr();
	CLR0ItemSetList &GetLR0ItemSetList();
	CLR0ItemSetList *GetLR0ItemSetListPtr();
	
	void SetCLR0Collection( CContextFreeGrammar &grammar, CLR0ItemList &item, CLR0ItemSetList &set );

public:
	CCLR0Collection & operator = ( CCLR0Collection &coll );

public:
	void Display();
	void OutFile( string filename );
};


//
// NX CCLR0CollectionCreator
//

class CCLR0CollectionCreator
{
public:
	CCLR0CollectionCreator();

	virtual ~CCLR0CollectionCreator();

public:
	int CreateCollection( CContextFreeGrammar &grammar, CCLR0Collection &coll );

protected:
	int Closure( CContextFreeGrammar &grammar, CLR0ItemList &item, int setnumber, CLR0ItemList &outitem );
	int Goto( CContextFreeGrammar &grammar, CLR0ItemList &item, const char *sym, int setnumber, CLR0ItemList &outitem );
};

#endif  _CANONICAL_LR0_COLLECTION_H_