// Document.cpp: CDocument NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "NewIV.h"
#include "DocumentNode.h"
#include "DialogNode.h"
#include "TreeManagement.h"
#include "common.h"
#include "logDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CNewIVApp theApp;
extern CTreeManagement treeManagement;
extern CLogDlg *g_pLogDlg;

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

//RXgN^
//F
// string strNodeNameFm[h
// IXMLDOMNode** pXislNodeF<xisl>DOMNode
// CApplicationNode* pParentNodeF̃m[h̐em[hCApplication
// int documentTypeF̃m[ȟ^i[g[tj
CDocumentNode::CDocumentNode(string strNodeName,IXMLDOMNode **pXislNode,
							 CApplicationNode* pParentNode,int documentType){

	//m[h̏
	this->mpXislNode = *pXislNode;					//DOMm[hi[
	this->mStrName.assign(strNodeName);				//hLgi[
	this->mType = DOCUMENT;							//Θbc[̌^i[
	this->mState = UNVISITED;						//Θbc[̏ԂUNVISITEDɂ
	this->mId = treeManagement.getIdCount();		//Θbc[IDԍi[

	this->mpParentNode = pParentNode;				//Θbc[̐em[hi[

	this->mDocumentType = documentType;				//CDocumentNodě^i[
													//[g[tH

	//em[hAvP[Vi[
	string *strAppName;
	strAppName = new string();
	pParentNode->getName(strAppName);
	this->mStrAppName.assign(strAppName->c_str());	
	delete strAppName;

	//hLg[ghLgłȂ
	if( this->mDocumentType != ROOTDOCUMENT ){
		//hLgϐ̓o^
		this->registDocVar();
	}

}

CDocumentNode::~CDocumentNode()
{
	char cAppName[MESSAGE_LENGTH];
	char cDocName[MESSAGE_LENGTH];

	strcpy(cAppName,mStrAppName.c_str());
	strcpy(cDocName,mStrName.c_str());
	//hLgϐȉ폜悤CΘbc[ǗʂāCϐǗɈ˗
	treeManagement.askVarManagementToDeleteVar(cAppName,cDocName,"","","");

	//DOM̉
	if( this->mDocumentType == ROOTDOCUMENT ){
		//CDocumentNode[ghLgȂ
		treeManagement.releaseRootDom();

		//[ghLg̏
		treeManagement.setRootDocName("");

	}else{
		//CDocumentNode[thLgȂ
		treeManagement.releaseLeafDom();
		//[thLg̏
		treeManagement.setLeafDocName("");

	}
}


//@\F
//		AvP[VԂ
//F
//	string* pStrAppNameFAvP[Vi[string^̃|C^
//߂l
//	Ȃ
void CDocumentNode::getAppName(string *pStrAppName){

	pStrAppName->assign(this->mStrAppName);

}

//@\F
//	hLgϐ𒊏oāCΘbc[ǗʂāCϐǗ
//  hLgϐo^˗𔭍sD
void CDocumentNode::registDocVar(){

	CString strLog;

	IXMLDOMNode* pDocumentVarNode = NULL; //<document_var>m[hi[
	IXMLDOMNodeList* pVarNodeList = NULL; //<var>m[hXg
	IXMLDOMNode* pVarNode = NULL;		   //<var>m[h
	long lLen;					   //<var>m[hXgi[
	int Ret;

	BSTR bStrDocumetVarXPath;      //<documet_var>vfXPathi[

	//<document_var>XPathi[
	bStrDocumetVarXPath = SysAllocString(L"//document_var");

	//<document_var>m[h̎擾
	( this->mpXislNode )->selectSingleNode(bStrDocumetVarXPath,&pDocumentVarNode);
	SysFreeString(bStrDocumetVarXPath);

	//document_var
	if( pDocumentVarNode != NULL ){

		//hLgϐ<var>^OQ擾
		pDocumentVarNode->get_childNodes(&pVarNodeList);
		pVarNodeList->get_length(&lLen);	
	
		BSTR bStrTagName;							//m[hi[
		BSTR bStrName = SysAllocString(L"name");    //name
		BSTR bStrNameValue;							//name̒l
		BSTR bStrValue = SysAllocString(L"expr");	//expr
		BSTR bStrValueValue;						//expr̒l
		IXMLDOMNamedNodeMap *pVarAttrsNodeMap;		//varvf̑}bv
		IXMLDOMNode* pNameAttrNode;					//namẽm[h
		IXMLDOMNode* pValueAttrNode;				//valuẽm[h
		char cTemp[MESSAGE_LENGTH];
		char cAppName[MESSAGE_LENGTH];
		char cDocName[MESSAGE_LENGTH];
		char cNameValue[WORD_LENGTH];
		char cValueValue[WORD_LENGTH];

		strcpy(cAppName,this->mStrAppName.c_str());
		strcpy(cDocName,this->mStrName.c_str());
		
		strLog = "***documentϐ\r\n";
		strLog += cDocName;
		strLog += ")̓o^***\r\n";
		g_pLogDlg->setText(strLog);
		//evar^Oɑ΂ď
		for(int i = 0 ; i < lLen; i++){
			pVarNodeList->get_item(i,&pVarNode);	

			pVarNode->get_baseName(&bStrTagName);
			BSTRToAscii(bStrTagName,cTemp,MESSAGE_LENGTH);
			SysFreeString(bStrTagName);
			if( !strcmp(cTemp,"var") ){

				//varvf̑m[hXg̎擾
				pVarNode->get_attributes(&pVarAttrsNodeMap);

				//namȇl擾
				pVarAttrsNodeMap->getNamedItem(bStrName,&pNameAttrNode);
				pNameAttrNode->get_text(&bStrNameValue);

				BSTRToAscii(bStrNameValue,cNameValue,WORD_LENGTH);
				SysFreeString(bStrNameValue);
			
				pVarAttrsNodeMap->getNamedItem(bStrValue,&pValueAttrNode);
				//valueΑl擾
				if(pValueAttrNode != NULL){
					pValueAttrNode -> get_text(&bStrValueValue);
					BSTRToAscii(bStrValueValue,cValueValue,WORD_LENGTH);
					//
					SysFreeString(bStrValueValue);

				}else{
					cValueValue[0] = '\0';
				}
				//Θbc[ǗʂāCϐǗɃhLgϐo^,ϐlo^˗
				Ret = treeManagement.askVarManagementToRegistVar(cAppName,cDocName,"","",cNameValue);
				if( Ret != 0 ){
					if( Ret == 1 ){
						strLog = "hLgϐ:";
						strLog += cNameValue;
						strLog += "d`Ă܂\r\n";
						g_pLogDlg->setText(strLog);
					}else if( Ret == 2 ){
						strLog = "hLgϐ:";
						strLog += cNameValue;
						strLog += "͕sȕϐł\r\n";
						g_pLogDlg->setText(strLog);
					}
						strLog = "hLgϐ:";
						strLog += cNameValue;
						strLog += "o^ł܂ł\r\n";
						g_pLogDlg->setText(strLog);
				}else{
					treeManagement.askVarManagemnetToSetVarData(cAppName,cDocName,"","",cNameValue,cValueValue);
					strLog = "hLgϐ:";
					strLog += cNameValue;
					strLog += " = ";
					strLog += cValueValue;
					strLog += "œo^\r\n";
					g_pLogDlg->setText(strLog);
				}
				cNameValue[0] = '\0';
				cValueValue[0] = '\0';
				cTemp[0] = '\0';
			}			
	
		}
		g_pLogDlg->setText("\r\n");
				//Q
		SysFreeString(bStrName);
		SysFreeString(bStrValue);
	}
}


//@\F
//		ŗ^ꂽDOMNodeCŏ<dialog>𒊏oC
//      ŏ<dialog>ɑΉCDialogNode𐶐CXg
//		ǉD
//F
//		_CAOւ̎
//߂lF
//		0:
//	   -1:s
//	@ -2FɐĂ
int CDocumentNode::makeFirstDialog(string strArg){

	CString strLog;

	IXMLDOMNode* pFirstDialogNode = NULL;		//ŏ<dialog>DOMm[hi[
	BSTR bStrFirstDialogXPath;					//ŏ<dialog>XPathi[

	CDialogNode* pTempDialogTreeNode = NULL;		//CDialogNodeւ̃|C^

	//ŏ<dialog>XPathi[
	bStrFirstDialogXPath = SysAllocString(L"//dialog");


	//ŏ<dialog>m[h̎擾
	( this->mpXislNode )->selectSingleNode(bStrFirstDialogXPath,&pFirstDialogNode);
	SysFreeString(bStrFirstDialogXPath);

	if( pFirstDialogNode == NULL ){
		strLog = this->mStrName.c_str();
		strLog += "ɍŏ<dialog>݂܂\r\n";
		g_pLogDlg->setText(strLog);
		return -1;
	}

	//XgvfȂC
	if( mpListHead == NULL ){
		//_~[m[h̐iCParListNode̐CŏɃ_~[m[h܂Kvj
		mpListHead = new CDialogTreeNode;
		mpListTail = mpListHead;

	}else{
		//XgvfłȂȂC

		//łɃXgɂCDialogNodeIuWFNgȂ̒T
		//( OCDialogNodeȂ̒T )
		// found_flag = 1
		//Ȃ flag = 0
		int found_flag = 0;
		CDialogNode* pCheckDialogTreeNode;		//ꎞIɃXgH邽߂̃m[h
			
		//TCDialogNode̖O擾
		BSTR bStrId;
		VARIANT vArIdValue;
		char cCheckDiaNodeName[WORD_LENGTH];
		bStrId= SysAllocString(L"@id");
		IXMLDOMNode* pIdAttrNode;

		pFirstDialogNode->selectSingleNode(bStrId,&pIdAttrNode);
		pIdAttrNode->get_nodeValue(&vArIdValue);
		VARIANTToAscii(vArIdValue,cCheckDiaNodeName);
		SysFreeString(bStrId);
		VariantClear(&vArIdValue);

		// 擪i_~[m[hj̎̃m[h擾
		pCheckDialogTreeNode= (CDialogNode*)mpListHead->retNextNode();
		//CDialogNodeɃXgɂȂ`FbN
		while( pCheckDialogTreeNode != NULL){
			 // m[h̎擾
			 string* strDiaNodeName;					//CDialogNode擾D
			 strDiaNodeName = new string();
			 pCheckDialogTreeNode->getName(strDiaNodeName);
			 if( strDiaNodeName->compare( cCheckDiaNodeName ) == 0 ){

				 //CDocumentNodeɃXgɑ݂Ă
				 //cerr << "" << cCheckDiaNodeName
				//	  << "CDialogtNode͐Ă܂\n";

				delete strDiaNodeName;
				strDiaNodeName = NULL;

				return -2;

			}else{
					
				pCheckDialogTreeNode = (CDialogNode*)pCheckDialogTreeNode->retNextNode();

			 }

			delete strDiaNodeName;
			strDiaNodeName = NULL;

		}//whilȅI im[hȂ̒TIj
	
	}//elsȅI

	//CDialogNode̐
	pTempDialogTreeNode = new CDialogNode( &pFirstDialogNode,this,strArg );


	if(pTempDialogTreeNode->mSuccess == 1){
		g_pLogDlg->setText("vIG[\r\n");
		delete pTempDialogTreeNode;
		return -1;
	}
	//CDialogNodeXg̍Ōɒǉ
	pTempDialogTreeNode->joinList(this->mpListTail);
	// XgŌւ̃|C^ړ
	this->mpListTail = pTempDialogTreeNode;

	return 0;

}




//Ŏw肳ꂽCDialogNodẽIuWFNg𐶐ăXgɉ
//F
//		string strDialogNameF_CAOm[h
//		string strArgFƂɓnC_CAO
//߂lF
//		0:
//	   -1:s
//	   -2FɐĂ
int CDocumentNode::makeDialog(string strDialogName,string strArg){

	IXMLDOMNode* pDialogNode = NULL;		//w肳ꂽ<dialog>DOMm[hi[
	BSTR bStrDialogXPath;				//w肳ꂽ<dialog>XPathi[
	char cDialogXPath[MESSAGE_LENGTH];

	CDialogNode* pTempDialogTreeNode = NULL;		//CDialogNodeւ̃|C^

	//w肳ꂽ<dialog>XPathi[
	strcpy(cDialogXPath,"//dialog[@id='");
	strcat(cDialogXPath,strDialogName.c_str());
	strcat(cDialogXPath,"']");
	bStrDialogXPath = AsciiToBSTR(cDialogXPath);
	

	//w肳ꂽ<dialog id="strDialogName">m[h̎擾
	( this->mpXislNode )->selectSingleNode(bStrDialogXPath,&pDialogNode);
	SysFreeString(bStrDialogXPath);

	if( pDialogNode == NULL ){
		cerr << this->mStrName << "id='" << strDialogName 
			 << "'dialog݂܂\n";
		return -1;
	}

	//XgvfȂC
	if( mpListHead == NULL ){
		//_~[m[h̐iCParListNode̐CŏɃ_~[m[h܂Kvj
		mpListHead = new CDialogTreeNode;
		mpListTail = mpListHead;

	}else{
		//XgvfłȂȂC

		//łɃXgɂCDialogNodeIuWFNgȂ̒T
		//( OCDialogNodeȂ̒T )
		CDialogNode* pCheckDialogTreeNode;		//ꎞIɃXgH邽߂̃m[h
			
		//TCDialogNode̖O擾
		BSTR bStrId;
		VARIANT vArIdValue;
		char cCheckDiaNodeName[WORD_LENGTH];
		bStrId= SysAllocString(L"@id");
		IXMLDOMNode* pIdAttrNode;

		pDialogNode->selectSingleNode(bStrId,&pIdAttrNode);
		pIdAttrNode->get_nodeValue(&vArIdValue);
		VARIANTToAscii(vArIdValue,cCheckDiaNodeName);
		SysFreeString(bStrId);
		VariantClear(&vArIdValue);

		// 擪i_~[m[hj̎̃m[h擾
		pCheckDialogTreeNode= (CDialogNode*)mpListHead->retNextNode();
		//CDialogNodeɃXgɂȂ`FbN
		while( pCheckDialogTreeNode != NULL){
			 // m[h̎擾
			 string* strDiaNodeName;					//CDialogNode擾D
			 strDiaNodeName = new string();
			 pCheckDialogTreeNode->getName(strDiaNodeName);
			 if( strDiaNodeName->compare( cCheckDiaNodeName ) == 0 ){

				 //CDocumentNodeɃXgɑ݂Ă
				 //cerr << "" << cCheckDiaNodeName
				//	  << "CDialogtNode͐Ă܂\n";

				delete strDiaNodeName;
				strDiaNodeName = NULL;

				return -2;

			}else{
					
				pCheckDialogTreeNode = (CDialogNode*)pCheckDialogTreeNode->retNextNode();

			 }

			delete strDiaNodeName;
			strDiaNodeName = NULL;

		}//whilȅI im[hȂ̒TIj
	
	}//elsȅI

	//CDialogNode̐
	pTempDialogTreeNode = new CDialogNode(&pDialogNode,this, strArg );
	if(pTempDialogTreeNode->mSuccess == 1){
		g_pLogDlg->setText("vIG[\r\n");
		delete pTempDialogTreeNode;
		return -1;
	}
	//CDialogNodeXg̍Ōɒǉ
	pTempDialogTreeNode->joinList(this->mpListTail);
	// XgŌւ̃|C^ړ
	this->mpListTail = pTempDialogTreeNode;

	return 0;

}

//@\F
//		ŗ^ꂽDOMNodeC荞<dialog>𒊏oC
//      e荞<dialog>ɑΉCDialogNode𐶐CXg
//		ǉĂD
//߂lF
//		0:
//	   -1:s
int CDocumentNode::makeInterruptDialog(){

	IXMLDOMNodeList* pInterruptDialogNodeList = NULL; //<dialog scope="document">̃m[hXg
	IXMLDOMNode* pInterruptDialogNode = NULL;		  //<dialog scope="dialog">̃m[hXg
	IXMLDOMElement* pTempElement = NULL;
	CDialogNode* pTempDialogTreeNode = NULL;
	long lLen;					   //<dialog scope="document">m[hXgi[
	int Ret = 0;

	BSTR bStrInterruptDialogXPath;      //<dialog scope="document">vfXPathi[

	//<dialog scope="document">XPathi[
	bStrInterruptDialogXPath = SysAllocString(L"//dialog[@scope='document']");

	//<dialog scope="document">m[h̎擾
	( this->mpXislNode )->selectNodes(bStrInterruptDialogXPath,&pInterruptDialogNodeList);
	SysFreeString(bStrInterruptDialogXPath);

	//<dialog scope="document">̃m[hXgHȂC
	pInterruptDialogNodeList->get_length(&lLen);
	for( int i = 0 ; i < lLen ; i++){

		//<dialog scope="document">̃m[h擾
		pInterruptDialogNodeList->get_item(i,&pInterruptDialogNode);
		
		//XgvfȂC
		if( mpListHead == NULL ){
			//_~[m[h̐iCParListNode̐CŏɃ_~[m[h܂Kvj
			mpListHead = new CDialogTreeNode;
			mpListTail = mpListHead;

			//CDialogNode̐
			pTempDialogTreeNode = new CDialogNode(&pInterruptDialogNode,this);
			if(pTempDialogTreeNode->mSuccess == 1){
				g_pLogDlg->setText("vIG[\r\n");
				delete pTempDialogTreeNode;
				return -1;
			}
			//CDialogNodeXg̍Ōɒǉ
			pTempDialogTreeNode->joinList(this->mpListTail);
			// XgŌւ̃|C^ړ
			this->mpListTail = pTempDialogTreeNode;

		}else{
		//XgvfłȂȂC

			//łɃXgɂCDialogNodeIuWFNgȂ̒T
			//( OCDialogNodeȂ̒T )
			// found_flag = 1
			//Ȃ flag = 0
			int found_flag = 0;
			CDialogNode* pCheckDialogTreeNode;		//ꎞIɃXgH邽߂̃m[h
			
			//TCDialogNode̖O擾
			BSTR bStrId;
			VARIANT vArIdValue;
			char cCheckDiaNodeName[WORD_LENGTH];
			bStrId= SysAllocString(L"@id");
			IXMLDOMNode* pIdAttrNode;

			pInterruptDialogNode->selectSingleNode(bStrId,&pIdAttrNode);
			pIdAttrNode->get_nodeValue(&vArIdValue);
			VARIANTToAscii(vArIdValue,cCheckDiaNodeName);
			SysFreeString(bStrId);
			VariantClear(&vArIdValue);


			// 擪i_~[m[hj̎̃m[h擾
			 pCheckDialogTreeNode= (CDialogNode*)mpListHead->retNextNode();
			//CDialogNodeɃXgɂȂ`FbN
			while( pCheckDialogTreeNode != NULL){
				 // m[h̎擾
				 string* strDiaNodeName;					//CDialogNode擾D
				 strDiaNodeName = new string();
				 pCheckDialogTreeNode->getName(strDiaNodeName);
				 if( strDiaNodeName->compare( cCheckDiaNodeName ) == 0 ){

					 //tOĂ
					 found_flag = -1;

					 //CDocumentNodeɃXgɑ݂Ă
					 //cerr << "" << cCheckDiaNodeName
					//	  << "CDialogtNode͐Ă܂\n";

					 //[v𔲂邽߂
					 pCheckDialogTreeNode = NULL;
					 Ret = -1;

				 }else{
					
					pCheckDialogTreeNode = (CDialogNode*)pCheckDialogTreeNode->retNextNode();

				 }
				delete strDiaNodeName;
				strDiaNodeName = NULL;
			}

			if( found_flag != -1 ){
				//CDialogNode̐
				pTempDialogTreeNode = new CDialogNode(&pInterruptDialogNode,this);
				if(pTempDialogTreeNode->mSuccess == 1){
					g_pLogDlg->setText("vIG[\r\n");
					delete pTempDialogTreeNode;
					return -1;
				}
				//CDialogNodeXg̍Ōɒǉ
				pTempDialogTreeNode->joinList(this->mpListTail);
				// XgŌւ̃|C^ړ
				this->mpListTail = pTempDialogTreeNode;
			}
		
			cCheckDiaNodeName[0] = '\0';
		}

	}


	return Ret;


}

//@\F
//		Xg̒Cŏ<dialog>ɑCDialogNodeANeBuԂɂD
//:
//		Ȃ
//߂lF
//	int 
//		0:
//	   -1:s
int CDocumentNode::beActiveDialog(){

	CString strLog;

	IXMLDOMNode* pFirstDialogNode = NULL;		//ŏ<dialog>DOMm[hi[
	BSTR bStrFirstDialogXPath;					//ŏ<dialog>XPathi[

	//ŏ<dialog>XPathi[
	bStrFirstDialogXPath = SysAllocString(L"//dialog");

	//ŏ<dialog>m[h̎擾
	( this->mpXislNode )->selectSingleNode(bStrFirstDialogXPath,&pFirstDialogNode);
	SysFreeString(bStrFirstDialogXPath);

	if( pFirstDialogNode == NULL ){
		strLog = this->mStrName.c_str();
		strLog += "ANeBuΏۂ̍ŏ<dialog>݂܂\r\n";
		g_pLogDlg->setText(strLog);

		return -1;
	}

	//ŏ<dialog>m[h_CAO̎擾
	BSTR bStrId;
	VARIANT vArIdValue;
	char cDialogName[WORD_LENGTH];
	bStrId= SysAllocString(L"@id");
	IXMLDOMNode* pIdAttrNode;

	pFirstDialogNode->selectSingleNode(bStrId,&pIdAttrNode);
	pIdAttrNode->get_nodeValue(&vArIdValue);
	VARIANTToAscii(vArIdValue,cDialogName);
	SysFreeString(bStrId);
	VariantClear(&vArIdValue);

	if( mpListHead ){

		//XgvfłȂȂC

		//ŏ<dialog>ɑΉCDialogNodeoD

		CDialogNode* pCheckDialogTreeNode;		//ꎞIɃXgH邽߂̃m[h
			
		// 擪i_~[m[hj̎̃m[h擾
		pCheckDialogTreeNode= (CDialogNode*)mpListHead->retNextNode();

		while( pCheckDialogTreeNode != NULL){
			 // m[h̎擾
			 string* strDiaNodeName;			//CDialogNode擾D
			 strDiaNodeName = new string();
			 pCheckDialogTreeNode->getName( strDiaNodeName );
			 if( strDiaNodeName->compare( cDialogName ) == 0 ){

				 //ŏ<dialog>ɑΉCDialogNodeD
				 //CDilaogNodeANeBuԂɂD
				 pCheckDialogTreeNode->beActive();

				delete strDiaNodeName;
				strDiaNodeName = NULL;

				return 0;

			}else{
					
				 //|C^Xg̎m[hɐi߂
				pCheckDialogTreeNode = (CDialogNode*)pCheckDialogTreeNode->retNextNode();
				delete strDiaNodeName;
				strDiaNodeName = NULL;

			 }

		}//whilȅI

		//ŏ<dialog>ɑΉCDialogNodeȂ
		strLog = this->mStrName.c_str();
		strLog += "ANeBuΏۂ̍ŏ<dialog>݂܂\r\n";
		g_pLogDlg->setText(strLog);

		return -1;

	}else{

		strLog = this->mStrName.c_str();
		strLog += "ANeBuΏۂ̍ŏ<dialog>݂܂\r\n";
		g_pLogDlg->setText(strLog);

		return -1;

	}

}

//@\F
//		Xg̒Cw肳ꂽ_CAO<dialog>ɑCDialogNode
//		ANeBuԂɂD
//:
//		string strDialogNameF_CAO
//߂lF
//	int 
//		0:
//	   -1:s( ΏۂCDialogNode݂Ȃj
int CDocumentNode::beActiveDialog(string strDialogName){


	CString strLog;

	//XgH邽߂CDialogNodẽ|C^
	CDialogNode* pTempDialogNodeBuff = NULL;

	if( mpListHead ){

		//_~[m[h̓ǂݔ΂
		pTempDialogNodeBuff = ( CDialogNode* )mpListHead->retNextNode();

		while( pTempDialogNodeBuff != NULL ){
			 // m[h̎擾
			 string* strDiaNodeName;			//CDialogNode擾D
			 strDiaNodeName = new string();
			 pTempDialogNodeBuff->getName( strDiaNodeName );

			 //ΏۂCDialogNodeƓOCDialogNodeȂ
			 if( strDiaNodeName->compare( strDialogName ) == 0 ){

				 pTempDialogNodeBuff->beActive();

				 delete strDiaNodeName;
				 return 0;

			 }

			 //|C^Xg̎m[hɂ߂
			 pTempDialogNodeBuff = ( CDialogNode* ) pTempDialogNodeBuff->retNextNode();

			 delete strDiaNodeName;
			 strDiaNodeName = NULL;
		}
		
		//ANeBuΏۂCDialogNodeȂD
		strLog = this->mStrName.c_str();
		strLog += "̃XgɁCANeBuΏۂid = ";
		strLog += strDialogName.c_str();
		strLog +="CDialogNode݂܂\r\n";
		g_pLogDlg->setText(strLog);
		return -1;

	}else{
		strLog = this->mStrName.c_str();
		strLog += "̃XgɁCANeBuΏۂid = ";
		strLog += strDialogName.c_str();
		strLog +="CDialogNode݂܂\r\n";
		g_pLogDlg->setText(strLog);
		return -1;
	}

}

//Xg̒w肳ꂽ_CAO
//CDialogNodeANeBuԂɂA̎qXg
//w肳ꂽDistanceFromDialogƓlExchange
//AANeBuԂɂD
int CDocumentNode::beActiveExchange(string strDialogName,int DistanceFromDialog ){

	CString strLog;

	//XgH邽߂CDialogNodẽ|C^
	CDialogNode* pTempDialogNodeBuff = NULL;

	if( mpListHead ){

		//_~[m[h̓ǂݔ΂
		pTempDialogNodeBuff = ( CDialogNode* )mpListHead->retNextNode();

		while( pTempDialogNodeBuff != NULL ){
			 // m[h̎擾
			 string* strDiaNodeName;			//CDialogNode擾D
			 strDiaNodeName = new string();
			 pTempDialogNodeBuff->getName( strDiaNodeName );

			 //ΏۂCDialogNodeƓOCDialogNodeȂ
			 if( strDiaNodeName->compare( strDialogName ) == 0 ){

				 pTempDialogNodeBuff->CDialogTreeNode::beActive();
				 delete strDiaNodeName;

				 return ((CDialogNode*)pTempDialogNodeBuff)->beActiveExchange(DistanceFromDialog);

			 }

			 //|C^Xg̎m[hɂ߂
			 pTempDialogNodeBuff = ( CDialogNode* ) pTempDialogNodeBuff->retNextNode();

			 delete strDiaNodeName;
			 strDiaNodeName = NULL;
		}
		
		//ANeBuΏۂCDialogNodeȂD
		strLog = this->mStrName.c_str();
		strLog += "̃XgɁCANeBuΏۂid = ";
		strLog += strDialogName.c_str();
		strLog +="CDialogNode݂܂\r\n";
		g_pLogDlg->setText(strLog);
		return -1;

	}else{
		strLog = this->mStrName.c_str();
		strLog += "̃XgɁCANeBuΏۂid = ";
		strLog += strDialogName.c_str();
		strLog +="CDialogNode݂܂\r\n";
		g_pLogDlg->setText(strLog);
		return -1;
	}


}



//@\F
//		ŗ^ꂽ_CAOm[hȉD
//F
//		string strDialogNameF_CAO
//߂lF
//		int
//			0:
//		   -1:s
int CDocumentNode::deleteDialog(string strDialogName){

	CString strLog;

	CDialogTreeNode* pDialogNodeBuff;

	if( mpListHead ){

		string* strDialogNameBuff;
		strDialogNameBuff = new string();

		pDialogNodeBuff =  mpListHead;

		//̃m[h̎qvfɒHȂ
		while( pDialogNodeBuff != NULL){

			// 擪i_~[m[hj̎̃m[h擾
			pDialogNodeBuff = ( CDialogTreeNode * )pDialogNodeBuff -> retNextNode();
			if( pDialogNodeBuff != NULL ){
				pDialogNodeBuff->getName(strDialogNameBuff);
				if( strDialogName.compare( strDialogNameBuff->c_str() ) == 0 ){
					//Ώۃm[hXg̍ŌȂ
					if( pDialogNodeBuff->retNextNode() == NULL ){
						mpListTail = ( CDialogTreeNode*) pDialogNodeBuff->retPrevNode();
					}

					//CDocumentNodeXg͂
					pDialogNodeBuff->cutOffList();
					//XgOIuWFNg̏
					delete pDialogNodeBuff;
					delete strDialogNameBuff;
					return 0;
				}
			}

		}
		delete strDialogNameBuff;

		strLog = "Ώۂ";
		strLog += strDialogName.c_str();
		strLog += ":CDialogNode܂\r\n";
		g_pLogDlg->setText(strLog);

		return -1;

	}else{

		strLog = "Ώۂ";
		strLog += strDialogName.c_str();
		strLog += ":CDialogNode܂\r\n";
		g_pLogDlg->setText(strLog);
		
		return -1;
	}


}

//@\Fw肵_CAOm[hΘbc[O
//		̃m[ĥł͂ȂCΘbc[o
//F
//		string strDialogNode:o_CAOm[h
//߂lF
//	int
//		0:
//	   -1:s
int CDocumentNode::cutOffDialog(string strDialogName,CDialogTreeNode** pDialogNode){

	CDialogTreeNode* pDialogNodeBuff;

	CString strLog;

	if( mpListHead ){

		string* strDialogNameBuff;
		strDialogNameBuff = new string();

		pDialogNodeBuff =  mpListHead;

		//̃m[h̎qvfɒHȂ
		while( pDialogNodeBuff != NULL){

			// 擪i_~[m[hj̎̃m[h擾
			pDialogNodeBuff = ( CDialogTreeNode * )pDialogNodeBuff -> retNextNode();
			if( pDialogNodeBuff != NULL ){
				pDialogNodeBuff->getName(strDialogNameBuff);
				if( strDialogName.compare( strDialogNameBuff->c_str() ) == 0 ){
					//Ώۃm[hXg̍ŌȂ
					if( pDialogNodeBuff->retNextNode() == NULL ){
						mpListTail = (CDialogTreeNode* )pDialogNodeBuff->retPrevNode();
					}
					//CDocumentNodeXg͂
					pDialogNodeBuff->cutOffList();
					//Om[hC|C^̃|C^
					*pDialogNode = pDialogNodeBuff;
					delete strDialogNameBuff;
					return 0;
				}
			}

		}
		delete strDialogNameBuff;


		strLog = "Ώۂ";
		strLog += strDialogName.c_str();
		strLog += ":CDialogNode܂\r\n";
		g_pLogDlg->setText(strLog);

		return -1;

	}else{
		CString strLog;
		strLog = "Ώۂ";
		strLog += strDialogName.c_str();
		strLog += ":CDialogNode܂\r\n";
		g_pLogDlg->setText(strLog);
		return -1;

	}
}

//@\F
//		qvfɁCV_CAOm[hǉ
//F
//		ǉ_CAOm[h|C^̃|C^
//߂lF
//	int
//		0:
//	   -1:s
int CDocumentNode::appendDialog(CDialogTreeNode** pDialogNode){

	//XgvfȂC
	if( mpListHead == NULL ){
		//_~[m[h̐iCParListNode̐CŏɃ_~[m[h܂Kvj
		mpListHead = new CDialogTreeNode;
		mpListTail = mpListHead;
	}

	//ǉhLgm[hXg̍Ōɒǉ
	(*pDialogNode)->joinList(this->mpListTail);
	// XgŌւ̃|C^ړ
	this->mpListTail = *pDialogNode;

	return 0;
}

//hLg̃^Cvi[g[tԂj
//߂lF
//	int hLg̃^Cv
int CDocumentNode::getDocmentType(){

	return mDocumentType;
}

//ANeBuԂ̃_CAȎΘbc[̃|C^ԂD
//߂lF
//	int 0 F
//  int -1Fs
int CDocumentNode::getActiveDialogNode(CDialogTreeNode** pDialogTreeNode){

	CDialogTreeNode* pDialogNodeBuff;

	if( mpListHead ){

		pDialogNodeBuff =  (CDialogTreeNode*) mpListHead->retNextNode();

		//̃m[h̎qvfɒHȂ
		while( pDialogNodeBuff != NULL){

			if( pDialogNodeBuff->getState() == ACTIVE ){
				*pDialogTreeNode = pDialogNodeBuff;
				return 0;
			}
			
			//Xg̎m[h擾 
			pDialogNodeBuff = ( CDialogTreeNode * )pDialogNodeBuff -> retNextNode();

		}
		g_pLogDlg->setText("ANeBuCDialogNode܂\r\n"); 
		return -1;

	}else{
		g_pLogDlg->setText("ANeBuCDialogNode܂\r\n"); 
		return -1;
	}

}

//w肵_CAOΘbc[̃|C^Ԃ
//	F  
//		string strDialogNameF_CAO
//		CDialogTreeNode** :Θbc[QƂ|C^̃|C^
//߂lF
//	int
//		0F
//	   -1Fs
int CDocumentNode::getDialogNode(string strDialogName, CDialogTreeNode** pDialogTreeNode){

	//Xgǂ邽߂̃|C^
	CDialogTreeNode* pDialogNodeBuff;
	string strTempDialogNodeName;

	if( mpListHead ){

		pDialogNodeBuff =  (CDialogTreeNode*) mpListHead->retNextNode();

		//̃m[h̎qvfɒHȂ
		while( pDialogNodeBuff != NULL){

			pDialogNodeBuff->getName(&strTempDialogNodeName);

			if( strTempDialogNodeName == strDialogName ){
				//Ώۃm[h
				*pDialogTreeNode = pDialogNodeBuff;
				return 0;
			}
			
			//Xg̎m[h擾 
			pDialogNodeBuff = ( CDialogTreeNode * )pDialogNodeBuff -> retNextNode();

		}
		g_pLogDlg->setText("擾ΏۂCDialogNode܂\r\n"); 
		return -1;

	}else{
		g_pLogDlg->setText("擾ΏۂCDialogNode܂\r\n"); 
		return -1;
	}

}

//ŏ<dialog>ɑ_CAOm[hւ̎QƂԂ
//	F  
//		CDialogTreeNode** :Θbc[QƂ|C^̃|C^
//߂lF
//	int
//		0F
//	   -1Fs
int CDocumentNode::getDialogNode(CDialogTreeNode** pDialogTreeNode){

	CString strLog;

	IXMLDOMNode* pFirstDialogNode = NULL;		//ŏ<dialog>DOMm[hi[
	BSTR bStrFirstDialogXPath;					//ŏ<dialog>XPathi[

	//ŏ<dialog>XPathi[
	bStrFirstDialogXPath = SysAllocString(L"//dialog");

	//ŏ<dialog>m[h̎擾
	( this->mpXislNode )->selectSingleNode(bStrFirstDialogXPath,&pFirstDialogNode);
	SysFreeString(bStrFirstDialogXPath);

	if( pFirstDialogNode == NULL ){

		strLog = this->mStrName.c_str();
		strLog += "Ɏ擾Ώۂ̍ŏ<dialog>݂܂\r\n";
		g_pLogDlg->setText(strLog);

		return -1;
	}

	//ŏ<dialog>m[h_CAO̎擾
	BSTR bStrId;
	VARIANT vArIdValue;
	char cDialogName[WORD_LENGTH];
	bStrId= SysAllocString(L"@id");
	IXMLDOMNode* pIdAttrNode;

	pFirstDialogNode->selectSingleNode(bStrId,&pIdAttrNode);
	pIdAttrNode->get_nodeValue(&vArIdValue);
	VARIANTToAscii(vArIdValue,cDialogName);
	SysFreeString(bStrId);
	VariantClear(&vArIdValue);

	if( mpListHead ){

		//XgvfłȂȂC

		//ŏ<dialog>ɑΉCDialogNodeoD

		CDialogNode* pCheckDialogTreeNode;		//ꎞIɃXgH邽߂̃m[h
			
		// 擪i_~[m[hj̎̃m[h擾
		pCheckDialogTreeNode= (CDialogNode*)mpListHead->retNextNode();

		while( pCheckDialogTreeNode != NULL){
			 // m[h̎擾
			 string* strDiaNodeName;			//CDialogNode擾D
			 strDiaNodeName = new string();
			 pCheckDialogTreeNode->getName( strDiaNodeName );
			 if( strDiaNodeName->compare( cDialogName ) == 0 ){

				 //ŏ<dialog>ɑΉCDialogNodeD
				*pDialogTreeNode = pCheckDialogTreeNode;

				delete strDiaNodeName;
				strDiaNodeName = NULL;

				return 0;

			}else{
					
				 //|C^Xg̎m[hɐi߂
				pCheckDialogTreeNode = (CDialogNode*)pCheckDialogTreeNode->retNextNode();
				delete strDiaNodeName;
				strDiaNodeName = NULL;

			 }

		}//whilȅI

		//ŏ<dialog>ɑΉCDialogNodeȂ
		strLog = this->mStrName.c_str();
		strLog += "Ɏ擾Ώۂ̍ŏ<dialog>܂ł\r\n";
		g_pLogDlg->setText(strLog);

		return -1;

	}else{

		strLog = this->mStrName.c_str();
		strLog += "Ɏ擾Ώۂ̍ŏ<dialog>܂ł\r\n";
		g_pLogDlg->setText(strLog);
		return -1;

	}
}


//\[XEBhEɋLq
void CDocumentNode::writeSource(){

	BSTR bstrXislNodeName;
	BSTR bstrXislChildNodeName;
	BSTR bstrBodyChildNodeName;

	CString strTemp;
	char cXislNodeName[WORD_LENGTH];
	char cXislChildNodeName[WORD_LENGTH];
	char cBodyChildNodeName[WORD_LENGTH];


	IXMLDOMNode* pXislNode;
	IXMLDOMNode* pXislChildNode;
	IXMLDOMNode* pBodyChildNode;

	//hLgfo
	strTemp = mStrName.c_str();
	strTemp += "\\line";
	theApp.addString(strTemp,4,this->mDocumentType);
	
	this->mpXislNode->get_nextSibling(&pXislNode);
	pXislNode->get_nextSibling(&pXislNode);

	while(pXislNode != NULL ){

		//m[h̎擾
		pXislNode->get_baseName(&bstrXislNodeName);
		BSTRToAscii(bstrXislNodeName,cXislNodeName,MESSAGE_LENGTH);
		SysFreeString(bstrXislNodeName);

		//[gvfȂ
		if( !strcmp(cXislNodeName,"xisl") ){

			theApp.getSource(pXislNode,strTemp);
			strTemp += "\\line";
			theApp.addString(strTemp,0,this->mDocumentType);

			//̎qvfɂ
			pXislNode->get_firstChild(&pXislChildNode);

			while( pXislChildNode != NULL ){

				//m[h̎擾
				pXislChildNode->get_baseName(&bstrXislChildNodeName);
				BSTRToAscii(bstrXislChildNodeName,cXislChildNodeName,MESSAGE_LENGTH);
				SysFreeString(bstrXislChildNodeName);

				//bodyvfȂ
				if( !strcmp(cXislChildNodeName,"body") ){

					theApp.getSource(pXislChildNode,strTemp);
					//^uP}
					strTemp.Insert(0,"  ");
					strTemp += "\\line";
					theApp.addString(strTemp,0,this->mDocumentType);

					//̎qvfɂ
					pXislChildNode->get_firstChild(&pBodyChildNode);

					while( pBodyChildNode != NULL ){

						//m[h̎擾
						pBodyChildNode->get_baseName(&bstrBodyChildNodeName);
						BSTRToAscii(bstrBodyChildNodeName,cBodyChildNodeName,MESSAGE_LENGTH);
						SysFreeString(bstrBodyChildNodeName);

						//dialogvfȂ
						if( !strcmp(cBodyChildNodeName,"dialog") ){

							//dialog̎擾
							//m[h(_CAO)̎擾
							BSTR bStrId;
							VARIANT vArIdValue;
							char cDialogName[WORD_LENGTH];
							bStrId= SysAllocString(L"./@id");
							IXMLDOMNode* pIdAttrNode;

							//Θbc[Ƀ_CAO
							int findDialog;

							findDialog = 0;

							pBodyChildNode->selectSingleNode(bStrId,&pIdAttrNode);
							if( pIdAttrNode ){
								pIdAttrNode->get_nodeValue(&vArIdValue);
								VARIANTToAscii(vArIdValue,cDialogName);
								VariantClear(&vArIdValue);
								if( mpListHead ){

									CDialogTreeNode* tempDialogTreeNode;

									//_~[m[h̓ǂݔ΂
									tempDialogTreeNode = ( CDialogTreeNode* )mpListHead->retNextNode();

									while( tempDialogTreeNode != NULL ){

										string strDialogName;
										tempDialogTreeNode->getName(&strDialogName);
										
										if( strDialogName == cDialogName ){

											findDialog = 1;
											((CDialogNode*)tempDialogTreeNode)->writeSource(this->mDocumentType);

										}
										tempDialogTreeNode = ( CDialogTreeNode* )tempDialogTreeNode->retNextNode();			

									}

									//Θbc[ɂȂ΁C\[X̂܂ܕ\
									if( findDialog == 0 ){
										theApp.writeSource(pBodyChildNode,2,this->mDocumentType,0);
									}
					
									findDialog = 0;
								}
							}//邩ǂ
							SysFreeString(bStrId);

						}else{

							//dialogvfłȂ
							theApp.writeSource(pBodyChildNode,2,this->mDocumentType,0);

						}

						pBodyChildNode->get_nextSibling(&pBodyChildNode);

					}
					strTemp = "  </body>";
					strTemp += "\\line";
					theApp.addString(strTemp,0,this->mDocumentType);


				}else{

					//bodyvfłȂ
					theApp.writeSource(pXislChildNode,1,this->mDocumentType,0);

				}

				pXislChildNode->get_nextSibling(&pXislChildNode);

			}//xisl̎qvfɂ

			strTemp = "</xisl>";
			strTemp += "\\line";
			theApp.addString(strTemp,0,this->mDocumentType);

			
		}else{

			//[gvfłȂ
			theApp.writeSource(pXislNode,0,this->mDocumentType,0);

		}

		pXislNode->get_nextSibling(&pXislNode);	
	}


}