//
// SLR(1)\͊vO
// GLR\͊
//
// GLRParser.h / GLRParser.cpp
//
// ̃vÓCMMIVXeɈˑȂvOłB
//
// 2002/09/10 Tue. G
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#include "StdAfx.h"
#include <assert.h>
#include <iostream>

#include "GLRParser.h"

using namespace std;


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//

//
// CLRStackHistoryItem
//

//
// ֐ : CLRStackHistoryItem::CLRStackHistoryItem()
// @  \ : ftHgRXgN^
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
CLRStackHistoryItem::CLRStackHistoryItem()
{
	m_bPush = true;
	m_strSymbol = "";
}

//
// ֐ : CLRStackHistoryItem::CLRStackHistoryItem( bool push, string symbol )
// @  \ : RXgN^
//    : push --- ̎(true:pushCfalse:pop)
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
CLRStackHistoryItem::CLRStackHistoryItem( bool push, string symbol )
{
	m_bPush = push;
	m_strSymbol = symbol;
}

//
// ֐ : CLRStackHistoryItem::CLRStackHistoryItem( const CLRStackHistoryItem &item )
// @  \ : Rs[RXgN^
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
CLRStackHistoryItem::CLRStackHistoryItem( const CLRStackHistoryItem &item )
{
	m_bPush = item.GetStackOperation();
	m_strSymbol = item.GetSymbol();
}

//
// ֐ : CLRStackHistoryItem::~CLRStackHistoryItem()
// @  \ : fXgN^
//    : 
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
CLRStackHistoryItem::~CLRStackHistoryItem()
{
}

//
// ֐ : bool CLRStackHistoryItem::GetStackOperation() const
// @  \ : ̎ނԂ
//    : Ȃ
// ߂l : true : pushCfalse : pop
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
bool CLRStackHistoryItem::GetStackOperation() const
{
	return m_bPush;
}

//
// ֐ : string CLRStackHistoryItem::GetSymbol() const
// @  \ : ɗpꂽL擾
//    : Ȃ
// ߂l : m_strSymbol̒l
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
string CLRStackHistoryItem::GetSymbol() const
{
	return m_strSymbol;
}

//
// ֐ : void CLRStackHistoryItem::SetOperationInfo( bool bPush, string symbol )
// @  \ : X^bN̏ݒ肷
//    : bPush --- ̎(true:push,false:pop)
//			symbol --- ɗpꂽL
// ߂l : Ȃ
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
void CLRStackHistoryItem::SetOperationInfo( bool bPush, string symbol )
{
	m_bPush = bPush;
	m_strSymbol = symbol;
}

//
// ֐ : CLRStackHistoryItem &CLRStackHistoryItem::operator = ( CLRStackHistoryItem &item )
// @  \ : Zq
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
CLRStackHistoryItem &CLRStackHistoryItem::operator = ( const CLRStackHistoryItem &item )
{
	if ( &item == this ) { return *this; }

	m_bPush = item.GetStackOperation();
	m_strSymbol = item.GetSymbol();

	return *this;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//


//
// CLRStackItem
//

//
// ֐ : CLRStackItem::CLRStackItem()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/09 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/09 Fri.
//
CLRStackItem::CLRStackItem()
{
	m_nType = TYPE_UNKNOWN;
	m_strSymbol[ 0 ] = '\0';
	m_nStateNumber = -1;
}

//
// ֐ : CLRStackItem::CLRStackItem( const char *symbol )
// @  \ : RXgN^
//    : symbol ---- ͋L
// 쐬 : 2001/11/09 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/09 Fri.
//
CLRStackItem::CLRStackItem( const char *symbol )
{
	m_nType = TYPE_SYMBOL;
	strcpy( m_strSymbol, symbol );
	m_nStateNumber = -1;
}

//
// ֐ : CLRStackItem::CLRStackItem( int state )
// @  \ : RXgN^
//    : state --- Ԕԍ
// 쐬 : 2001/11/09 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/09 Fri.
//
CLRStackItem::CLRStackItem( int state )
{
	m_nType = TYPE_STATE;
	m_strSymbol[ 0 ] = '\0';
	m_nStateNumber = state;
}

//
// ֐ : CLRStackItem::CLRStackItem( const CLRStackItem &item )
// @  \ : Rs[RXgN^
//    : item -- Rs[
// 쐬 : 2001/11/09 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/09 Fri.
//
CLRStackItem::CLRStackItem( const CLRStackItem &item )
{
	m_nType = item.GetItemType();
	strcpy( m_strSymbol, item.GetSymbol() );
	m_nStateNumber = item.GetStateNumber();
}
//
// ֐ : CLRStackItem::~CLRStackItem()
// @  \ : fXgN^
// 쐬 : 2001/11/09 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/09 Fri.
//
CLRStackItem::~CLRStackItem()
{
}

//
// ֐ : ITEMTYPE CLRStackItem::GetItemType() const
// @  \ : Ă̎ނԂ
//    : Ȃ
// ߂l : ITEMTYPE񋓌^̒l
// 쐬 : 2001/11/09 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/09 Fri.
//
ITEMTYPE CLRStackItem::GetItemType() const
{
	return m_nType;
}

//
// ֐ : const char *GetSymbol() const
// @  \ : ێĂLԂ
//    : Ȃ
// ߂l : Lւ̃|C^
// 쐬 : 2001/11/09 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/09 Fri.
//
const char *CLRStackItem::GetSymbol() const
{
	return m_strSymbol;
}


//
// ֐ : int CLRStackItem::GetStateNumber() const
// @  \ : ێĂԔԍԂ
//    : Ȃ
// ߂l : m_nStateNumber̒l
// 쐬 : 2001/11/09 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/09 Fri.
//
int CLRStackItem::GetStateNumber() const
{
	return m_nStateNumber;
}


//
// ֐ : void CLRStackItem::SetItem( const char *symbol )
// @  \ : Lݒ肷
//    : symbol --- ݒ肷L
// ߂l : Ȃ
// 쐬 : 2001/11/09 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/09 Fri.
//
void CLRStackItem::SetItem( const char *symbol )
{
	m_nType = TYPE_SYMBOL;
	strcpy( m_strSymbol, symbol );
	m_nStateNumber = -1;
}

//
// ֐ : void CLRStackItem::SetItem( int state )
// @  \ : Ԕԍݒ肷 
//    : state --- ݒ肷Ԕԍ
// ߂l : Ȃ
// 쐬 : 2001/11/09 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/09 Fri.
//
void CLRStackItem::SetItem( int state )
{
	m_nType = TYPE_STATE;
	m_strSymbol[ 0 ] = '\0';
	m_nStateNumber = state;
}

//
// ֐ : CLRStackItem &CLRStackItem::operator = ( CLRStackItem &item )
// @  \ : Zq
//    : item ---- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/09 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/09 Fri.
//
CLRStackItem &CLRStackItem::operator = ( const CLRStackItem &item )
{
	if ( &item == this ) { return *this; }

	m_nType = item.GetItemType();
	strcpy( m_strSymbol, item.GetSymbol() );
	m_nStateNumber = item.GetStateNumber();

	return *this;
}

//
// CLRStack
//


//
// ֐ : CLRStack::CLRStack()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
CLRStack::CLRStack() : m_Stack(), m_History(), m_SaveStack()
{
	m_nStackNumber = -1;
	m_nLastHistorySize = 0;
	m_bValid = true;
}

//
// ֐ : CLRStack::CLRStack( int number )
// @  \ : RXgN^
//    : X^bNʔԍ
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
CLRStack::CLRStack( int number ) : m_Stack(), m_History(), m_SaveStack()
{
	m_nStackNumber = number;
	m_nLastHistorySize = 0;
	m_bValid = true;
}


//
// ֐ : CLRStack::CLRStack( const CLRStack &lrstack )
// @  \ : Rs[RXgN^
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
CLRStack::CLRStack( const CLRStack &lrstack )
{
	m_nStackNumber = lrstack.GetStackNumber();
	m_nLastHistorySize = lrstack.GetLastHistorySize();

	m_Stack = lrstack.GetStack();
	m_History = lrstack.GetStackHistory();

	m_bValid = lrstack.GetStackValid();
	
	m_SaveStack = lrstack.GetSaveStack();
}

//
// ֐ : CLRStack::~CLRStack() 
// @  \ : fXgN^
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
CLRStack::~CLRStack()
{
	Initialize();
}

//
// ֐ : void CLRStack::Initialize()
// @  \ : X^bN
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
void CLRStack::Initialize()
{
	m_SaveStack.clear();
	m_Stack.clear();
	m_History.clear();
	m_nStackNumber = -1;
	m_nLastHistorySize = 0;

	m_bValid = true;
}

//
// ֐ : void CLRStack::InitialState()
// @  \ : X^bN
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2002/07/11 Thur. G
//
void CLRStack::InitialState()
{
	//cout << "X^bNԂɂȂ܂B" << endl;

	int number = m_nStackNumber;

	Initialize();

	m_nStackNumber = number;

	Push( 0 );
	m_SaveStack.push_back( CLRStackItem( 0 ) );
}

//
// ֐ : int CLRStack::GetCount() const
// @  \ : X^bNɐς܂Ăvf擾
//    : Ȃ
// ߂l : X^bNɐς܂Ăvf
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
int CLRStack::GetStackSize() const
{
	return m_Stack.size();
}

//
// ֐ : int CLRStack::GetStackNumber() const
// @  \ : X^bN̎ʔԍ擾
//    : Ȃ
// ߂l : m_nStackNumber̒l
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
int CLRStack::GetStackNumber() const
{
	return m_nStackNumber;
}

//
// ֐ : void CLRStack::SetStackNumber( int number )
// @  \ : X^bN̎ʔԍݒ肷
//    : number --- X^bN̎ʔԍ
// ߂l : Ȃ
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
void CLRStack::SetStackNumber( int number )
{
	m_nStackNumber = number;
}

//
// ֐ : void CLRStack::Push( const char *symbol )
// @  \ : vfX^bNpush
//    : symbol ---- vfɓl(Lj
// ߂l : Ȃ
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
void CLRStack::Push( const char *symbol )
{
	m_Stack.push_back( CLRStackItem( symbol ) );
	m_History.push_back( CLRStackHistoryItem( true, symbol ) );
}

//
// ֐ : void CLRStack::Push( int state )
// @  \ : vfX^bNpush
//    : state ---- vfɓl(Ԕԍj
// ߂l : Ȃ
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
void CLRStack::Push( int state )
{
	m_Stack.push_back( CLRStackItem( state ) );
}

//
// ֐ : void CLRStack::Push( CLRStackItem &item )
// @  \ : vfX^bNpush
//    : symbol ---- X^bNɂޗvf
// ߂l : Ȃ
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
void CLRStack::Push( CLRStackItem &item )
{
	m_Stack.push_back( item );
	if ( item.GetItemType() == TYPE_SYMBOL ) {
		m_History.push_back( CLRStackHistoryItem( true, item.GetSymbol() ) );
	}
}

//
// ֐ : void CLRStack::Pop()
// @  \ : X^bN̐擪vf|bv
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
void CLRStack::Pop()
{
	CLRStackItem item;

	if ( m_Stack.size() > 0 ) {
		// poṕCvfȏ゠Ƃ
		item = m_Stack.back();
		if ( item.GetItemType() == TYPE_SYMBOL ) {
			// popvfLȂ΁C̗ۑB
			m_History.push_back( CLRStackHistoryItem( false, item.GetSymbol() ) );
		}
		m_Stack.pop_back();	// iX^bN̐擪j폜
	}
}

//
// ֐ : CLRStackItem &CLRStack::Top()
// @  \ : X^bN̐擪vf擾
//    : Ȃ
// ߂l : 擪vfւ̎Q
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
CLRStackItem &CLRStack::Top()
{
	return m_Stack.back();
}

//
// ֐ : CLRStackItem &CLRStack::GetItem( int index )
// @  \ : X^bN̔Cӂ̗vf擾
//    : index ---- 擾vf̈ʒui납琔j
// ߂l : 擾vfւ̎Q
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
CLRStackItem &CLRStack::GetItem( int index )
{
	// 납琔c
	int r_index = m_Stack.size() - ( index + 1 );
	
	assert( ( r_index >= 0 ) && ( r_index < m_Stack.size() ) );

	list < CLRStackItem >::iterator sp = m_Stack.begin();
	list < CLRStackItem >::iterator ep = m_Stack.end();

	while ( sp != ep ) {
		if ( r_index == 0 ) { break; }
		sp ++; r_index --;
	}

	assert( sp != ep );

	return *sp;
}

//
// ֐ : const list < CLRStackItem > &GetStack() const
// @  \ : X^bN擾
//    : Ȃ
// ߂l : m_Stackւ̎Q
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
const list < CLRStackItem > &CLRStack::GetStack() const
{
	return m_Stack;
}


//
// ֐ : CLRStack &CLRStack::operator = ( CLRStack & lrstack )
// @  \ : Zq
//    : lrstack --- Rs[
// ߂l : IuWFNg
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
CLRStack &CLRStack::operator = ( const CLRStack &lrstack )
{
	if ( &lrstack == this ) { return *this; }

	Initialize();

	m_nStackNumber = lrstack.GetStackNumber();
	m_nLastHistorySize = lrstack.GetLastHistorySize();

	m_Stack = lrstack.GetStack();
	m_History = lrstack.GetStackHistory();

	m_bValid = lrstack.GetStackValid();
	
	m_SaveStack = lrstack.GetSaveStack();

	return *this;
}

//
// ֐ : void CLRStack::Display( int flag )
// @  \ : 
//    : flag ---- \tO(0FX^bNobNAbvC1:X^bN̂݁C2:obNAbv̂)
// ߂l :
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2002/07/11 Thur. G
//
void CLRStack::Display( int flag )
{
	cout << "------------------ STACK : NO." << m_nStackNumber << endl;

	list < CLRStackItem >::reverse_iterator sp, ep;

	if ( flag != 2 ) {		// X^bN̕\
		cout << "STACK      : ";
		sp = m_Stack.rbegin();		ep = m_Stack.rend();
		for ( ; sp != ep; sp ++ ) {
			switch ( sp->GetItemType() ) {
				case TYPE_STATE  : cout << "[STATE " << sp->GetStateNumber() << "]"; break;
				case TYPE_SYMBOL : cout << "[SYMBOL " << sp->GetSymbol()     << "]"; break;
				default          : cout << "[UNKNOWN]";                              break;
			}
			cout << " ";
		}
		cout << endl;
	}

	if ( flag != 1 ) {		// obNAbv̕\
		cout << "SAVE STACK : ";
		sp = m_SaveStack.rbegin();		ep = m_SaveStack.rend();
		for ( ; sp != ep; sp ++ ) {
			switch ( sp->GetItemType() ) {
				case TYPE_STATE  : cout << "[STATE " << sp->GetStateNumber() << "]"; break;
				case TYPE_SYMBOL : cout << "[SYMBOL " << sp->GetSymbol()     << "]"; break;
				default          : cout << "[UNKNOWN]";                              break;
			}
		}
		cout << endl;
	}
}

//
// ֐ : int CLRStack::GetHistorySize() const
// @  \ : TCY擾
//    : Ȃ
// ߂l : m_HistoryXg̃TCY
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
int CLRStack::GetHistorySize() const
{
	return m_History.size();
}

//
// ֐ : CLRStackHistoryItem &CLRStack::GetHistoryItem( int index )
// @  \ : 擾
//    : index ---- 擾񂪂ʒu
// ߂l : 擾
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
CLRStackHistoryItem &CLRStack::GetHistoryItem( int index )
{
	assert( ( index >= 0 ) && ( index < m_History.size() ) );

	list < CLRStackHistoryItem >::iterator sp, ep;
	sp = m_History.begin();		ep = m_History.end();

	while ( ( sp != ep ) && ( index > 0 ) ) {
		sp ++; index --;
	}

	assert( ( sp != ep ) && ( index == 0 ) );

	return *sp;

}

//
// ֐ : const list < CLRStackHistoryItem > CLRStack::GetStackHistory() const
// @  \ : Xg擾
//    : Ȃ
// ߂l : Xg(m_History)ւ̎Q
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
const list < CLRStackHistoryItem > &CLRStack::GetStackHistory() const 
{
	return m_History;
}

//
// ֐ : int CLRStack::GetLastHistorySize() const
// @  \ : ̒ÕTCY
//    : Ȃ
// ߂l : 
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
int CLRStack::GetLastHistorySize() const
{
	return m_nLastHistorySize;
}

//
// ֐ : int CLRStack::SetLastHistorySize() 
// @  \ : ݂̌̐擪CfbNXݒ肷
//    : 
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
int CLRStack::SetLastHistorySize()
{
	m_nLastHistorySize = m_History.size();

	return m_nLastHistorySize;
}

//
// ֐ : bool CLRStack::GetStackValid() const
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
bool CLRStack::GetStackValid() const
{
	return m_bValid;
}

//
// ֐ : void CLRStack::SetStackValid( bool valid )
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
void CLRStack::SetStackValid( bool valid )
{
	m_bValid = valid;
}

//
// ֐ : void CLRStack::SaveStack()
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2002/07/11 Thur. G
//
void CLRStack::SaveStack()
{
	//cout << "Save Stack" << endl;
	m_SaveStack = m_Stack;
}

//
// ֐ : void CLRStack::SetSaveStack()
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2002/07/11 Thur. G
//
void CLRStack::SetSaveStack()
{
//	cout << "Restore Stack" << endl;
	m_Stack = m_SaveStack;
	//Display( 1 );
}

//
// ֐ : const list < CLRStackItem > &CLRStack::GetSaveStack() const
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
const list < CLRStackItem > &CLRStack::GetSaveStack() const
{
	return m_SaveStack;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//


//
// CGLRParser
//


//
// ֐ : CGLRParser::CGLRParser()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
CGLRParser::CGLRParser() : m_StackList(), m_Grammar(), m_LRTable()
{
	m_nNewStackNumber = 1;
}

//
// ֐ : CGLRParser::CGLRParser( CContextFreeGrammar &grammar, CLRTable &table )
// @  \ : RXgN^
//    : grammar --- @
//			table ----- LR\͕\
// ߂l :
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
CGLRParser::CGLRParser( CContextFreeGrammar &grammar, CLRTable &table ) : m_StackList()
{
	m_nNewStackNumber = 1;
	m_Grammar = grammar;
	m_LRTable = table;

	// X^bN̐
	GotoInitialState();
}

//
// ֐ : CGLRParser::~CGLRParser()
// @  \ : fXgN^
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
CGLRParser::~CGLRParser()
{
	Initialize();
}

//
// ֐ : void CGLRParser::Initialize()
// @  \ : 
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
void CGLRParser::Initialize()
{
	m_StackList.clear();

	m_nNewStackNumber = 1;
}

//
// ֐ : vector < CActionHistoryList > &CGLRParser::Input( const char *symbol )
// @  \ : ͎t
//    : symbol --- ͋L
// ߂l : s̗Xg
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2002/07/11 Thur. G
//

int CGLRParser::Input( const char *symbol )
{
	list < CLRStack > sublist;
	list < CLRStack >::iterator sp, ep;

	m_LastAction.clear();

	// ݂LȑSẴX^bNɑ΂āC͂sB
	sp = m_StackList.begin();	ep = m_StackList.end();

	while ( sp != ep ) {
		
		//cout << "INPUT : " << symbol << endl;

		if ( sp->GetStackValid() ) {
			// LȃX^bNɓ͂āCB
			sp->SetLastHistorySize();
			Input( symbol, *sp, sublist );
			//sp->Display( 1 );
			// sp->Display( 0 );
		}
		else {
			// ȃX^bNɑ΂͂cB
		}

		sp ++;
	}

	// ͉ߒŐꂽX^bNǉB
	sp = sublist.begin();	ep = sublist.end();
	while ( sp != ep ) {
		m_StackList.push_back( *sp );
		sp ++;
	}

	// ͂G[ɂȂX^bŃCB
	int valid_count = 0;
	map < int, ACTIONTYPE >::iterator mp;
	sp = m_StackList.begin();	ep = m_StackList.end();
	while ( sp != ep ) {
		mp = m_LastAction.find( sp->GetStackNumber() );
		if ( mp != m_LastAction.end() ) {
			if ( mp->second == ACTION_NOTHING ) {
				// ͂G[B
				if ( GetActiveStackCount() > 1 ) {
					// LȃX^bNɂ΁C폜Ă܂B
					sp = m_StackList.erase( sp );
				}
				else {

					sp->SetSaveStack();
					sp ++;
				}
			}
			else {
				// LȃX^bNB
				valid_count ++;
				sp ++;
			}
		}
		else {
			sp ++;
		}
	}

	// CcĂȂ΁CԂ𐶐B
	if( m_StackList.size() == 0 ) { 
		GotoInitialState();
	}

	return valid_count;		// LȃX^bN̗LB
}



//
// ֐ : ACTIONTYPE CGLRParser::Input( const char *symbol, CLRStack &current, list < CLRStack * >&sublist )
// @  \ : ͎t 
//    : symbol ---- ͋L
//			current ---- X^bN
//			sublist --- X^bNXg
// ߂l : sANV̎
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2002/07/11 Thur. G
//
ACTIONTYPE CGLRParser::Input( const char *symbol, CLRStack &current, list < CLRStack > &sublist )
{
	CProductionSet	&production = m_Grammar.GetProductionSet();
	CLRSubTable		&action_t   = m_LRTable.GetActionTable();
	CLRSubTable		&goto_t		= m_LRTable.GetGotoTable();
	CSymbolTable    &terminal     = m_Grammar.GetTerminalSymbol();

	// Ƃ肠CX^bN̐擪
	CLRStackItem item = current.Top();

	assert( item.GetItemType() == TYPE_STATE );	// 擪͕KԔԍĂB

	// action\玟̓TB
	CLRTableState state = action_t.GetState( item.GetStateNumber() );

	if ( ! terminal.ExistSymbol( symbol ) ) {
		// \ɑΉLȂ
		//cout << "This symbol is not accepted." << endl;
		AddLastAction( current.GetStackNumber(), ACTION_NOTHING );
		return ACTION_NOTHING;
	}
	CLRTableCell  cell  = state.GetCell( symbol );



	if ( cell.GetCellType() == TYPE_NOTHING ) {
		AddLastAction( current.GetStackNumber(), ACTION_NOTHING );
		//cout << endl;

		return ACTION_NOTHING;
	}
	
	// ANV擾
	int action_c = cell.GetActionCount();
	CLRTableAction action;
	ACTIONTYPE exec_action;

	if ( action_c == 1 ) {
		// ANV̏ꍇ́C݂̃X^bN邾B
		action = cell.GetAction( 0 );

		exec_action = ParsingOperation( action, symbol, current, sublist );
	
		AddLastAction( current.GetStackNumber(), exec_action );

		return exec_action;
	}
	else {
		// actionꍇ́C݂̃X^bÑRs[action̐Cꂼɓ͂Ă݂
		
		cout << "SPLIT STACK[" << current.GetStackNumber() << "" << current.GetStackNumber() << "`" << m_nNewStackNumber + action_c - 2 << "]" << endl;

		CLRStack Temp( current );
		
		action = cell.GetAction( 0 );
		exec_action = ParsingOperation( action, symbol, current, sublist );

		for ( int i = 1; i < action_c; i ++ ) {
			action = cell.GetAction( i );
			
			// VX^bN𐶐

			CLRStack Stack( Temp );
			Stack.SetStackNumber( m_nNewStackNumber );
			
			m_nNewStackNumber ++;

			// VX^bNgāC͂B
			exec_action = ParsingOperation( action, symbol, Stack, sublist );

			if ( exec_action != ACTION_NOTHING ) {
				// LȏsĂ΁C̃X^bNgĂB
				sublist.push_back( Stack );
			}
		}

		AddLastAction( current.GetStackNumber(), exec_action );

		return exec_action;
	}

	AddLastAction( current.GetStackNumber(), ACTION_NOTHING );

	return ACTION_NOTHING;
}

//
// ֐ : ACTION_TYPE CGLRParser::ParsingOperation( CLRTableAction &action, const char *symbol, CLRStack current, list < CLRStack * > &sublist )
// @  \ : SHIFT, REDUCE, ACCEPT̏s
//    : action --- sANV
//			symbol --- ͋L
//			current -- Ώۂ̃X^bN
// ߂l : s̎
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2002/07/11 Thur. G
//
ACTIONTYPE CGLRParser::ParsingOperation( CLRTableAction &action, const char *symbol, CLRStack &current, list < CLRStack > &sublist )
{
	CProductionSet &production = m_Grammar.GetProductionSet();
	CLRSubTable    &goto_t     = m_LRTable.GetGotoTable();

	CLRStackItem    item;
	CLRTableState   state;
	CLRTableCell    cell;

	ACTIONTYPE type = action.GetActionType();
	
	if ( type == ACTION_SHIFT ) {
		// shift
		current.Push( symbol );
		current.Push( action.GetParameter() );

		//cout << "SHIFT - " << action.GetParameter() << endl;

	}
	else if ( type == ACTION_REDUCE ) {
		// reduce
		//cout << "REDUCE - " << action.GetParameter() << ", ";


		// Ҍ鐶K擾
		CProduction pro;
		production.GetProduction( action.GetParameter(), pro, CProductionSet::SEARCH_NUMBER );

		// K̉Eӂ̒~2Cpops
		int count = pro.GetRightSideLength();
		for ( int i = 0; i < count * 2; i ++ ) {
			current.Pop();
		}

		// popɌԔԍێ
		item = current.Top();
		assert( item.GetItemType() == TYPE_STATE );

		// Ҍ̔I[Lpush
		current.Push( pro.GetLeftSideSymbol() );

		// goto\āC̑Jڐ肷B
		state = goto_t.GetState( item.GetStateNumber() );
		cell  = state.GetCell( pro.GetLeftSideSymbol() );
		action = cell.GetAction();		// goto\̃Zɕ̃ANVĂ͂߂邱Ƃ͂Ȃ

		// ̏Ԃpush
		assert( action.GetActionType() == ACTION_SHIFT );
		current.Push( action.GetParameter() );
		
		//cout << "SHIFT - " << action.GetParameter() << endl;
		
//		current.Display();

		// ݂̓͂pĎ̏sB

		type = Input( symbol, current, sublist );
	}
	else if ( type == ACTION_ACCEPT ) {
		// accept
		//cout << "ACCEPT" << endl;

	}
	else {
		//cout << "NOTHIGN" << endl;

	}

//	current.Display();

	// ŌɍsANVL^
	AddLastAction( current.GetStackNumber(), type );
	
	return type;
}

//
// ֐ : CContextFreeGrammar &CGLRParser::GetGrammar()
// @  \ : @IuWFNg擾
//    : Ȃ
// ߂l : m_Grammar IuWFNgւ̎Q
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
CContextFreeGrammar &CGLRParser::GetGrammar() 
{
	return m_Grammar;
}

//
// ֐ : CLRTable &CGLRParser::GetLRTable()
// @  \ : LR\͕\ IuWFNg擾
//    : Ȃ
// ߂l : m_LRTable IuWFNgւ̎Q
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
CLRTable &CGLRParser::GetLRTable() 
{
	return m_LRTable;
}

//
// ֐ : void CGLRParser::GotoInitialState()
// @  \ : ԂԂɖ߂
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/16 Fri.
//
void CGLRParser::GotoInitialState()
{
	// 1. X^bN폜
	Initialize();

	// 2. ԂɂX^bNǉB
	
	CLRStack Stack( 0 );
//	Stack.Push( CLRStackItem( 0 ) );
	Stack.InitialState();
	m_StackList.push_back( Stack );


	// 3. Ҍ폜
	m_LastAction.clear();

	// 5. ǉX^bN̔ԍ
	m_nNewStackNumber = 1;
}


//
// ֐ : int CGLRParser::RemoveStack( int stacknumber )
// @  \ : w肵ԍ̃X^bN폜
//    : stacknumber --- 폜X^bN̔ԍ
// ߂l : 폜̃X^bNCs畉̒lԂB
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/16 Fri.
//
int CGLRParser::RemoveStack( int stacknumber )
{
	list < CLRStack >::iterator sp, ep;

	// X^bN폜
	sp = m_StackList.begin(); ep = m_StackList.end();
	while ( sp != ep ) {
		if ( sp->GetStackNumber() == stacknumber ) {
			m_StackList.erase( sp );
			break;
		}
		sp ++;
	}
	if ( sp == ep ) { return -1; }
	
	return m_StackList.size();

}



//
// ֐ : CLRStack &CGLRParser::GetStack( int stack, bool bIndex )
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/16 Fri.
//
CLRStack &CGLRParser::GetStack( int stack, bool bIndex )
{
	list < CLRStack >::iterator sp, ep;
	sp = m_StackList.begin(); ep = m_StackList.end();

	if ( bIndex ) {
		// X^bÑCfbNX
		while ( ( sp != ep ) && ( stack > 0 ) ) {
			sp ++; stack --;
		}
		assert ( ( sp != ep ) && ( stack == 0 ) ); 
	}
	else {
		// X^bNԍ̌
		for ( ; sp != ep; sp ++ ) {
			if ( sp->GetStackNumber() == stack ) { break; }
		}

		assert( sp != ep );
	}

	return *sp;
}

//
// ֐ : int CGLRParser::GetStackCount() const
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/16 Fri.
//
int CGLRParser::GetStackCount() const
{
	return m_StackList.size();
}


//
// ֐ : void CGLRParser::AddLastAction( int stacknumber, ACTIONTYPE action )
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
void CGLRParser::AddLastAction( int stacknumber, ACTIONTYPE action )
{
	map < int, ACTIONTYPE >::iterator mp;

	mp = m_LastAction.find( stacknumber );
	if ( mp == m_LastAction.end() ) {
		// ǉ
		m_LastAction.insert( pair < int, ACTIONTYPE >( stacknumber, action ) );
	}
	else {
		// łɕʂ̃ANVsĂ
		mp->second = action;
	}
}

//
// ֐ : const list < CLRStack > &CGLRParser::GetStackList() const
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/21 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/21 Wed.
//
const list < CLRStack > &CGLRParser::GetStackList() const
{
	return m_StackList;
}

//
// ֐ : const map < int, ACTIONTYPE > &CGLRParser::GetLastAction() const
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
const map < int, ACTIONTYPE > &CGLRParser::GetLastAction() const
{
	return m_LastAction;
}


//
// ֐ : int CGLRParser::GetNewStackNumber() const
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/16 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/16 Fri.
//
int CGLRParser::GetNewStackNumber() const
{
	return m_nNewStackNumber;
}

//
// ֐ : CGLRParser &CGLRParser::operator = ( const CGLRParser &parser )
// @  \ : Zq
//    :
// ߂l :
// 쐬 : 2001/11/12 Mon.
// 쐬 : J F
//
// ŏIXV : 2001/11/12 Mon.
//
CGLRParser &CGLRParser::operator = ( CGLRParser &parser )
{
	if ( &parser == this ) { return *this; }

	m_Grammar = parser.GetGrammar();
	m_LRTable = parser.GetLRTable();
	m_StackList = parser.GetStackList();
	m_LastAction = parser.GetLastAction();
	m_nNewStackNumber = parser.GetNewStackNumber();

	return *this;
}


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/12/01 Sta.
// 쐬 : J F
//
// ŏIXV : 2001/12/01 Sat.
//
int CGLRParser::GetActiveStackCount()
{
	list < CLRStack >::iterator sp, ep;
	sp = m_StackList.begin();	ep = m_StackList.end();
	
	int count = 0;
	for ( ; sp != ep; sp ++ ) {
		if ( sp->GetStackValid() ) { count ++; }
	}

	return count;
}

//
// ֐ : void CGLRParser::Clear()
// @  \ : 
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2002/09/10 Tue.
// 쐬 :  G
//
// ŏIXV : 2002/09/10 Tue.
//
void CGLRParser::Clear()
{
	GotoInitialState();

	m_LRTable.Init();
	m_Grammar.Init();
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/16 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/16 Fri.
//
