//
// SLR(1)\͊vO
// GLR\͊
//
// GLRParser.h / GLRParser.cpp
//
// ̃vÓCMMIVXeɈˑȂvOłB
//
// 2002/09/10 Tue. G
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#ifndef _GLRPARSER_H_
#define _GLRPARSER_H_

#include <list>
#include <vector>
#include <map>

#include "LRTable.h"
#include "SymbolTable.h"

using namespace std;

//
// ITEMTYPE 񋓌^
//
// X^bN̗vfɎ߂Ă񂪓͋LCԔԍB
enum ITEMTYPE
{
	TYPE_UNKNOWN = 0,	// s
	TYPE_SYMBOL,		// L
	TYPE_STATE,			// Ԕԍ
};

//
// CStackHistoryItem
// 
// LpushCpopɊւ闚ێ
//

class CLRStackHistoryItem
{
private:
	bool m_bPush;		// ̎(Push:true, Pop:false)
	string m_strSymbol; // ɗpL

public:
	CLRStackHistoryItem();
	CLRStackHistoryItem( bool push, string symbol );
	CLRStackHistoryItem( const CLRStackHistoryItem &item );

	virtual ~CLRStackHistoryItem();

public:
	bool GetStackOperation() const;
	string GetSymbol() const;

	void SetOperationInfo( bool bPush, string symbol );

public:
	CLRStackHistoryItem &operator = ( const CLRStackHistoryItem &item );
};

//
// CLRStackItem
//

class CLRStackItem
{
private:
	ITEMTYPE m_nType;							// i[̎
	char	 m_strSymbol[ SYMBOL_LENGTH + 1 ];	// L
	int		 m_nStateNumber;					// Ԕԍ

public:
	CLRStackItem();
	CLRStackItem( const char *symbol );
	CLRStackItem( int state );
	CLRStackItem( const CLRStackItem &item );

	virtual ~CLRStackItem();

public:
	ITEMTYPE GetItemType() const;
	const char *GetSymbol() const;
	int GetStateNumber() const;

	void SetItem( const char *symbol );
	void SetItem( int state );

public:
	CLRStackItem &operator = ( const CLRStackItem &item );
};



//
// CLRStack
//

class CLRStack
{
private:
	int							 m_nStackNumber;		// X^bN̔ԍ
	list < CLRStackItem >		 m_Stack;				// LR X^bN
	list < CLRStackHistoryItem > m_History;				// X^bN̏
	int							 m_nLastHistorySize;	// ̒ÕTCY
	bool						 m_bValid;				// X^bN̗LtO
	
	list < CLRStackItem >		m_SaveStack;			// obNAbvX^bN

public:
	CLRStack();
	CLRStack( int number );
	CLRStack( const CLRStack &lrstack );

	virtual ~CLRStack();

public:
	void Initialize();
	void InitialState();

	int GetStackSize() const;
	int GetHistorySize() const;
	int	GetStackNumber() const;
	int GetLastHistorySize() const;
	bool GetStackValid() const;

	void SetStackNumber( int number );	
	int SetLastHistorySize();
	void SetStackValid( bool valid );

	void SaveStack();
	void SetSaveStack();

public:
	void Push( const char *symbol );
	void Push( int state );
	void Push( CLRStackItem &item );

	void Pop();

	CLRStackItem &Top();
	CLRStackItem &GetItem( int index );

	CLRStackHistoryItem &GetHistoryItem( int index );

	const list < CLRStackItem > &GetStack() const;
	const list < CLRStackHistoryItem > &GetStackHistory() const;
	const list < CLRStackItem > &GetSaveStack() const;

public:
	CLRStack &operator = ( const CLRStack &lrstack );

public:
	void Display( int flag = 0 );
};

//
// CGLRParser
//

class CGLRParser
{
private:
	list < CLRStack >			m_StackList;
	CContextFreeGrammar			m_Grammar;
	CLRTable					m_LRTable;
	int							m_nNewStackNumber;

	map < int, ACTIONTYPE >     m_LastAction;

public:
	CGLRParser();
	CGLRParser( CContextFreeGrammar &grammar, CLRTable &table );

	virtual ~CGLRParser();

public:
	void Initialize();
	void GotoInitialState();

	void Clear();

	int Input( const char *symbol );

	int GetStackCount() const;
	int GetActiveStackCount();

	CLRStack &GetStack( int stack, bool bIndex = true );
	int RemoveStack( int stacknumber );

	void AddLastAction( int stack, ACTIONTYPE action );


public:
	CContextFreeGrammar &GetGrammar();
	CLRTable			&GetLRTable();

	const list < CLRStack > &GetStackList() const;
	const map < int, ACTIONTYPE > &GetLastAction() const;
	int GetNewStackNumber() const;

	CGLRParser &operator = ( CGLRParser &parser );

protected:
	ACTIONTYPE Input( const char *symbol, CLRStack &current, list < CLRStack >&sublist );
	ACTIONTYPE ParsingOperation( CLRTableAction &action, const char *symbol, CLRStack &current, list < CLRStack > &sublist );

};

#endif  _GLRPARSER_H_