//
// MMIVXe Ver.1 ͓
// <input>ǗW[
//
// InputInfo.h / InputInfo.cpp
//
// 2001/11/13 Tue. JF
// 2002/07/13 Sat. G
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#include "StdAfx.h"
#include <assert.h>

#include "XMLManager.h"
#include "InputInfo.h"

using namespace std;


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//


//
// CInputVariableInfo
//

//
// ֐ : CInputVariableInfo::CInputVariableInfo()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputVariableInfo::CInputVariableInfo()
{
	m_strVariable = m_strValue = "";
}

//
// ֐ : CInputVariableInfo::CInputVariableInfo( string &varname, string &value )
// @  \ : RXgN^
//    : varname ---- ϐ
//			value ------ l
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputVariableInfo::CInputVariableInfo( string &varname, string &value )
{
	m_strVariable = varname;
	m_strValue = value;
}

//
// ֐ : CInputVariableInfo::CInputVariableInfo( CInputVariableInfo &varinfo )
// @  \ : Rs[RXgN^
//    : varinfo --- Rs[
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputVariableInfo::CInputVariableInfo( const CInputVariableInfo &varinfo )
{
	m_strVariable = varinfo.GetVariable();
	m_strValue    = varinfo.GetValue();
}

//
// ֐ : CInputVariableInfo::~CInputVariableInfo()
// @  \ : fXgN^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputVariableInfo::~CInputVariableInfo()
{
}

//
// ֐ : string CInputVariableinfo::GetVariable()
// @  \ : ϐ擾
//    : Ȃ
// ߂l : m_strVariable oϐ̒lԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
string CInputVariableInfo::GetVariable() const
{
	return m_strVariable;
}

//
// ֐ : string CInputVariableInfo::GetValue()
// @  \ : l擾
//    : Ȃ
// ߂l : m_strValue oϐ̒lԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
string CInputVariableInfo::GetValue() const
{
	return m_strValue;
}

//
// ֐ : void CInputVariableInfo::SetVariable( string &varname )
// @  \ : ϐݒ肷
//    : varname --- ϐ
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
void CInputVariableInfo::SetVariable( string &varname )
{
	m_strVariable = varname;
}

//
// ֐ : void CInputVariableInfo::SetValue( string &value )
// @  \ : lݒ肷
//    : value --- ݒ肷l
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
void CInputVariableInfo::SetValue( string &value )
{
	m_strValue = value;
}

//
// ֐ : CInputVariableInfo &CInputVariableInfo::operator = ( const CInputVariableInfo &varinfo )
// @  \ : Zq
//    : varinfo --- Rs[
// ߂l : IuWFNgւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
CInputVariableInfo &CInputVariableInfo::operator = ( const CInputVariableInfo &varinfo )
{
	if ( &varinfo == this ) { return *this; }

	m_strVariable = varinfo.GetVariable();
	m_strValue    = varinfo.GetValue();

	return *this;
}

//
// ֐ : bool CInputVariableInfo::operator < ( const CInputVariableInfo &varinfo )
// @  \ : rZqiȂj
//    : varinfo --- rΏ
// ߂l : IuWFNgm_strVariabletrue,ȊOfalseԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
bool CInputVariableInfo::operator < ( const CInputVariableInfo &varinfo ) const
{
	return m_strVariable < varinfo.GetVariable();
}



//
// ֐ : bool CInputVariableInfo::operator == ( const CInputVariableInfo &varinfo ) const
// @  \ : Zq
//    : varinfo --- rΏ
// ߂l : ΉeIuWFNg̒ltrueCȊOfalseԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
bool CInputVariableInfo::operator == ( const CInputVariableInfo &varinfo ) const
{
	if ( &varinfo == this ) { return true; }

	if ( ( m_strVariable == varinfo.GetVariable() ) && ( m_strValue == varinfo.GetValue() ) ) {
		return true;
	}
	
	return false;
}

//
// ֐ : void CInputVariableInfo::Display()
// @  \ : \
//    :
// ߂l :
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/15 Thu.
//
void CInputVariableInfo::Display()
{
	cout << "NAME : " << m_strVariable << ", VALUE : " << m_strValue;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/15 Thu.
//


//
// CInputAttributeInfo
//

//
// ֐ : CInputAttributeInfo::CInputAttributeInfo()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputAttributeInfo::CInputAttributeInfo()
{
	m_strAttrName = m_strAttrValue = m_strAttrPath = "";
	m_nValueType = TYPE_ATTR_UNKNOWN;
}

//
// ֐ : CInputAttributeInfo::CInputAttributeInfo( string &attrname, string &attrvalue, string &attrpath, ATTRVALUETYPE valuetype )
// @  \ : RXgN^
//    : attrname ---- 
//			attrvalue --- l/ϐ
//			attrpath ---- vf
//			valuetype ---- attrvalue ̈Ӗ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputAttributeInfo::CInputAttributeInfo( string &attrname, string &attrvalue, string &attrpath, ATTRVALUETYPE valuetype )
{
	m_strAttrName = attrname;
	m_strAttrValue = attrvalue;
	m_strAttrPath = attrpath;
	m_nValueType = valuetype;
}

//
// ֐ : CInputAttributeInfo::CInputAttributeInfo( CInputAttributeInfo &attrinfo )
// @  \ : Rs[RXgN^
//    : attrinfo --- Rs[
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputAttributeInfo::CInputAttributeInfo( const CInputAttributeInfo &attrinfo )
{
	m_strAttrName  = attrinfo.GetAttributeName();
	m_strAttrValue = attrinfo.GetAttributeValue();
	m_strAttrPath  = attrinfo.GetAttributePath();
	m_nValueType   = attrinfo.GetValueType();
}

//
// ֐ : CInputAttributeInfo::CInputAttributeInfo( string &attrname, string &attrpath )
// @  \ : RXgN^iL[IuWFNgpj
//    : attrname --- 
//			attrpath --- vf
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/15 Thu.
//
CInputAttributeInfo::CInputAttributeInfo( string &attrname, string &attrpath )
{
	m_strAttrName = attrname;
	m_strAttrPath = attrpath;
	m_strAttrValue = "";
	m_nValueType = TYPE_ATTR_UNKNOWN;
}

//
// ֐ : CInputAttributeInfo::~CInputAttributeInfo()
// @  \ : fXgN^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputAttributeInfo::~CInputAttributeInfo()
{
}


//
// ֐ : string CInputAttributeInfo::GetAttributeName()
// @  \ : l܂͕ϐ擾
//    : Ȃ
// ߂l : m_strAttrName ̒l
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
string CInputAttributeInfo::GetAttributeName() const
{
	return m_strAttrName;
}
//
// ֐ : string CInputAttributeInfo::GetAttributeValue()
// @  \ : lѕϐ擾
//    : Ȃ
// ߂l : m_strAttrValue ̒l
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
string CInputAttributeInfo::GetAttributeValue() const
{
	return m_strAttrValue;
}


//
// ֐ : string CInputAttributeInfo::GetAttributePath()
// @  \ : vf擾
//    : Ȃ
// ߂l : m_strAttrPath ̒l
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
string CInputAttributeInfo::GetAttributePath() const
{
	return m_strAttrPath;
}


//
// ֐ : ATTRVALUETYPE CInputAttributeInfo::GetValueType()
// @  \ : m_strAttrValue̕\Ӗ擾
//    : Ȃ
// ߂l : m_nValueType ̒l
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
ATTRVALUETYPE CInputAttributeInfo::GetValueType() const
{
	return m_nValueType;
}

//
// ֐ : void CInptuAttributeInfo::SetAttributeValue( string &attrvalue, string &attrpath, ATTRVALUETYPE type )
// @  \ : lѕϐݒ肷
//    : attrname ---- 
//			attrvalue --- ݒ肷l/ϐ
//			attrpath ---- Ăvf
//			type ---- attrvalue ̈Ӗ
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
void CInputAttributeInfo::SetAttributeValue( string &attrname, string &attrValue, string &attrpath, ATTRVALUETYPE type )
{
	m_strAttrName = attrname;
	m_strAttrValue = attrValue;
	m_strAttrPath = attrpath;
	m_nValueType = type;
}


//
// ֐ : CInputAttributeInfo &CInputAttributeInfo::oeprator = ( CInputAttributeInfo &info )
// @  \ : Zq
//    : info --- Rs[
// ߂l : IuWFNgւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputAttributeInfo &CInputAttributeInfo::operator = ( CInputAttributeInfo &info )
{
	if ( &info == this ) { return *this; }

	m_strAttrName = info.GetAttributeName();
	m_strAttrValue = info.GetAttributeValue();
	m_strAttrPath  = info.GetAttributePath();
	m_nValueType = info.GetValueType();

	return *this;
}

//
// ֐ : bool CInputAttributeInfo::operator < ( CInputAttributeInfo &info )
// @  \ : rZqiȂj
//    : info ---- rΏۂ̃IuWFNg
// ߂l : IuWFNgm_strAttrNametrue,ȊOfalseԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
bool CInputAttributeInfo::operator < ( const CInputAttributeInfo &info ) const
{
	if ( m_strAttrName < info.GetAttributeName() ) { return true; }

	else if ( m_strAttrName == info.GetAttributeName() ) {
		
		if ( m_strAttrPath < info.GetAttributePath() ) { return true; } 
	}

	return false;
}

//
// ֐ : bool CInputAttributeInfo::operator == ( const CInputAttributeInfo &info ) const
// @  \ : Zq
//    : info --- rΏ
// ߂l : ΉeIuWFNgSētrueCȊOfalseԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//

bool CInputAttributeInfo::operator == ( const CInputAttributeInfo &info ) const 
{
	if ( ( m_strAttrName == info.GetAttributeName() ) && ( m_strAttrValue == info.GetAttributeValue() ) && 
		 ( m_strAttrPath == info.GetAttributePath() ) && ( m_nValueType == info.GetValueType() ) ) {
		return true;
	}

	return false;
}

//
// ֐ : void CInputAttributeInfo::Display()
// @  \ : \
//    :
// ߂l :
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/15 Thu.
//
void CInputAttributeInfo::Display()
{
	switch ( m_nValueType ) {
	case TYPE_ATTR_VARIABLE:
		// ƕϐ̃Zbg
		cout << "NAME : " << m_strAttrName << ", ELEMENT : " << m_strAttrPath << ", VARIABLE : " << m_strAttrValue;
		break;

	case TYPE_ATTR_VALUE:
		// Ƒl̃Zbg
		cout << "NAME : " << m_strAttrName << ", ELEMENT : " << m_strAttrPath << ", VALUE : " << m_strAttrValue;
		break;

	case TYPE_ATTR_INDEX:
		// vf̃CfbNX
		cout << "ELEMENT : " << m_strAttrPath << ", INDEX : " << m_strAttrValue;
		break;
		
	default:
		// s
		cout << "UNKNOWN TYPE" << endl;
		break;
	}
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2001/11/15 Thu.
//



//
// CInputIndividualInfo
//


//
// ֐ : CInputIndividualInfo::CInputIndividualInfo()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
CInputIndividualInfo::CInputIndividualInfo()
{
//	m_strDocument = m_strDialog = m_strExchange = m_strInputSymbol = "";
	m_strExchange = m_strInputSymbol = "";

	m_Variables.clear();
	m_Attributes.clear();
}

//
// ֐ : CInputIndividualInfo::CInputIndividualInfo( string &symbol )
// @  \ : RXgN^
//    : symbol ---- ͋L
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputIndividualInfo::CInputIndividualInfo( string &symbol )
{
	m_strInputSymbol = symbol;
}


//
// ֐ : CInputIndividualInfo::CInputIndividualInfo( CInputIndividualInfo &info )
// @  \ : Rs[RXgN^
//    : info ---- Rs[
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
CInputIndividualInfo::CInputIndividualInfo( const CInputIndividualInfo &info )
{
//	m_strDocument = info.GetDocument();
//	m_strDialog   = info.GetDialog();
	m_strExchange = info.GetExchange();
	m_strInputSymbol = info.GetInputSymbol();

	m_Attributes = info.GetAttributeList();
	m_Variables  = info.GetVariableList();
}

//
// ֐ : CInputIndividualInfo::~CInputIndividualInfo()
// @  \ : fXgN^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputIndividualInfo::~CInputIndividualInfo()
{
	m_Variables.clear();
	m_Attributes.clear();
}

//
// ֐ : string CInputIndividualInfo::GetDocument()
// @  \ : ɂȂinputĂhLg擾
//    : Ȃ
// ߂l : m_strDocument ̒l
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G RgAEg
//
//
//string CInputIndividualInfo::GetDocument() const
//{
//	return m_strDocument;
//}
//

//
// ֐ : string CInputIndividualInfo::GetDialog()
// @  \ : ɂȂinputĂdialog擾
//    : Ȃ
// ߂l : m_strDialog ̒l
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G RgAEg
//
//string CInputIndividualInfo::GetDialog() const
//{
//	return m_strDialog;
//}
//

//
// ֐ : string CInputIndividualInfo::GetExchange()
// @  \ : ɂȂinputĂexchange擾
//    : Ȃ
// ߂l : m_strExchange ̒l
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
string CInputIndividualInfo::GetExchange() const
{
	return m_strExchange;
}

//
// ֐ : string CInputIndividualInfo::GetExcahage()
// @  \ : Ή͋L擾
//    : Ȃ
// ߂l : m_strInputSymbol ̒l
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
string CInputIndividualInfo::GetInputSymbol() const
{
	return m_strInputSymbol;
}

//
// ֐ : int CInputIndividualInfo::GetVariableCount()
// @  \ : Ăϐ̐擾
//    : Ȃ
// ߂l : m_Variables Ăvf
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CInputIndividualInfo::GetVariableCount() const
{
	return m_Variables.size();
}

//
// ֐ : CInputVariableInfo &CInputIndividualInfo::GetVariable( string &varname )
// @  \ : ϐ擾
//    : varname --- ϐ
// ߂l : IuWFNgւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputVariableInfo &CInputIndividualInfo::GetVariable( string &varname )
{
	return *m_Variables.find( CInputVariableInfo( varname ) );
}


//
// ֐ : CInputVariableInfo &CinputIndividualInfo::GetVarialbe( int index )
// @  \ : ϐ擾
//    : index --- 擾ꏊ
// ߂l : IuWFNgւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputVariableInfo &CInputIndividualInfo::GetVariable( int index )
{
	assert( ( index >= 0 ) && ( index < m_Variables.size() ) );

	set < CInputVariableInfo >::iterator sp = m_Variables.begin();
	set < CInputVariableInfo >::iterator ep = m_Variables.end();

	while ( ( sp != ep ) && ( index > 0 ) ) {
		index --;
		sp ++;
	}
	if ( sp == ep ) { assert( false ); }

	return *sp;
}

//
// ֐ : int CInputIndividualInfo::GetAttributeCount()
// @  \ : Ă鑮̐擾
//    : Ȃ
// ߂l : m_Attributes Ăvf
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CInputIndividualInfo::GetAttributeCount() const
{
	return m_Attributes.size();
}

//
// ֐ : CInputAttributeInfo &CInputIndividualInfo::GetAttribute( string &attrname, string &attrpath )
// @  \ : 擾
//    : attrname --- 鑮
//			attrpath --- 鑮vf
// ߂l : IuWFNgւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputAttributeInfo &CInputIndividualInfo::GetAttribute( string &attrname, string &attrpath )
{
	return *m_Attributes.find( CInputAttributeInfo( attrname, attrpath ) );
}

//
// ֐ : CInputAttributeInfo &CinputIndividualInfo::GetAttribute( int index )
// @  \ : 擾
//    : index --- 擾ꏊ
// ߂l : IuWFNgւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputAttributeInfo &CInputIndividualInfo::GetAttribute( int index )
{
	assert( ( index >= 0 ) && ( index < m_Attributes.size() ) );

	set < CInputAttributeInfo >::iterator sp = m_Attributes.begin();
	set < CInputAttributeInfo >::iterator ep = m_Attributes.end();

	while ( ( sp != ep ) && ( index > 0 ) ) {
		index --;
		sp ++;
	}
	if ( sp == ep ) { assert( false ); }

	return *sp;
}

//
// ֐ : int CInputIndividualInfo::SetVariable( set < CInputVariableInfo > &varlist );
// @  \ : ϐXgRs[
//    : varlist --- Rs[̕ϐXg
// ߂l : Rs[vf
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CInputIndividualInfo::SetVariable( set < CInputVariableInfo > &varlist )
{
	m_Variables.clear();

	m_Variables = varlist;

	return m_Variables.size();
}

//
// ֐ : int CInputIndividualInfo::AddVariable( CInputVariableInfo &varinfo )
// @  \ : ϐǉ
//    : varinfo --- ǉϐ
// ߂l : ǉ̗vf
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CInputIndividualInfo::AddVariable( CInputVariableInfo &varinfo )
{
	m_Variables.insert( varinfo );

	return m_Variables.size();
}

//
// ֐ : int CInputIndividualInfo::SetAttribute( set < CInputAttributeInfo > &attrlist );
// @  \ : ϐXgRs[
//    : attrlist --- Rs[̑Xg
// ߂l : Rs[vf
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CInputIndividualInfo::SetAttribute( set < CInputAttributeInfo > &attrlist )
{
	m_Attributes.clear();

	m_Attributes = attrlist;

	return m_Attributes.size();
}

//
// ֐ : int CInputIndividualInfo::AddAttribute( CInputAttributeInfo &attrinfo )
// @  \ : ϐǉ
//    : attrinfo --- ǉ鑮
// ߂l : ǉ̗vf
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CInputIndividualInfo::AddAttribute( CInputAttributeInfo &attrinfo )
{
	m_Attributes.insert( attrinfo );

	return m_Attributes.size();
}

//
// ֐ : void CInputIndividualInfo::InitVariable()
// @  \ : ϐXg폜
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
void CInputIndividualInfo::InitVariable()
{
	m_Variables.clear();
}


//
// ֐ : void CInputIndividualInfo::InitAttribute()
// @  \ : Xg폜
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
void CInputIndividualInfo::InitAttribute()
{
	m_Attributes.clear();
}

//
// ֐ : CInputIndividualInfo &CInputIndividualInfo::operator = ( CInputIndividualInfo &info )
// @  \ : Zq
//    : Rs[
// ߂l : IuWFNgւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
CInputIndividualInfo &CInputIndividualInfo::operator = ( CInputIndividualInfo &info )
{
	if ( &info == this ) { return *this; }
	
//	m_strDocument = info.GetDocument();
//	m_strDialog   = info.GetDialog();
	m_strExchange = info.GetExchange();
	m_strInputSymbol = info.GetInputSymbol();

	m_Variables.clear();
	int count = info.GetVariableCount();
	for ( int i = 0; i < count; i ++ ) {
		m_Variables.insert( info.GetVariable( i ) );
	}

	m_Attributes.clear();
	count = info.GetAttributeCount();
	for ( i = 0; i < count; i ++ ) {
		m_Attributes.insert( info.GetAttribute( i ) ) ;
	}

	return *this;
}

//
// ֐ : bool CINputIndividualInfo::operator == ( const CInputIndividualInfo &info ) const
// @  \ : Zq
//    : info --- rΏ
// ߂l : m_exchangem_VariablesCm_Attributes̃XgłtrueCȊOfalseԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
bool CInputIndividualInfo::operator == ( const CInputIndividualInfo &info ) const
{
	if ( &info == this ) { return true; }

	if( m_strExchange != info.GetExchange() )
	{
		return false;
	}
//	if ( ( m_strDocument != info.GetDocument() ) || ( m_strDialog != info.GetDialog() ) || ( m_strExchange != info.GetExchange() ) ) {
//		return false;
//	}

	if ( ! ( m_Variables == info.GetVariableList() ) || ! ( m_Attributes == info.GetAttributeList() ) ) {
		return false;
	}

	return true;
}


//
// ֐ : bool CInputIndividualInfo::operator < ( CInputIndividualInfo &info ) const
// @  \ : rZqiȂj
//    : info --- rΏ
// ߂l : IuWFNgm_strInputSymbol̕trueCȊÓCfalseԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
bool CInputIndividualInfo::operator < ( const CInputIndividualInfo &info ) const
{
	return m_strInputSymbol < info.GetInputSymbol();
}

//
// ֐ : const set < CInputVariableInfo > &CInputIndividualInfo::GetVariableList() const
// @  \ : ϐXg擾
//    : Ȃ
// ߂l : m_Variablesւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
const set < CInputVariableInfo > &CInputIndividualInfo::GetVariableList() const
{
	return m_Variables;
}

//
// ֐ : const set < CInputAttributeInfo > &CInputIndividualInfo::GetAttributeList() const
// @  \ : Xg擾
//    : Ȃ
// ߂l : m_Attributesւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
const set < CInputAttributeInfo > &CInputIndividualInfo::GetAttributeList() const
{
	return m_Attributes;
}

//
// ֐ : void CInputIndividualInfo::SetDocument( string &document )
// @  \ : document̏ݒ肷
//    : document --- ݒ肷document
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G RgAEg
//
//void CInputIndividualInfo::SetDocument( string &document )
//{
//	m_strDocument = document;
//}

//
// ֐ : void CInputIndividualInfo::SetDialog( string &dialog )
// @  \ : dialog̏ݒ肷
//    : dialog --- ݒ肷dialog
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
//void CInputIndividualInfo::SetDialog( string &dialog )
//{
//	m_strDialog = dialog;
//}

//
// ֐ : void CInputIndividualInfo::SetExchange( string &exchange )
// @  \ : exchangȅݒ肷
//    : exchange --- ݒ肷exchange
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
void CInputIndividualInfo::SetExchange( string &exchange )
{
	m_strExchange = exchange;
}

//
// ֐ : void CInputIndividualInfo::SetInputSymbol( string &symbol )
// @  \ : Ή͋Lݒ肷
//    : symbol --- ݒ肷͋L
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
void CInputIndividualInfo::SetInputSymbol( string &symbol )
{
	m_strInputSymbol = symbol;
}

//
// ֐ : void CInputIndividualInfo::Display()
// @  \ : \
//    :
// ߂l :
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
void CInputIndividualInfo::Display()
{
//	cout << "DOCUMENT : " << m_strDocument << ", DIALOG : " << m_strDialog;
//	cout << ", EXCHANGE : " << m_strExchange << ", INPUT SYMBOL : " << m_strInputSymbol << endl;
	cout << "EXCHANGE : " << m_strExchange << ", INPUT SYMBOL : " << m_strInputSymbol << endl;
	
	int count = m_Attributes.size();
	cout << "MATCH ATTRIBUTES INFO" << endl;
	for ( int i = 0; i < count; i ++ ) {
		CInputAttributeInfo &attr = GetAttribute( i );
		cout << "[" << i << "]";
		attr.Display();
		cout << endl;
	}

	cout << endl;

	count = m_Variables.size();
	cout << "NAMELIST ATTRIBUTES INFO" << endl;
	for ( i = 0; i < count; i ++ ) {
		CInputVariableInfo &var = GetVariable( i );
		cout << "[" << i << "]";
		var.Display();
		cout << endl;
	}
}

//
// CInputInfo
//

//
// ֐ : CInputInfo::CInputInfo()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
CInputInfo::CInputInfo()
{
	m_strType = m_strEvent = m_strMatch = m_strTarget = m_strInputSymbol = "";
}

//
// ֐ : CInputInfo::CInputInfo( string &type, string &event, string &match, string &target, string &symbol = string() )
// @  \ : RXgN^
//    : type --- <input>type
//			event -- <input>event
//			match -- <input>match
//			symbol - Ή͋L
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
CInputInfo::CInputInfo( string &type, string &event, string &match, string &target, string &symbol )
{
	m_strType = type;
	m_strEvent = event;
	m_strMatch = match;
	m_strTarget = target;
	m_strInputSymbol = symbol;
}

//
// ֐ : CInputInfo::CInputInfo( string &symbol )
// @  \ : RXgN^
//    : symbol -- Ή͋L
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputInfo::CInputInfo( string &symbol )
{
	m_strType = m_strEvent = m_strMatch = m_strTarget = "";
	m_strInputSymbol = symbol;
}


//
// ֐ : CInputInfo::CInputInfo( const CInputInfo &info )
// @  \ : Rs[RXgN^
//    : info --- Rs[
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputInfo::CInputInfo( const CInputInfo &info )
{
	m_strType = info.GetTypeAttribute();
	m_strEvent = info.GetEventAttribute();
	m_strMatch = info.GetMatchAttribute();
	m_strTarget = info.GetTargetAttribute();

	m_strInputSymbol = info.GetInputSymbol();
}

//
// ֐ : CInputInfo::~CInputInfo()
// @  \ : fXgN^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputInfo::~CInputInfo()
{
}

//
// ֐ : string CInputInfo::GetTypeAttribute() const
// @  \ : typel擾
//    : Ȃ
// ߂l : m_strType̒l
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
string CInputInfo::GetTypeAttribute() const
{
	return m_strType;
}

//
// ֐ : string CInputInfo::GetEventAttribute() const
// @  \ : Eventl擾
//    : Ȃ
// ߂l : m_strEvent̒l
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
string CInputInfo::GetEventAttribute() const
{
	return m_strEvent;
}

//
// ֐ : string CInputInfo::GetMatchAttribute() const
// @  \ : Matchl擾
//    : Ȃ
// ߂l : m_strMatch̒l
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
string CInputInfo::GetMatchAttribute() const
{
	return m_strMatch;
}

//
// ֐ : string CInputInfo::GetTargetAttribute() const
// @  \ : Targetl擾
//    : Ȃ
// ߂l : m_stTarget̒l
// 쐬 : 2002/07/05 Fri.
// 쐬 : G
//
// ŏIXV : 2002/07/05 Fri. G
//
string CInputInfo::GetTargetAttribute() const
{
	return m_strTarget;
}

//
// ֐ : string CInputInfo::GetInputSymbol() const
// @  \ : Ή͋L擾
//    : Ȃ
// ߂l : m_strInputSymbol̒l
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
string CInputInfo::GetInputSymbol() const
{
	return m_strInputSymbol;
}

//
// ֐ : void CInputInfo::SetTypeAttribute( string &type )
// @  \ : typelݒ肷
//    : type --- ݒ肷l
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
void CInputInfo::SetTypeAttribute( string &type )
{
	m_strType = type;
}

//
// ֐ : void CInputInfo::SetEventAttribute( string &event )
// @  \ : eventlݒ肷
//    : event --- ݒ肷l
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
void CInputInfo::SetEventAttribute( string &event )
{
	m_strEvent = event;
}

//
// ֐ : void CInputInfo::SetMatchAttribute( string &match )
// @  \ : matchlݒ肷
//    : match --- ݒ肷l
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
void CInputInfo::SetMatchAttribute( string &match )
{
	m_strMatch = match;
}

//
// ֐ : void CInputInfo::SetTargetAttribute( string &target )
// @  \ : targetlݒ肷
//    : target --- ݒ肷l
// ߂l : Ȃ
// 쐬 : 2002/07/05 Fri.
// 쐬 : G
//
// ŏIXV : 2002/07/055 Fri. G
//
void CInputInfo::SetTargetAttribute( string &target )
{
	m_strTarget = target;
}

//
// ֐ : void CInputInfo::SetInputSymbol( string &symbol )
// @  \ : ͋Lݒ肷
//    : symbol -- ݒ肷L
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
void CInputInfo::SetInputSymbol( string &symbol )
{
	m_strInputSymbol = symbol;
}

//
// ֐ : CInputInfo &CInputInfo::operator = ( const CInputInfo &info )
// @  \ : Zq
//    : info --- Rs[
// ߂l : IuWFNgւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputInfo &CInputInfo::operator = ( const CInputInfo &info )
{
	if ( &info == this ) { return *this; }

	m_strType = info.GetTypeAttribute();
	m_strEvent = info.GetEventAttribute();
	m_strMatch = info.GetMatchAttribute();
	m_strTarget = info.GetTargetAttribute();
	m_strInputSymbol = info.GetInputSymbol();

	return *this;
}

//
// ֐ : bool CInputInfo::operator == ( const CInputInfo &info ) const
// @  \ : Zq
//    : info --- rΏ
// ߂l : m_strInputSymbolȊO̒lSētrueCȊOfalseԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
bool CInputInfo::operator == ( const CInputInfo &info ) const
{
	if ( 
		( m_strType == info.GetTypeAttribute() )
		&& ( m_strEvent == info.GetEventAttribute() )
		&& ( m_strMatch == info.GetMatchAttribute() )
//		&& ( m_strTarget == info.GetTargetAttribute() )
		) {
		return true;
	}

	return false;
}

//
// ֐ : bool CInputInfo::operator < ( const CInputInfo &info ) const
// @  \ : rZqiȂj
//    : info ---- rΏ
// ߂l : IuWFNgm_strInputSymboltrueCȊOfalse
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2003/02/12 Tue.
//
bool CInputInfo::operator < ( const CInputInfo &info ) const
{
	return m_strInputSymbol < info.GetInputSymbol();
}

//
// ֐ : void CInputInfo::Display()
// @  \ : \
//    :
// ߂l :
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
void CInputInfo::Display()
{
	cout << "SYMBOL : " << m_strInputSymbol << ", TYPE : " << m_strType << " , EVENT : " << m_strEvent << " , MATCH : " << m_strMatch << " , TARGET : " << m_strTarget << endl;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//

//
// CInputInfoList
//

//
// ֐ : CInputInfoList::CInputInfoList()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputInfoList::CInputInfoList()
{
	m_InputList.clear();
	m_IndiviList.clear();
}

//
// ֐ : CInputInfoList::~CInputInfoList()
// @  \ : fXgN^
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputInfoList::~CInputInfoList()
{
	m_InputList.clear();
	m_IndiviList.clear();
}

//
// ֐ : void CInputInfoList::InitInputList()
// @  \ : CInputInfõXg
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
void CInputInfoList::InitInputList()
{
	m_InputList.clear();
}

//
// ֐ : void CInputInfoList::InitIndiviList()
// @  \ : CInputInfõXg
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
void CInputInfoList::InitIndiviList()
{
	m_IndiviList.clear();
}

//
// ֐ : int CInputInfoList::GetInputListSize()
// @  \ : ͏̐Ԃ
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2002/07/08 Mon.
// 쐬 : G
//
// ŏIXV : 2002/07/08 Mon. G
//
int CInputInfoList::GetInputListSize()
{
	return m_InputList.size();
}

//
// ֐ : int CInputInfoList::GetIndiviListSize()
// @  \ : ʓ͏̐Ԃ
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2002/07/08 Mon.
// 쐬 : G
//
// ŏIXV : 2002/07/08 Mon. G
//
int CInputInfoList::GetIndiviListSize()
{
	return m_IndiviList.size();
}

//
// ֐ : CInputInfo &CInputInfoList::GetInputInfo( int index )
// @  \ : CInputInfoIuWFNg擾
//    : index ---- ʒu
// ߂l : IuWFNgւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputInfo &CInputInfoList::GetInputInfo( int index )
{
	assert( ( index >= 0 ) && ( index < m_InputList.size() ) );

	set < CInputInfo >::iterator sp = m_InputList.begin();
	set < CInputInfo >::iterator ep = m_InputList.end();

	while ( ( sp != ep ) && ( index > 0 ) ) {
		sp ++; index --;
	}

	assert( sp != ep );

	return *sp;
}

//
// ֐ : CInputInfo &CInputInfoList::GetInputInfo( string &type, string &event, string &match, string &target )
// @  \ : CInputInfoIuWFNg
//    : type --- <input>type
//			event --- <input>event
//			match --- <input>match
//			target --- <input>target
// ߂l : CInputInfoIuWFNgւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
CInputInfo &CInputInfoList::GetInputInfo( string &type, string &event, string &match, string &target )
{
	set < CInputInfo >::iterator sp = m_InputList.begin();
	set < CInputInfo >::iterator ep = m_InputList.end();

	while ( sp != ep ) {
		CInputInfo object( type, event, match, target );
		if ( *sp == object ) { break; }
		sp ++;
	}

	assert( sp != ep );

	return *sp;
}

//
// ֐ : CInputInfo &CInputInfoList::GetInputInfo( string &symbol )
// @  \ : CInputInfoIuWFNg擾
//    : symbol --- L[[h̓͋L
// ߂l : IuWFNgւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputInfo &CInputInfoList::GetInputInfo( string &symbol )
{
	return *m_InputList.find( CInputInfo( symbol ) );
}

//
// ֐ : CInputIndividualInfo &CInputInfoListGetInputIndividualInfo( int index )
// @  \ : CInputIndividualInfoIuWFNg擾
//    : index ---- ʒu
// ߂l : IuWFNgւ̎Q
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
CInputIndividualInfo &CInputInfoList::GetInputIndividualInfo( int index )
{
	assert ( ( index >= 0 ) && ( index < m_IndiviList.size() ) );

	multiset < CInputIndividualInfo >::iterator sp = m_IndiviList.begin();
	multiset < CInputIndividualInfo >::iterator ep = m_IndiviList.end();

	while ( ( sp != ep ) && ( index > 0 ) ) {
		sp ++; index --;
	}

	assert( sp != ep );

	return *sp;
}

//
// ֐ : CInputIndividualInfo CInputInfo::GetInputIndividualInfo( string document, string dialog, string exchange, string input )
// @  \ : CInputIndividualInfoIuWFNg擾
//    : exchange --- <input>exchange
//			input    --- <input>ɑΉ鎯ʎq
// ߂l : IuWFNg
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
//CInputIndividualInfo CInputInfoList::GetInputIndividualInfo( string document, string dialog, string exchange, string input )
CInputIndividualInfo CInputInfoList::GetInputIndividualInfo( string exchange, string input )
{
	multiset < CInputIndividualInfo >::iterator sp = m_IndiviList.begin();
	multiset < CInputIndividualInfo >::iterator ep = m_IndiviList.end();

	
	while ( sp != ep ) {
		/*
		CInputIndividualInfo object;
		object.SetDocument( document );
		object.SetDialog( dialog );
		object.SetExchange( exchange );
		object.SetInputSymbol( input );
		if ( *sp == object ) {
			break;
		}
		*/

		// RgAEg G
		//
		//if ( ( sp->GetDocument() == document ) && ( sp->GetDialog() == dialog ) && ( sp->GetExchange() == exchange ) && ( sp->GetInputSymbol() == input ) ) {
		//	// ɂ̂SĈvOK
		//	break;
		//}
		//
		if( ( sp->GetExchange() == exchange ) && ( sp->GetInputSymbol() == input ) )
		{
			break;
		}
		sp ++; 
	}

	if ( sp == ep ) {
		return CInputIndividualInfo();
	}

	return *sp;
}

//
// ֐ : list < CInputIndividualInfo > CInputInfoList::GetInputIndividualInfo( string &symbol )
// @  \ : CInputIndividualInfoIuWFNg擾
//    : symbol --- Ή͋L
// ߂l : 擾IuWFNg̃Xg
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
list < CInputIndividualInfo > CInputInfoList::GetInputIndividualInfo( string &symbol )
{
	CInputIndividualInfo key( symbol );
	multiset < CInputIndividualInfo >::iterator sp = m_IndiviList.find( key );
	list < CInputIndividualInfo > result;

	if ( sp != m_IndiviList.end() ) {
		do {
			result.push_back( *sp );
			sp ++;
		} while ( sp != m_IndiviList.upper_bound( key ) );
	}

	return result;
}

//
// ֐ : int CInputInfoList::SetInputInfo( set < CInputInfo > &infolist )
// @  \ : CInputInfõXgRs[
//    : infolist --- Rs[
// ߂l : Rs[̃TCY
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CInputInfoList::SetInputInfo( set < CInputInfo > &infolist )
{
	set < CInputInfo >::iterator sp = infolist.begin();
	set < CInputInfo >::iterator ep = infolist.end();

	m_InputList.clear();

	while ( sp != ep ) {
		m_InputList.insert( *sp );
		sp ++;
	}

	return m_InputList.size();
}

//
// ֐ : int CInputInfoList::AddINputInfo( CinputInfo &info )
// @  \ : CInputInfoIuWFNgǉ
//    : info --- ǉIuWFNg
// ߂l : ǉ̃Xg̃TCY
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CInputInfoList::AddInputInfo( CInputInfo &info )
{
	m_InputList.insert( info );

	return m_InputList.size();
}

//
// ֐ : int CInputInfoList::SetInputIndividualInfo( multiset < CInputIndividualInfo > &infolist )
// @  \ : CINputIndividualInfõXgRs[
//    : infolist --- Rs[
// ߂l : Rs[̃XgTCY
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CInputInfoList::SetInputIndividualInfo( multiset < CInputIndividualInfo > &infolist )
{
	multiset < CInputIndividualInfo >::iterator sp = infolist.begin();
	multiset < CInputIndividualInfo >::iterator ep = infolist.end();

	m_IndiviList.clear();

	while ( sp != ep ) {
		m_IndiviList.insert( *sp );
		sp ++;
	}

	return m_IndiviList.size();
}

//
// ֐ : int CInputInfoList::AddINputIndividualInfo( CINputIndividualInfo &info )
// @  \ : CInpuIndividualInfoIuWFNgXgɒǉ
//    : info --- ǉIuWFNg
// ߂l : ǉ̃XgTCY
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2001/11/13 Tue.
//
int CInputInfoList::AddInputIndividualInfo( CInputIndividualInfo &info )
{
	m_IndiviList.insert( info );

	return m_IndiviList.size();
}


//
// ֐ : bool CInputInfoList::ExistInputInfo( CInputInfo &info )
// @  \ : info Ɠ񂪂邩ǂ𒲂ׂ
//    : info --- 
//			out ---- vIuWFNg
// ߂l : 񂪂trueCfalseԂ
// 쐬 : 2001/11/16 Fri.
// 쐬 : J F
//
// ŏIXV : 2002/07/06 Sat. G
//
bool CInputInfoList::ExistInputInfo( CInputInfo &info, CInputInfo &out )
{
	set < CInputInfo >::iterator sp = m_InputList.begin();
	set < CInputInfo >::iterator ep = m_InputList.end();

	for ( ; sp != ep; sp ++ ) {
		if ( ( sp->GetTypeAttribute() == info.GetTypeAttribute() ) &&
			( sp->GetEventAttribute() == info.GetEventAttribute() ) &&
			( sp->GetMatchAttribute() == info.GetMatchAttribute() )// &&
//			( sp->GetTargetAttribute() == info.GetTargetAttribute() )
			) {
			out = *sp;
			return true;
		}
	}

	return false;
}


//
// ֐ : bool CInputInfoList::ExistInputIndividualInfo( CInputIndividualInfo &info, CInputIndividualInfo &out )
// @  \ : info Ɠ񂪂邩ǂׂ
//    : info ---- 
//			out ----- vIuWFNg̃Rs[
// ߂l : 񂪂trueCȂfalseԂ
// 쐬 : 2001/11/13 Tue.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//
bool CInputInfoList::ExistInputIndividualInfo( CInputIndividualInfo &info, CInputIndividualInfo &out )
{
/*
	multiset < CInputIndividualInfo >::iterator sp = m_IndiviList.begin();
	multiset < CInputIndividualInfo >::iterator ep = m_IndiviList.end();

	CInputAttributeInfo attr1, attr2;
	CInputVariableInfo  var1, var2;
	bool attr_flag, var_flag;
	int attr_count = info.GetAttributeCount(), var_count = info.GetVariableCount();
	for ( ; sp != ep; sp ++ ) {
		// dialogƂ̃`FbNKvH
		if ( ( sp->GetDocument() != info.GetDocument() ) || ( sp->GetDialog() != info.GetDialog() ) || ( sp->GetExchange() != info.GetExchange() ) ) {
			continue;
		}

		if ( ( attr_count == sp->GetAttributeCount() ) && ( var_count == sp->GetVariableCount() ) ) {
			// match̑𒲂ׂB
			// e(ƕϐ񂪓jȂCԂŃ\[gĂ͂
			attr_flag = true;
			for ( int i = 0; i < attr_count; i ++ ) {
				attr1 = info.GetAttribute( i ); attr2 = sp->GetAttribute( i );
				if ( ( attr1.GetAttributeName() != attr2.GetAttributeName() ) || ( attr1.GetAttributePath() != attr2.GetAttributePath() ) ||
																						( attr1.GetValueType() != attr2.GetValueType() ) ) {
					attr_flag = false;
					break;
				}
			}

			if ( attr_flag == false ) { break; } //{ continue; }

			// namelist̏𒲂ׂ
			// eȂCiϐjԂŃ\[gĂ͂H
			var_flag = true;
			for ( i = 0; i < var_count; i ++ ) {
				var1 = info.GetVariable( i ); var2 = sp->GetVariable( i );
				if ( var1.GetVariable() != var2.GetVariable() ) {
					
					var_flag = false;
					break;
				}
			}

			if ( attr_flag && var_flag ) {
				// match̑namelist̗vc
				out = *sp;
				return true;
			}
		
		}
		
	}
//*/
//*
	multiset < CInputIndividualInfo >::iterator sp, ep;
	sp = m_IndiviList.begin();	ep = m_IndiviList.end();

//  RgAEg G
//	for ( ; sp != ep; sp ++ ) {
//		if ( ( sp->GetDocument() == info.GetDocument() ) && ( sp->GetDialog() == info.GetDialog() ) && ( sp->GetExchange() == info.GetExchange() ) && ( sp->GetInputSymbol() == info.GetInputSymbol() ) ) {
//			out = *sp;
//			return true;
//		}
//	}
//
	for( ; sp != ep; sp++ )
	{
//		if( ( sp->GetExchange() == info.GetExchange() ) && ( sp->GetInputSymbol() == info.GetInputSymbol() ) )
//		{
//			out = *sp;
//			return true;
//		}
		if( ( sp->GetExchange() == info.GetExchange() ) && ( sp->GetInputSymbol() == info.GetInputSymbol() ) )
		{
			if( sp->GetAttributeCount() == info.GetAttributeCount() )
			{
				for( int i = 0; i < sp->GetAttributeCount(); i++ )
				{
					CInputAttributeInfo atinfo1 = sp->GetAttribute( i );
					CInputAttributeInfo atinfo2 = info.GetAttribute( i );

					if( atinfo1.GetAttributeName() == atinfo2.GetAttributeName()
						&& atinfo1.GetAttributePath() == atinfo2.GetAttributePath()
						&& atinfo1.GetAttributeValue() == atinfo2.GetAttributeValue()
						)
					{}
					else
					{
						return false;
					}
				}
				out = *sp;
				return true;
			}
		}
	}
//*/
	return false;
}
bool CInputInfoList::ExistInputIndividualInfoForIntegrate( CInputIndividualInfo &info, CInputIndividualInfo &out )
{
	multiset < CInputIndividualInfo >::iterator sp, ep;
	sp = m_IndiviList.begin();	ep = m_IndiviList.end();

	for( ; sp != ep; sp++ )
	{
		if( ( sp->GetExchange() == info.GetExchange() ) && ( sp->GetInputSymbol() == info.GetInputSymbol() ) )
		{
			if( sp->GetAttributeCount() == info.GetAttributeCount() )
			{
				for( int i = 0; i < sp->GetAttributeCount(); i++ )
				{
					CInputAttributeInfo atinfo1 = sp->GetAttribute( i );
					CInputAttributeInfo atinfo2 = info.GetAttribute( i );

					if( atinfo1.GetAttributeName() == atinfo2.GetAttributeName()
						&& atinfo1.GetAttributePath() == atinfo2.GetAttributePath()
						)
					{}
					else
					{
						return false;
					}
				}
				out = *sp;
				m_IndiviList.erase(sp);
				return true;
			}
		}
	}
//*/
	return false;
}


//
// ֐ : int CInputInfoList::RemoveInfo( string document, string dialog )
// @  \ : 폜
//    : document --- hLg
//			dialog ----- Θb
// ߂l : 폜L̐Ԃ(m_InputList폜ꂽj
// 쐬 : 2001/11/16 Fri.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G RgAEg
//
/*
int CInputInfoList::RemoveInfo( string document, string dialog )
{
	multiset < CInputIndividualInfo >::iterator sp, ep;
	sp = m_IndiviList.begin();
	ep = m_IndiviList.end();
	vector < string > sym_list;

	// Yʏ폜
	while ( sp != ep ) {
		if ( ( sp->GetDocument() == document ) && ( sp->GetDialog() == dialog ) ) {
			// 폜L̃Xgɒǉ
			sym_list.push_back( sp->GetInputSymbol() );
			sp = m_IndiviList.erase( sp );
		}
		else {
			sp ++;
		}
	}

	// XgɎcꂽ͋LɑΉʏ񂪂ȂȂĂ΁C{폜
	int size = sym_list.size();
	int del_count = 0;
	set < CInputInfo >::iterator dp;
	
	for ( int i = 0; i < size; i ++ ) {
		sp = m_IndiviList.find( sym_list[ i ] );

		if ( sp == m_IndiviList.end() ) {
			dp = m_InputList.find( sym_list[ i ] );
			m_InputList.erase( dp );
			del_count ++;
		}
	}

	return del_count;
}
*/


//
// ֐ : int CInputInfoList::RemoveInfo( string document, string dialog )
// @  \ : 폜
//    : document --- hLg
// ߂l : 폜L̐Ԃ(m_InputList폜ꂽj
// 쐬 : 2001/11/16 Fri.
// 쐬 : J F
//
// ŏIXV : 2001/11/16 Fri.
//
/*
int CInputInfoList::RemoveInfo( string document )
{
	multiset < CInputIndividualInfo >::iterator sp, ep;
	sp = m_IndiviList.begin();
	ep = m_IndiviList.end();
	vector < string > sym_list;

	// Yʏ폜
	while ( sp != ep ) {
		if ( sp->GetDocument() == document ) {
			// 폜L̃Xgɒǉ
			sym_list.push_back( sp->GetInputSymbol() );
			sp = m_IndiviList.erase( sp );
		}
		else {
			sp ++;
		}
	}

	// XgɎcꂽ͋LɑΉʏ񂪂ȂȂĂ΁C{폜
	int size = sym_list.size();
	int del_count = 0;
	set < CInputInfo >::iterator dp;
	
	for ( int i = 0; i < size; i ++ ) {
		sp = m_IndiviList.find( sym_list[ i ] );

		if ( sp == m_IndiviList.end() ) {
			dp = m_InputList.find( sym_list[ i ] );
			if ( dp != m_InputList.end() ) {
				m_InputList.erase( dp );
				del_count ++;
			}
		} 
	}

	return del_count;
}
*/

//
// ֐ : void CInputInfoList::Display()
// @  \ : 
//    : 
// ߂l : 
// 쐬 : 2002/07/08 Mon.
// 쐬 : G
//
// ŏIXV : 2002/07/08 Mon. G
//
void CInputInfoList::Display()
{
	cout << "***** INPUT *****" << endl;
	for( int i = 0; i < m_InputList.size(); i++ )
	{
		CInputInfo info = GetInputInfo( i );
		info.Display();
		cout << endl;
	}

	cout << "***** INDIVI *****" << endl;
	for( int j = 0; j < m_InputList.size(); j++ )
	{
		CInputIndividualInfo indivi = GetInputIndividualInfo( j );
		indivi.Display();
		cout << endl;
	}

}



//
// CInputAnalyser
//

//
// ֐ : int CInputAnalyser::AnalysisInput( const char *source, string &document, string dialog, string &exchange, CInputInfo &info, CInputIndividualInfo &indivi )
// @  \ : <input>^O͂
//    : source --- <input>̕
//			document -- hLg
//			dialog  --- dialog
//			exchange -- exchange
//			info ------- ͊{
//			indivi ----- ͌ŗL
// ߂l :
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G RgAEg
//
/*
int CInputAnalyser::AnalysisInput( const char *source, string document, string dialog, string exchange, CInputInfo &info, CInputIndividualInfo &indivi, bool bflag )
{
	CXMLManager xml;
	
	try {
		// <input>DOMɓǂݍ
		if ( xml.LoadXML( source ) < 0 ) {
			throw -1;
		}

		// <input>̃m[h擾
		XMLNodeArray node;
		if ( xml.FindNodesByTagName( "input", node ) < 0 ) {
			throw -2;
		}

		if ( AnalysisInput( node[ 0 ], document, dialog, exchange, info, indivi, bflag ) < 0 ) {
			throw -3;
		}
	}
	catch ( int error ) {
		return error;
	}

	return 0;
}
*/

//
// ֐ : int CInputAnalyzer::AnalysisInput( const char *source, string &exchange, CInputInfo &info, CInputIndividualInfo &indivi )
// @  \ : <input>^O͂
//    : source --- <input>̕
//			exchange -- exchange
//			info ------- ͊{
//			indivi ----- ͌ŗL
// ߂l :
// 쐬 : 2002/07/05 Fri.
// 쐬 : G
//
// ŏIXV : 2002/07/05 Fri. G
//
int CInputAnalyzer::AnalysisInput( const char *source, string exchange, CInputInfo &info, CInputIndividualInfo &indivi, bool bflag )
{
	CXMLManager xml;

	try{
		// <input>DOMɓǂݍ
		if( xml.LoadXML( source ) < 0 )
		{
			throw -1;
		}

		// <input>̃m[h擾
		XMLNodeArray node;
		if( xml.FindNodesByTagName( "input", node ) < 1 )
		{
			throw -2;
		}

		if( AnalysisInput( node[0], exchange, info, indivi, bflag ) < 0 )
		{
			throw -3;
		}
	}
	catch( int error )
	{
		return error;
	}

	return 0;
}

//
// ֐ : int CInputAnalyzer::AnalysisInputForUserinput( const char *source, string &exchange, CInputInfo &info, CInputIndividualInfo &indivi )
// @  \ : <command>user_input̎<parameter>^O͂
//    : source --- W[ԃbZ[W<parameter>...</parameter>̕
//			exchange -- exchange
//			info ------- ͊{
//			indivi ----- ͌ŗL
// ߂l :
// 쐬 : 2002/07/07 Sun.
// 쐬 : G
//
// ŏIXV : 2002/07/07 Sun. G
//
int CInputAnalyzer::AnalysisInputForUserinput( const char *source, string exchange, CInputInfo &info, CInputIndividualInfo &indivi, bool bflag )
{
	CXMLManager xml;

	try{
		if( xml.LoadXML( source ) < 0 )
		{
			throw -1;
		}

		// <input>̃m[h
		XMLNodeArray node;
		if( xml.FindNodesByTagName( "input", node ) < 1 )
		{
			throw -2;
		}
		if( AnalysisInput( node[0], exchange, info, indivi, bflag ) < 0 )
		{
			throw -2;
		}

		// <return>Ή͂i<return_list>̎qvfj
		XMLNodeArray paramlist;
		if( xml.FindNodesByTagName( "return", paramlist ) >= 1 )
		{
			// <param>̉͂
			XMLAttributeList attrlist;
			XMLAttributeList::iterator ite;
			CInputVariableInfo varinfo;
			string attrname = "name";

			for( int i = 0; i < paramlist.size(); i++ )
			{
				if( xml.GetAttributes( paramlist[i], attrlist ) < 1 )
				{
					continue;
				}
				ite = attrlist.find( "name" );
				if( ite == attrlist.end() ) { throw -3; }

				varinfo.SetVariable( ite->second );
				varinfo.SetValue( xml.GetNodeValue( paramlist[i] ) );

				indivi.AddVariable( varinfo );
			}
		}
	}
	catch( int error )
	{
		return error;
	}

	return 0;
}

//
// ֐ : int CInputAnalyser::AnalysisInput( MSXML2::IXMLDOMNode *pNode, string &document, string dialog, string &exchange, CInputInfo &info, CInputIndividualInfo &indivi )
// @  \ : <input>^O͂
//    : source --- <input>̕
//			document -- hLg
//			dialog  --- dialog
//			exchange -- exchange
//			info ------- ͊{
//			indivi ----- ͌ŗL
// ߂l :
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G RgAEg
//
/*
int CInputAnalyser::AnalysisInput( MSXML2::IXMLDOMNode *pInput, string document, string dialog, string exchange, CInputInfo &info, CInputIndividualInfo &indivi, bool bflag )
{
	CXMLManager xml;

	info = CInputInfo();
	indivi = CInputIndividualInfo();
	
	indivi.SetDocument( document );
	indivi.SetDialog( dialog );
	indivi.SetExchange( exchange );

	try {
		// 擾
		XMLAttributeList attrlist;
		XMLAttributeList::iterator ap;

		xml.GetAttributes( pInput, attrlist );
		
		// typěiK{j
		ap = attrlist.find( "type" );
		if ( ap == attrlist.end() ) { throw -1;	}	// ȂiAEgj
		info.SetTypeAttribute( ap->second );

		// evenťiK{j
		ap = attrlist.find( "event" );
		if ( ap == attrlist.end() ) { throw -2; }	// ȂiAEgj
		info.SetEventAttribute( ap->second );

		// matcȟiȗj
		ap = attrlist.find( "match" );
		if ( ap != attrlist.end() ) {
			// matchƂ́Cl͂B
			if ( bflag ) { AnalysisMatchAttribute( ap->second, info, indivi ); }
			else		 { AnalysisMatchAttributeForUserInput( ap->second, info, indivi ); }
		}
		else {
			info.SetMatchAttribute( string( "" ) );
		}

		// namelisťiȗj
		ap = attrlist.find( "namelist" );
		if ( ap != attrlist.end() ) {
			// namelistƂ́Cl͂B
			AnalysisNamelistAttribute( ap->second, indivi );
		}
	}
	catch ( int error ) {
		return error;
	}

	return 0;
}
*/


//
// ֐ : int CInputAnalyzer::AnalysisInput( MSXML2::IXMLDOMNode *pInput, string exchange, CInputInfo &info, CInputIndividualInfo &indivi, bool bflag )
// @  \ : <input>^O͂
//    : pInput --- <input>m[h
//			exchange -- exchange
//			info ------- ͊{
//			indivi ----- ͌ŗL
// ߂l :
// 쐬 : 2002/07/09 Tue.
// 쐬 : G
//
// ŏIXV : 2002/07/09 Tue. G
//
int CInputAnalyzer::AnalysisInput( MSXML2::IXMLDOMNode *pInput, string exchange, CInputInfo &info, CInputIndividualInfo &indivi, bool bflag )
{
	CXMLManager xml;

	info = CInputInfo();
	indivi = CInputIndividualInfo();

	indivi.SetExchange( exchange );

	try {
		// 擾
		XMLAttributeList attrlist;
		XMLAttributeList::iterator ap;

		xml.GetAttributes( pInput, attrlist );

		// typěiK{j
		ap = attrlist.find( "type" );
		if( ap == attrlist.end() ){ throw -1; } // ȂiAEgj
		info.SetTypeAttribute( ap->second );
		
		// evenťiK{j
		ap = attrlist.find( "event" );
		if( ap == attrlist.end() ) { throw -2; } // ȂiAEgj
		info.SetEventAttribute( ap->second );

		// matcȟiȗj
		ap = attrlist.find( "match" );
		if( ap != attrlist.end() ) {
			// match́Al͂
			if( bflag )	{ AnalysisMatchAttribute( ap->second, info, indivi ); }
			else		{ AnalysisMatchAttributeForUserInput( ap->second, info, indivi ); }
		}
		else{
			info.SetMatchAttribute( string("") );
		}

		// targeťiȗj
		// <input>ɏĂȂĂAʂ̏<operation>̒lIɒǉ
		// ɌĂ΂̂ŁAtarget͕K{ł͂Ȃ
		ap = attrlist.find( "target" );
		if( ap != attrlist.end() )
		{
			info.SetTargetAttribute( ap->second );
		}

		// namelisťiȗj
		/*
		ap = attrlist.find( "namelist" );
		if( ap != attrlist.end() ) {
			// namelist́Al͂
			AnalysisNamelistAttribute( ap->second, indivi );
		}
		*/
		
	}
	catch( int error )
	{
		return error;
	}

	return 0;
}

//
// ֐ : int CInputAnalyzer::AnalysisMatchAttribute( string &source, CInputInfo &info, CInputIndividualInfo &indivi )
// @  \ : match͂
//    : source --- match̕
//			info ----- ͊{
//			indivi --- ͌ŗL
// ߂l : 
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//

int CInputAnalyzer::AnalysisMatchAttribute( string &source, CInputInfo &info, CInputIndividualInfo &indivi )
{
	// [ϐ := @] ɂȂĂ镔𔲂oCc
	// ƕϐ́CCInputIndividualInfom_AttributesXgɒǉ


	string attrname, attrvar, attrpath, original;
	string::size_type top, next, eqsym, find_top;

	// 󔒂
	string::iterator sp = source.begin();
	string::iterator ep = source.end();
	while ( sp != ep ) {
		if ( *sp == ' ' ) {	sp = source.erase( sp ); }
		else              { sp ++; }
	}

	// 1.̕𔲂o
	find_top = 0;
	top = source.find( '[' );
	if ( top == string::npos ) {
		original = source;
	}
	else {
		while ( top != string::npos ) {
			// ŵꂼɂă`FbN
			
			next = source.find( ']', top ) ;
			if ( next != string::npos ) {
				// ']'c
				eqsym = source.find( ":=", top );
				if( ( eqsym != string::npos ) && ( eqsym < next ) ) {
					// 
					// "/OLS/goods_list/category/goods[goods:=@id]/object/button[1]"
					// "/OLS/goods_list/category/goods[goods:=@id]/object/button[2]"
					// ĂȂɑZq(:=)B
					//        lӂ̕ϐɑĂB
					// XgɕۑĂ
					original += source.substr( find_top, top - find_top );	// '['̒O܂ł̃pX
					attrpath = original;
					
					// indiviɒǉ镶
					attrvar  = source.substr( top + 1, eqsym - ( top + 1 ) );
					attrname = source.substr( eqsym + 3, next - ( eqsym + 3 ) );

					// Xgɒǉ
					indivi.AddAttribute( CInputAttributeInfo( attrname, attrvar, attrpath, TYPE_ATTR_VARIABLE ) );

					// info.m_strMatchp̃f[^쐬c
					original += ( '[' + attrname + ']' );
				}
		
				else {
					// 
					// "/OLS/goods_list/category/goods[@id='a']/object/button[1]"
					eqsym = source.find( "=", top );
					if ( ( eqsym != string::npos ) && ( eqsym < next ) ) {
						// ĂȂɑZq(=)B
						// XgɕۑĂ
						original += source.substr( find_top, top - find_top );	// '['̒O܂ł̃pX
						attrpath = original;

						// indiviɒǉ镶
						attrname  = source.substr( top + 2, eqsym - ( top + 2 ) );
						attrvar = source.substr( eqsym + 2, next - ( eqsym + 2 ) );
						
						// Xgɒǉ
						//indivi.AddAttribute( CInputAttributeInfo( attrname, attrvar, attrpath, TYPE_ATTR_VALUE ) );

						// info.m_strMatchp̃f[^쐬c
						original += ( '[' + attrname + ']' );
					}
					else {
						original += ( source.substr( find_top, next - find_top + 1 ) );
					}
				}
			}
			else {
				original += ( source.substr( find_top, next - find_top + 1 ) );
			}
			
			find_top = next + 1;
			top = source.find( '[', find_top );
		}
	}
	// Ō̌JnʒuŌ܂ł̃pXoriginalɒǉ
//	original += source.substr( find_top );
	info.SetMatchAttribute( original );

	return indivi.GetAttributeCount();
}


//
// ֐ : int CInputAnalyzer::AnalysisMatchAttributeForUserInput( string &source, CInputInfo &info, CInputIndividualInfo &indivi )
// @  \ : match͂
//    : source --- match̕
//			info ----- ͊{
//			indivi --- ͌ŗL
// ߂l : 
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2002/07/05 Fri. G
//

int CInputAnalyzer::AnalysisMatchAttributeForUserInput( string &source, CInputInfo &info, CInputIndividualInfo &indivi )
{
	// [@ = l] ɂȂĂ镔𔲂oCc
	// ƕϐ́CCInputIndividualInfom_AttributesXgɒǉ

	// 
	// "/OLS/goods_list/category/goods[@id=a]/object/button[1]"

	string attrname, attrvar, attrpath, original;
	string::size_type top, next, eqsym, find_top;


	// 󔒂
	string::iterator sp = source.begin();
	string::iterator ep = source.end();
	while ( sp != ep ) {
		if ( *sp == ' ' ) {	sp = source.erase( sp ); }
		else              { sp ++; }
	}

	// 1.̕𔲂o
	find_top = 0;
	top = source.find( '[' );

	// ̕Ȃ΁C͂̕KvȂBƂ̂̂܂ܓo^
	if ( top == string::npos ) { 
		original = source; 
	}
	else {
		while ( top != string::npos ) {
			// ŵꂼɂă`FbN
			// "/OLS/goods_list/category/goods[@id='a']/object/button[1]"
			
			next = source.find( ']', top ) ;
			if ( next != string::npos ) {
				// ']'c
				eqsym = source.find( "=", top );
				if( ( eqsym != string::npos ) && ( eqsym < next ) ) {
					// ĂȂɑZq(=)B
					// XgɕۑĂ
					original += source.substr( find_top, top - ( find_top ) );	// '['̒O܂ł̃pX
					attrpath = original;

					// indiviɒǉ镶
					attrname  = source.substr( top + 2, eqsym - ( top + 2 ) );
					attrvar = source.substr( eqsym + 2, ( next - 1 ) - ( eqsym + 2 ) );
					
					// Xgɒǉ
					indivi.AddAttribute( CInputAttributeInfo( attrname, attrvar, attrpath, TYPE_ATTR_VALUE ) );

					// info.m_strMatchp̃f[^쐬c
					original += ( '[' + attrname + ']' );
				}
				else {
					original += ( source.substr( find_top, next - find_top + 1 ) );
				}
			}
			
			find_top = next + 1;
			top = source.find( '[', find_top );
		}
	}
	
	// Ō̌JnʒuŌ܂ł̃pXoriginalɒǉ
//	original += source.substr( find_top );
	info.SetMatchAttribute( original );

	return indivi.GetAttributeCount();
}


//
// ֐ : int CInputAnalyzer::AnalysisNamelistAttribute( string &source, CInputIndividualInfo &indivi )
// @  \ : namelist͂
//    : source --- namelist̃\[X
//			indivi --- ͌ŗL
// ߂l :
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2002/07/06 Sat. G RgAEg
//
/*
int CInputAnalyzer::AnalysisNamelistAttribute( string &source, CInputIndividualInfo &indivi )
{
	if ( source.size() == 0 ) { return 0; }

	string var;
	string::size_type top_pos, part_pos;
	
	top_pos = 0;
	part_pos = source.find( ',' );
	if ( part_pos == string::npos ) {
		// ','Ȃꍇ́Cϐ
		AnalysisVariable( source, indivi );
	}
	else {
		do {
			// ','ȂȂ܂ŌJԂcB
			var = source.substr( top_pos, part_pos - top_pos );
			AnalysisVariable( var, indivi );

			// Tc
			top_pos = part_pos + 1;
			part_pos = source.find( ',', top_pos );

			if ( part_pos == string::npos ) {
				// Ō̈c
				var = source.substr( top_pos );
				AnalysisVariable( var, indivi );
			}

		} while ( part_pos != string::npos );
	}

	return indivi.GetVariableCount();
}
*/


//
// ֐ : int CInputAnalyzer::AnalysisVariable( string &source, CInputIndividualInfo &indivi )
// @  \ : namelisẗ̕ϐ́C̕ϐƒl̃yẢ͂
//    : source --- namelisẗꕔ
//			indivi --- ͌ŗL
// ߂l :
// 쐬 : 2001/11/15 Thu.
// 쐬 : J F
//
// ŏIXV : 2002/07/06 Sat. G RgAEg
//
/*
int CInputAnalyzer::AnalysisVariable( string &source, CInputIndividualInfo &indivi )
{
	string::size_type coron;

	if ( ( coron = source.find( ':' ) ) == string::npos ) {
		// ':'Ȃꍇ́Cϐ̂
		indivi.AddVariable( CInputVariableInfo( source ) );
	}
	else {
		// ':'ꍇ́COϐC낪l
		string varname = source.substr( 0, coron );
		string value = source.substr( coron + 1 );
		indivi.AddVariable( CInputVariableInfo( varname, value ) );
	}

	return 0;
}
*/

