//
// MMIVXe Ver.1 ͓
// <input>ǗW[
//
// InputInfo.h / InputInfo.cpp
//
// 2001/11/13 Tue. JF
// 2002/07/09 Tue. G
//
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#ifndef _INPUTINFO_H_
#define _INPUTINFO_H_

#include <list>
#include <set>
#include <string>
#include "msxml3.tlh"

using namespace std;



//
// CInputVariableInfo
//

class CInputVariableInfo
{
private:
	string m_strVariable;	// ϐ
	string m_strValue;		// l

public:
	CInputVariableInfo();
	CInputVariableInfo( string &varname, string &value = string() );
	CInputVariableInfo( const CInputVariableInfo &varinfo );

	virtual ~CInputVariableInfo();

public:
	string GetVariable() const;
	string GetValue() const;

	void SetVariable( string &varname );
	void SetValue( string &value );

public:
	CInputVariableInfo &operator = ( const CInputVariableInfo &varinfo );
	bool operator == ( const CInputVariableInfo &varinfo ) const;
	bool operator < ( const CInputVariableInfo &varinfo ) const;

public:
	void Display();
};

//
// 񋓌^ ATTRVALUETYPE
//
// CInputAttributeInfo.m_strAttrValue \Ă̂H
//

enum ATTRVALUETYPE
{
	TYPE_ATTR_UNKNOWN = -1,			// s
	TYPE_ATTR_VALUE,				// l
	TYPE_ATTR_VARIABLE,				// ϐ
	TYPE_ATTR_INDEX,				// CfbNXw
};


//
// CInputAttributeInfo
//

class CInputAttributeInfo
{
private:
	string m_strAttrName;			// 
	string m_strAttrValue;			// l/ϐ
	string m_strAttrPath;			// vf

	ATTRVALUETYPE m_nValueType;		// m_strAttrValuëӖ

public:
	CInputAttributeInfo();
	CInputAttributeInfo( string &attrname, string &attrvalue, string &attrpath, ATTRVALUETYPE valuetype = TYPE_ATTR_VARIABLE );
	CInputAttributeInfo( const CInputAttributeInfo &attrinfo );
	CInputAttributeInfo( string &attrname, string &attrpath );

	virtual ~CInputAttributeInfo();

public:
	string GetAttributeName() const;
	string GetAttributeValue() const;
	string GetAttributePath() const;
	ATTRVALUETYPE GetValueType() const;

	void SetAttributeValue( string &attrname, string &attrvalue, string &attrpaht, ATTRVALUETYPE type );

public:
	CInputAttributeInfo &operator = ( CInputAttributeInfo &info );
	bool operator == ( const CInputAttributeInfo &info ) const;
	bool operator < ( const CInputAttributeInfo &info ) const;

	void Display();
};

//
// CInputIndividualInfo
//
class CInputIndividualInfo
{
private:
	string m_strExchange;						// Ăexchangeidl

	string m_strInputSymbol;					// ͋L

	set < CInputVariableInfo >  m_Variables;	// ϐXg
	set < CInputAttributeInfo > m_Attributes;	// lXg


//	Θb̑JڂɊւ͎Ȃ
//	string m_strDocument;						// Ădocumet̖O
//	string m_strDialog;							// Ădialogidl

public:
	CInputIndividualInfo();
	CInputIndividualInfo( string &symbol );
	CInputIndividualInfo( const CInputIndividualInfo &info );

	virtual ~CInputIndividualInfo();

public:
//	string GetDocument() const;
//	string GetDialog() const;
	string GetExchange() const;
	string GetInputSymbol() const;

	const set < CInputVariableInfo > &GetVariableList() const;
	const set < CInputAttributeInfo > &GetAttributeList() const;

	int GetVariableCount() const;
	CInputVariableInfo &GetVariable( string &varname );
	CInputVariableInfo &GetVariable( int index );

	int GetAttributeCount() const;
	CInputAttributeInfo &GetAttribute( string &attrname, string &attrpath );
	CInputAttributeInfo &GetAttribute( int index ) ;

//	void SetDocument( string &document );
//	void SetDialog( string &dialog );
	void SetExchange( string &exchange );
	void SetInputSymbol( string &symbol );

	int  SetVariable( set < CInputVariableInfo > &varlist );
	int  AddVariable( CInputVariableInfo &varinfo );
	
	int  SetAttribute( set < CInputAttributeInfo > &attrlist );
	int  AddAttribute( CInputAttributeInfo &attrinfo );

	void InitVariable();
	void InitAttribute();

public:
	CInputIndividualInfo &operator = ( CInputIndividualInfo &info );
	bool operator == ( const CInputIndividualInfo &info ) const;
	bool operator < ( const CInputIndividualInfo &info ) const;

	void Display();
};

//
// CInputInfo
//
class CInputInfo
{
private:
	string m_strType;			// type
	string m_strEvent;			// event
	string m_strMatch;			// match
	string m_strTarget;			// target 

	string m_strInputSymbol;	// ͋Liɗpj

public:
	CInputInfo();
	CInputInfo( string &type, string &event, string &match, string &target, string &symbol = string() );
	CInputInfo( string &symbol );
	CInputInfo( const CInputInfo &info );

	virtual ~CInputInfo();

public:
	string GetTypeAttribute() const;
	string GetEventAttribute() const;
	string GetMatchAttribute() const;
	string GetTargetAttribute() const;
	string GetInputSymbol() const;

	void SetTypeAttribute( string &type );
	void SetEventAttribute( string &event );
	void SetMatchAttribute( string &match );
	void SetTargetAttribute( string &targe );
	void SetInputSymbol( string &symbol );

public:
	CInputInfo &operator = ( const CInputInfo &info );
	bool operator == ( const CInputInfo &info ) const;
	bool operator < ( const CInputInfo &info ) const;

	void Display();
};

//
// CInputInfoList
//
class CInputInfoList
{
private:
	set < CInputInfo >				   m_InputList;		// ͊{
	multiset < CInputIndividualInfo >  m_IndiviList;	// ʓ͏imatch, namelist)

public:
	CInputInfoList();

	virtual ~CInputInfoList();

public:
	void InitInputList();
	void InitIndiviList();

	int  GetInputListSize();
	int  GetIndiviListSize();

	CInputInfo &GetInputInfo( int index );
	CInputInfo &GetInputInfo( string &type, string &event, string &match, string &target );
	CInputInfo &GetInputInfo( string &symbol );

	CInputIndividualInfo &GetInputIndividualInfo( int index );
//	CInputIndividualInfo GetInputIndividualInfo( string document, string dialog, string exchange, string input );
	CInputIndividualInfo GetInputIndividualInfo( string exchange, string input );
	list < CInputIndividualInfo > GetInputIndividualInfo( string &symbol );

	int SetInputInfo( set < CInputInfo > &infolist );
	int AddInputInfo( CInputInfo &info );

	int SetInputIndividualInfo( multiset < CInputIndividualInfo > &infolist );
	int AddInputIndividualInfo( CInputIndividualInfo &info );

	bool ExistInputInfo( CInputInfo &info, CInputInfo &out );
	bool ExistInputIndividualInfo( CInputIndividualInfo &info, CInputIndividualInfo &out );
	bool ExistInputIndividualInfoForIntegrate( CInputIndividualInfo &info, CInputIndividualInfo &out );

//	int RemoveInfo( string document, string dialog );
//	int RemoveInfo( string document );
public:
	void Display();
};

//
// CInputAnalysis
//
class CInputAnalyzer
{
public:
//	int AnalysisInput( const char *source, string document, string dialog, string exchange, CInputInfo &info, CInputIndividualInfo &indivi, bool bflag = true );
//	int AnalysisInput( MSXML2::IXMLDOMNode *pInput, string document, string dialog, string exchange, CInputInfo &info, CInputIndividualInfo &indivi, bool bflag = true );
	int AnalysisInput( const char *source, string exchange, CInputInfo &info, CInputIndividualInfo &indivi, bool bflag = true );
	int AnalysisInput( MSXML2::IXMLDOMNode *pInput, string exchange, CInputInfo &info, CInputIndividualInfo &indivi, bool bflag = true );
	int AnalysisInputForUserinput( const char *source, string exchange, CInputInfo &info, CInputIndividualInfo &indivi, bool bflag = true );

protected:
	int AnalysisMatchAttribute( string &source, CInputInfo &info, CInputIndividualInfo &indivi );
	int AnalysisMatchAttributeForUserInput( string &source, CInputInfo &info, CInputIndividualInfo &indivi );
//	int AnalysisNamelistAttribute( string &source, CInputIndividualInfo &indivi );
//	int AnalysisVariable( string &source, CInputIndividualInfo &indivi );
};


#endif  _INPUTINFO_H_
