//
// MMIVXe Ver.1.1 ͓
// ͓W[
//
// InputIntegrator2.h / InputIntegrator2.cpp
//
// 2002/09/13 Fri. G
//
//
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#include "StdAfx.h"
#include "InputIntegrator2.h"
#include "Socket.h"


extern CMsgServer communicationManagement;         //ʐMW[

//
// O[o萔
//
const char *TIMEOUT_SYMBOL = "t-out";

//
// CInputIntegrator2
//

//
// ֐ : CInputIntegrator2::CInputIntegrator2()
// @  \ : 
//    : 
// ߂l : 
// 쐬 : 2002/07/07 Sun.
// 쐬 : G
//
// ŏIXV : 2002/07/07 Sun.
//


//
// ֐ : CInputIntegrator2::CInputIntegrator2()
// @  \ : ftHgRXgN^
// 쐬 : 2002/07/07 Sun.
// 쐬 : G
//
// ŏIXV : 2002/07/07 Sun.
//
CInputIntegrator2::CInputIntegrator2() : m_Parser(), m_NodeList()
{
	
}

//
// ֐ : CInputIntegrator2::CInputIntegrator2( const CInputIntegrator2 &integrator )
// @  \ : Rs[RXgN^
// 쐬 : 2002/07/07 Sun.
// 쐬 : G
//
// ŏIXV : 2002/07/07 Sun.
//
CInputIntegrator2::CInputIntegrator2( const CInputIntegrator2 &integrator )
{
	m_Parser	 = (CGLRParser&)integrator.GetParser();
	m_NodeList	 = (CXISLNodeList&)integrator.GetNodeList();
	m_bValid	 = integrator.IsValid();
}

//
// ֐ : CInputIntegrator2::~CInputIntegrator2()
// @  \ : ftHgfXgN^
// 쐬 : 2002/07/07 Sun.
// 쐬 : G
//
// ŏIXV : 2002/07/07 Sun.
//
CInputIntegrator2::~CInputIntegrator2()
{
	
}

//
// ֐ : CInputIntegrator2& CInputIntegrator2::operator = ( const CInputIntegrator2 &integrator )
// @  \ : Zq
//    : 
// ߂l : 
// 쐬 : 2002/07/07 Sun.
// 쐬 : G
//
// ŏIXV : 2002/07/07 Sun.
//
CInputIntegrator2& CInputIntegrator2::operator = ( const CInputIntegrator2 &integrator )
{
	if( this == &integrator ) { return *this; }
	
	m_Parser	 = (CGLRParser&)integrator.GetParser();
	m_NodeList	 = (CXISLNodeList&)integrator.GetNodeList();
	m_bValid	 = integrator.IsValid();
	
	return *this;
}

//
// ֐ : const CGLRParser& CInputIntegrator2::GetParser() const
// @  \ : GLRp[U擾
//    : Ȃ
// ߂l : m_Parserւ̎Q
// 쐬 : 2002/07/07 Sun.
// 쐬 : G
//
// ŏIXV : 2002/07/08 mon.
//
const CGLRParser& CInputIntegrator2::GetParser() const
{
	return m_Parser;
}

//
// ֐ : const CXISLNodeList& CInputIntegrator2::GetNodeList() const
// @  \ : \̐ɎgXISLm[hXg擾
//    : Ȃ
// ߂l : m_NodeListւ̎Q
// 쐬 : 2002/07/07 Sun.
// 쐬 : G
//
// ŏIXV : 2002/07/08 mon.
//
const CXISLNodeList& CInputIntegrator2::GetNodeList() const
{
	return m_NodeList;
}

//
// ֐ : const bool CInputIntegrator2::IsValid() const
// @  \ : \L
//    : Ȃ
// ߂l : L true  false
// 쐬 : 2002/07/07 Sun.
// 쐬 : G
//
// ŏIXV : 2002/07/08 mon.
//
const bool CInputIntegrator2::IsValid() const
{
	return m_bValid;
}

//
// ֐ : int CInputIntegrator2::Input( const char *symbol, list < string > &reduce_list )
// @  \ : [U̓͂󂯁Cs
//    : symbol ---- ͋L
//		  : reduce_list ---- <exchange>ɑΉҌ̃Xg
// ߂l : LȃX^bN̐
// 쐬 : 2002/07/08 Mon.
// 쐬 : G
//
// ŏIXV : 2002/07/08 Mon. G
//
int CInputIntegrator2::Input( const char *symbol, list < string > &reduce_list )
{
	reduce_list.clear();
	
	int valid_stack = m_Parser.Input( symbol );
	if( valid_stack > 0 )
	{
		// ͂^CAEg̎ɏ肭łX^bN𒲂ׂ
		if( !strcmp( symbol, ::TIMEOUT_SYMBOL ) )
		{
			int stack_count = m_Parser.GetStackCount();
			
			// ^CAEg肭΁C[Ҍ(1ȏ)˃^CAEgɂVtg]B
			// āCҌ̒ɂ́CKexchangeɑΉI[Lւ̊ҌB
			// ̊ҌTB
			for( int i = 0; i < stack_count; i++ )
			{
				CLRStack &lrstack = m_Parser.GetStack(i);
				int last_history = lrstack.GetLastHistorySize();
				int history_size = lrstack.GetHistorySize();
				CLRStackHistoryItem hisitem;
				CXISLNodeInfo ninfo;
				
				for( int j = history_size - 2; j >= last_history; j-- )
				{
					hisitem = lrstack.GetHistoryItem(j);
					ninfo = m_NodeList.GetNodeInfo( hisitem.GetSymbol() );
					if( ninfo.GetNodeType() == TYPE_NODE_EXCHANGE )
					{
						// cout << "REDUCE : " << hisitem.GetSymbol() << endl;
						reduce_list.push_back( hisitem.GetSymbol() );
						lrstack.SaveStack();
						break;
					}
				}
				if( j > last_history )
				{
					// exchangeɑΉI[L΁C̏Ԃɖ߂B
					lrstack.SetSaveStack();
				}
			}
		}
	}
	
	return valid_stack;
}

//
// ֐ : void CInputIntegrator2::InitializeState()
// @  \ : ͉̉ߒNA
//    : Ȃ
// ߂l : Ȃ
// 쐬 : 2002/07/08 Mon.
// 쐬 : G
//
// ŏIXV : 2002/07/08 Mon. G
//
void CInputIntegrator2::InitializeState()
{
	m_bValid = true;
	m_Parser.GotoInitialState();
}

//
// ֐ : bool CInputIntegrator2::SetValid( bool flag )
// @  \ : \̗L/؂ւ
//    : flag ---- LȂtrue, Ȃfalse
// ߂l : \̏
// 쐬 : 2002/07/08 Mon.
// 쐬 : G
//
// ŏIXV : 2002/07/08 Mon. G
//
bool CInputIntegrator2::SetValid( bool flag )
{
	m_bValid = flag;
	return m_bValid;
}

//
// ֐ : bool CInputIntegrator2::SetValid( bool flag )
// @  \ : \̗L/؂ւ
//    : flag ---- LȂtrue, Ȃfalse
// ߂l : \̏
// 쐬 : 2002/07/08 Mon.
// 쐬 : G
//
// ŏIXV : 2002/07/08 Mon. G
//
void CInputIntegrator2::Init()
{
	m_bValid = false;
	m_NodeList.Init();
	m_Parser.Clear();
}

//
// CInputIntegrationManager2
//

//
// ֐ : CInputIntegrationManager2::CInputIntegrationManager2()
// @  \ : ftHgRXgN^
//    : 
// ߂l : 
// 쐬 : 2002/07/09 Tue.
// 쐬 : G
//
// ŏIXV : 2002/07/09 Tue.
//
CInputIntegrationManager2::CInputIntegrationManager2()
{
	m_Accepted.InitInputList();
	m_Accepted.InitIndiviList();
	m_Integrator[0].SetValid( false );
	m_Integrator[1].SetValid( false );
	InitializeCriticalSection( &m_CriIntegrator[0] );
	InitializeCriticalSection( &m_CriIntegrator[1] );
	m_Timeout = GetTickCount();
	m_IntegrateInterval = _TIMEOUT_;
}

//
// ֐ : CInputIntegrationManager2::~CInputIntegrationManager2()
// @  \ : fXgN^
//    : 
// ߂l : 
// 쐬 : 2002/07/09 Tue.
// 쐬 : G
//
// ŏIXV : 2002/07/09 Tue.
//
CInputIntegrationManager2::~CInputIntegrationManager2()
{
}

//
// ֐ : bool CInputIntegrationManager2::IsValidNormalIntegrator( bool flag )
// @  \ : ʏ͗p̓\̗L/̐؂ւ
//    : flag ---- LɂȂ true, ɂȂ false
// ߂l : \̏ true - L false - 
// 쐬 : 2002/07/09 Tue.
// 쐬 : G
//
// ŏIXV : 2002/07/09 Tue.
//
//bool CInputIntegrationManager2::SetValidNormalIntegrator( bool flag )
//{
//	return m_Integrator[1].SetValid( flag );
//}
//

//
// ֐ : bool CInputIntegrationManager2::IsValidInterruptIntegrator( bool flag )
// @  \ : ʏ͗p̓\̗L/̐؂ւ
//    : flag ---- LɂȂ true, ɂȂ false
// ߂l : \̏ true - L false - 
// 쐬 : 2002/07/09 Tue.
// 쐬 : G
//
// ŏIXV : 2002/07/09 Tue.
//
//bool CInputIntegrationManager2::SetValidInterruptIntegrator( bool flag )
//{
//	return m_Integrator[0].SetValid( flag );
//}
//

//
// ֐ : bool CInputIntegrationManager2::SetNormalInput( string &input )
// @  \ : ʏ͗p̓\𐶐
//    : <exchange>̃XgiidK{j
// ߂l :  true  s false
// 쐬 : 2002/07/09 Tue.
// 쐬 : G
//
// ŏIXV : 2002/07/09 Tue.
//
bool CInputIntegrationManager2::SetNormalInput( string &input )
{

	// ͏
	m_InputList[1].InitInputList();
	m_InputList[1].InitIndiviList();

	// <exchange>̃Xg<alt_exchange>ň͂݁A<dialog>t
	string source = "<dialog id=\"virtual-nor\"><alt_exchange>";
	source.append( input );
	source += "</alt_exchange></dialog>";

	// tgGhɓ͏񑗐M
	SendInputInfo( "send_input_normal", input );

	// \쐬
#ifdef _DEBUG
	cout << "Create Normal IntegrationTable...";
#endif
	CIntegrationTableCreator2 itc;
	EnterCriticalSection( &m_CriIntegrator[1] );
	int ret = itc.IntegrationTableCreate( source.c_str(), m_Integrator[1], m_InputList[1] );
	LeaveCriticalSection( &m_CriIntegrator[1] );
	if( ret == 0 )
	{
#ifdef _DEBUG
		cout << "SUCCEEDED" << endl;
#endif
		m_Integrator[1].InitializeState();
		return true;
	}
	else
	{
#ifdef _DEBUG
		cout << "FAILED" << endl;
#endif
		m_Integrator[1].SetValid( false );
		return false;
	}
}

//
// ֐ : bool CInputIntegrationManager2::SetInterruptInput( string &input )
// @  \ : 荞ݓ͗p̓\𐶐
//    : <exchange>̃XgiidK{j
// ߂l :  true  s false
// 쐬 : 2002/07/09 Tue.
// 쐬 : G
//
// ŏIXV : 2002/07/09 Tue.
//
bool CInputIntegrationManager2::SetInterruptInput( string &input )
{
	// ͏
	m_InputList[0].InitInputList();
	m_InputList[0].InitIndiviList();

	// <exchange>̃Xg<alt_exchange>ň͂݁A<dialog>t
	string source = "<dialog id=\"virtual-nor\"><alt_exchange>";
	source.append( input );
	source += "</alt_exchange></dialog>";

	// tgGhɓ͏񑗐M
	SendInputInfo( "send_input_interrupt", input );

	// \쐬
#ifdef _DEBUG
	cout << "Create Interrupt IntegrationTable...";
#endif
	CIntegrationTableCreator2 itc;
	EnterCriticalSection( &m_CriIntegrator[0] );
	int ret = itc.IntegrationTableCreate( source.c_str(), m_Integrator[0], m_InputList[0] );
	LeaveCriticalSection( &m_CriIntegrator[0] );
	if( ret == 0 )
	{
#ifdef _DEBUG
		cout << "SUCCEEDED" << endl;
#endif
		m_Integrator[0].InitializeState();
		return true;
	}
	else
	{
#ifdef _DEBUG
		cout << "FAILED" << endl;
#endif
		m_Integrator[0].SetValid( false );
		return false;
	}
}

//
// ֐ : void CInputIntegrationManager2::Input( string source, string &result )
// @  \ : ͓
//    : source ---- W[ԃbZ[Wuser_inputR}h<parameter>
//        : result ---- Ɍʂi[
// ߂l : Ȃ
// 쐬 : 2002/07/09 Tue.
// 쐬 : G
//
// ŏIXV : 2002/08/22 Thur.
//
bool CInputIntegrationManager2::Input( string source, string &result )
{
	TRACE("kazu");
	result = "";
	string exchange;

	// Jn
	if( Integrate( source, exchange ) )
	{
		// <exchange>̊ҌN̕
		string var_list = ""; 
		int i, j, k;
		CInputIndividualInfo indivi, indivi_out;
		int size = m_Accepted.GetIndiviListSize();
		
		// ͂̕ϐȂǂW߂
		for( i = 0; i < size; i++ )
		{
			indivi = m_Accepted.GetInputIndividualInfo( i );
			indivi.SetExchange( exchange );
			for( j = 0; j < 2; j++ )
			{
				 if( m_InputList[j].ExistInputIndividualInfoForIntegrate( indivi, indivi_out ) )
				 {
					 int attr_count = indivi_out.GetAttributeCount();
					 for( k = 0; k < attr_count; k++ )
					 {
						 CInputAttributeInfo attr1 = indivi_out.GetAttribute( k );
						 var_list += "<param name=\"";
						 var_list += attr1.GetAttributeValue() + "\">";
						 if( indivi.GetAttributeCount() )
						 {
							var_list += indivi.GetAttribute( k ).GetAttributeValue() + "</param>";
						 }
						 else
						 {
							 var_list += "</param>";
						 }
					 }
					 int var_count = indivi.GetVariableCount();
					 int var_count2 = indivi_out.GetVariableCount();
					 if( var_count >= var_count2 )
					 {
						 for( k  = 0; k < var_count; k++ )
						 {
							 var_list += "<param name=\"" + indivi.GetVariable( k ).GetVariable() + "\">";
							 var_list += indivi.GetVariable( k ).GetValue() + "</param>";
						 }
					 }
				 }
			}
		}

		// ʂi[
		result += "<integrate>" + exchange + "</integrate>";
		result += "<var_list>" + var_list + "</var_list>";
		result.insert( 0, "<result>" );
		result.append( "</result>" );

#ifdef _DEBUG
	cout << endl;
	cout << "INTEGRATE : " << exchange << endl; 
#endif

		return true;
	}

	// Ҍ͋NȂ
	return false;
}

//
// ֐ : bool CInputIntegrationManager2::Input( string source, string &exchange )
// @  \ : ͓
//    : source ---- W[ԃbZ[Wuser_inputR}h<parameter>
//			exchange ---- Ҍꂽ<exchange>id
// ߂l : Ҍ true ĂȂ false
// 쐬 : 2002/07/09 Tue.
// 쐬 : G
//
// ŏIXV : 2002/09/13 Fri.
//
bool CInputIntegrationManager2::Integrate( string source, string &exchange )
{
	//
	// source̒g
	// <parameter>
	//  <input....>
	//  <return_list> 邩킩񂯂ǁEE
	//   <param...>
	//  </return_list>
	// </parameter>
	// ƂȂĂƂ
	// ^CAEĝƂ t-out 
	CInputInfo				 info, info_out;
	CInputIndividualInfo	 indivi, indivi_out;
	CInputAnalyzer			 ana;
	string					 input_symbol;
	list < string >			 reduce_list;
	bool					 valid = true;
	bool					 input_validation = false;

#ifdef _DEBUG
	cout << endl;
	cout << endl;
	cout << "INPUT : " << source << endl;
#endif

	// 荞ݗpƒʏp𕪂ē
	for( int i = 1; i > -1; i-- )
	{
		if( m_Integrator[i].IsValid() )
		{
			EnterCriticalSection( &m_CriIntegrator[i] );
			input_symbol = ::TIMEOUT_SYMBOL;

			// ^CAEgłȂΕێĂ͏Ɣrē͋L߂
			// ͋LȂΓ͂Ȃ
			if( source != ::TIMEOUT_SYMBOL )
			{
				if( ana.AnalysisInputForUserinput( source.c_str(), "", info, indivi, false ) < 0 )
				{
					return false;
				}
				valid |= m_InputList[i].ExistInputInfo( info, info_out );
				input_symbol = info_out.GetInputSymbol();
			}
			
			// ŏIIɂ̃tOfalsê܂܂Ȃsourcë͉ӖȂ͂ƂƂɂȂ
			input_validation |= valid;

			if( valid )
			{
#ifdef _DEBUG
				cout << "TABLE : " << i << " - Integrate...";
#endif
				reduce_list.clear();

				// VtgҌNΗLȃX^bN1ȏ̂͂
				int valid_stack = m_Integrator[i].Input( input_symbol.c_str(), reduce_list );
				if( valid_stack > 0 )
				{
					// Ҍ͋NĂ܂񂩁H
					if( reduce_list.size() > 0 )
					{
#ifdef _DEBUG
						cout << "SUCCEEDED." << endl;
#endif
						exchange = reduce_list.front();

						// ʏ͗p̃e[uɈxȂꍇ̓RgAEgOĂ
						//if( i == 1 )
						//{
						//	m_Integrator[i].SetValid( false );
						//}
						m_Integrator[i].InitializeState();
						return true;
					}
#ifdef _DEBUG
					cout << "SHIFT." << endl;
#endif
					// L͂ێ
					// Ҍɂ<input>̏𔲂o
					info.SetInputSymbol( input_symbol );
					indivi.SetInputSymbol( input_symbol );
					if( !m_Accepted.ExistInputInfo( info, info_out ) ) { m_Accepted.AddInputInfo( info ); }
					//if( !m_Accepted.ExistInputIndividualInfo( indivi, indivi_out ) ) { m_Accepted.AddInputIndividualInfo( indivi ); }
					m_Accepted.AddInputIndividualInfo( indivi );
					// ^CAEgJEgȂ
					InitTimeout();

					// ʏpSHIFTȂ犄荞ݗp͔̏΂
					if( i == 1 )
					{
						return false;
					}
				}
#ifdef _DEBUG
				else
				{
					cout << "FAILED." << endl;
				}
#endif
			}
			LeaveCriticalSection( &m_CriIntegrator[i] );
		}
	}

	if( !input_validation )
	{
		// ʏ͗pɂ荞ݓ͗pɂLȓ͂Ȃ
		// ܂茻ݕێĂ͖͗ɂȂ
		m_Accepted.InitInputList();
		m_Accepted.InitIndiviList();
	}
	
	return false;
}

//
// ֐ : void CInputIntegrationManager2::SendInputInfo( string cmd, string exchanges );
// @  \ : tgGh<input>𑗐M
//    : cmd ---- send_input_normal  send_input_interrupt
//        : exchanges ---- <exchange>̃Xg        
// ߂l : Ȃ
// 쐬 : 2002/07/10 Wed.
// 쐬 : G
//
// ŏIXV : 2002/07/10 Wed.
//
void CInputIntegrationManager2::SendInputInfo( string cmd, string exchanges )
{
	string inputs;
	CXMLManager xml;
	BSTR text;
	char buf[256];

	exchanges.insert( 0, "<root>" );
	exchanges.append( "</root>" );
	
	if( xml.LoadXML( exchanges.c_str() ) < 0 ) { return; }

	XMLNodeArray array;
	int array_size;
	xml.FindNodesByTagName( "input", array );

	array_size = array.size();
	inputs = "";
	for( int i = 0; i < array_size; i++ )
	{
		array[i]->get_xml( &text );
		xml.BSTRToAscii( text, buf, 255 );
		SysFreeString(text);
		inputs += buf;
	}

	// <command>cmd
	// <parameter><input_info>inputs
	// pătgGhɓ͏𑗐M
	/*
	inputs.insert( 0, "<input_info>" );
	inputs.append( "</input_info>" );

	CComMsg msg;
	msg.Set( "DialogMngr", "FrontEnd", cmd.c_str(), inputs.c_str() );
	g_Serv.SendMsg( msg );
	*/
}

//
// ֐ : bool CInputIntegrationManager2::SetNormalInput( string &input, string &path )
// @  \ : ʏ͗p̓\𐶐
//    : <exchange>̃XgiidK{j
//			<exchange>݂t@C̃pX
// ߂l :  true  s false
// 쐬 : 2002/07/09 Tue.
// 쐬 : G & @L
//
// ŏIXV : 2002/10/10 Tha.
//
bool CInputIntegrationManager2::SetNormalInput( string &input, string &path )
{

	// ͏
	m_InputList[1].InitInputList();
	m_InputList[1].InitIndiviList();

	// <exchange>̃Xg<alt_exchange>ň͂݁A<dialog>t
	string source = "<dialog id=\"virtual-nor\"><alt_exchange>";
	source.append( input );
	source += "</alt_exchange></dialog>";

	// tgGhɓ͏񑗐M
	SendNormalInputInfo( input , path );

	// \쐬
#ifdef _DEBUG
	cout << "Create Normal IntegrationTable...";
#endif
	CIntegrationTableCreator2 itc;
	EnterCriticalSection( &m_CriIntegrator[1] );
	int ret = itc.IntegrationTableCreate( source.c_str(), m_Integrator[1], m_InputList[1] );
	LeaveCriticalSection( &m_CriIntegrator[1] );
	if( ret == 0 )
	{
#ifdef _DEBUG
		cout << "SUCCEEDED" << endl;
#endif
		m_Integrator[1].InitializeState();
		return true;
	}
	else
	{
#ifdef _DEBUG
		cout << "FAILED" << endl;
#endif
		m_Integrator[1].SetValid( false );
		return false;
	}
}

//
// ֐ : bool CInputIntegrationManager2::SetInterruptInput( string &input, string &path )
// @  \ : 荞ݓ͗p̓\𐶐
//    :		
//		  :     AvP[Vx<exchange>̃XgiidK{j
//		  :     AvP[VhLgւ̃pX
//		  :     hLgx<exchange>̃Xg(idK{)
//		  :     [thLgւ̃pX
// ߂l :  true  s false
// 쐬 : 2002/07/09 Tue.
// 쐬 : G &  L
//
// ŏIXV : 2002/10/10 Tha.
//
bool CInputIntegrationManager2::SetInterruptInput( string &inputRoot, string &pathRoot, string &inputLeaf, string &pathLeaf )
{
	// ͏
	m_InputList[0].InitInputList();
	m_InputList[0].InitIndiviList();

	// <exchange>̃Xg<alt_exchange>ň͂݁A<dialog>t
	string source = "<dialog id=\"virtual-int\"><alt_exchange>";
	source.append( inputRoot );
	source.append( inputLeaf );
	source += "</alt_exchange></dialog>";

	// tgGhɓ͏񑗐M
	SendInterruptInputInfo( inputRoot, pathRoot, inputLeaf, pathLeaf );

	// \쐬
#ifdef _DEBUG
	cout << "Create Interrupt IntegrationTable...";
#endif
	CIntegrationTableCreator2 itc;
	EnterCriticalSection( &m_CriIntegrator[0] );
	int ret = itc.IntegrationTableCreate( source.c_str(), m_Integrator[0], m_InputList[0] );
	LeaveCriticalSection( &m_CriIntegrator[0] );
	if( ret == 0 )
	{
#ifdef _DEBUG
		cout << "SUCCEEDED" << endl;
#endif
		m_Integrator[0].InitializeState();
		return true;
	}
	else
	{
#ifdef _DEBUG
		cout << "FAILED" << endl;
#endif
		m_Integrator[0].SetValid( false );
		return false;
	}
}

//
// ֐ : void CInputIntegrationManager2::SendNormalInputInfo( string exchanges, string path );
// @  \ : tgGhɕʂ<input>𑗐M
//    : 
//        : exchanges ---- <exchange>̃Xg
//		  : exchanges ---- <exchange>݂t@C̃pX        
// ߂l : Ȃ
// 쐬 : 2002/07/10 Wed.
// 쐬 :  G &  L
//
// ŏIXV : 2002/10/11 Fri.
//
//ʏ͑MpCpX𑗐M悤ɉ
void CInputIntegrationManager2::SendNormalInputInfo( string exchanges, string path ){

	string strCom;
	strCom = "send_input_normal";

	string inputs;
	string strInputInfo;
	CXMLManager xml;
	BSTR text;
	char buf[256];

	exchanges.insert( 0, "<msg>" );
	exchanges.append( "</msg>" );
	
	if( xml.LoadXML( exchanges.c_str() ) < 0 ) { return; }

	XMLNodeArray array;
	int array_size;
	xml.FindNodesByTagName( "input", array );

	array_size = array.size();
	inputs = "";
	for( int i = 0; i < array_size; i++ )
	{
		array[i]->get_xml( &text );
		xml.BSTRToAscii( text, buf, 255 );
		SysFreeString(text);
		inputs += buf;
	}

	//<input_info path="XXX">̍쐬
	strInputInfo = "<input_info path=\"";
	strInputInfo += path;
	strInputInfo += "\">";

	// <command>cmd
	// <parameter><input_info>inputs
	// pătgGhɓ͏𑗐M

	inputs.insert( 0, strInputInfo);
	inputs.append( "</input_info>" );

	// <command>cmd
	// <parameter><input_info>inputs
	// pătgGhɓ͏𑗐M

	CComMsg msg;
	msg.Set( "DialogMngr", "FrontEnd", strCom.c_str(), inputs.c_str() );
	communicationManagement.SendMsg( msg );
}


//荞ݓ͑MpCpX𑗐M悤ɉ
//
// ֐ : void CInputIntegrationManager2::SendInterruptInputInfo( string exchangesInRoot, string pathRoot, string exchangesInLeaf, string pathLeaf );
// @  \ : tgGhɊ荞݂<input>𑗐M
//    : cmd ---- send_input_normal  send_input_interrupt
//		  : exchangesInRoot    AvP[Vx<exchange>̃XgiidK{j
//		  : pathRoot		  AvP[VhLgւ̃pX
//		  : exchangesInLeaf    hLgx<exchange>̃Xg(idK{)
//		  : pathLeaf		   [thLgւ̃pX  
// ߂l : Ȃ
// 쐬 : 2002/10/10 Tha.
// 쐬 : G &  L
//
// ŏIXV : 2002/07/10 Wed.
//
void CInputIntegrationManager2::SendInterruptInputInfo( string exchangesInRoot, string pathRoot, string exchangesInLeaf, string pathLeaf ){

	string strCom;
	strCom = "send_input_interrupt";

	string inputs = "";
	string inputsInRoot = "";
	string inputsInLeaf = "";
	string strInputInfo = "";
	CXMLManager xml;
	CXMLManager xml2;
	BSTR text;
	char buf[256];

	//AvP[Vx<input>
	if( exchangesInRoot != "" ){

		exchangesInRoot.insert( 0, "<msg>" );
		exchangesInRoot.append( "</msg>" );

		if( xml.LoadXML( exchangesInRoot.c_str() ) < 0 ) { return; }
	
		XMLNodeArray array;
		int array_size;
		xml.FindNodesByTagName( "input", array );

		array_size = array.size();
		for( int i = 0; i < array_size; i++ )
		{
			array[i]->get_xml( &text );
			xml.BSTRToAscii( text, buf, 255 );
			SysFreeString(text);
			inputsInRoot += buf;
		}

		//<input_info path="XXX">̍쐬
		strInputInfo = "<input_info path=\"";
		strInputInfo.append(pathRoot);
		strInputInfo.append("\">");

		//<input_info></input_info>^O̒ǉ
		inputsInRoot.insert( 0,strInputInfo); 
		inputsInRoot.append( "</input_info>" );

	}

	//[tx<input>
	if( exchangesInLeaf != "" ){

		exchangesInLeaf.insert( 0, "<msg>" );
		exchangesInLeaf.append( "</msg>" );
	
		if( xml2.LoadXML( exchangesInLeaf.c_str() ) < 0 ) { return; }

		XMLNodeArray array;
		int array_size;
		xml.FindNodesByTagName( "input", array );

		array_size = array.size();
		inputsInLeaf = "";
		for( int i = 0; i < array_size; i++ )
		{
			array[i]->get_xml( &text );
			xml2.BSTRToAscii( text, buf, 255 );
			SysFreeString(text);
			inputsInLeaf += buf;
		}

		//<input_info path="XXX">̍쐬
		strInputInfo = "<input_info path=\"";
		strInputInfo.append(pathLeaf);
		strInputInfo.append("\">");

		inputsInLeaf.insert(0, strInputInfo);
		inputsInLeaf.append( "</input_info>" );

	}

	inputs = inputsInRoot;
	inputs += inputsInLeaf;

	// <command>cmd
	// <parameter><input_info>inputs
	// pătgGhɓ͏𑗐M

	CComMsg msg;
	msg.Set( "DialogMngr", "FrontEnd", strCom.c_str(), inputs.c_str() );
	communicationManagement.SendMsg( msg );
}

/*
bool CInputIntegrationManager2::SetNormalInput( LPCSTR szFile )
{
	string input;
	fstream fs;
	char buf[512];

	input.erase( input.begin(), input.end() );
	fs.open( szFile , ios::in );
	if( fs.is_open() != 0 )
	{
		while( !fs.eof() )
		{
			fs.getline( buf, 512 );
			input.append( buf );
		}
	}
	fs.close();
	fs.clear();
	return SetNormalInput( input );
}
*/

/*
bool CInputIntegrationManager2::SetInterruptInput( LPCSTR szFile )
{
	string input;
	fstream fs;
	char buf[512];

	input.erase( input.begin(), input.end() );
	fs.open( szFile , ios::in );
	if( fs.is_open() != 0 )
	{
		while( !fs.eof() )
		{
			fs.getline( buf, 512 );
			input.append( buf );
		}
	}
	fs.close();
	fs.clear();
	return SetInterruptInput( input );
}
*/

void CInputIntegrationManager2::SetIntegrateInterval( DWORD interval )
{
	m_IntegrateInterval = interval;
}

bool CInputIntegrationManager2::CheckTimeout()
{
	DWORD current_time = GetTickCount();
	
	if( ( current_time - m_Timeout ) >= m_IntegrateInterval )
	{
//#ifdef _DEBUG
//		cout << endl;
//		cout << "****** TIMEOUT ";
//#endif
		InitTimeout();
		return true;
	}
	else
	{
		return false;
	}
}

void CInputIntegrationManager2::InitTimeout()
{
//#ifdef _DEBUG
//	cout << "****** Initialize Timeout. ******" << endl;
//	cout << endl;
//#endif
	m_Timeout = GetTickCount();
}

void CInputIntegrationManager2::InitNormalTable()
{
	m_Integrator[1].Init();
}

void CInputIntegrationManager2::InitInterruptTable()
{
	m_Integrator[0].Init();
}


