// Interpreter.cpp: CInterpreter NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Interpreter.h"
#include "common.h"
#include "logDlg.h"

extern CDocumentManagement documentManagement;
extern CLogDlg *g_pLogDlg;
//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CInterpreter::CInterpreter()
{

}

CInterpreter::~CInterpreter()
{

}

//@\F
//		ŗ^ꂽXISLɑ΂DTDɂG[osD
//F
//	string* pStrXislDocNameF͂XISLhLg̃t@C
//							΂ɂwC΂ɂ(http://`)w肪\
//	                        ΃pXŎw肳ĂꍇCɂ͐΃pX
//                          i[ĕԂD
//  IXMLDOMDocument *pXislDocF͂ɐ΁C̈ɉ͂XISLhLg
//								DOMi[DsNULL
//߂lF
//		0F͐
//		-1F͎s
//  
int CInterpreter::interpret(string* pStrXislDocName, IXMLDOMDocument** pXislDoc)
{

	CString strLog;

	VARIANT vURL;
	VARIANT_BOOL vb;
	
	//΃pX̎wȂC΃pXɕϊ
	documentManagement.changeRelativeToAbsolutePath(pStrXislDocName);

	// COMCu
	//CoInitialize(NULL);

	// XMLhLgEIuWFNg쐬
	HRESULT hr;
	hr = CoCreateInstance(	CLSID_DOMDocument,		NULL, 
							CLSCTX_INPROC_SERVER,	IID_IXMLDOMDocument,
							(void**)pXislDoc);
	if(FAILED(hr)){
	
		//G[ɂ郁̉
		if( *pXislDoc ){
			delete *pXislDoc;
		}
		*pXislDoc = NULL;
		return -1;
	}

	// 񓯊ǂݍ݂Itɂ
	(*pXislDoc)->put_async(VARIANT_FALSE);
	//DTD؂ɐݒ
	(*pXislDoc)->put_validateOnParse(VARIANT_TRUE);
	//GeBeBWJs
	(*pXislDoc)->put_resolveExternals(VARIANT_TRUE);
	
	// XMLhLgǂݍ
	vURL = AsciiToVARIANT((LPCTSTR)pStrXislDocName->c_str());
	g_pLogDlg->setText("interpret:");
	g_pLogDlg->setText( pStrXislDocName->c_str() );
	g_pLogDlg->setText("\r\n");
	hr = (*pXislDoc) -> load(vURL, &vb);
	if(FAILED(hr)){

		//G[ɂ郁̉
		if( pXislDoc ){
			(*pXislDoc) -> Release();
		}		
		*pXislDoc = NULL;
		return -1;
	}

	IXMLDOMParseError *errorObj = NULL;
	long errorCode = E_FAIL;
	long errorLine;
	//p[T̃G[R[ho
	( *pXislDoc )->get_parseError(&errorObj);
	errorObj->get_errorCode(&errorCode);
	if(errorCode != 0 ){
		BSTR bStrReason;
		errorObj->get_reason(&bStrReason);
		errorObj->get_line(&errorLine);
		char cTemp[DOCUMENT_LENGTH];
		BSTRToAscii(bStrReason,cTemp,MESSAGE_LENGTH);
		//G[̕\

		strLog.Format("G[ %d sF%d %s\r\n",errorLine,errorCode,cTemp);

		g_pLogDlg->setText(strLog);

		//̉
		SysFreeString(bStrReason);
		errorObj->Release();
		errorObj=NULL;

		//G[ɂ郁̉
		if( pXislDoc ){
			( *pXislDoc )->Release();
		}
		*pXislDoc = NULL;
		return -1;

	}else{

		//DTD\͐D
		//DOM̕ϊ

		//eXgp\
		//BSTR bStrXmlString;
		//pXislDoc->get_xml(&bStrXmlString);
		//char temporary[DOCUMENT_LENGTH];
		//BSTRToAscii(bStrXmlString,temporary,DOCUMENT_LENGTH);
		//fprintf(stderr,"%s",temporary);
		//SysFreeString(bStrXmlString);


		//̉
		errorObj->Release();
		errorObj=NULL;


	}

	return 0;
}

//@\
//	XISLhLg̑΃pX΃pXɕϊ
//	Ώ
//	E<operation>̑target
//	E<input>̑target
//
//
//	ΏۂXISLhLgDOM
//߂l
//  int  0F
//      -1Fs( targetȂ j
int CInterpreter::changeRelativeToAbsolute(IXMLDOMDocument** pXislDoc)
{
	IXMLDOMNodeList *operationTargetNodeList = NULL;
	IXMLDOMNode		*operationTargetNode = NULL;
	IXMLDOMNodeList *inputTargetNodeList = NULL;
	IXMLDOMNode		*inputTargetNode = NULL;
	HRESULT hr;
	
	string *strPath;			//targetŎw肳ĂpXi[
	strPath = new string();
	char cTemp[MESSAGE_LENGTH];

	BSTR bStrTargetValue;  //target̒li[

	BSTR bStrOperationPattern;  //<operation>̑targetXPathi[
	BSTR bStrInputPattern;		//<input>̑targetXPathi[
	
	long length;	//m[hXg̒i[
	int i;

	int Ret = 0;

	//om[h̏XPathBSTR^ŕۑ
	//<operation>^Ȏtarget𔲂ôŁCXPath = "//operation/@target"
	bStrOperationPattern = AsciiToBSTR("//operation/@target");
	//<input>^Ȏtarget𔲂ôŁCXPath = "//input/@target"
	bStrInputPattern = AsciiToBSTR("//input/@target");

	//Ώۃm[hXg̎擾( <operation>)̎擾
	hr = (*pXislDoc)->selectNodes(bStrOperationPattern,&operationTargetNodeList);
	::SysFreeString(bStrOperationPattern);
	if( hr != S_OK ){
		Ret = -1;
	}

	operationTargetNodeList->get_length(&length); //m[hXg̗vfiji[
	//<operation>̑target̃m[hXgɒHȂ
	for( i = 0; i < length; i++){
		operationTargetNodeList -> get_item( i, &operationTargetNode );

		//target̑l擾
		operationTargetNode->get_text(&bStrTargetValue);
		BSTRToAscii(bStrTargetValue,cTemp,MESSAGE_LENGTH);
		::SysFreeString(bStrTargetValue);

		//lstrPathɊi[
		strPath->assign(cTemp,MESSAGE_LENGTH);
		if( cTemp[0] != '\0' ){
			//strPath𑊑΃pX΃pX
			documentManagement.changeRelativeToAbsolutePath(strPath);
		}

		//̑lɊi[
		strcpy(cTemp,strPath->c_str());
		operationTargetNode->put_nodeTypedValue(AsciiToVARIANT(cTemp));
		cTemp[0] ='\0';
		
	}

	//Ώۃm[hXg̎擾( <input>)̎擾
	hr = (*pXislDoc)->selectNodes(bStrInputPattern,&inputTargetNodeList);
	::SysFreeString(bStrInputPattern);
	if( hr != S_OK ){
		Ret = -1;
	}

	inputTargetNodeList->get_length(&length); //m[hXg̗vfiji[
	//<input>̑target̃m[hXgɒHȂ
	for( i = 0; i < length; i++){
		inputTargetNodeList -> get_item( i, &inputTargetNode );

		//pX̎擾
		inputTargetNode->get_text(&bStrTargetValue);
		BSTRToAscii(bStrTargetValue,cTemp,MESSAGE_LENGTH);
		::SysFreeString(bStrTargetValue);
		strPath->assign(cTemp,MESSAGE_LENGTH);
		documentManagement.changeRelativeToAbsolutePath(strPath);
		strcpy(cTemp,strPath->c_str());
		inputTargetNode->put_nodeTypedValue(AsciiToVARIANT(cTemp));
		cTemp[0] ='\0';
		
	}
						
	//eXgpCϊDOMt@Cɕۑ	
	VARIANT vURL;
	string strTemp;
	strTemp = "\\\\chariot\\TEMP\\TEST\\temp.xisl";
	vURL = AsciiToVARIANT((LPCTSTR)strTemp.c_str());
	hr = (*pXislDoc) -> save(vURL);
	VariantClear(&vURL);

	//̉
	delete strPath;
	strPath = NULL;

	//operationTargetNodeList->Release();
	//operationTargetNodeList = NULL;
	//if( operationTargetNode != NULL ){
	//	operationTargetNode->Release();
	//	operationTargetNode = NULL;
	//}
	//inputTargetNodeList->Release();
	//inputTargetNodeList = NULL;
	//if( inputTargetNode != NULL ){
	//	inputTargetNode->Release();
	//	inputTargetNode = NULL;
	//}



	return Ret;
}

//
//@\F^ꂽXISLhLgCAvP[V[gw肵Ă邩C
//      w肵ĂȂ𔻒肵Cw肳Ă΁CAvP[V[g̃h
//      Lg̕ւ̃|C^ɁC΃pXt̃AvP[V
//      [ghLgi[D
//F
//  IXMLDOMDocument **pLeafXislDocF
//@@@    XISL[thLgDOM̃|C^̃|C^
//  string *pStrRootDocNameG
//@@@    ΃pXtXISL[ghLg̃t@Ci[镶
//          ̃|C^D
// ߂lF
//   int 0 F AvP[V[gw肳Ă0    
//       1 :  w肳ĂȂ
//

int CInterpreter::retRootDocName( IXMLDOMDocument** pLeafXislDoc,
	  			  				  string* pStrRootDocName){
	
	IXMLDOMNode* rootNode;
	HRESULT hr;

	BSTR bStrRootPattern;
	BSTR bStrApplicatonValue;

	char cTemp[MESSAGE_LENGTH];
	
	//om[h̏XPathBSTR^ŕۑ
	//<xisl>^Ȏapplication𔲂ôŁCXPath = "//xisl/@application"
	bStrRootPattern = AsciiToBSTR("//xisl/@application");
	SysFreeString(bStrRootPattern);
	//<xisl>^Ȏapplicationm[h̒o
	hr = (*pLeafXislDoc)->selectSingleNode(bStrRootPattern,&rootNode);
	if( hr != S_OK ){
		return 1;
	}	
	
	//application̒l̒o
	rootNode->get_text(&bStrApplicatonValue);
	BSTRToAscii(bStrApplicatonValue,cTemp,MESSAGE_LENGTH);
	SysFreeString(bStrApplicatonValue);
	pStrRootDocName->assign(cTemp);
	cTemp[0] = '\0';

	//΃pX΃pXɕϊ
	documentManagement.changeRelativeToAbsolutePath(pStrRootDocName);

	//rootNode->Release();
	rootNode = NULL;
	return 0;

}

