// OperationManagement.cpp: COperationManagement NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "NewIV.h"
#include "OperationManagement.h"
#include "common.h"
#include "TreeManagement.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CTreeManagement treeManagement;
//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

COperationManagement::COperationManagement()
{
	mpListHead = NULL;
	mpListTail = NULL;
}

COperationManagement::~COperationManagement()
{

	initialize();
}

//operationǗ̏
void COperationManagement::initialize(){

	//qvf̏
	if(mpListHead)
	{
		COperation* pTempOperation;
		while((mpListHead->retNextNode())!= NULL){
			// 擪i_~[m[hj̎̃m[h擾
			pTempOperation = ( COperation* )mpListHead->retNextNode();
			// m[hoperationXgO
			pTempOperation->cutOffList();
			// m[hJ
			delete pTempOperation;
		}

	}
	if( mpListHead != NULL ){
		//_~[m[h̏
		delete mpListHead;
	}
	mpListHead = NULL;
	mpListTail = NULL;

}

//ŗ^ꂽexchangeIdƁC<operation>DOMm[h̃|C^
//COperation𐶐āCXgɉ
//F
//		int exchangeId;
//		IXMLDOMNode** ppOperationNode <operation>DOMm[h
//߂lF
//		int
//			0:
//		   -1:s
int COperationManagement::makeOperation(int exchangeId, IXMLDOMNode** ppOperationXisl){

	//XgH邽߂́CCOperationNX̃|C^
	COperation* pTempOperation;

	if( mpListHead == NULL ) {
		mpListHead = new COperation;
		mpListTail = mpListHead;
	}

	//_~[m[h̓ǂݔ΂
	pTempOperation = (COperation*)mpListHead->retNextNode();

	//XgɓCOperationȂ̊mF
	while( pTempOperation != NULL ){
		
		if( pTempOperation->getId() == exchangeId ){
			return -1;
		}

		//Xg߂
		pTempOperation = (COperation*)pTempOperation->retNextNode();
	}

	//XgɒǉCOperationIuWFNg̐
	pTempOperation = new COperation(exchangeId,ppOperationXisl);

	//Xg̍Ōɒǉ
	pTempOperation->joinList(mpListTail);
	//Ō̃|C^i߂
	mpListTail = pTempOperation;

	return 0;

}

//ŗ^ꂽexchangeIdCOperationXg
//F
//		int exchangeId: exchangeidl
//߂lF
//		int
//			0F
//		   -1Fs
int COperationManagement::deleteOperation(int exchangeId){

	//XgɎqvf
	if( mpListHead ){

		//XgH邽߂̃|C^
		COperation* pTempOperation;

		//擪̃_~[m[hǂݔ΂
		pTempOperation = (COperation*)mpListHead->retNextNode();

		while(pTempOperation!=NULL){

			if( pTempOperation->getId() == exchangeId ){
				//Ώۂ̃IuWFNg

				if( pTempOperation->retNextNode() == NULL ){
					//Ώۃm[hXg̍ŌȂ
					mpListTail =( COperation* )pTempOperation->retPrevNode();
				}
				//Xg̎O
				pTempOperation->cutOffList();
				//OIuWFNg̏
				delete pTempOperation;
				pTempOperation = NULL;

				return 0;
			}
	
			//Xg߂
			pTempOperation = (COperation*)pTempOperation->retNextNode();

		}

		//Ώۃm[h݂Ȃ
		return -1;

	}else{
		return -1;
	}

}

//ʏ͗p
//exchangeIdi[ꂽXgC<operation>𐶐C
//̕ԂD
//F
//		vector<int> exchangeIdsF擾ΏۂexchangeIdi[Ă铮Iz
//		string* pStrOperationInfoFoperationi[镶
//		string* pStrPath:operation݂pX
//߂lF
//	int
//		0:@
//	   -1F s(PȏexchangeId݂Ȃ)
int COperationManagement::getOperationInfo(vector<int> exchangeIds, string* pStrOperationInfo, string* pStrPath){


	COperation* pTempOperation;
	int find_flag = 0;
	int Ret = 0;

	//݃ANeBuԂ̃hLgpXɑ
	pStrPath->assign( treeManagement.getActiveDocumentName() );

	//t@C̏
	int pos=0;
	pos = pStrPath->rfind("/");
	if( pos != -1 ){
		pStrPath->erase(pos+1);
	}

	pStrOperationInfo->assign("");

	if( mpListHead ){

		//Iz݂Ȃ
		for(int i=0; i < exchangeIds.size(); i++){

			//擪̃_~[m[h̓ǂݔ΂
			pTempOperation = ( COperation* )mpListHead->retNextNode();

			while( pTempOperation != NULL ){

				if( pTempOperation->getId() == exchangeIds[i] ){
					string strOprInfo;
					pTempOperation->getOperationInfo(&strOprInfo);
					pStrOperationInfo->append(strOprInfo);
					pTempOperation = NULL;
					find_flag = 1;
				}else{
					pTempOperation = (COperation*)pTempOperation->retNextNode();
				}

			}

			if( find_flag == 0 ){
				//Ȃ
				Ret = -1;
			}else{
				find_flag = 0;
			}
		}

		return Ret;

	}else{

		return -1;

	}

}


//荞ݓ͗p
//exchangeIdi[ꂽXgC<operation>𐶐D
//܂̎C[g荞ݗpoperationƃhLg荞ݗpoperation
//ʁXɕĕԂD܂ꂼ̃pXԂD
//
//		<vector><int> exchangeIdsF擾ΏۂexchangeIds
//			string*   pRootPath : [g̃pX
//			string*   pStrRootOperationInfo : [gɑ݂<operation>
//			string*   pDocPath : [t̃pX
//			string*   pStrDocOperationInfo : [tɑ݂<operation>
//l
//[gƃ[tꍇC
//̃pX͓ƂwD܂<opeation>ɊւẮC
//[gɊ荞݂<operation>񂪊i[C[t͋󕶎ƂȂD
int COperationManagement::getInterruptOperationInfo(vector<int> exchangeIds, 
							  string* pRootPath, string* pStrRootOperationInfo,
							  string* pDocPath, string* pStrDocOperationInfo){

	COperation* pTempOperation;
	int find_flag = 0;
	int Ret = 0;

	//[g̃pX̃Zbg
	pRootPath->assign(treeManagement.getRootDocName());

	//[t̃pX̃Zbg
	pDocPath->assign(treeManagement.getLeafDocName());

	int pos=0;
	pos = pRootPath->rfind("/");
	if( pos != -1 ){
		pRootPath->erase(pos+1);
	}
	pos = pDocPath->rfind("/");
	if( pos != -1 ){
		pDocPath->erase(pos+1);
	}



	pStrRootOperationInfo->assign("");
	pStrDocOperationInfo->assign("");

	if( mpListHead ){

		//Iz݂Ȃ
		for(int i=0; i < exchangeIds.size(); i++){


			//擪̃_~[m[h̓ǂݔ΂
			pTempOperation = ( COperation* )mpListHead->retNextNode();

			while( pTempOperation != NULL ){

				if( pTempOperation->getId() == exchangeIds[i] ){

					string strOprInfo;
					pTempOperation->getOperationInfo(&strOprInfo);

					if( treeManagement.existInRoot(exchangeIds[i]) ){
						//exchange[gɑ݂Ȃ
						pStrRootOperationInfo->append(strOprInfo);
					}else{
						//exchange[tɑ݂Ȃ
						pStrDocOperationInfo->append(strOprInfo);
					}

					pTempOperation = NULL;
					strOprInfo.empty();
					find_flag = 1;

				}else{
					pTempOperation = (COperation*)pTempOperation->retNextNode();
				}

			}

			if( find_flag == 0 ){
				//Ȃ
				Ret = -1;
			}else{
				find_flag = 0;
			}
		}

		return Ret;

	}else{

		return -1;

	}

}

//SĂCOperationo
void COperationManagement::getAllOperationInfo(string* pStrAllOperationInfo){

	if(mpListHead){

		COperation* pTempOperation;
		int id;
		char cId[WORD_LENGTH];
		string strOperationInfo;
		pStrAllOperationInfo->assign("");

		pTempOperation = (COperation*)mpListHead->retNextNode();

		while( pTempOperation != NULL ){

			id = pTempOperation->getId();
			itoa(id,cId,10);
			pStrAllOperationInfo->append("id = ");
			pStrAllOperationInfo->append( cId );
			pStrAllOperationInfo->append("\n");

			pTempOperation->getOperationInfo(&strOperationInfo);
			pStrAllOperationInfo->append("operation info =\n");
			pStrAllOperationInfo->append(strOperationInfo);
			pStrAllOperationInfo->append("\n");

			pTempOperation = (COperation*)pTempOperation->retNextNode();
		}

	}
}


//Soperationt@Cɂ
int COperationManagement::writeOperationInfo(){

	FILE *pFileOut = NULL;
	pFileOut = fopen("operation_info.txt","w");

	if( pFileOut == NULL ){
		fprintf(pFileOut,"Can't open operation_info file.\n");
		return -1;
	}
	
	string* pStrNodeInfo;
	pStrNodeInfo = new string();

	getAllOperationInfo(pStrNodeInfo);

	fprintf(pFileOut,pStrNodeInfo->c_str());

	delete pStrNodeInfo;

	fclose(pFileOut);

	return 0;

}

//@\F
//		w肵exchangeId<operation><input>̑return̒lAĕԂD
//F
//		int exchangeId;
//		string* strReturnVarList;
//߂lF
//		int -1 : s
//		int  0 : 
int COperationManagement::returnVarList( int exchangeId, string* strReturnVarList )
{

	strReturnVarList->assign("");

	//XgɎqvf
	if( mpListHead ){

		//XgH邽߂̃|C^
		COperation* pTempOperation;

		//擪̃_~[m[hǂݔ΂
		pTempOperation = (COperation*)mpListHead->retNextNode();

		while(pTempOperation!=NULL){

			if( pTempOperation->getId() == exchangeId ){
				//Ώۂ̃IuWFNg

				strReturnVarList->append(pTempOperation->getReturnVarList());

				return 0;
			}
	
			//Xg߂
			pTempOperation = (COperation*)pTempOperation->retNextNode();

		}

		//Ώۃm[h݂Ȃ
		return -1;

	}else{
		return -1;
	}




}
