// Socket.h
//
//////////////////////////////////////////////////////////////////////

#ifndef _SOCKET_H_
#define _SOCKET_H_

#pragma comment( lib, "wsock32.lib" ) 

#include <windows.h>
#include <winsock.h>
#include <sys/types.h>
#include <process.h>

#include <iostream>
#include <string>
#include <list>
#include <deque>
#include <fstream>

using namespace std;


#define ADDRFILE "AddressInfo.txt"	// AhX񂪏ꂽt@C
#define MMI_MODULE_NAME_LENGTH		15				// W[15܂
#define RECV_BUFFER_SIZE			255				// recv()̎Mpobt@TCY

// sockaddr_in\̂bvNX
class CSockAddr
{

protected:

	struct sockaddr_in m_InetSockAddr;		// C^[lbgp\PbgAhX\

public:

	CSockAddr();
	CSockAddr( const char *IpAddr, const int nPort );
	CSockAddr( const CSockAddr &Addr );
	virtual ~CSockAddr();

	CSockAddr& operator = ( const CSockAddr &Addr );

	// IPAhXƃ|[gԍZbg
	void Set( const char *IpAddr, const int nPort );

	// ZbgĂ|[gԍԂ
	int GetPort() const;
	// IPAhXԂ
	const char* GetIpAddr() const;
	// õ|C^Ԃ
	const struct sockaddr* GetSockaddr() const;
	const struct sockaddr_in* GetSockaddrIN() const;

};

// MMIVXep
// W[̃AhXǗ
class CMMIModuleAddr : public CSockAddr
{

private:

	char m_szModule[ MMI_MODULE_NAME_LENGTH + 1 ];	// W[

public:

	CMMIModuleAddr();
	CMMIModuleAddr( const char *szName, const char *IpAddr, const int nPort );
	CMMIModuleAddr( const CMMIModuleAddr &Addr );
	virtual ~CMMIModuleAddr();

	CMMIModuleAddr& operator = ( const CMMIModuleAddr &Addr );

	// W[AIPAhXA|[gԍ܂Ƃ߂ăZbg
	void Set( const char *Module, const char *IpAddr, const int nPort );

	// W[Ԃ
	const char* GetName() const;

};

// ubLO\Pbg̃bv
class CSock
{

public:
	SOCKET m_hSocket;	// \Pbgnh

public:
	CSock();
	virtual ~CSock();

	void Attach( SOCKET hSocket );
	void Detach();

	bool Socket( int nAddrFamily = AF_INET, int nSocketType = SOCK_STREAM, int nProtocol = IPPROTO_TCP );
	bool Bind( CSockAddr *addr );
	bool Listen( int nMaxCon = 5 );
	bool Accept( CSock &sock );
	bool Connect( CSockAddr *addr );
	void Close();

	int Send( const char *szMsg, size_t nByte );

	int Recv( char *szBuff );

	bool IsValid();

};

// W[ԒʐMpbZ[W̃bv
class CComMsg
{
public:

	string m_Msg;			// bZ[W

protected:

	string GetSubstring( const char *szTag ) const;

public:

	CComMsg();
	CComMsg( string &msg );
	CComMsg( const CComMsg &msg );
	CComMsg( LPCSTR from, LPCSTR to, LPCSTR cmd, LPCSTR param );
	CComMsg( LPCSTR msg );
	virtual ~CComMsg();

	CComMsg& operator = ( const CComMsg &msg );

	int Set( string &msg );
	int Set( LPCSTR msg );
	int Set( LPCSTR from, LPCSTR to, LPCSTR cmd, LPCSTR param );

	string Get();
	string GetCmd() const;
	string GetCmdWithTag() const;
	string GetParam() const;
	string GetParamWithTag() const;
	string GetFrom() const;
	string GetFromWithTag() const;
	string GetTo() const;
	string GetToWithTag() const;
	string GetBody() const;
	string GetBodyWithTag() const;


protected:
	void Dump();
	int IsValid();
};

// bZ[WMp̃NX
class CMsgServer
{

protected:

	char m_szModule[ MMI_MODULE_NAME_LENGTH + 1 ];				// W[
	list < CMMIModuleAddr* > m_Addrlist;	// AhXXg
	CSock m_Socket;							// ڑҋ@p\Pbg
	DWORD m_dwThread;						// MpXbh̃nh

	deque < CComMsg* > m_MsgDeque;			// 
	CRITICAL_SECTION m_CriticalSection;		// ftHgbZ[WL[p

public:

	CMsgServer();
	virtual ~CMsgServer();
	
	// 
	BOOL Initialize( LPCSTR szModule );
	
	// T[o[̊Jnƒ~
	void Run();
	void Stop();

	// L[烁bZ[Wo
	virtual BOOL GetMsg( CComMsg &msg );
	virtual BOOL GetMsg( string &msg );

	// bZ[W𑗐M
	BOOL SendMsg( CComMsg &msg );
	BOOL SendMsg( string &msg );

protected:

	void WinSockInit();
	
	// AhXt@C̓ǂݍ
	void ReadAddrFile( LPCSTR szFile );
	// AhXNA
	void ClearAddr();
	// W[AhXQ
	CMMIModuleAddr* GetAddr( LPCSTR szModule );
	
	// MpXbh
	static DWORD WINAPI RecvThread( void* );
	
	// MbZ[W
	virtual void AnalyzeMessage( string &msg );	

};

#endif _SOCKET_H_