//
// SLR(1)\͊쐬vO
// L\
//
// SymbolTable.h / SymbolTable.cpp
//
// 2001/10/30 Tue. JF
// 2002/07/06 Sat. G
//
// ̃vÓCMMIVXeɈˑȂvOłB
//
// ŏIXV : 2002/07/13 Sat. G
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#ifndef _SYMBOLTABLE_H_
#define _SYMBOLTABLE_H_

#include <map>
#include <string>

using namespace std;

#define SYMBOL_LENGTH	20		// L̒

//
// 񋓌^ SYMBOLTYPE
//
// I[LƔI[L̂ǂł邩
//

enum SYMBOLTYPE
{
	SYMBOL_UNKNOWN		= -1,		// s
	SYMBOL_TERMINAL,				// I[L
	SYMBOL_NONTERMINAL,				// I[L
};


//
// NX CSymbol
// 
// @ɏoLǗ
//
// 2001/10/30 Tue. JF

class CSymbol
{
private:
	char m_strSymbol[ SYMBOL_LENGTH + 1 ];	// L
	SYMBOLTYPE m_nType;						// L^Cv

public:
	CSymbol();
	CSymbol( const char *sym, SYMBOLTYPE type );
	CSymbol( const CSymbol &sym );

	virtual ~CSymbol();

public:
	const char *GetSymbol() const;
	SYMBOLTYPE  GetSymType() const;

	void SetSymbol( const char *sym, SYMBOLTYPE type );

public:
	CSymbol &operator = ( const CSymbol &sym );

	void Display();

};

//
// NX CSymbolTable
//
// @ɏoL̋L\Ǘ
// ̋Lo^邱Ƃ֎~B
//
// 2001/10/30 Tue. JF
//

class CSymbolTable
{
private:
	map < string, CSymbol* > m_SymbolTable;		// L\

public:
	CSymbolTable();
	virtual ~CSymbolTable();

public:
	int GetSize() const;

public:
	void RemoveAll();

	int AddSymbol( const char *sym, SYMBOLTYPE type );
	int RemoveSymbol( const char *sym );
	int RemoveSymbol( int index );

	SYMBOLTYPE GetSymType( const char *sym );
	int GetSymbol( int index, CSymbol &symbol );

	bool ExistSymbol( const char *sym );

public:
	int GetTerminalSymTable( CSymbolTable &table );
	int GetNonterminalSymTable( CSymbolTable &table );

	void Display();

protected:
	map < string, CSymbol * >::iterator SearchSymbol( const char *sym );

	int GetSubTable( SYMBOLTYPE type, CSymbolTable &table );

public:
	CSymbolTable &operator = ( CSymbolTable &table );
};



#endif  _SYMBOLTABLE_H_