// TreeManagement.cpp: CTreeManagement NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "common.h"
#include "logDlg.h"
#include "NewIV.h"
//#include "DialogControl.h"

#include "TreeManagement.h"
#include "VariableManagement.h"
#include "DocumentManagement1.h"
#include "Interpreter.h"
#include "OperationManagement.h"
#include "ActionManagement.h"
#include "StackManagement.h"
#include "StackNode.h"

#include "DialogTreeNode.h"
#include "ParentsOfExchangeNode.h"
#include "ExchangeNode.h"
#include "BeginNode.h"
#include "EndNode.h"


#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern CVariableManagement variableManagement;
extern CDocumentManagement documentManagement;
extern CInterpreter interpreter;
extern COperationManagement operationManagement;
extern CActionManagement actionManagement;
extern CStackManagement stackManagement;
extern CNewIVApp theApp;
extern CLogDlg *g_pLogDlg;
//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CTreeManagement::CTreeManagement()
{
	//idԍ̃JEg̏
	this->mIdCount = 0;

	//|C^̏
	this->mpLeafXisl = NULL;
	this->mpRootXisl = NULL;
	this->mRootDialogTreeNode = NULL;

}

CTreeManagement::~CTreeManagement()
{

	if( this->mRootDialogTreeNode ){
		delete mRootDialogTreeNode;
		mRootDialogTreeNode = NULL;
	}

}


//̃IuWFNg̏
void CTreeManagement::initialize(){

	if( this->mRootDialogTreeNode ){
		delete mRootDialogTreeNode;
		mRootDialogTreeNode = NULL;
	}

	this->mIdCount = 0;

}

//@\:
//	oϐmIdCountlԂD
//  ܂ANZXxɁCCNgD
//F
//  Ȃ
//߂lF
//	int mIdCountl
int CTreeManagement::getIdCount(){

	return this->mIdCount++;

}

//@\:
//	[ghLgԂD
//F
//	string* rootDocNameFmStrRootDocNamei[string^̃|C^D
//߂l:
// ȂD
void CTreeManagement::getRootDocName(string *rootDocName){

	rootDocName->assign(this->mStrRootDocName);

}

//@\:
//	[thLgԂD
//F
//	string* leafDocNameFmStrLeafDocNamei[string^̃|C^D
//߂l:
// ȂD
void CTreeManagement::getLeafDocName(string *leafDocName){

	leafDocName->assign(this->mStrLeafDocName);

}


//@\:
//	[ghLgZbgD
//F
//	string rootDocNameF[ghLgi[Ă镶
//߂l:
// ȂD
void CTreeManagement::setRootDocName(string rootDocName){

	this->mStrRootDocName = rootDocName;

}

//@\:
//	[thLgZbgD
//F
//	string leafDocNameF[thLgi[Ă镶
//߂l:
// ȂD
void CTreeManagement::setLeafDocName(string leafDocName){

	this->mStrLeafDocName = leafDocName;

}

//@\:
//  [ghLgDOMZbgD
//F
//	IXMLDOMDocument *pRootXisl:[ghLgDOM̃|C^
//߂l:
// ȂD
void CTreeManagement::setRootDom(IXMLDOMDocument** pRootXisl){

	this->mpRootXisl = *pRootXisl;

}

//@\:
//  [thLgDOMZbgD
//F
//	IXMLDOMDocument *pLeafXisl:[thLgDOM̃|C^
//߂l:
// ȂD
void CTreeManagement::setLeafDom(IXMLDOMDocument** pLeafXisl){

	this->mpLeafXisl = *pLeafXisl;
	
}

//@\F
//		[ghLgDOM̉
//FȂ
//߂lFȂ
void CTreeManagement::releaseRootDom(){

	if( mpRootXisl ){

		mpRootXisl->Release();
		mpRootXisl = NULL;

	}

}

//@\F
//		[thLgDOM̉
//FȂ
//߂lFȂ
void CTreeManagement::releaseLeafDom(){

	if( mpLeafXisl ){
		mpLeafXisl->Release();
		mpLeafXisl = NULL;
	}

}

//@\F
//	Θbc[̃[gm[hłCApplicationIuWFNg̐
//	܂CApplication̉ʂɂ́C[ghLgCDocumentD
//  ܂CDocument̉ʂɂ́C荞<dialog>CDialogD
//F
//	Ȃ
//߂lF
//   0:I
//	-1FُI
int CTreeManagement::makeApplication(){
	
	int Ret = 0;
	IXMLDOMNode* pRootNode;

	//[gvf<xisl>m[h̎擾D
	(this->mpRootXisl)->get_firstChild(&pRootNode);

	//eXgpϐ
	//BSTR bStrTemp;
	//char cTemp[WORD_LENGTH];
	//[gvfƂĂ邩CeXgp
	//pRootElement->get_baseName(&bStrTemp);
	//BSTRToAscii(bStrTemp,cTemp,WORD_LENGTH);

	//Θbc[̃[gm[h̐(AvP[Vϐo^jD
	this->mRootDialogTreeNode =new CApplicationNode(mStrRootDocName,&pRootNode,NULL);
	//Θbc[̃[gm[hANeBuԂɂD
	mRootDialogTreeNode->beActive();

	//[ghLgCDocument𐶐D
	Ret = this->mRootDialogTreeNode->makeDocument(mStrRootDocName,&pRootNode,ROOTDOCUMENT);

	return Ret;
}

//@\F
//		[gm[hȉɁC[thLgɑΉCDocumentNode̐D
//		CDocumentNodeȉɂ́C荞<dialog>ɑΉCDialogNodeD
//F
//		Ȃ
//߂lF
//	int 
//		0 :@
//	   -1 :@s
int CTreeManagement::makeLeafDocument(){

	int Ret = 0;
	IXMLDOMNode* pRootNode;

	//writeDialogTree();
	//[gvf<xisl>m[h̎擾D
	(this->mpLeafXisl)->get_firstChild(&pRootNode);

	//[thLgCDocument𐶐D
	Ret = (this->mRootDialogTreeNode)->makeDocument(mStrLeafDocName,&pRootNode,LEAFDOCUMENT);

	return Ret;
}

//@\F
//		w肵hLgm[h̉ʂɁCŏ<dialog>ɑΉCDialogNode̐
//F
//		string strDocumentNameFhLg
//		string strArg;	_CAOւ̎@ȂNULL
//߂lF
//		int
//			0F
//		   -1Fs
//		   -2FłɐĂ
int CTreeManagement::makeDialog( string &strDocumentName, string strArg ){

	return mRootDialogTreeNode->makeDialog(strDocumentName, strArg);

}

//@\F
//		w肵hLgm[h̉ʂɁC
//		w肳ꂽ<dialog>ɑΉCDialogNode̐
//F
//		string strDocumentNameFhLg
//		string strDialogNameF_CAO
//		string strArgF_CAOւ̎
//߂lF
//		int
//			0F
//		   -1Fs
//		   -2:łɐĂ
int CTreeManagement::makeDialog( string &strDocumentName, string &strDialogName, string strArg ){

	return mRootDialogTreeNode->makeDialog(strDocumentName,strDialogName,strArg);
}

//@\F
// ϐǗɁCϐo^˗sD
// ͈F	char*	pVarName										o^ϐ̖O
//				char*	pNLApplication	/ pNLDocument
//						pNLDialog	/ pNLExchange						ϐ̊KwiXR[vj
// o͈F	
// ߂l  F	intiIF0 ^ُIF-1 ^do^F1 ^ϐsF2)

int CTreeManagement::askVarManagementToRegistVar(char *pNLApplication,	char *pNLDocument,
												 char *pNLDialog,	char *pNLExchange, 
												 char *pVarName){

	//ϐǗɕϐo^˗D
	return variableManagement.registVar(pNLApplication, pNLDocument, pNLDialog, pNLExchange,pVarName);


}

//@\F
// ϐǗɁCϐlo^˗sD
// ͈F	char*	pVarName										ϐ̖O
//				char*	pNLApplication	/ pNLDocument
//						pNLDialog	/ pNLExchange						ϐ̊KwiXR[vj
//				char*	pVarData										ϐɏޓe
// o͈F	
// ߂l  F	intiIF0 ^ُIF-1 ^ϐ݂ȂF1j
// ------------------------------
// ϐ(ZbVϐȂAZbVϐ̒ʒm͓AetgGhɑM
// ------------------------------
int CTreeManagement::askVarManagemnetToSetVarData(	char *pNLApplication,	char *pNLDocument,
													char *pNLDialog,	char *pNLExchange,
													char *pVarName, char *pVarData){

	return variableManagement.setVar(pNLApplication, pNLDocument, pNLDialog, pNLExchange,pVarName,pVarData);

}

//-----------------------------------------------------------------------------
// ͈F	char*	pVarName										ϐ̖O
//				char*	pAppName	/ pDocName
//						pDiaName	/ pExcId						ϐ̊KwiXR[vj
//				char*	pVarData										擾f[^i[镶z
// o͈F	
// ߂l  F	intiIF0 ^ُIF-1 ^ϐ݂ȂF1j//
//---------------------------------------------------------------------------
//ϐ݂̂ŁA[J猟AvƂł̒lQbgB
//application. document. exchange.@̐ړlĂB
//---------------------------------------------------------------------------
int CTreeManagement::askVarManagementToNewGetVar(	char *pNLApplication,	char *pNLDocument,
									char *pNLDialog,		char *pNLExchange,		
									char *pVarName, char *pVarData){

	return variableManagement.newGetVar(pNLApplication, pNLDocument, pNLDialog, pNLExchange,pVarName,pVarData);

}

//@\F
//		ϐǗɕϐ폜˗
//F	char*	pVarName										폜ϐ̖O
//			char*	pNLApplication	/ pNLDocument
//			pNLDialog	/ pNLExchange						폜ϐ̊KwiXR[vj
// ߂l  F	intiIF0 ^ُIF-1 ^ϐ݂ȂF1j
int CTreeManagement::askVarManagementToDeleteVar(char *pNLApplication,	char *pNLDocument,
												 char *pNLDialog,	char *pNLExchange, 
												 char *pVarName){

	if( !strcmp(pVarName,"") ){
		char cVarData[DOCUMENT_LENGTH];

		//ϐǗɁCϐ폜˗D
		variableManagement.swapVar(pNLApplication,pNLDocument, pNLDialog, pNLExchange,cVarData);
		return 0;
	}else{
		//ϐǗɁCϐ폜˗D
		return variableManagement.deleteVar(pNLApplication,pNLDocument, pNLDialog, pNLExchange,pVarName);

	}

}

//operationǗoperationo^˗s
//F
//		int exchangeIdFo^operatioñGNX`FWidl
//		IXMLDOMNodeF@<operation>DOMm[h̃|C^̃|C^
//߂l:
//		int
//			0Fo^s
//		   -1Fo^
int CTreeManagement::askOperationManagementToRegistOperation(int exchangeId,IXMLDOMNode** ppOperationNode){
	
	return operationManagement.makeOperation(exchangeId,ppOperationNode);
}

//operationǗoperation폜˗s
int CTreeManagement::askOperationManagementToDeleteOperation(int exchangeId){

	return operationManagement.deleteOperation(exchangeId);
}

//ANVsɁCactiono^˗s
int CTreeManagement::askActionManagementToRegistAction(string &strAppName,string &strDocName,string strDiaName,int exchangeId,IXMLDOMNode** ppActionNode){

	return actionManagement.makeAction(strAppName, strDocName, strDiaName, exchangeId, ppActionNode);

}

//ANVsɁCaction폜˗s
int CTreeManagement::askActionManagementToDeleteAction(int exchangeId){

	return actionManagement.deleteAction(exchangeId);

}

//ANVsɁCaction̏˗s
int CTreeManagement::askActionManagementToInitAction(int exchangeId){

	return actionManagement.initAction(exchangeId);

}

//ANVsɁCprompt(exchangPʂ́j̓o^˗s
int CTreeManagement::askActionManagementToRegistPrompts(string &strAppName,string &strDocName,string &strDiaName,int exchangeId,IXMLDOMNodeList** ppPromptNodeList){

	return actionManagement.makePrompts(strAppName, strDocName, strDiaName, exchangeId,ppPromptNodeList);

}

//ANVsɁCprompt(exchangePʂ́j̍폜˗s
int CTreeManagement::askActionManagementToDeletePrompts(int exchangeId){

	return actionManagement.deletePrompts(exchangeId);
}

//ANVsɁCprompt(exchangePʂ)̏˗s
int CTreeManagement::askActionManagementToInitPrompts(int exchangeId){

	return actionManagement.initPrompts(exchangeId);
}

//ANVsɁCprompt(exchangePʂ)̏˗s
//JEgl͏ȂD
int CTreeManagement::askActionManagementToInitPromptsWtihNotInitCount(int exchangeId){
	return actionManagement.initPromptsWithNotInitPrompts(exchangeId);
}
//@\F
//		Θbc[̓eCt@CɂD
//		
int CTreeManagement::writeDialogTree(){
	
	FILE *pFileOut = NULL;
	pFileOut = fopen("dialogTree.txt","w");

	if( pFileOut == NULL ){
		fprintf(pFileOut,"Can't open DialogTree file.\n");
		return -1;
	}
	
	string* pStrNodeInfo;
	pStrNodeInfo = new string();
	pStrNodeInfo->assign("");

	this->writeDialogTreeNode(this->mRootDialogTreeNode,pStrNodeInfo,0);
	fprintf(pFileOut,pStrNodeInfo->c_str());

	delete pStrNodeInfo;

	fclose(pFileOut);

	return 0;
}

//@\:
//		P̑Θbc[̃m[ht@CɏoD
//		 eqvfɑ΂āCċAIɂ̃\bhJԂD
//F 
//		CDialogTreeNode *pDialogTreeNodeFΘb[̃m[h
//		string pStrNodeInfoFostring

void CTreeManagement::writeDialogTreeNode(CDialogTreeNode *pDialogTreeNode, string* pStrNodeInfo, int count){

	char cNodeInfo[DOCUMENT_LENGTH];

	CDialogTreeNode* pDialogTreeNodeBuff = NULL;

	//m[h̎擾
	pDialogTreeNode->getNodeInfo(cNodeInfo);
	//m[h̘A
	pStrNodeInfo->append(cNodeInfo);
	pStrNodeInfo->append("\n");

	if( pDialogTreeNode -> mpListHead ){

		//int i = 1;
		pDialogTreeNodeBuff =  ( pDialogTreeNode -> mpListHead );
		//̃m[h̎qvfɑ΂āCċAI
		while( pDialogTreeNodeBuff != NULL){

			// 擪i_~[m[hj̎̃m[h擾
			pDialogTreeNodeBuff = (CDialogTreeNode*) pDialogTreeNodeBuff -> retNextNode();
			if( pDialogTreeNodeBuff != NULL ){
				//^ȗ}(₷߂ɁCKwj
				count++;
				for(int j = 0; j < count; j++){
					pStrNodeInfo->append("\t");
				}

				//q̃m[hǉ
				writeDialogTreeNode( pDialogTreeNodeBuff, pStrNodeInfo, count);

				//i++;
				count--;
			}

		}

	}

}





//@\F
//		w肵hLgCDocumentNodeANeBu
//		ԂɂD
//F
//		string strDocumentNameFhLg
//߂lF
//		int
//			0:
//		   -1:Ts
int CTreeManagement::beActiveDocument(string &strDocumentName){

	return mRootDialogTreeNode->beActiveDocument(strDocumentName);

}

//@\F
//		w肵idlΘbc[̃m[hANeBuԂɂD
//	    ̍ہCANeBuԂɂm[h̐eC܂̐ed(ŏIIɂ̓[g܂Łj
//		ANeBuԂɂD
//F
//		int id:idl
//߂lF
//		int
//		0:
//	   -1:sim[h݂Ȃj
int CTreeManagement::beActiveNode(int id){

	return mRootDialogTreeNode->beActiveNode(id);

}

//@\F
//		w肳ꂽIDm[hCpromptedԂɂD
//		Ώۃm[hactiveԂȂpromptedԂɂłȂ
//F
//		int id:idl
//߂lF
//		int
//		0:
//	   -1:s
int CTreeManagement::bePromptedNode(int id){

	return mRootDialogTreeNode->bePromptedNode(id);
}

//activeԂexchangeunvisitedԂɂ
//߂lF
//		0:
//     -1:unvisitedԂexchangeȂ
int CTreeManagement::beUnvisitedNodeOnActiveNode(){

	CDialogTreeNode *pTempNode;
	int Ret;

	//tɂƂƋ߂m[h擾
	Ret = getActiveNode(&pTempNode);
	if( Ret == -1 ){
		return -1;
	}

	if( pTempNode->getType() == EXCHANGE ){

		//̃m[hvveBhԂɂ
		((CExchangeNode*)pTempNode)->beUnvisitedForReprompt();
		
	}else{
		return -1;
	}

	
	return 0;

}


//@\F
//		w肳ꂽIDm[hCvisitedԂɂD
//		ԂύXłȂꍇD
//F
//		int id:idl
//߂lF
//		int
//		0:
//	   -1:݂Ȃ
//	   -2FԂύXłȂ
int CTreeManagement::beVisitedNode(int id){

	return mRootDialogTreeNode->beVisitedNode(id);

}

//@\F
//		w肳ꂽIDm[hCIvisitedԂɂD
//F
//		int id:idl
//߂lF
//		int
//		0:
//	   -1:݂Ȃ
int CTreeManagement::forceBeVisitedNode(int id){

	return mRootDialogTreeNode->forceBeVisitedNode(id);

}

//@\F[g̃hLgԂ
//@@Ȃ
//߂lF@[g̃hLg
string CTreeManagement::getRootDocName(){

	return mStrRootDocName;
}

//@\F[t̃hLgԂ
//FȂ
//߂lF@[t̃hLg
string CTreeManagement::getLeafDocName(){

	return mStrLeafDocName;
}

//w肳ꂽhLgC_CAO_CAOm[h̃|C^Ԃ
//	F  
//		string strDocumentNameFhLg
//		string strDialogNameF_CAO
//߂lF
//	int
//		0:
//	   -1:s
int CTreeManagement::getDialogNode(string &strDocumentName, string &strDialogName, CDialogTreeNode** pDialogTreeNode){

	return	mRootDialogTreeNode->getDialogNode(strDocumentName,strDialogName,pDialogTreeNode);

}

//w肳ꂽidlC_CAOm[hւ̎QƂԂD
//F
//		
int CTreeManagement::getDialogTreeNode(int id, CDialogTreeNode** pDialogTreeNode){

	return mRootDialogTreeNode->getDialogTreeNode(id,pDialogTreeNode);


}

//w肳ꂽhLg̍ŏ̃_CAOm[h̃|C^Ԃ
//	F  
//		string strDocumentNameFhLg
//߂lF
//	int
//		0:
//	   -1:s
int CTreeManagement::getDialogNode(string &strDocumentName,CDialogTreeNode** pDialogTreeNode){

	return	mRootDialogTreeNode->getDialogNode(strDocumentName,pDialogTreeNode);

}

//tɍł߂ANeBuԂ̑Θbc[̃|C^ԂD
//߂l
//		  0 : m[h
//	     -1 : m[hȂ
int CTreeManagement::getActiveNode(CDialogTreeNode** pDialogTreeNode){

	//[gCɃANeBuȃm[hHĂD
	return mRootDialogTreeNode->getActiveNode(pDialogTreeNode);

}

//ANeBuԂ̃_CAȎΘbc[̃|C^ԂD
int CTreeManagement::getActiveDialogNode(CDialogTreeNode** pDialogTreeNode){

	return mRootDialogTreeNode->getActiveDialogNode(pDialogTreeNode);

}

//ANeBuԂ̃hLg̑Θbc[̃|C^ԂD
int CTreeManagement::getActiveDocumentNode(CDialogTreeNode** pDialogTreeNode){

	return mRootDialogTreeNode->getActiveDocumentNode(pDialogTreeNode);

}


//@\F
//		vvgs҂ԂłExchnageId𔲂o
//		CBegin,CExchange,邢CEnd̂ꂩANeBȕԂȂ
//		prompts҂exchange͂Ȃ
//		CParentsOfExchangeactiveԂ~܂ĂȂi̎qvfȉ
//		ɃANeBuexchangeȂ)C̎qvfprompts҂exchange
//		łD
//		xCprompt𔭍sexchangéC<reprompt>^OsȊOɁC
//		prompt̔s͍sȂ̂ŁCۂɔô
//		par,alt̏ꍇ@@SĂvisitedԂpromptedԂłȂqvf
//		seq̏ꍇ@@@@visitedԂpromptedԂłȂŏ̎qvf҂󂯏
//F
//		vector<int>*@Iz
//߂lF
//		Ȃ
void CTreeManagement::getReadyExchangeIdForPrompt(vector<int>* pVectorExchangeId){

	//tɍł߂activeԂ̃m[hi[
	CDialogTreeNode* pActiveDialogTreeNode = NULL;

	//tɍł߂activeԂ̃m[h擾
	this->getActiveNode(&pActiveDialogTreeNode);

	if( pActiveDialogTreeNode->getType() != PARENTSofEXCHANGE ){
		//prompts҂exchange͂Ȃ
		g_pLogDlg->setText("prompts҂exchange͂Ȃ\r\n");
		return;

	}else{

		//̃m[hɑ΂ē͑҂Ԃexchangeo߂o
		((CParentsOfExchangeNode*)pActiveDialogTreeNode)->getReadyExchangeIdForPrompt(pVectorExchangeId);

		if( pVectorExchangeId->size == 0 ){
			//prompts҂exchange͂Ȃ
			g_pLogDlg->setText("prompts҂exchange͂Ȃ\r\n");
			return;
		}

	}


}
//@\F
//		͑҂i荞ݓ͈ȊOjԂłExchangeId𔲂o 
//		CBegin,CExchangeC邢CEnd̂ꂩANeBuԂȂ΁C
//		͑҂exchange͂ȂD
//		CParentsOfExchnageactiveԂ~܂ĂȂC̎qvf
//		͑҂exchangełDۂɔốC
//		par,alt̏ꍇ @SĂvisitedłȂqvf
//		seq̏ꍇ		@visitedłȂŏ̎qvf҂󂯏
//:
//		vector<int>* Iz
//߂lF
//Ȃ
void CTreeManagement::getReadyExchangeId(vector<int>* pVectorExchangeId){
			
	//tɍł߂activeԂ̃m[hi[
	CDialogTreeNode* pActiveDialogTreeNode = NULL;

	//tɍł߂activeԂ̃m[h擾
	this->getActiveNode(&pActiveDialogTreeNode);

	if( pActiveDialogTreeNode->getType() != PARENTSofEXCHANGE ){
		//͑҂exchange͂Ȃ
		//g_pLogDlg->setText("͑҂exchange݂܂\r\n");
		return;

	}else{

		//̃m[hɑ΂ē͑҂Ԃexchangeo߂o
		((CParentsOfExchangeNode*)pActiveDialogTreeNode)->getReadyExchangeId(pVectorExchangeId);

		if( pVectorExchangeId->size == 0 ){
			//͑҂exchange͂Ȃ
			//g_pLogDlg->setText("͑҂exchange݂܂\r\n");
			return;
		}

	}

}

//@\F
//	@	荞ݓ͑҂exchangeId𔲂oD
//		<dialog scope="document">̍ŏ̓͑҂<exchange>idSĔoD
//:
//		vector<int>* Iz
//߂lF
//Ȃ
void CTreeManagement::getInterruptExchangeId(vector<int>* pVectorExchangeId){

	//[gm[hSm[hTC荞ݓ͑҂exchangeId𔲂oD
	getInterruptExchangeId2(this->mRootDialogTreeNode,pVectorExchangeId);

}


//@\F
//		CDialogNode(type="interrupt")ȂCŏɓ͂󂯕tCExchangeIdԂD
//		
//F
//		vector<int> vectorExchangeIdFíjexchangeIdԂ
void CTreeManagement::getInterruptExchangeId2(CDialogTreeNode* pTempDialogTreeNode, vector<int>* pVectorExchangeId){

	//evfCDialogNodeCParentsOfExchangeNodeȂ
	if( pTempDialogTreeNode->getType() == PARENTSofEXCHANGE && (pTempDialogTreeNode->mpParentNode)->getType() == DIALOG ){

		//̐evfCDialogNode荞ݑΘbȂ
		if( ((CDialogNode*)pTempDialogTreeNode->mpParentNode)->getDialogType() == INTERRUPTDIALOG){

			((CParentsOfExchangeNode*)pTempDialogTreeNode)->getFirstExchangeId(pVectorExchangeId);

		}

	}

	//qvfȂ
	if( pTempDialogTreeNode->mpListHead ){

		//qvfH邽߂̃|C^
		CDialogTreeNode* pDialogTreeNode = NULL;

		//_~[m[h̓ǂݔ΂
		pDialogTreeNode = (CDialogTreeNode*)(pTempDialogTreeNode->mpListHead)->retNextNode();
		
		while( pDialogTreeNode != NULL ){

			//ċAI
			getInterruptExchangeId2(pDialogTreeNode,pVectorExchangeId);

			//̎qvfǂށD
			pDialogTreeNode = (CDialogTreeNode*)pDialogTreeNode->retNextNode();

		}

	}else{
		return;
	}


}

//@\F
//		ANeBuԂłCDocumentNodeŏCDialogNode
//		ANeBuԂɂD
//F
//		Ȃ
//߂lF
//		int
//			0:
//		   -1:siANeBuΏۂ̃m[hȂ)
int CTreeManagement::beActiveDialog(){

	return mRootDialogTreeNode->beActiveDialog();

}

//@\Fw肳ꂽhLgCDocumentNode,
//		w肳ꂽ_CAOCDialogNodeANeBuԂɂD
//F
//		string strDocumentNameF@hLg
//		string strDialogNameF	@_CAO
//߂lF
//	int
//		0F
//	   -1Fs(@ANeBuΏۂ̃m[hȂ ) 
int CTreeManagement::beActiveDialog(string &strDocumentName,string &strDialogName){

	return mRootDialogTreeNode->beActiveDialog(strDocumentName,strDialogName);

}

//w肳ꂽhLgCDocumentNode,
//w肳ꂽ_CAOCw肳ꂽ_CAOm[h̑ΓI
//CExchangeNodeANeBuɂ
int CTreeManagement::beActiveExchange(string &strDocumentName,string &strDialogName,int DistanceFromDialog){

	return mRootDialogTreeNode->beActiveExchange(strDocumentName,strDialogName,DistanceFromDialog);

}


//@\FANeBuԂ̃hLg̎w肳ꂽ<dialog>ɑΉ
//		 CDialogNodeANeBuԂɂD
//F
//		string strDialogNameFANeBuΏۂ̃_CAO
//߂lF
//	int 0:
//		-1FsiANeBuΏۂ̃m[hȂj
int CTreeManagement::beActiveDialog(string &strDialogName){
	return mRootDialogTreeNode->beActiveDialog(strDialogName);
}

//@\FΘbc[̃[gSĂ
//FȂ
//߂l:
//		int  0 : 
//		@@-1 : s
void CTreeManagement::deleteApplication(){

	//[g
	if( this->mRootDialogTreeNode ){

		delete mRootDialogTreeNode;
		mRootDialogTreeNode = NULL;

	}

}

//@\F
//		w肵hLgCDocumentNodeȉ
//F
//		string strDocumentNameFhLg
//߂lF
//		int
//			0:
//		   -1:Ts
int CTreeManagement::deleteDialogTree(string &strDocumentName){

	return mRootDialogTreeNode->deleteDocument(strDocumentName);

}

//@\F
//		w肵_CAOCCDocumentNodeȉD
//F
//		string strDocumentNameF_CAOm[hhLgm[h
//		string strDialogNameF_CAOm[h
//߂lF
//		int  0:
//			-1:siȂj
int CTreeManagement::deleteDialogTree(string &strDocumentName,string &strDialogName){
	return mRootDialogTreeNode->deleteDialog(strDocumentName,strDialogName);
}


//@\FΘbc[̏Ԃi߂D
//		activeԂ̃m[hvisitedԂɂāC
//		Ɏsׂm[hactiveԂɂD
//߂lF
//		  0:
//		  1:Θb̏I(ɎŝׂȂj
//		 -1:͑҂
//		 -2:G[
int CTreeManagement::conductStateOfDialogTree(){

	CDialogTreeNode* pActiveDialogTreeNode = NULL;
	CDialogTreeNode* pTempDialogTreeNode = NULL;
	int dialogType;
	int Ret;

	//ANeBuԂ̈ԗtɋ߂m[h擾
	Ret = getActiveNode(&pActiveDialogTreeNode);
	//̃m[ȟ^擾
	dialogType = pActiveDialogTreeNode->getType();

	if( Ret == -1 ||
		dialogType == APPLICATION || 
		dialogType == DOCUMENT ){
		//i߂ΘbȂ
		//Θb̏I
		return 1;

	}else{

		if( dialogType == DIALOG ){

			//̃m[hvisitedԂɂ悤Ƃ
			Ret = pActiveDialogTreeNode->beVisited();
			if( Ret == 0 ){
				//Θb̏I
				return 1;
			}else{

				//ŏ̎qvf̎擾i擪̃_~[m[h΂)
				pTempDialogTreeNode = ( CDialogTreeNode* )(pActiveDialogTreeNode->mpListHead)->retNextNode();

				while( pTempDialogTreeNode != NULL ){

					if( pTempDialogTreeNode->getState() != VISITED ){

						//ŏvisitedłȂvfactiveԂɂāCI
						pTempDialogTreeNode->beActive();
						return 0;
					}

					pTempDialogTreeNode = ( CDialogTreeNode* )pTempDialogTreeNode->retNextNode();
				}

			}

			return 1;

		}

		if( dialogType == BEGIN ){
			//̑Θbm[hvisitedԂɂD
			pActiveDialogTreeNode->beVisited();
			//̉m[h̎擾
			pTempDialogTreeNode = ( CDialogTreeNode* )pActiveDialogTreeNode->retNextNode();
			if( pTempDialogTreeNode != NULL ){
				//m[hANeBuԂɂ
				pTempDialogTreeNode->beActive();
				return -1;
			}else{
				//ɂ̐em[hvisitedԂɂȂĂ͂
				//<begin>ŏI<dialog>
				return 1;
			}
		}

		if( dialogType == END ){
			//̑Θbm[hvisitedԂɂi̐em[hCDialogNodevisitedԂɂȂj
			pActiveDialogTreeNode->beVisited();
			//Θb̏I
			return 1;
		}

		if( dialogType == PARENTSofEXCHANGE ){

			//̑Θbm[hvisitedԂɂ悤Ƃ
			Ret = pActiveDialogTreeNode->beVisited();
			if( Ret == -1 ){
		
				//͑҂
				return -1;

			}else{

				//visitedԂɂłDPΘb߂(ċAI)
				return conductStateOfDialogTree();

			}


		}

		if( dialogType == EXCHANGE ){
			//̑Θbm[hvisitedԂɂD
			pActiveDialogTreeNode->beVisited();

			//ΘbP߂(ċAIj
			return conductStateOfDialogTree();

		}

		//ɂ́CȂ͂
		return -2;

	}
}

//@\F
//		goto,call,荞ݓ͂ɂΘb̑JڃxvZ
//F
//		string strNextDialogFgotocall̑next̒l
//			) 
//				hLg#_CAO
//				#_CAO
//				hLg
//		int* originalDialogTypeFJڌ̃_CAO̎ށi荞݂Cʂj
//		string* pStrOriginApplicatgion@:@Jڌ̃AvP[V
//		string* pStrOriginDocument		:@Jڌ̃hLg
//		string* pStrOriginDialog		:@Jڌ̃_CAO	
//		string* pStrGotoApplication		:@Jڐ̃AvP[V	
//		string* pStrGotoDocument		:@Jڐ̃hLg	
//		string* pStrGotoDialog			:@Jڐ̃_CAO
//߂lF
//		int 
//			0:hLg_CAOւ̑J
//		    1:AvP[VŃhLgقȂΘbւ̑J
//			2:AvP[VقȂ_CAOւ̑J
//		   -1:G[o
int CTreeManagement::getMoveLevel(string strNextDialog,int* originalDialogType,
								  string* pStrOriginApplication, string* pStrOriginDocument,string* pStrOriginDialog,
								  string* pStrGotoApplication, string* pStrGotoDocument, string* pStrGotoDialog){

	CString strLog;

	CDialogTreeNode* pActiveDialogNode;
	//Jڌ̃AvChLC_CAOƁC_CAǑ^擾
	if( getActiveDialogNode(&pActiveDialogNode) != 0 ){
		return -1;
	}
	pActiveDialogNode->getName(pStrOriginDialog);
	((CDialogNode*)pActiveDialogNode)->getDocName(pStrOriginDocument);
	((CDialogNode*)pActiveDialogNode)->getAppName(pStrOriginApplication);
	*originalDialogType = ((CDialogNode*)pActiveDialogNode)->getDialogType();


	int pos;			 //#̈ʒu

	//󔒂̏
	int length = strNextDialog.length();
	for( int i = 0; i < length; i++ ){
		if( strNextDialog[i] == ' ' ){
			strNextDialog.erase(i,1);
		}
	}

	//#̈ʒu̎擾
	pos = strNextDialog.find("#");
	//#QȏȂ̊mF
	if( pos != strNextDialog.rfind("#") ){
		strLog = "next̒l(:";
		strLog += strNextDialog.c_str();
		strLog += ")s\r\n";
		g_pLogDlg->setText(strLog);

		return -1;
	}
	
	if( pos != -1 ){
		//Jڐ̃hLg̊i[
		pStrGotoDocument->assign( strNextDialog.substr(0,pos) );
		if( pStrGotoDocument->compare("") == 0 ){
			//#_CAO̎wChLgւ̑J
			pStrGotoDocument->assign( pStrOriginDocument->c_str() );
		}

		strNextDialog.erase(0,pos+1);
		//Jڐ̃_CAO̊i[
		pStrGotoDialog->assign( strNextDialog );
	}else{
		//#Ȃ̂ŁCJڐƂăhLgw肵Ă
		pStrGotoDocument->assign(strNextDialog);

		//ŏ̃_CAO̎擾

		//_CAO͎w肵ĂȂ̂ŁCNULLi[
		pStrGotoDialog->assign("");
	}


	//Jڐ̃hLg΃pXt̃hLgɕύX
	if( pStrGotoDocument->compare("") == 0){
		//hLgւ̑JڂȂ̂
		
		pStrGotoApplication->assign( pStrOriginApplication->c_str() );
		pStrGotoDocument->assign( pStrOriginDocument->c_str() );
		return 0;

	}else{
		//hLgǗɁC݂̃pXZbg
		documentManagement.setServerInfo(pStrOriginDocument->c_str());
		//Jڐ̃hLgC΃pXt̃hLgɕύX
		documentManagement.changeRelativeToAbsolutePath(pStrGotoDocument);
	}

	if( pStrGotoDocument->compare(pStrOriginDocument->c_str()) == 0 ){
		//hLgւ̑JڂȂ

		//Jڐ̃AvP[V
		pStrGotoApplication->assign( pStrOriginApplication->c_str() );
		return 0;
	
	}else{

		//قȂhLgւ̑JځD

		//AvP[V̔r
		IXMLDOMDocument *pXislDoc = NULL;


		if( interpreter.interpret(pStrGotoDocument,&pXislDoc) != 0 ){
			strLog = "Jڐ̃hLg:";
			strLog += pStrGotoDocument->c_str();
			strLog += "͂łȂ\r\n";
			g_pLogDlg->setText(strLog);

			return -1;
		}
		//Jڐ̃AvP[V̎擾
		interpreter.retRootDocName(&pXislDoc,pStrGotoApplication);
		
		//JڐAvP[Vw肳ĂȂC[tg[g
		if( pStrGotoApplication->compare("") == 0 )
			pStrGotoApplication->assign(pStrGotoDocument->c_str());
	
		pXislDoc->Release();

		if( pStrGotoApplication->compare(pStrOriginApplication->c_str()) == 0){
			//AvP[Vւ̑J
			return 1;

		}else{
			//قȂAvP[Vւ̑J
			return 2;
		}


	}

}


//荞݂ɓ͂ɔΘbc[̏ԕύXCCCޔ
//F
//		int exchangeIdF荞ݓ͂exchangeId
//߂lF
//	int
//		0F
//	   -1Fs
int CTreeManagement::moveDialogForInterrupt(int exchangeId){

	string strOrgDocName;   //݃ANeBuȃhLg
	string strOrgDiaName;   //݃ANeBuȃ_CAO
	int DistanceFromDialog = -1;   //݃ANeBuexchangeDialog̑ΓIȈʒuێ
	string strNextDocName;	//Jڐ̃hLg
	string strNextDiaName;  //Jڐ̃_CAO
	int orgDiaType;

	//activeȑΘbc[̃m[h擾CJڌ̃hLC_CAO̎擾
	CDialogTreeNode* pActiveDialogNode;
	//Jڌ̃AvChLC_CAOƁC_CAǑ^擾
	if( getActiveDialogNode(&pActiveDialogNode) != 0 ){
		return -1;
	}
	pActiveDialogNode->getName(&strOrgDiaName);
	((CDialogNode*)pActiveDialogNode)->getDocName(&strOrgDocName);
	orgDiaType = ((CDialogNode*)pActiveDialogNode)->getDialogType();

	//ANeBuΏۂExchangeDialogNodȇΓIȈʒuێĂ
	CDialogTreeNode* pExchangeNode = NULL;
	this->getDialogTreeNode(exchangeId,&pExchangeNode);
	if( pExchangeNode ){
		if( pExchangeNode->getType() == 6 ){
			DistanceFromDialog = ((CExchangeNode*)pExchangeNode)->mDistanceFromDialog;
		}
	}

	//Jڌ̃_CAOm[h̑ޔpϐ
	CDialogTreeNode* pDialogTreeNode;	//ޔc[m[h|C^
	char cVarData[DOCUMENT_LENGTH];		//ޔϐf[^i[镶
	CStackNode* stackNode;				//X^bNɐςރm[h
	stackNode = new CStackNode;

	char cAppName[MESSAGE_LENGTH];
	char cDocName[MESSAGE_LENGTH];
	char cDiaName[MESSAGE_LENGTH];

	strcpy(cAppName,mStrRootDocName.c_str());
	strcpy(cDocName,strOrgDocName.c_str());
	strcpy(cDiaName,strOrgDiaName.c_str());

	//݃ANeBuȃhLgm[hunvisitedԂɂ
	CDialogTreeNode* pTempDialogTreeNode;
	getActiveDocumentNode(&pTempDialogTreeNode);
	pTempDialogTreeNode->beUnvisited();

	//Jڌ̃_CAOCΘbc[؂藣
	if( this->cutOffDialog(strOrgDocName,strOrgDiaName,&pDialogTreeNode) == -1){
		return -1;
	}
	
	//Jڌ̃_CAOm[h̕ϐȉޔ
	variableManagement.swapVar(cAppName,cDocName,cDiaName,"",cVarData);

	//X^bNm[hɈȉi[
	//Jڌ̑Θbc[̃|C^
	//ϐf[^i[
	//Jڌ̃_CAOChLgCAvP[V
	//Jڃx
	stackNode->mpDialogTreeData = pDialogTreeNode;
	(stackNode->mStrVarData).assign(cVarData);
	stackNode->mStrOrgAppName = mStrRootDocName;
	stackNode->mStrOrgDocName = strOrgDocName;
	stackNode->mStrOrgDiaName = strOrgDiaName;
	stackNode->mLevel = 3;

	if( orgDiaType == INTERRUPTDIALOG ){
		//Jڌ̃_CAO荞݃_CAOȂ
		//xVC荞݃_CAO𐶐D
		//荞݃_CAO͐ĂKvD
		if( this->makeDialog(strOrgDocName,strOrgDiaName,"") != 0 ){
			return -1;
		}
	}

	//JڐexchnageANeBuɂD
	if ( beActiveNode(exchangeId) != 0 ){

		//ɓƂƂ́AÕ_CAOƓ_CAOɊ荞
		//Ƃ
		//Ƃ肠AV荞݃_CAOc[ANeBuɂ
		beActiveDialog(strOrgDocName,strOrgDiaName);

		if( DistanceFromDialog != -1 ){
			//Dialog̑΋łlp
			//ExchangeANeBuɂ
			beActiveExchange(strOrgDocName,strOrgDiaName,DistanceFromDialog);
		}


	}

	//Jڐ̃hLgC_CAO̎擾
	getActiveDialogNode(&pActiveDialogNode);
	pActiveDialogNode->getName(&strNextDiaName);
	((CDialogNode*)pActiveDialogNode)->getDocName(&strNextDocName);

	
	//Jڐ̃hLgC_CAOX^bNɊi[
	stackNode->mStrNextDocName = strNextDocName;
	stackNode->mStrNextDiaName = strNextDiaName;

	//X^bNǗɃX^bNm[hς
	stackManagement.pushStackNode(&stackNode);

	return 0;

}

//returnC荞ݑΘbȈɎgp
//@\FX^bNoΘbc[C݂̑Θbc[ɂȂ
//		̎CΘbc[̏ԂύX
//ϐɖ߂
//FȂ
//߂lF
//		0:( call̕A
//		1:( 荞݂̕A
//	   -1:s
int CTreeManagement::restoreDialog(){

	//X^bNom[hi[
	CStackNode* pStackNode;

	int moveLevel;			//ޔx̊i[
	string strOrgDiaName;	//ޔĂ_CAO
	string strOrgDocName;	//ޔĂhLg
	string strOrgAppName;	//ޔĂAv
	string strOrgLeafDocName; //ޔĂ[thLg
	string strActiveApp;      //Jڐ̃Av
	string strActiveDoc;      //Jڐ̃hLg
	string strActiveDia;      //Jڐ̃_CAO
	string strVarData;		  //ޔĂϐf[^
	CDialogTreeNode* pOrgDiaTreeNode; //ޔĂΘbc[̃|C^
	IXMLDOMDocument* pOrgLeafDOM;	  //ޔĂDOM
	IXMLDOMDocument* pOrgRootDOM;	  //ޔĂDOM

	//X^bNm[hoD
	if( stackManagement.popStackNode(&pStackNode) == -1 ){

		//callŌĂ΂ĂȂC邢͊荞݂NĂȂ̂<return>o܂D
		g_pLogDlg->setText("X^bNɑޔĂ񂪂܂\r\n");
		return -1;

	}

	//X^bNm[hޔ̎擾
	moveLevel = pStackNode->mLevel;
	strOrgDiaName = pStackNode->mStrOrgDiaName;
	strOrgDocName = pStackNode->mStrOrgDocName;
	strOrgAppName = pStackNode->mStrOrgAppName;
	strOrgLeafDocName = pStackNode->mStrOrgLeafDocName;
	strActiveApp = pStackNode->mStrNextAppName;
	strActiveDoc = pStackNode->mStrNextDocName;
	strActiveDia = pStackNode->mStrNextDiaName;
	pOrgDiaTreeNode = pStackNode->mpDialogTreeData;
	pOrgLeafDOM	= pStackNode->mpLeafDocumentXisl;
	pOrgRootDOM = pStackNode->mpRootDocumentXisl;
	strVarData = pStackNode->mStrVarData;

	//om[h
	delete pStackNode;
	pStackNode = NULL;

	//hLgǗ̑Jڌ̃hLg̃pXZbg
	documentManagement.setServerInfo(strOrgDocName);

	//JڂẴ_CAO̎(荞݂ʂji[
	int activeDialogType; 
	//JڂẴ_CAO̎(荞݂ʂj擾
	CDialogTreeNode* pTempDialogTreeNode;							//ƗpΘbc[̃|C^
	//JڂẴ_CAOm[h̎擾
	if( strActiveDia == "" ){
		//JڂẴ_CAOChLg̍ŏ̃_CAOł
		getDialogNode(strActiveDoc,&pTempDialogTreeNode);
		//JڂẴ_CAOŏ̃_CAOɂ
		pTempDialogTreeNode->getName(&strActiveDia);
	}else{
		getDialogNode(strActiveDoc,strActiveDia,&pTempDialogTreeNode);	
	}
	activeDialogType = ((CDialogNode*)pTempDialogTreeNode)->getDialogType();
	pTempDialogTreeNode = NULL;

	CDialogTreeNode* pOrgActiveDiaTreeNode;	//ޔĂΘbc[̃ANeBuȃm[hi[
	int orgActiveNodeId=0;			    	//ޔĂΘbc[̃ANeBuȃm[hidi[


	//ޔĂϐɖ߂
	char cVarData[DOCUMENT_LENGTH];	//ޔĂϐf[^
	strcpy(cVarData,strVarData.c_str());


	variableManagement.restoreVar(cVarData);
	cVarData[0] = '\0';

	switch( moveLevel ){

		case 0:
			//hLg_CAOreturnɂ镜A

			//JڂẴ_CAOm[h̏
			if( this->deleteDialogTree(strActiveDoc,strActiveDia) != 0){
				return -1;
			}


			if( activeDialogType == INTERRUPTDIALOG ){
				//_CAO荞݃_CAOȂ
				//xVC荞݃_CAO𐶐D
				//荞݃_CAO͐ĂKvD
				if( this->makeDialog(strActiveDoc,strActiveDia,"") != 0 ){
					return -1;
				}
			}

			//ޔĂΘbc[ANeBuȃm[hidl擾
			pOrgDiaTreeNode->getActiveNode(&pOrgActiveDiaTreeNode);
			orgActiveNodeId = pOrgActiveDiaTreeNode->getId();

			//ޔĂΘbc[݂̑Θbc[ɑ}
			appendDialog(strOrgDocName,&pOrgDiaTreeNode);

			//ANeBuԂm[hANeBuɂ
			beActiveNode(orgActiveNodeId);
			break;

		case 1:

			//hLgقȂ铯AvP[Vreturnɂ镜A

			//JڂẴhLgC[ghLgȂC_CAOm[h
			if( mStrRootDocName == strActiveDoc ){

				//JڂĂ_CAOm[hȉ
				deleteDialogTree(strActiveDoc,strActiveDia);

				if( activeDialogType == INTERRUPTDIALOG ){
				//_CAO荞݃_CAOȂ
				//xVC荞݃_CAO𐶐D
				//荞݃_CAO͐ĂKvD
					if( this->makeDialog(strActiveDoc,strActiveDia,"") != 0 ){
						return -1;
					}
				}

				//݃ANeBuȃhLgm[hunvisitedԂɂ
				getActiveDocumentNode(&pTempDialogTreeNode);
				pTempDialogTreeNode->beUnvisited();

			}else{
				//JڂẴhLg̏
				if( this->deleteDialogTree(strActiveDoc) != 0 ){
					return -1;
				}
			}

			//ޔĂhLg[ghLgȂ
			//ޔĂ[gDOMƁC܂[găZbg
			//ޔĂhLg[thLgȂ
			//ޔĂ[tDOMƁC܂[tăZbg
			if( ((CDocumentNode*)pOrgDiaTreeNode)->getDocmentType() == ROOTDOCUMENT ){
				setRootDocName( strOrgDocName );
				setRootDom( &pOrgRootDOM );
			}else{
				setLeafDocName( strOrgDocName );
				setLeafDom( &pOrgLeafDOM );
			}

			//ޔĂΘbc[ANeBuȃm[hidl擾
			pOrgDiaTreeNode->getActiveNode(&pOrgActiveDiaTreeNode);
			orgActiveNodeId = pOrgActiveDiaTreeNode->getId();

			//ޔĂΘbc[݂̑Θbc[ɑ}
			appendDocument(&pOrgDiaTreeNode);

			//ANeBuԂm[hANeBuɂ
			beActiveNode(orgActiveNodeId);
			break;

		case 2:
			//قȂAvP[V̕A

			//݂̑Θbc[̃[gSĂ
			this->deleteApplication();

			//ޔĂΘbc[ANeBuȃm[hidl擾
			CDialogTreeNode* pTempDiaTreeNode;
			pOrgDiaTreeNode->getActiveNode(&pTempDiaTreeNode);
			orgActiveNodeId = pTempDiaTreeNode->getId();

			//[gC[gDOMC[tC[tDOMꂼZbg
			setRootDocName( strOrgAppName );
			setRootDom( &pOrgRootDOM );
			setLeafDocName( strOrgLeafDocName );
			setLeafDom( &pOrgLeafDOM );

			//ޔĂΘbc[[gɎw
			mRootDialogTreeNode = (CApplicationNode*)pOrgDiaTreeNode;

			//ANeBuԂm[hANeBuɂ
			beActiveNode( orgActiveNodeId );

			break;
			
		case 3:
			//荞݂̕A,邢̓[ghLgcallĂ̕A
			//݃ANeBuȃ_CAOm[h̏
			if( this->deleteDialogTree(strActiveDoc,strActiveDia) != 0){
				return -1;
			}
			if( activeDialogType == INTERRUPTDIALOG ){
				//_CAO͊荞dialogł΁C
				//xKv
				if( this->makeDialog(strActiveDoc,strActiveDia,"") != 0 ){
					return -1;
				}
			}
			//݃ANeBuȃhLgunvisitedԂɕύX
			CDialogTreeNode* pTempDialogTreeNode;
			getActiveDocumentNode(&pTempDialogTreeNode);
			pTempDialogTreeNode->beVisited();

			//ޔĂΘbc[ANeBuȃm[hidl擾
			pOrgDiaTreeNode->getActiveNode(&pTempDiaTreeNode);
			orgActiveNodeId = pTempDiaTreeNode->getId();

			//}OɁC_CAOȂ`FbNCΏ
			int Ret;
			Ret = deleteDialogTree(strOrgDocName,strOrgDiaName);
			if( Ret == -1 ){
				g_pLogDlg->setText("̂̓G[ł͂Ȃ\r\n");
			}

			//ޔĂΘbc[݂̑Θbc[ɑ}
			appendDialog(strOrgDocName,&pOrgDiaTreeNode);

			//ANeBuԂm[hANeBuɂ
			beActiveNode(orgActiveNodeId);
			break;

		default:
			break;

		}

		if( moveLevel == 3 ){
			return 1;
		}else{
			return 0;
		}

}
//@\F
//		goto,callɂCΘbc[̏ԕύXCCCޔs
//		łɁCϐǗ̕ϐ̏Cޔ𓙂s
//F
//		string strNextDialogFgoto,call̑next̒lD
//				hLg#_CAO
//				#_CAO
//		int type:
//				0:callɂJ
//				1:gotoɂJ
//		string strArg:
//@@@@		Jڐ̃_CAOɓn
//߂l:
//		int
//			0:
//		   -1:s
int CTreeManagement::moveDialog(string strNextDialog,int type,string strArg){

	CString strLog;

	//Jڌ̃_CAO̎ށC_CAOChLgCAvP[V
	int orgDialogType;
	string strOrgDiaName;
	string strOrgDocName;
	string strOrgAppName;

	//Jڐ̃_CAOChLgCAvP[V
	string strNextDiaName;
	string strNextDocName;
	string strNextAppName;

	IXMLDOMDocument* pNextDocDOM=NULL;//Jڐ̃[thLgDOM
	IXMLDOMDocument* pNextAppDOM=NULL;//Jڐ̃[ghLgDOM

	CDialogTreeNode* pTempDialogTreeNode; //ƗpΘbc[̃|C^

	//Jڃx 0:hLgC1:hLgقȂ 2:AvP[VقȂ
	int moveLevel;

	//Jڃx̎擾
	moveLevel = getMoveLevel(strNextDialog,&orgDialogType,&strOrgAppName,&strOrgDocName,&strOrgDiaName,&strNextAppName,&strNextDocName,&strNextDiaName);

	if( moveLevel == -1 ){
		g_pLogDlg->setText("Jڃx̎擾s\r\n");
		return -1;
	}

	char cVarData[DOCUMENT_LENGTH];		//ޔϐf[^i[镶
	char cAppName[MESSAGE_LENGTH];
	char cDocName[MESSAGE_LENGTH];
	char cDiaName[MESSAGE_LENGTH];

	strcpy(cAppName,strOrgAppName.c_str());
	strcpy(cDocName,strOrgDocName.c_str());
	strcpy(cDiaName,strOrgDiaName.c_str());

	//goto,call,荞ݓ͂ɂ鏈̐U蕪
	if( type == 0){
		//callɔ

		//Jڌ̃_CAOm[h̑ޔpϐ
		CDialogTreeNode* pDialogTreeNode;	//ޔc[m[h|C^
		CStackNode *stackNode;				//X^bNɐςރm[h
		stackNode = new CStackNode;

		//Jڃxɂ鏈̐U蕪
		switch( moveLevel ){

			case 0:
				//hLg_CAOւ̑J

				//Jڌ̃_CAOm[hCΘbc[؂藣
				if( this->cutOffDialog(strOrgDocName,strOrgDiaName,&pDialogTreeNode) == -1){
					delete stackNode;
					stackNode = NULL;
					return -1;
				}

				//Jڌ̃_CAOm[h̕ϐȉޔ
				variableManagement.swapVar(cAppName,cDocName,cDiaName,"",cVarData);

				//X^bNm[hɈȉi[
				//Jڌ̑Θbc[̃|C^
				//ϐf[^i[
				//Jڌ̃_CAOChLgCAvP[V
				//Jڐ̃_CAO
				//Jڃx
				stackNode->mpDialogTreeData = pDialogTreeNode;
				(stackNode->mStrVarData).assign(cVarData);
				stackNode->mStrOrgAppName = strOrgAppName;
				stackNode->mStrOrgDocName = strOrgDocName;
				stackNode->mStrOrgDiaName = strOrgDiaName;
				stackNode->mStrNextDiaName = strNextDiaName;
				stackNode->mStrNextDocName = strOrgDocName;
				stackNode->mStrNextAppName = strOrgAppName;
				stackNode->mLevel = moveLevel;

				//X^bNǗɃX^bNm[hς
				stackManagement.pushStackNode(&stackNode);
				
				if( orgDialogType == INTERRUPTDIALOG ){
					//Jڌ̃_CAO荞݃_CAOȂ
					//xVC荞݃_CAO𐶐D
					//荞݃_CAO͐ĂKvD
					if( this->makeDialog(strOrgDocName,strOrgDiaName,"") != 0 ){
						delete stackNode;
						stackNode = NULL;
						return -1;
					}
				}

				if( strNextDiaName != "" ){
					//Jڐ̃_CAOm[h̐悤Ƃ
					if( this->makeDialog(strNextDocName,strNextDiaName,strArg) == -1){
						strLog = "Jڐ̃_CAO(:";
						strLog += strNextDiaName.c_str();
						strLog += ")ł܂\r\n";
						g_pLogDlg->setText(strLog);

						delete stackNode;
						stackNode = NULL;
						return -1;
					}
					//Jڐ̃_CAOm[hANeBuԂɂ
					if( this->beActiveDialog(strNextDocName,strNextDiaName) != 0){
						delete stackNode;
						stackNode = NULL;
						return -1;
					}
				}else{
					//NULLw肵Ă̂ŁCŏ̃_CAO𐶐
					if( this->makeDialog(strNextDocName,strArg) == -1 ){
						strLog = "Jڐ̃hLg(:";
						strLog += strNextDocName.c_str();
						strLog += ")̍ŏ̃_CAOł܂\r\n";
						g_pLogDlg->setText(strLog);

						delete stackNode;
						stackNode = NULL;
						return -1;
					}
					//ŏ̃_CAOm[hANeBuԂɂ
					if( this->beActiveDialog() != 0 ){
						delete stackNode;
						stackNode = NULL;
						return -1;
					}
				}
				break;

			case 1:
				//hLgقȂ铯AvP[Vւ̑J

				//Jڌ̃hLg[ghLgȂCJڌ̃_CAO؂藣
				if( strOrgDocName == mStrRootDocName ){
			
					//݃ANeBuȃhLgm[hunvisitedԂɂ
					getActiveDocumentNode(&pTempDialogTreeNode);
					pTempDialogTreeNode->beUnvisited();

					//Jڌ̃_CAOm[hCΘbc[؂藣
					if( this->cutOffDialog(strOrgDocName,strOrgDiaName,&pDialogTreeNode) == -1){
						delete stackNode;
						stackNode = NULL;
						return -1;
					}

					if( orgDialogType == INTERRUPTDIALOG ){
						//Jڌ̃_CAO荞݃_CAOȂ
						//xVC荞݃_CAO𐶐D
						//荞݃_CAO͐ĂKvD
						if( this->makeDialog(strOrgDocName,strOrgDiaName,"") != 0 ){
							delete stackNode;
							stackNode = NULL;
							return -1;
						}
					}

					//Jڌ[ghLgȂC
					//hLgϐ = AvP[VϐȂ̂
					//hLgϐ͑ޔȂ
					//Jڌ̃_CAOϐ̂ݑޔ
					variableManagement.swapVar(cAppName,cDocName,cDiaName,"",cVarData);
				
					//ޔ̂́C_CAOm[hȂ̂
					moveLevel = 3;

				}else{

					//Jڌ̃hLgCΘbc[؂藣
					if( this->cutOffDocument(strOrgDocName,&pDialogTreeNode) == -1){
						delete stackNode;
						stackNode = NULL;
						return -1;
					}

					//Jڌ̃hLgϐȉޔ
					variableManagement.swapVar(cAppName,cDocName,"","",cVarData);
				}

	
				//X^bNm[hɈȉi[
				//Jڌ̑Θbc[̃|C^
				//ϐf[^i[
				//Jڌ̃_CAOChLgCAvP[V
				//Jڐ̃_CAOChLg
				//Jڃx
				//Jڌ̃hLgDOM
				stackNode->mpDialogTreeData = pDialogTreeNode;
				(stackNode->mStrVarData).assign(cVarData);
				stackNode->mStrOrgAppName = strOrgAppName;
				stackNode->mStrOrgDocName = strOrgDocName;
				stackNode->mStrOrgDiaName = strOrgDiaName;
				stackNode->mStrNextDiaName = strNextDiaName;
				stackNode->mStrNextDocName = strNextDocName;
				stackNode->mStrNextAppName = strOrgAppName;
				stackNode->mLevel = moveLevel;
				stackNode->mLevel = moveLevel;

				//Jڌ̃hLg[ghLgȂ烋[ghLgDOMޔ
				//łȂȂ烊[thLgDOMޔ
				if( ((CDocumentNode*)pDialogTreeNode)->getDocmentType() != ROOTDOCUMENT ){
					stackNode->mpLeafDocumentXisl = mpLeafXisl;
				}

				//X^bNǗɃX^bNm[hς
				stackManagement.pushStackNode(&stackNode);


				//Jڐ̃hLg[ghLgłȂȂC邢
				//Jڐ̃hLgłɑ݂郊[thLgłȂ
				if( strNextDocName != strNextAppName && strNextDocName !=  strOrgDocName) {

					//Jڐ̃hLg̃C^vg
					if( interpreter.interpret(&strNextDocName,&pNextDocDOM) != 0 ){
						g_pLogDlg->setText("Jڐ̃hLg͎̉s\r\n");
						return -1;
					}
					//hLgǗɌ݂̃pXăZbg
					documentManagement.setServerInfo(strNextDocName);

					//΃pX΃pXւ̕ϊ
					if( interpreter.changeRelativeToAbsolute(&pNextDocDOM) != 0 ){
						pNextDocDOM->Release();
						return -1;
					}

					//[thLg͂PȂ̂ŁC[thLgC
					//[thLgDOM̍ăZbg
					this->setLeafDom(&pNextDocDOM);
					this->setLeafDocName(strNextDocName);

					//Jڐ̃hLgm[h̐i[thLgm[h̐j
					if( this->makeLeafDocument() != 0 ){
						strLog = "Jڐ̃hLgm[h(:";
						strLog += strNextDocName.c_str();
						strLog += ")ł܂\r\n";
						g_pLogDlg->setText(strLog);
						return -1;
					}
				}

				//Jڐ̃hLgm[hANeBuԂɂ
				if( this->beActiveDocument(strNextDocName) != 0 ){
					return -1;
				}

				//Jڐ̃_CAOm[h̐ƏԂANeBuɂ
				if( strNextDiaName != ""){

					//Jڐ̃_CAOm[h̐
					//łɐĂꍇ̓G[ł͂Ȃ
					if( this->makeDialog(strNextDocName,strNextDiaName,strArg) == -1){
						strLog = "Jڐ̃_CAO(:";
						strLog += strNextDiaName.c_str();
						strLog += ")ł܂\r\n";
						g_pLogDlg->setText(strLog);

						return -1;
					}
					//Jڐ̃_CAOm[hANeBuԂɂ
					if( this->beActiveDialog(strNextDiaName) != 0 ){
						return -1;
					}

				}else{

					//NULLȂ̂ŁCJڐ̃hLg̍ŏ̃_CAO̐
					if( this->makeDialog(strNextDocName,strArg) == -1 ){
						g_pLogDlg->setText("Jڐ̍ŏ̃_CAOł܂\r\n");
						return -1;
					}

					//Jڐ̃hLg̍ŏ̃_CAOANeBuԂɂ
					if( this->beActiveDialog() != 0 ){
						return -1;
					}
				}
				
				break;
			case 2:
				//قȂAvP[Vւ̑J

				//Θbc[[g؂藣
				if( this->cutOffApplicatoin(&pDialogTreeNode) == -1){
					delete stackNode;
					stackNode = NULL;
					return -1;
				}

				//Jڌ̃AvP[Vϐȉޔ
				variableManagement.swapVar(cAppName,"","","",cVarData);


				//X^bNm[hɈȉi[
				//Jڌ̑Θbc[̃|C^
				//ϐf[^i[
				//Jڌ̃_CAOChLgCAvP[V
				//Jڐ̃_CAOChLgCAvP[V
				//Jڃx
				//Jڌ̃[gC[tDOM
				//[thLg
				stackNode->mpDialogTreeData = pDialogTreeNode;
				(stackNode->mStrVarData).assign(cVarData);
				stackNode->mStrOrgAppName = strOrgAppName;
				stackNode->mStrOrgDocName = strOrgDocName;
				stackNode->mStrOrgDiaName = strOrgDiaName;
				stackNode->mStrNextDiaName = strNextDiaName;
				stackNode->mStrNextDocName = strNextDocName;
				stackNode->mStrNextAppName = strNextAppName;
				stackNode->mStrOrgLeafDocName = mStrLeafDocName;
				stackNode->mLevel = moveLevel;
				stackNode->mpLeafDocumentXisl = mpLeafXisl;
				stackNode->mpRootDocumentXisl = mpRootXisl;
				//X^bNǗɃX^bNm[hς
				stackManagement.pushStackNode(&stackNode);				

				//Jڐ̃hLg̃C^vg
				if( interpreter.interpret(&strNextDocName,&pNextDocDOM) != 0 ){
					g_pLogDlg->setText("Jڐ̃hLg͎̉s\r\n");
					return -1;
				}

				//T[õfBNgJڐ̃hLg̃pXɐݒ
				documentManagement.setServerInfo(strNextDocName);
				//΃pX΃pXɕϊ
				interpreter.changeRelativeToAbsolute(&pNextDocDOM);

				if( strNextDocName != strNextAppName ){
					//[tCʂ̃hLg[gƂĎw肵ĂȂ
					//̃[g̃C^v
					if( interpreter.interpret(&strNextAppName,&pNextAppDOM) != 0 ){
						strLog = "Jڐ̃hLgw肵Ă郋[ghLg(:";
						strLog += strNextAppName.c_str();
						strLog += "j͎̉s\r\n";
						g_pLogDlg->setText(strLog);
						pNextDocDOM->Release();
						return -1;
					}

					//T[õfBNg[g̃hLg̃pXɐݒ
					documentManagement.setServerInfo(strNextAppName);
					//΃pX΃pXɕϊ
					interpreter.changeRelativeToAbsolute(&pNextAppDOM);
					//T[õfBNgJڐ̃hLg̃pXɖ߂
					documentManagement.setServerInfo(strNextDocName);

					//[ghLgC[ghLgDOM̃Zbg
					this->setRootDocName(strNextAppName);
					this->setRootDom(&pNextAppDOM);
					//[thLgC[thLgDOM̃Zbg
					this->setLeafDocName(strNextDocName);
					this->setLeafDom(&pNextDocDOM);

					//AvP[V̐
					if( this->makeApplication() != 0 ){
						strLog = "Jڐ̃AvP[V(:";
						strLog += strNextAppName.c_str();
						strLog += ")ł܂\r\n";
						g_pLogDlg->setText(strLog);
						return -1;
					}
					//Jڐ̃hLgi[thLgm[hj̐
					if( this->makeLeafDocument() != 0 ){
						strLog = "Jڐ̃hLg(:";
						strLog += strNextDocName.c_str();
						strLog += ")ł܂\r\n";
						g_pLogDlg->setText(strLog);

						return -1;
					}
					//Jڐ̃hLgi[thLgm[hjANeBuԂɂ
					this->beActiveDocument( strNextDocName );

					if( strNextDiaName != ""){
						//Jڐ̃_CAOw肵ĂȂ

						//Jڐ̃_CAO̐
						if( this->makeDialog( strNextDocName,strNextDiaName,strArg ) == -1 ){
							strLog = "Jڐ̃_CAO(:";
							strLog += strNextDiaName.c_str();
							strLog += ")ł܂\r\n";
							g_pLogDlg->setText(strLog);

							return -1;
						}

						//Jڐ̃_CAOANeBuԂɂ
						this->beActiveDialog(strNextDiaName);

					}else{

						//NULL񂪂Ă̂ŁCJڐ̃hLg̍ŏ̃_CAO̐
						if( this->makeDialog( strNextDocName,strArg ) == -1 ){
							strLog = "Jڐ̃hLg(:";
							strLog += strNextDocName.c_str();
							strLog += ")̍ŏ̃_CAOł܂\r\n";
							g_pLogDlg->setText(strLog);

							return -1;
						}
						//Jڐ̃hLg̍ŏ̃_CAOANeBuԂɂ
						this->beActiveDialog();

					}
				
				}else{
					//[tg[g̏ꍇ([g[tj
					//[ghLgC[ghLgDOM̃Zbg
					this->setRootDocName(strNextDocName);
					this->setRootDom(&pNextDocDOM);
					//[thLgC[thLgDOM̃Zbg
					this->setLeafDocName(strNextDocName);
					this->setLeafDom(&pNextDocDOM);

					//AvP[V̐
					if( this->makeApplication() != 0 ){
						strLog = "Jڐ̃AvP[V(:";
						strLog += strNextAppName.c_str();
						strLog += ")ł܂\r\n";
						g_pLogDlg->setText(strLog);

						return -1;
					}
					//AvP[VhLgANeBuԂɂ
					this->beActiveDocument( strNextAppName );

					if( strNextDiaName != "" ){
						//Jڐ̃_CAOw肳ĂȂ

						//Jڐ̃_CAO̐
						if( this->makeDialog(strNextAppName,strNextDiaName,strArg) != 0 ){
							strLog = "Jڐ̃_CAO(:";
							strLog += strNextDiaName.c_str();
							strLog += ")ł܂\r\n";
							g_pLogDlg->setText(strLog);

							return -1;
						}
			
						//Jڐ̃_CAOANeBuԂɂ
						this->beActiveDialog(strNextDiaName);

					}else{

						//NULL񂪂Ă̂ŁCJڐ̃hLg̍ŏ̃_CAO̐
						if( this->makeDialog(strNextAppName,strArg) != 0 ){
							strLog = "Jڐ̃hLg(:";
							strLog += strNextDocName.c_str();
							strLog += ")̍ŏ̃_CAOł܂\r\n";
							g_pLogDlg->setText(strLog);

							return -1;
						}

						//Jڐ̃hLg̍ŏ̃_CAOANeBuԂɂ
						this->beActiveDialog();

					}

				}
				break;
			default:
				//̏͂肦Ȃ
				break;
		}

	}else if( type == 1 ){

		//gotoɔ

		//Jڃxɂ鏈̐U蕪
		switch( moveLevel ){

			case 0:
				//hLg_CAOւ̑J
	
				//Jڌ̃_CAOm[h̏
				if( this->deleteDialogTree(strOrgDocName,strOrgDiaName) != 0){
					return -1;
				}

				//Jڌ̃_CAOϐȉ
				askVarManagementToDeleteVar(cAppName,cDocName,cDiaName,"",cVarData);
				cVarData[0] = '\0';

				if( orgDialogType == INTERRUPTDIALOG ){
					//Jڌ̃_CAO荞݃_CAOȂ
					//xVC荞݃_CAO𐶐D
					//荞݃_CAO͐ĂKvD
					if( this->makeDialog(strOrgDocName,strOrgDiaName,"") != 0 ){
						return -1;
					}
				}

				if( strNextDiaName != "" ){
					//Jڐ̃_CAOm[h̐悤Ƃ
					if( this->makeDialog(strNextDocName,strNextDiaName,strArg) == -1){
						strLog = "Jڐ̃_CAO(:";
						strLog += strNextDiaName.c_str();
						strLog += ")ł܂\r\n";
						g_pLogDlg->setText(strLog);

						return -1;
					}
					//Jڐ̃_CAOm[hANeBuԂɂ
					if( this->beActiveDialog(strNextDocName,strNextDiaName) != 0){
						return -1;
					}
				}else{
					//NULLw肵Ă̂ŁCŏ̃_CAO𐶐
					if( this->makeDialog(strNextDocName, strArg) == -1 ){

						g_pLogDlg->setText("Jڐ̍ŏ̃_CAOł܂\r\n");
						return -1;
					}
					//ŏ̃_CAOm[hANeBuԂɂ
					if( this->beActiveDialog() != 0 ){
						return -1;
					}
				}
				
				break;

			case 1:
				//hLgقȂ铯AvP[Vւ̑J

				//Jڌ̃hLg[ghLgȂCJڌ̃_CAO؂藣
				if( strOrgDocName == mStrRootDocName ){

					//݃ANeBuȃhLgm[hunvisitedԂɂ
					getActiveDocumentNode(&pTempDialogTreeNode);
					pTempDialogTreeNode->beUnvisited();
					
					//Jڌ̃_CAOm[hCΘbc[
					if( this->deleteDialogTree(strOrgDocName,strOrgDiaName) == -1){
						return -1;
					}

					//Jڌ̃_CAOϐȉ
					askVarManagementToDeleteVar(cAppName,cDocName,cDiaName,"",cVarData);
					cVarData[0] = '\0';

					if( orgDialogType == INTERRUPTDIALOG ){
						//Jڌ̃_CAO荞݃_CAOȂ
						//xVC荞݃_CAO𐶐D
						//荞݃_CAO͐ĂKvD
						if( this->makeDialog(strOrgDocName,strOrgDiaName,"") != 0 ){
							return -1;
						}
					}



				}else{

					//Jڌ̃hLgCΘbc[
					if( this->deleteDialogTree(strOrgDocName) != 0){
						return -1;
					}

					//Jڌ̃hLgϐȉ
					askVarManagementToDeleteVar(cAppName,cDocName,"","",cVarData);
					cVarData[0] = '\0';

				}

				//Jڐ̃hLg[ghLgłȂȂC邢
				//Jڐ̃hLgłɑ݂郊[thLgłȂ
				if( strNextDocName != strNextAppName && strNextDocName !=  strOrgDocName) {

					//Jڐ̃hLg̃C^vg
					if( interpreter.interpret(&strNextDocName,&pNextDocDOM) != 0 ){
						g_pLogDlg->setText("Jڐ̃hLgm[h͎̉s\r\n");
						pNextDocDOM->Release();
						return -1;
					}
					//T[õfBNgJڐ̃hLg̃pXɃZbg
					documentManagement.setServerInfo(strNextDocName);
					//΃pX΃pXւ̕ϊ
					if( interpreter.changeRelativeToAbsolute(&pNextDocDOM) != 0 ){
						pNextDocDOM->Release();
						return -1;
					}

					//[thLg͂PȂ̂ŁC[thLgC
					//[thLgDOM̍ăZbg
					this->setLeafDom(&pNextDocDOM);
					this->setLeafDocName(strNextDocName);

					//Jڐ̃hLgm[h̐i[thLgm[h̐j
					this->makeLeafDocument();

					//if( this->makeLeafDocument() != 0 ){
					//	g_pLogDlg->setText("Jڐ̃hLgm[hł܂\r\n");
					//	return -1;
					//}

				}

				//Jڐ̃hLgm[hANeBuԂɂ
				if( this->beActiveDocument(strNextDocName) != 0 ){
					return -1;
				}

				//Jڐ̃_CAOm[h̐ƏԂANeBuɂ
				if( strNextDiaName != ""){

					//Jڐ̃_CAOm[h̐
					if( this->makeDialog(strNextDocName,strNextDiaName,strArg) == -1){
						strLog ="Jڐ̃_CAO(:";
						strLog += strNextDiaName.c_str();
						strLog += ")ł܂\r\n";
						g_pLogDlg->setText(strLog);

						return -1;
					}
					//Jڐ̃_CAOm[hANeBuԂɂ
					if( this->beActiveDialog(strNextDiaName) != 0 ){
						return -1;
					}

				}else{

					//NULLȂ̂ŁCJڐ̃hLg̍ŏ̃_CAO̐
					if( this->makeDialog(strNextDocName, strArg) == -1 ){
						g_pLogDlg->setText("Jڐ̍ŏ̃_CAOł܂\r\n");
						return -1;
					}

					//Jڐ̃hLg̍ŏ̃_CAOANeBuԂɂ
					if( this->beActiveDialog() != 0 ){
						return -1;
					}
				}

				break;
			case 2:
				//قȂAvP[Vւ̑J

				//Θbc[̃[gSĂ
				this->deleteApplication();

				//Jڌ̃AvP[Vϐȉ
				askVarManagementToDeleteVar(cAppName,"","","",cVarData);
				cVarData[0] = '\0';

				//Jڐ̃hLg̃C^vg
				if( interpreter.interpret(&strNextDocName,&pNextDocDOM) != 0 ){
					g_pLogDlg->setText("Jڐ̃hLg͎̉s\r\n");
					return -1;
				}
				//T[õfBNgJڐ̃hLg̃pXɃZbg
				documentManagement.setServerInfo(strNextDocName);
				//΃pX΃pXւ̕ϊ
				if( interpreter.changeRelativeToAbsolute(&pNextDocDOM) != 0 ){
					pNextDocDOM->Release();
					return -1;
				}

				if( strNextDocName != strNextAppName ){
					//[tCʂ̃hLg[gƂĎw肵ĂȂ
					//̃[g̃C^v
					if( interpreter.interpret(&strNextAppName,&pNextAppDOM) != 0 ){
						strLog = "Jڐ̃hLgw肵Ă郋[ghLg(:";
						strLog += strNextAppName.c_str();
						strLog += ")͎̉s\r\n";
						g_pLogDlg->setText(strLog);

						pNextDocDOM->Release();
						return -1;
					}
					//T[õfBNgJڐ̃hLg̃pXɃZbg
					documentManagement.setServerInfo(strNextAppName);
					//΃pX΃pXւ̕ϊ
					if( interpreter.changeRelativeToAbsolute(&pNextAppDOM) != 0 ){
						pNextDocDOM->Release();
						return -1;
					}
					//T[õfBNgJڐ̃hLg̃pXɖ߂
					documentManagement.setServerInfo(strNextDocName);



					//[ghLgC[ghLgDOM̃Zbg
					this->setRootDocName(strNextAppName);
					this->setRootDom(&pNextAppDOM);
					//[thLgC[thLgDOM̃Zbg
					this->setLeafDocName(strNextDocName);
					this->setLeafDom(&pNextDocDOM);

					//AvP[V̐
					if( this->makeApplication() != 0 ){
						strLog = "Jڐ̃AvP[V(:";
						strLog += strNextAppName.c_str();
						strLog += ")ł܂\r\n";
						g_pLogDlg->setText(strLog);

						return -1;
					}
					//Jڐ̃hLgi[thLgm[hj̐
					if( this->makeLeafDocument() != 0 ){
						strLog = "Jڐ̃hLg(:";
						strLog += strNextDocName.c_str();
						strLog += ")ł܂\r\n";
						g_pLogDlg->setText(strLog);
							
						return -1;
					}
					//Jڐ̃hLgi[thLgm[hjANeBuԂɂ
					this->beActiveDocument( strNextDocName );

					if( strNextDiaName != ""){
						//Jڐ̃_CAOw肵ĂȂ

						//Jڐ̃_CAO̐
						if( this->makeDialog( strNextDocName,strNextDiaName,strArg ) == -1 ){
							strLog = "Jڐ̃_CAO(:";
							strLog += strNextDiaName.c_str();
							strLog += ")ł܂\r\n";
							g_pLogDlg->setText(strLog);
							
							return -1;
						}

						//Jڐ̃_CAOANeBuԂɂ
						this->beActiveDialog(strNextDiaName);

					}else{

						//NULL񂪂Ă̂ŁCJڐ̃hLg̍ŏ̃_CAO̐
						if( this->makeDialog( strNextDocName, strArg ) == -1 ){
							strLog = "Jڐ̃hLg(:";
							strLog += strNextDocName.c_str();
							strLog += ")̍ŏ̃_CAOł܂\r\n";
							g_pLogDlg->setText(strLog);

							return -1;
						}
						//Jڐ̃hLg̍ŏ̃_CAOANeBuԂɂ
						this->beActiveDialog();

					}
				
				}else{
					//[tg[g̏ꍇ([g[tj
					//[ghLgC[ghLgDOM̃Zbg
					this->setRootDocName(strNextDocName);
					this->setRootDom(&pNextDocDOM);
					//[thLgC[thLgDOM̃Zbg
					this->setLeafDocName(strNextDocName);
					this->setLeafDom(&pNextDocDOM);

					//AvP[V̐
					if( this->makeApplication() != 0 ){
						strLog = "Jڐ̃AvP[V(:";
						strLog += strNextAppName.c_str();
						strLog += ")ł܂\r\n";
						g_pLogDlg->setText(strLog);
						return -1;
					}
					//AvP[VhLgANeBuԂɂ
					this->beActiveDocument( strNextAppName );

					if( strNextDiaName != "" ){
						//Jڐ̃_CAOw肳ĂȂ

						//Jڐ̃_CAO̐
						if( this->makeDialog(strNextAppName,strNextDiaName,strArg) != 0 ){
							strLog = "Jڐ̃_CAO(:";
							strLog += strNextDiaName.c_str();
							strLog += ")ł܂\r\n";
							g_pLogDlg->setText(strLog);

							return -1;
						}
			
						//Jڐ̃_CAOANeBuԂɂ
						this->beActiveDialog(strNextDiaName);

					}else{

						//NULL񂪂Ă̂ŁCJڐ̃hLg̍ŏ̃_CAO̐
						if( this->makeDialog(strNextAppName, strArg) != 0 ){

							strLog = "Jڐ̃hLg(:";
							strLog += strNextDocName.c_str();
							strLog += ")̍ŏ̃_CAOł܂\r\n";
							g_pLogDlg->setText(strLog);
							return -1;
						}

						//Jڐ̃hLg̍ŏ̃_CAOANeBuԂɂ
						this->beActiveDialog();

					}

				}


				
				break;
			default:
				//̏͂肦Ȃ
				break;

		}
	}else{
	
		//type̎w肪
		return -1;


	}

	return 0;

}


//@\F[gΘbc[O
//F
//		CDialogTreeNode**F[g|C^̃|C^
//߂lF
//		int   0:
//		int  -1:s
int CTreeManagement::cutOffApplicatoin(CDialogTreeNode** pRootNode){

	if( this->mRootDialogTreeNode != NULL ){

		*pRootNode = mRootDialogTreeNode;
		mRootDialogTreeNode = NULL;

		return 0;

	}else{
		*pRootNode = NULL;
		return -1;
	}
}

//@\Fw肵hLgm[hΘbc[O
//		̃m[ĥł͂ȂCΘbc[oD
//F
//		string strDocumentNameFohLgm[h
//		CDialogTreeNode**Fom[h|C^̃|C^
//߂lF
//		int   0:
//		int  -1:s
int CTreeManagement::cutOffDocument(string &strDocumentName,CDialogTreeNode** pDocumentNode){

	return mRootDialogTreeNode->cutOffDocument(strDocumentName,pDocumentNode);

}

//@\Fw肵_CAOm[hΘbc[O
//		̃m[ĥł͂ȂCΘbc[o
//F
//		string strDocumentNameFo_CAOm[hhLgm[h
//		string strDialogNode:o_CAOm[h
//߂lF
//	int
//		0:
//	   -1:s
int CTreeManagement::cutOffDialog(string &strDocumentName,string &strDialogName,CDialogTreeNode** pDialogNode){

	return mRootDialogTreeNode->cutOffDialog(strDocumentName,strDialogName,pDialogNode);
}

//@\Fw肵hLgm[hCAvP[Vm[h̎qvfɒǉ
//F
//		ǉhLgm[h|C^̃|C^
//߂lF
//	int
//		0:
//	   -1:s
int CTreeManagement::appendDocument(CDialogTreeNode** pDocumentNode){

	return mRootDialogTreeNode->appendDocument(pDocumentNode);

}

//@\Fw肵_CAOm[hChLgm[h̎qvfɒǉ
//F
//		ǉhLgm[h|C^̃|C^
//߂lF
//	int
//		0:
//	   -1:s
int CTreeManagement::appendDialog(string &strDocumentName,CDialogTreeNode** pDialogNode){

	return mRootDialogTreeNode->appendDialog(strDocumentName,pDialogNode);

}

//@\Fw肳ꂽexchangeIdXMLԂ
//FexchangeId
//߂lFXML
string CTreeManagement::getExchangeXML(int ExchangeId)
{
	CDialogTreeNode* pTempDialogTreeNode;
	getDialogTreeNode(ExchangeId,&pTempDialogTreeNode);

	return pTempDialogTreeNode->getXML();

}

//w肳ꂽIDlm[h[ghLgɑ݂邩ǂ𔻒
bool CTreeManagement::existInRoot(int exchangeId){

	CDialogTreeNode* pTempDialogTreeNode;
	//w肳ꂽhcexchangem[h擾
	getDialogTreeNode(exchangeId,&pTempDialogTreeNode);

	//̃m[h̃AvP[VƃhLg̎擾
	string strAppName;
	string strDocName;

	if( pTempDialogTreeNode ){
		((CExchangeNode*)pTempDialogTreeNode)->getAppName(&strAppName);
		((CExchangeNode*)pTempDialogTreeNode)->getAppName(&strDocName);
	}

	if( strAppName == strDocName ){
		//̃m[h̓[gł
		return true;
	}else{
		//̃m[h̓[tł
		return false;
	}

}

//݃ANeBuȃhLgԂ
string CTreeManagement::getActiveDocumentName(){

	CDialogTreeNode* pTempDialogTreeNode;
	//݃ANeBuȃhLgm[h̎擾
	getActiveDocumentNode(&pTempDialogTreeNode);

	string strActiveDocumentName;

	pTempDialogTreeNode->getName(&strActiveDocumentName);

	return strActiveDocumentName;

}

//Θbc[̏𕶎̐Fςĕ\
void CTreeManagement::writeSource(){

	theApp.clearString(0);
	theApp.clearString(1);

	mRootDialogTreeNode->writeSource();

	theApp.printString(0);
	theApp.printString(1);

}

//Θbc[̏𕶎̐Fςĕ\
void CTreeManagement::writeSource(string &strDoc){

	theApp.clearString(0);
	theApp.clearString(1);

	mRootDialogTreeNode->writeSource(strDoc);

	theApp.printString(0);
	theApp.printString(1);

}


int CTreeManagement::askActionManagementToGetActionNode(int exchangeId, IXMLDOMNode **pXDNode)
{
	return actionManagement.getActionDOMNode(exchangeId,pXDNode);
}

