//
// MMIVXe Ver.1.1 ͓
// ͓W[
//
// XISLNodeList.h / XISLNodeList.cpp
//
// 2002/07/07 Sun. G
// g͑J񂪍܂
//
//

#pragma warning ( disable:4786 )		// C4786̌x\ȂiHj

#include "stdafx.h"
#include <assert.h>

#include "XISLNodeList.h"

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//

//
// CXISLNodeInfo
//


//
// ֐ : CXISLNodeInfo::CXISLNodeInfo()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
CXISLNodeInfo::CXISLNodeInfo()
{
	m_strNodeName = "";
	m_nNodeType = TYPE_NODE_UNKNOWN;
}


//
// ֐ : CXISLNodeInfo::CXISLNodeInfo( string &nodename, XISLNODETYPE type )
// @  \ : RXgN^
//    : nodename --- m[h
//			type ------- m[h̎
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
CXISLNodeInfo::CXISLNodeInfo( string &nodename, XISLNODETYPE type )
{
	m_strNodeName = nodename;
	m_nNodeType = type;
}

//
// ֐ : CXISLNodeInfo::CXISLNodeInfo( const CXISLNodeInfo &info )
// @  \ : Rs[RXgN^
//    : info ^----- Rs[
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
CXISLNodeInfo::CXISLNodeInfo( const CXISLNodeInfo &info )
{
	m_strNodeName = info.GetNodeName();
	m_nNodeType   = info.GetNodeType();
}

//
// ֐ : CXISLNodeInfo::~CXISLNodeInfo()
// @  \ : fXgN^
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
CXISLNodeInfo::~CXISLNodeInfo()
{
}

//
// ֐ : string CXISLNodeInfo::GetNodeName() const
// @  \ : m[h擾
//    : Ȃ
// ߂l : m_strNodeName̒l
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
string CXISLNodeInfo::GetNodeName() const
{
	return m_strNodeName;
}

//
// ֐ : XISLNODETYPE CXISLNodeInfo::GetNodeType() const
// @  \ : m[h̎ނ擾
//    : Ȃ
// ߂l : m_nNodeType̒l
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
XISLNODETYPE CXISLNodeInfo::GetNodeType() const
{
	return m_nNodeType;
}

//
// ֐ : void CXISLNodeInfo::SetNodeInfo( string &nodename, XISLNODETYPE type )
// @  \ : m[hCm[h̎ނݒ肷
//    : nodename --- ݒ肷m[h
//			type     ---- ݒ肷m[h̎
// ߂l : Ȃ
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
void CXISLNodeInfo::SetNodeInfo( string &nodename, XISLNODETYPE type )
{
	m_strNodeName = nodename;
	m_nNodeType = type;
}

//
// ֐ : CXISLNodeInfo &CXISLNodeInfo::operator = ( const CXISLNodeInfo &info )
// @  \ : Zq
//    : info ---- Rs[
// ߂l : IuWFNgւ̎Q
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
CXISLNodeInfo &CXISLNodeInfo::operator = ( const CXISLNodeInfo &info )
{
	if ( &info == this ) { return *this; }

	m_strNodeName = info.GetNodeName();
	m_nNodeType   = info.GetNodeType();

	return *this;
}

//
// ֐ : bool CXILSNodeInfo::operator == ( const CXISLNodeInfo &info ) const
// @  \ : Zq
//    : info --- rΏۂ̃IuWFNg
// ߂l : ꂼ̃oIuWFNgtrue,ȊOfalseԂB
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
bool CXISLNodeInfo::operator == ( const CXISLNodeInfo &info ) const
{
	if ( &info == this ) { return true; }

	if ( ( m_strNodeName == info.GetNodeName() ) && ( m_nNodeType == info.GetNodeType() ) ) {
		return true;
	}

	return false;
}

//
// ֐ : bool CXISLNodeInfo::operator < ( const CXISLNodeInfo &info ) const
// @  \ : rZqiȂj
//    : info --- rΏۂ̃IuWFNg
// ߂l : IuWFNgm_strNodeNametrueCȊOfalseԂ
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
bool CXISLNodeInfo::operator < ( const CXISLNodeInfo &info ) const
{
	return m_strNodeName < info.GetNodeName();
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//

//
// CXISLNodeList
//

//
// ֐ : CXISLNodeList::CXISLNodeList()
// @  \ : ftHgRXgN^
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
CXISLNodeList::CXISLNodeList()
{
	m_NodeInfoList.clear();
}

//
// ֐ : CXISLNodeList::CXISLNodeList( const CXISLNodeList &nodelist )
// @  \ : Rs[RXgN^
//    : nodelist --- Rs[
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
CXISLNodeList::CXISLNodeList( const CXISLNodeList &nodelist )
{
	m_NodeInfoList = nodelist.GetNodeList();
}

//
// ֐ : CXISLNodeList::~CXISLNodeList()
// @  \ : fXgN^
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
CXISLNodeList::~CXISLNodeList()
{
	m_NodeInfoList.clear();
}

//
// ֐ : int CXISLNodeList::GetNodeCount()
// @  \ : ێĂvf擾
//    : Ȃ
// ߂l : m_NodeInfoList Ăvf
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
int CXISLNodeList::GetNodeCount()
{
	return m_NodeInfoList.size();
}

//
// ֐ : CXISLNodeInfo CXISLNodeList::GetNodeInfo( int index )
// @  \ : CXISLNodeInfoIuWFNg
//    : index --- ʒu
// ߂l : IuWFNg
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
CXISLNodeInfo CXISLNodeList::GetNodeInfo( int index )
{
	assert( ( index >= 0 ) && ( index < m_NodeInfoList.size() ) );

	set < CXISLNodeInfo >::iterator sp = m_NodeInfoList.begin();
	set < CXISLNodeInfo >::iterator ep = m_NodeInfoList.end();

	while ( ( sp != ep ) && ( index > 0 ) ) {
		sp ++; index --;
	}

	assert( sp == ep );

	return *sp;
}

//
// ֐ : CXISLNodeInfo CXISLNodeList::GetNodeInfo( string &nodename )
// @  \ : CXISLNodeInfoIuWFNg擾
//    : nodename --- m[h̖O
// ߂l : IuWFNg
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
CXISLNodeInfo CXISLNodeList::GetNodeInfo( string &nodename )
{
	set < CXISLNodeInfo >::iterator sp;
	sp = m_NodeInfoList.find( CXISLNodeInfo( nodename ) );
	
	if ( sp == m_NodeInfoList.end() ) {
		return CXISLNodeInfo();
	}

	return *sp;
}

//
// ֐ : int CXISLNodeList::AddNodeInfo( CXISLNodeInfo &info )
// @  \ : m[hǉ
//    : info --- ǉm[h
// ߂l : ǉ̗vf
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
int CXISLNodeList::AddNodeInfo( CXISLNodeInfo &info )
{
	m_NodeInfoList.insert( info );

	return m_NodeInfoList.size();
}

//
// ֐ : const set <CXISLNodeInfo > &CXISLNodeList::GetNodeList() const
// @  \ : m[hXg擾
//    : Ȃ
// ߂l : m[hXg{̂̃IuWFNgiύXsj
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
const set < CXISLNodeInfo > &CXISLNodeList::GetNodeList() const
{
	return m_NodeInfoList;
}

//
// ֐ : CXISLNodeList &CXISLNodeList::operator = ( CXISLNodeList &nodelist )
// @  \ : Zq
//    : nodelist --- Rs[
// ߂l : IuWFNgւ̎Q
// 쐬 : 2001/11/14 Wed.
// 쐬 : J F
//
// ŏIXV : 2001/11/14 Wed.
//
CXISLNodeList &CXISLNodeList::operator = ( CXISLNodeList &nodelist )
{
	if ( &nodelist == this ) { return *this; }

	m_NodeInfoList.clear();

	m_NodeInfoList = nodelist.GetNodeList();

	return *this;
}

void CXISLNodeList::Init()
{
	m_NodeInfoList.clear();
}
