//
// MMIVXe Ver.1.1 tgGh
// ʐM䕔
//
// Communicater.h / Communicater.cpp
//
// 2002/10/25 Fri. G
//
//
//

#include "stdafx.h"
#include "Kiosk.h"
#include "Communicater.h"
#include "MainFrame.h"

#include <string>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;


//
// CCommunicater
//

BEGIN_MESSAGE_MAP(CCommunicater, CWnd)
	//{{AFX_MSG_MAP(CCommunicater)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

const char* CCommunicater::_COMMAND_START_SESSION		 = "start_session";
const char* CCommunicater::_COMMAND_SEND_INPUT_NORMAL	 = "send_input_normal";
const char* CCommunicater::_COMMAND_SEND_INPUT_INTERRUPT	 = "send_input_interrupt";
const char* CCommunicater::_COMMAND_USER_INPUT			 = "user_input";
const char* CCommunicater::_COMMAND_EXECUTE_OUTPUT		 = "execute_output";
const char* CCommunicater::_COMMAND_END_OUTPUT			 = "end_output";
const char* CCommunicater::_COMMAND_END_SESSION			 = "end_session";
const char* CCommunicater::_COMMAND_END_SYSTEM			 = "end_system";
const char* CCommunicater::_COMMAND_ERROR_OUTPUT			 = "error_output";
const char* CCommunicater::_COMMAND_ERROR_INPUT			 = "error_input";
const char* CCommunicater::_COMMAND_ERROR_SCENARIO		 = "error_scenario";

// hoge
const char* CCommunicater::_COMMAND_END_WORLD = "END_WORLD";


CCommunicater::CCommunicater() : m_pTracer( NULL ), m_pInputManager( NULL ), m_pOutputManager( NULL ), m_State( false ), m_MyPort( 20100 )
{
	int		nResult;
	WORD	wRequireVersion;
	WSADATA	lpWSAData;

	wRequireVersion = MAKEWORD( 2, 0 );
	nResult = WSAStartup( wRequireVersion, &lpWSAData );

	CWinApp *pApp = AfxGetApp();
	CString strIp = pApp->GetProfileString("DM","IP","0,0,0,0");
	int nPort = pApp->GetProfileInt("DM","Port",20000);

	m_Accept = INVALID_SOCKET;
	m_Recv = INVALID_SOCKET;
	m_DMAddr.sin_family = AF_INET;
	m_DMAddr.sin_addr.s_addr = NULL;
	m_DMAddr.sin_addr.s_addr = inet_addr( strIp );
	m_DMAddr.sin_port = htons( nPort );

	DWORD LclIP;
	char *LclHostName;
	char SBf[256];

	LclHostName = GetHostNameAndIP(&LclIP);
	wsprintf(SBf,"%d.%d.%d.%d",(BYTE)(LclIP>>24),(BYTE)(LclIP>>16),(BYTE)(LclIP>>8),(BYTE)LclIP);
	pApp->WriteProfileString("ENGINE","IP","127.0.0.1");//SBf);
//
//	if( nResult != 0  )
//	{
//		// error
//	}
//
//	if( lpWSAData.wVersion != wRequireVersion )
//	{
//		// error
//	}
//
}

CCommunicater::~CCommunicater()
{
//	WSACleanup();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CCommunicater::Init( CInputManager* pInput, COutputManager* pOutput, CMessageTracer* pTracer )
{
	m_pInputManager = pInput;
	m_pOutputManager = pOutput;
	m_pTracer = pTracer;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CCommunicater::SetMyNetCfg( int port )
{
	m_MyPort = port;
}


//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CCommunicater::SetDMAddr( const string& ip, int port )
{
	m_DMAddr.sin_addr.s_addr = inet_addr( ip.c_str() );
	m_DMAddr.sin_port = htons( (u_short)port );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CCommunicater::Run()
{
	if( ( m_Accept = socket( AF_INET, SOCK_STREAM, IPPROTO_IP ) ) != INVALID_SOCKET )
	{
		struct sockaddr_in si;
		si.sin_family = AF_INET;
		si.sin_addr.s_addr = INADDR_ANY;
		si.sin_port = htons( (u_short)m_MyPort );
		if( bind( m_Accept, reinterpret_cast< sockaddr* >( &si ), sizeof( sockaddr_in ) ) != SOCKET_ERROR )
		{
			if( listen( m_Accept, 5 ) != SOCKET_ERROR )
			{
				if( !WSAAsyncSelect( m_Accept, this->m_hWnd, SM_EVENT, FD_ACCEPT | FD_CLOSE | FD_READ ) )
				{
					m_State = true;
					return true;
				}
			}
		}
	}
	m_State = false;
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CCommunicater::IsRunning()
{
	return m_State;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CCommunicater::Stop()
{
	m_State = false;
	if( WSAAsyncSelect( m_Accept, this->m_hWnd, 0, 0 ) == SOCKET_ERROR )
	{
		return false;
	}
	shutdown( m_Accept, 0x02 );
	closesocket( m_Accept );
	m_Accept = INVALID_SOCKET;
	return true;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
int CCommunicater::GetMyPort()
{
	return m_MyPort;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
struct sockaddr_in CCommunicater::GetDMAddr()
{
	return m_DMAddr;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CCommunicater::Send( const string& cmd, const string& param )
{
	string msg = "<msg><head><from>FrontEnd</from><to>DialogMngr</to></head>";
	msg += "<body><command>" + cmd + "</command><parameter>" + param + "</parameter></body></msg>";

	SOCKET sock = socket( AF_INET, SOCK_STREAM, IPPROTO_IP );
	if( sock != INVALID_SOCKET )
	{
		if( connect( sock, reinterpret_cast< struct sockaddr*>( &m_DMAddr ), sizeof( sockaddr_in ) ) == SOCKET_ERROR )
		{
			// error
		}
		m_pTracer->OnAccepted();

		size_t nSize = msg.length();
		size_t nRet = 0;
		int nRetBuf = 0;
		while( 1 )
		{
			if( nRet >= nSize )
				break;
			nRetBuf = send( sock, &(msg.c_str())[nRet], nSize - nRet, 0 );
			if(nRetBuf == SOCKET_ERROR)
				break;
			nRet += nRetBuf;
		}
		m_pTracer->OnSended( msg );
		shutdown( sock, 0x02 );
		closesocket( sock );
		m_pTracer->OnClosed();
	}
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CCommunicater::AnalyzeMessage()
{
	
	string received = m_Buff;

	int cmd_start = received.find( "<command>" );
	int cmd_end = received.find( "</command>" );
	if( cmd_start == string::npos || cmd_end == string::npos )
	{
		m_pTracer->AppendLine( "ʐMbZ[W̍\G[" );
		// message error
		return;
	}

	int param_start = received.find( "<parameter>" );
	int param_end = received.find( "</parameter>" );
	if( param_start == string::npos || param_end == string::npos )
	{
		// message error
		m_pTracer->AppendLine( "ʐMbZ[W̍\G[" );
		return;
	}

	string command = received.substr( cmd_start + 9, cmd_end - (cmd_start+9) );
	string parameter = received.substr( param_start, param_end + 12 - param_start );

	if( command == _COMMAND_SEND_INPUT_NORMAL )
	{
		m_pInputManager->Analyze( true, parameter );
	}
	else if( command == _COMMAND_SEND_INPUT_INTERRUPT )
	{
		m_pInputManager->Analyze( false, parameter );
	}
	else if( command == _COMMAND_EXECUTE_OUTPUT )
	{
		m_pOutputManager->Analyze( parameter );
	}
	else if( command == _COMMAND_END_SESSION )
	{
		m_pTracer->AppendLine( " - end_session received." ); 
		((CMainFrame*)AfxGetMainWnd())->m_pIECtrl->ClearAll();
		// end_session
	}
	else if( command == _COMMAND_ERROR_SCENARIO )
	{
		// error_scenario
	}
	else
	{
		m_pTracer->AppendLine( "T|[gÕbZ[W" );
		// command error
	}	
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
LRESULT CCommunicater::DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	int nRecv;
	char szBuff[255];

	switch( WSAGETSELECTEVENT( lParam ) )
	{
	case FD_ACCEPT:
		m_Buff = "";
		m_Recv = accept( m_Accept, NULL, NULL );
		m_pTracer->OnAccepted();
		break;

	case FD_READ:
		if( m_Recv != INVALID_SOCKET )
		{
			while( 1 )
			{
				nRecv = recv( m_Recv, szBuff, 255, 0 );
				if( nRecv < 1 )
					break;
				if( nRecv != SOCKET_ERROR )
				{
					m_Buff.append( szBuff, nRecv );
				}	
			}
			m_pTracer->OnReceived( m_Buff );
		}
		break;

	case FD_CLOSE:
		shutdown( m_Recv, 0x02 );
		closesocket( m_Recv );
		m_Recv = INVALID_SOCKET;
		memset( static_cast< void* >( szBuff ), '\0', 255 );
		m_pTracer->OnClosed();

		AnalyzeMessage();
		break;

	default:
		break;
	}

	return CWnd::DefWindowProc(message, wParam, lParam);
}

char *CCommunicater::GetHostNameAndIP(DWORD *LocalIP){
	static char LocalHost[256];
    WSAData musrStartup;

	WSAStartup(MAKEWORD(1, 1), &musrStartup);

    if (gethostname(LocalHost, sizeof(LocalHost)) == 0) {
        *LocalIP = GetHostByNameAlias(LocalHost);	//zXgƎ΂IPĂ
    } else {
        wsprintf(LocalHost, "localhost");
        *LocalIP = INADDR_LOOPBACK;			//zXgȂIṔu0x7f000001(127.0.0.1)v
    }
	WSACleanup();
	return LocalHost;
}

DWORD CCommunicater::GetHostByNameAlias(const char *strHostName) {
    struct hostent *hp;
    DWORD lngIP;
//	int iError;
    if ((lngIP = inet_addr(strHostName)) == INADDR_NONE) {
        if ((hp = gethostbyname(strHostName)) != NULL) {
            lngIP = *(DWORD *) hp->h_addr_list[0];
        }
    }
//	iError = WSAGetLastError();
	lngIP = ntohl(lngIP);
//	WSASetLastError(iError);
	return lngIP;
}