// FSMCtrl.cpp: CFSMCtrl NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "kiosk.h"
#include "FSMCtrl.h"
#include "SSMClient.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern BOOL CALLBACK EnumWindowsProc(HWND hWnd, LPARAM lParam);

//
// CFSMCtrl::CCmdSpeech
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CFSMCtrl::CCmdSpeech::CCmdSpeech( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CFSMCtrl::CCmdSpeech::~CCmdSpeech()
{
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CFSMCtrl::CCmdSpeech::Execute()
{
	CFSMCtrl* pCtrl = static_cast< CFSMCtrl* >( m_pModality );
	pCtrl->Lock( true );

	string text,endsync,expression;

	if( !GetParamValue( "name", "text", text ) )
	{
		Error( this, "o̓eLXgȂ" );
		return RESULT_FAILED;
	}
	if( !GetParamValue( "name", "endsync", endsync ) )
	{
		//ftHg"on"
		endsync = "on";
	}
	if( !GetParamValue( "name", "expression", expression ) )
	{
		//w肪Ή܂
		expression = "";
	}

	if(endsync.compare("on") == 0)
		pCtrl->m_bEndsync = true;
	else
	{
		SetEndState( COutputCommand::_ENDOUTPUT_NORMAL );
		pCtrl->SetState(true);
		pCtrl->m_bEndsync = false;
	}

	pCtrl->m_pSSMClient->SetText(text.c_str(),true);
	pCtrl->m_bProcessing = true;
	pCtrl->m_strSpeakExpression = expression.c_str();

	return RESULT_CONTINUE;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CFSMCtrl::CCmdSpeech::Terminate()
{
	CFSMCtrl* pCtrl = static_cast< CFSMCtrl* >( m_pModality );
	if( pCtrl->IsSpeaking() )
	{
		pCtrl->Stop();
		m_EndState = _ENDOUTPUT_INTERRUPT;
	}	
	return RESULT_SUCCEEDED;
}

//
// CFSMCtrl::CCmdFaceExp
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CFSMCtrl::CCmdFaceExp::CCmdFaceExp( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CFSMCtrl::CCmdFaceExp::~CCmdFaceExp()
{
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CFSMCtrl::CCmdFaceExp::Execute()
{
	CFSMCtrl* ctrl = static_cast< CFSMCtrl* >( m_pModality );
	ctrl->Lock ( true );

	string strFaceExp,strDur;
	if( !GetParamValue( "name", "expression", strFaceExp ) ){ return RESULT_FAILED; }
	if( !GetParamValue( "name", "dur", strDur ) ){return RESULT_FAILED; }

	ctrl->FaceExp( strFaceExp.c_str(),strDur.c_str() );

	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CFSMCtrl::CCmdFaceExp::Terminate()
{
	return RESULT_SUCCEEDED;
}



//
// CFSMCtrl::CCmdFaceMot
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CFSMCtrl::CCmdFaceMot::CCmdFaceMot( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CFSMCtrl::CCmdFaceMot::~CCmdFaceMot()
{
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CFSMCtrl::CCmdFaceMot::Execute()
{
	CFSMCtrl* pCtrl = static_cast< CFSMCtrl* >( m_pModality );
	pCtrl->Lock( true );

	string strAct,strId;

	if( !GetParamValue( "name", "action", strAct ) )
	{
		Error( this, "action̎w肪" );
		return RESULT_FAILED;
	}
	if( !GetParamValue( "name", "id", strId ) )
	{
		Error( this, "id̎w肪" );
		return RESULT_FAILED;
	}

	pCtrl->FaceMot(strAct.c_str(),strId.c_str());

	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CFSMCtrl::CCmdFaceMot::Terminate()
{
	return RESULT_SUCCEEDED;
}

//
// CFSMCtrl::CCmdCharacter
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CFSMCtrl::CCmdCharacter::CCmdCharacter( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CFSMCtrl::CCmdCharacter::~CCmdCharacter()
{
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CFSMCtrl::CCmdCharacter::Execute()
{
	CFSMCtrl* pCtrl = static_cast< CFSMCtrl* >( m_pModality );
	pCtrl->Lock( true );

	string strChr;

	if( !GetParamValue( "name", "mask", strChr ) )
	{
		Error( this, "o̓eLXgȂ" );
		return RESULT_FAILED;
	}

	pCtrl->Character(strChr.c_str());

	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CFSMCtrl::CCmdCharacter::Terminate()
{
	return RESULT_SUCCEEDED;
}

//
// CFSMCtrl::CCmdAutnomous
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CFSMCtrl::CCmdAutnomous::CCmdAutnomous( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CFSMCtrl::CCmdAutnomous::~CCmdAutnomous()
{
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CFSMCtrl::CCmdAutnomous::Execute()
{
	CFSMCtrl* pCtrl = static_cast< CFSMCtrl* >( m_pModality );
	pCtrl->Lock( true );

	string strAct;

	if( !GetParamValue( "name", "action", strAct ) )
	{
		Error( this, "action̎w肪" );
		return RESULT_FAILED;
	}

	pCtrl->Autonomous(strAct.c_str());

	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CFSMCtrl::CCmdAutnomous::Terminate()
{
	return RESULT_SUCCEEDED;
}

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
const char* CFSMCtrl::_TYPE_AGENT = "agent";
const char* CFSMCtrl::_EVENT_SPEECH = "speech";
const char* CFSMCtrl::_EVENT_FACEEXP = "face_exp";
const char* CFSMCtrl::_EVENT_FACEMOT = "face_mot";
const char* CFSMCtrl::_EVENT_CHARACTER = "character";
const char* CFSMCtrl::_EVENT_AUTONOMOUS = "autonomous";

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CFSMCtrl::CFSMCtrl( COutputManager* om, int ModalityID, CProcessTracer* tracer ) : COutputModality( om, ModalityID ), m_FSMClient(this), m_pProcessTracer( tracer )
{
	m_pProcessTracer->Write( "FSMǗ", " - " );
	if( Regist() )
	{
		m_pProcessTracer->AppendLine( " - o͊Ǘɓo^" );
	}
	m_pProcessTracer->AppendLine( " - FSMN" );

	CWinApp *pApp = AfxGetApp();
	CString strFSM = pApp->GetProfileString("FSM","Path",NULL);
	CString strCurrent = strFSM.Left(strFSM.ReverseFind('\\')+1);

	STARTUPINFO si;
    // CreateProcess()̈ݒ
    ZeroMemory(&si, sizeof(STARTUPINFO));
    ZeroMemory(&m_piFSM, sizeof(PROCESS_INFORMATION));
    si.cb = sizeof(STARTUPINFO);
    si.dwFlags = STARTF_USESHOWWINDOW;
    si.wShowWindow = SW_SHOW;
//    si.wShowWindow = SW_MINIMIZE;
//*
    if(!CreateProcess(NULL,
			strFSM.GetBuffer(strFSM.GetLength()),
//            _T("D:\\IPA\\engine\\FSM\\FSM\\bin\\fsm_d.exe"),
            NULL,
            NULL,
            FALSE,  
            0,  
            NULL,
			strCurrent.GetBuffer(strCurrent.GetLength()),
//            _T("D:\\IPA\\engine\\FSM\\FSM\\bin\\"),  
            &si,  
            &m_piFSM)){  
		pApp->WriteProfileInt("ENGINE","Validate",0);
        AfxMessageBox(_T("FSMNł܂ł\nċNƐݒ_CAO\܂"));  
		return;
	}
	strFSM.ReleaseBuffer();
	strCurrent.ReleaseBuffer();
//*/

	m_bProcessing = false;
	m_pProcessTracer->AppendLine( " - " );
}

CFSMCtrl::~CFSMCtrl()
{
	m_pProcessTracer->Write( "FSMǗ", " - ..." );
	if( Release() )
	{
		m_pProcessTracer->AppendLine( " - o͊Ǘ폜" );
	}
	m_pProcessTracer->AppendLine( " - " );

	m_FSMClient.Stop();

	// R[obN֐̌ĂяoB
//	EnumWindows(EnumWindowsProc, (LPARAM)&m_piFSM);

//	::CloseHandle(m_piFSM.hThread);
//	::CloseHandle(m_piFSM.hProcess);

	m_pProcessTracer->AppendLine( " - FSMGW~" );
	
	m_pProcessTracer->AppendLine( " - " );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
COutputCommand* CFSMCtrl::StoreCommand( const string& msg )
{
	m_pProcessTracer->Write( "FSMǗ", "<output>̉" );
	m_pProcessTracer->AppendLine( msg.c_str() );

	// <parameter>...</parameter>
	string count, event, path;
	bool bargein;
	CVariables vars;
	list < COutputParam > pars;

	if( !AnalyzeOutput( msg, count, bargein, path, event, vars, pars ) ){ return NULL; }

	COutputCommand* pCmd = NULL;
	if( event == _EVENT_SPEECH )
	{
		CCmdSpeech* pSpeech = new CCmdSpeech( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pSpeech );
	}
	else if( event == _EVENT_FACEEXP )
	{
		CCmdFaceExp* pFaceExp = new CCmdFaceExp( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = pFaceExp;
	}
	else if( event == _EVENT_FACEMOT )
	{
		CCmdFaceMot* pFaceMot = new CCmdFaceMot( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = pFaceMot;
	}
	else if( event == _EVENT_CHARACTER )
	{
		CCmdCharacter* pCharacter = new CCmdCharacter( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = pCharacter;
	}
	else if( event == _EVENT_AUTONOMOUS )
	{
		CCmdAutnomous* pAutonomous = new CCmdAutnomous( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = pAutonomous;
	}
	else
	{
		m_pProcessTracer->AppendLine( " - <output>" );
		return NULL;
	}

	m_Cmdlist.push_back( pCmd );

	return pCmd;

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CFSMCtrl::Execute()
{
	m_pProcessTracer->Write( "FSMǗ", " - <output>̎s" );
	COutputModality::Execute();
//	list < COutputCommand* > :: iterator ite = m_Cmdlist.begin();
//	if( (*ite)->GetEndState() == COutputCommand::_ENDOUTPUT_NORMAL )
//	{
//		Finish();
//	}
	return true;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CFSMCtrl::Terminate()
{
	if(m_Cmdlist.empty())
	{
		m_pProcessTracer->Write( "FSMǗ", " - ~<output>͂܂" );
		return true;
	}
	m_pProcessTracer->Write( "FSMǗ", " - <output>̋~" );
	(*m_Cmdlist.begin())->Terminate();
	return true;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
string CFSMCtrl::GetTypeAttribute()
{
	return _TYPE_AGENT;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
list < string > CFSMCtrl::GetEventAttribute()
{
	list < string > event;
	event.push_back( _EVENT_SPEECH );
	event.push_back( _EVENT_FACEEXP );
	event.push_back( _EVENT_FACEMOT );
	event.push_back( _EVENT_CHARACTER );
	event.push_back( _EVENT_AUTONOMOUS );
	return event;
}

BOOL CFSMCtrl::ConnectEngine()
{
	m_pProcessTracer->Write( "FSMǗ", " - FSMɐڑ" );
	int nRet = m_FSMClient.Initialize();
	if(nRet == -1)
	{
		m_pProcessTracer->AppendLine( " - \Pbg쐬s" );
		return FALSE;
	}
	else if(nRet == -2)
	{
		m_pProcessTracer->AppendLine( " - ڑvs" );
		return FALSE;
	}

	m_FSMClient.Run();
	m_pProcessTracer->AppendLine( " - MXbhJn" );
	return TRUE;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CFSMCtrl::OnSpeakFinished()
{
	if(m_Cmdlist.empty())
		return;

	list < COutputCommand* > :: iterator ite = m_Cmdlist.begin();
	COutputCommand* pCmd = ( *ite );

	if( pCmd->GetEndState() != COutputCommand::_ENDOUTPUT_INTERRUPT )
	{
		pCmd->SetEndState( COutputCommand::_ENDOUTPUT_NORMAL );
	}

	Finish();
}

void CFSMCtrl::OnSpeakReady(LPCTSTR lpszPho,LPCTSTR lpszDur)
{
	if(m_bProcessing)
	{
		m_strSpeakDur = lpszDur;
		this->Speak(lpszPho,m_bEndsync);
		m_bProcessing = false;
	}
}

void CFSMCtrl::Speak( LPCSTR lpszText, bool bEndsync )
{
	m_FSMClient.SetLipSync(lpszText);
	if(!bEndsync)
		Finish();
}

void CFSMCtrl::FaceExp( LPCTSTR lpszExpression, LPCTSTR lpszDur)
{
	m_FSMClient.FaceExp(lpszExpression,lpszDur);
}

void CFSMCtrl::FaceMot( LPCTSTR lpszAction, LPCTSTR lpszId)
{
	m_FSMClient.FaceMot(lpszAction,lpszId);
}

void CFSMCtrl::Character( LPCTSTR lpszChr)
{
	m_FSMClient.Character(lpszChr);
}

void CFSMCtrl::Autonomous(LPCTSTR lpszAction)
{
	m_FSMClient.Autonomous(lpszAction);
}

BOOL CFSMCtrl::IsSpeaking()
{
	if(m_FSMClient.IsSpeaking())
		return TRUE;
	else
		return FALSE;
}

void CFSMCtrl::Stop()
{
	m_FSMClient.StopSpeak();
}
