// FSMCtrl.h: CFSMCtrl NX̃C^[tFCX
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_FSMCTRL_H__E07FEE49_50EB_42D5_A35E_B4E505884B7A__INCLUDED_)
#define AFX_FSMCTRL_H__E07FEE49_50EB_42D5_A35E_B4E505884B7A__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "OutputModality.h"
#include "FSMClient.h"
#include "OutputModality.h"
#include "ProcessTracer.h"

class CSSMClient;
class CFSMCtrl : public COutputModality  
{
private:
	class CCmdSpeech : public COutputCommand
	{
	public:
		CCmdSpeech( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdSpeech();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};
	class CCmdFaceExp : public COutputCommand
	{
	public:
		CCmdFaceExp( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdFaceExp();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};
	class CCmdFaceMot : public COutputCommand
	{
	public:
		CCmdFaceMot( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdFaceMot();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};
	class CCmdCharacter : public COutputCommand
	{
	public:
		CCmdCharacter( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdCharacter();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};
	class CCmdAutnomous : public COutputCommand
	{
	public:
		CCmdAutnomous( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars );
		virtual ~CCmdAutnomous();
		EXECRESULT Execute();
		EXECRESULT Terminate();
	};

public:
	static const char* _TYPE_AGENT;
	static const char* _EVENT_SPEECH;
	static const char* _EVENT_FACEEXP;
	static const char* _EVENT_FACEMOT;
	static const char* _EVENT_CHARACTER;
	static const char* _EVENT_AUTONOMOUS;

	bool m_bProcessing;
	bool m_bEndsync;
	CSSMClient *m_pSSMClient;
	CString m_strSpeakExpression;
	CString m_strSpeakDur;

private:
	CFSMClient m_FSMClient;
	PROCESS_INFORMATION m_piFSM;
	CProcessTracer* m_pProcessTracer;

public:
	CFSMCtrl( COutputManager* om, int ModalityID, CProcessTracer* tracer );
	virtual ~CFSMCtrl();

	virtual string GetTypeAttribute();
	virtual list < string > GetEventAttribute();
	virtual COutputCommand* StoreCommand( const string& msg );
	virtual bool Execute();
	virtual bool Terminate();

	BOOL ConnectEngine();
	void OnSpeakFinished();
	void OnSpeakReady(LPCTSTR lpszPho,LPCTSTR lpszDur);
	void Speak( LPCSTR lpszText,bool bEndsync );
	void FaceExp( LPCTSTR lpszExpression, LPCTSTR lpszDur);
	void FaceMot( LPCTSTR lpszAction, LPCTSTR lpszId);
	void Character( LPCTSTR lpszChr);
	void Autonomous( LPCTSTR lpszAction);
	BOOL IsSpeaking();
	void Stop();
};

#endif // !defined(AFX_FSMCTRL_H__E07FEE49_50EB_42D5_A35E_B4E505884B7A__INCLUDED_)
