//
// MMIVXetgGhVer1.1
// uEU
//
// IEFrame.h / IFFrame.cpp
//
// 2002/10/15 Tue. G
//
//
//

#include "stdafx.h"
#include "Kiosk.h"
#include "IEFrame.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif _DEBUG

//
// CIEFrame
//

IMPLEMENT_DYNCREATE(CIEFrame, CBaseFrame)

BEGIN_MESSAGE_MAP(CIEFrame, CBaseFrame)
	//{{AFX_MSG_MAP(CIEFrame)
	ON_COMMAND(ID_FILE_CLOSE, OnFileClose)
	ON_WM_SETFOCUS()
	ON_WM_CREATE()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


#ifdef _DEBUG
void CIEFrame::AssertValid() const
{
	CBaseFrame::AssertValid();
}

void CIEFrame::Dump(CDumpContext& dc) const
{
	CBaseFrame::Dump(dc);
}

#endif //_DEBUG

CIEFrame::CIEFrame()
{

}

CIEFrame::~CIEFrame()
{
}

BOOL CIEFrame::PreCreateWindow(CREATESTRUCT& cs)
{
	if( !CBaseFrame::PreCreateWindow(cs) )
		return FALSE;

	cs.dwExStyle &= ~WS_EX_CLIENTEDGE;
	cs.lpszClass = AfxRegisterWndClass(0);

	return TRUE;
}

void CIEFrame::OnFileClose() 
{
	SendMessage(WM_CLOSE);
}

int CIEFrame::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CBaseFrame::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	if (!m_WndView.Create( this ) )
	{
		TRACE0("Failed to create view window\n");
		return -1;
	}

	return 0;
}

void CIEFrame::OnSetFocus(CWnd* pOldWnd) 
{
	CBaseFrame::OnSetFocus(pOldWnd);

	m_WndView.SetFocus();
}

BOOL CIEFrame::OnCmdMsg(UINT nID, int nCode, void* pExtra, AFX_CMDHANDLERINFO* pHandlerInfo) 
{
	if (m_WndView.OnCmdMsg(nID, nCode, pExtra, pHandlerInfo))
		return TRUE;
	
	return CBaseFrame::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

void CIEFrame::OnSize(UINT nType, int cx, int cy) 
{
	CBaseFrame::OnSize(nType, cx, cy);
	m_WndView.MoveWindow( 0, 0, cx, cy );
}

void CIEFrame::Navigate( LPCSTR strUrl )
{
	m_WndView.Navigate( strUrl );
}

CIEView* CIEFrame::GetIEView()
{
	return & m_WndView;
}

void CIEFrame::GoBack()
{
	m_WndView.GoBack();
}

void CIEFrame::Reload()
{
	m_WndView.Refresh();
}

bool CIEFrame::SetValue( LPCSTR ObjID, LPCSTR value )
{
	IHTMLElement* pElem = m_WndView.GetObject( ObjID );
	if( !pElem )
	{
		return false;
	}

	BSTR bstr_tag_name;
	HRESULT hr;
	CString tag_name;

	hr = pElem->get_tagName( &bstr_tag_name );
	if( !SUCCEEDED( hr ) )
	{
		return false;
	}
	tag_name = bstr_tag_name;

	int nLen = lstrlen( value ) * 2;
	OLECHAR* oleChar = new OLECHAR[ nLen + 1 ];
	::MultiByteToWideChar( CP_ACP, 0, value, -1, oleChar, nLen + 1 );
	BSTR bstr_value = SysAllocString( oleChar );
	delete oleChar;

	if( tag_name == "TEXTAREA" )
	{
		IHTMLTextAreaElement* pTxtElem;
		hr = pElem->QueryInterface( IID_IHTMLTextAreaElement, (void**)&pTxtElem );
		if( SUCCEEDED( hr ) )
		{
			pTxtElem->put_value( bstr_value );
			SysFreeString( bstr_value );
			pTxtElem->Release();

			return true;
		}
	}
	else if( tag_name == "INPUT" )
	{
		MSHTML::IHTMLInputElement* pIptElem;
		hr = pElem->QueryInterface( MSHTML::IID_IHTMLInputElement, (void**)&pIptElem );
		if( SUCCEEDED( hr ) )
		{
			BSTR bstrType;
			CString type;
			pIptElem->get_type( &bstrType );
			type = bstrType;
			pIptElem->Release();

			if( type == "text" )
			{
				IHTMLInputTextElement *pITxtElem;
				hr = pElem->QueryInterface( IID_IHTMLInputTextElement, (void**)&pITxtElem );
				if( SUCCEEDED( hr ) )
				{
					pITxtElem->put_value( bstr_value );
					SysFreeString( bstr_value );
					pITxtElem->Release();
					
					return true;
				}
			}
		}
	}
	else
	{
	}
	return false;
}

CString CIEFrame::GetValue( LPCSTR  ObjID )
{
	IHTMLElement* pElem = m_WndView.GetObject( ObjID );
	if( !pElem )
	{
		return "";
	}

	BSTR bstr_tag_name;
	HRESULT hr;
	CString tag_name;

	hr = pElem->get_tagName( &bstr_tag_name );
	if( !SUCCEEDED( hr ) )
	{
		return "";
	}
	tag_name = bstr_tag_name;

	BSTR bstr_value;
	if( tag_name == "TEXTAREA" )
	{
		IHTMLTextAreaElement* pTxtElem;
		hr = pElem->QueryInterface( IID_IHTMLTextAreaElement, (void**)&pTxtElem );
		if( SUCCEEDED( hr ) )
		{
			pTxtElem->get_value( &bstr_value );
			pTxtElem->Release();
		}
	}
	else if( tag_name == "INPUT" )
	{
		MSHTML::IHTMLInputElement* pIptElem;
		hr = pElem->QueryInterface( MSHTML::IID_IHTMLInputElement, (void**)&pIptElem );
		if( SUCCEEDED( hr ) )
		{
			BSTR bstrType;
			CString type;
			pIptElem->get_type( &bstrType );
			type = bstrType;
			pIptElem->Release();

			if( type == "text" )
			{
				IHTMLInputTextElement *pITxtElem;
				hr = pElem->QueryInterface( IID_IHTMLInputTextElement, (void**)&pITxtElem );
				if( SUCCEEDED( hr ) )
				{
					pITxtElem->get_value( &bstr_value );
					pITxtElem->Release();					
				}
			}
		}
	}
	else
	{
	}
	CString ret = bstr_value;
	return ret;
}

