//
// MMIVXetgGhVer1.1
// uEU
//
// IEModalDialog.h / IEModalDialog.cpp
//
// 2002/12/12 Thur. G
//
//
//

#include "stdafx.h"
#include "kiosk.h"
#include "MainFrame.h"
#include "IEModalDialog.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

//
// CIEModalDialog::CHTMLElement
//

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIEModalDialog::CHTMLElement::CHTMLElement( CIEModalDialog* pBrowser, IDispatch* pDisp ) : m_pBrowser( pBrowser ), m_Type( INVALID ), m_Id(), m_dwConCookie( NULL ), m_pDisp( pDisp ), m_IsCon( false )
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIEModalDialog::CHTMLElement::~CHTMLElement()
{
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
ELEMENT_TYPE CIEModalDialog::CHTMLElement::GetType( CString& tag )
{
	if( !strcmp( "IMG", tag ) )
		return INVALID;
	else if( tag == "INPUT" )
		return INPUT;
	else if( tag=="HTML" )
		return ELEMENT;
	else 
		return INVALID;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
BOOL CIEModalDialog::CHTMLElement::Connect()
{
	HRESULT hr;
	IHTMLElement* pElem;
	hr = m_pDisp->QueryInterface( IID_IHTMLElement, (void**)&pElem );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}

	BSTR tag;
	CString strTag;
	pElem->get_tagName( &tag );
	strTag = tag;
	m_Type = GetType( strTag );

	switch( m_Type )
	{

	case ELEMENT :
		if( !AfxConnectionAdvise( pElem, DIID_HTMLElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
		{
			return FALSE;
		}
		break;

	case INPUT :
		MSHTML::IHTMLInputElement *pIptElem;
		hr = m_pDisp->QueryInterface( MSHTML::IID_IHTMLInputElement, (void**)&pIptElem );
		if( SUCCEEDED( hr ) )
		{
			BSTR bstrType;
			CString strType;			
			pIptElem->get_type( &bstrType );
			strType = bstrType;
			pIptElem->Release();

			if( !strcmp( strType, "text" ) )
			{
				IHTMLInputTextElement *pITxtElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputTextElement, (void**)&pITxtElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionAdvise( pITxtElem, DIID_HTMLInputTextElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
					{
						pITxtElem->Release();
						break;
					}
				}
				return FALSE;
			}

			else if( !strcmp( strType, "button" ) )
			{
				IHTMLInputButtonElement *pIBtnElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputButtonElement, (void**)&pIBtnElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionAdvise( pIBtnElem, DIID_HTMLOptionButtonElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, &m_dwConCookie ) )
					{
						pIBtnElem->Release();
						break;
					}
				}
				return FALSE;
			}

			else
			{
				return FALSE;
			}
		}
		return FALSE;

	default:
		return FALSE;
	}


	BSTR bstr_id;
	pElem->get_id( &bstr_id );
	m_Id = bstr_id;

	m_IsCon = true;

	pElem->Release();

	return TRUE;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
BOOL CIEModalDialog::CHTMLElement::Disconnect()
{
	if( !m_IsCon ){ return FALSE; }

	HRESULT hr;
	switch( m_Type )
	{
	case ELEMENT :
		IHTMLElement* pElem;
		hr = m_pDisp->QueryInterface( IID_IHTMLElement, (void**)&pElem );
		if( SUCCEEDED( hr ) )
		{
			if( AfxConnectionUnadvise( pElem, DIID_HTMLElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
			{
				pElem->Release();
				break;
			}
		}
		return FALSE;

	case INPUT :
		MSHTML::IHTMLInputElement *pIptElem;
		hr = m_pDisp->QueryInterface( MSHTML::IID_IHTMLInputElement, (void**)&pIptElem );
		if( SUCCEEDED( hr ) )
		{
			BSTR bstrType;
			CString strType;			
			pIptElem->get_type( &bstrType );
			strType = bstrType;
			pIptElem->Release();

			if( !strcmp( strType, "text" ) )
			{
				IHTMLInputTextElement *pITxtElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputTextElement, (void**)&pITxtElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionUnadvise( pITxtElem, DIID_HTMLInputTextElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
					{
						pITxtElem->Release();
						break;
					}
				}
				return FALSE;
			}

			else if( !strcmp( strType, "button" ) )
			{
				IHTMLInputButtonElement *pIBtnElem;
				hr = m_pDisp->QueryInterface( IID_IHTMLInputButtonElement, (void**)&pIBtnElem );
				if( SUCCEEDED( hr ) )
				{
					if( AfxConnectionUnadvise( pIBtnElem, DIID_HTMLOptionButtonElementEvents, m_pBrowser->GetInterface( &IID_IUnknown ), TRUE, m_dwConCookie ) )
					{
						pIBtnElem->Release();
						break;
					}
				}
				return FALSE;
			}

			else
			{
				return FALSE;
			}
		}
		return FALSE;

	default:
		return FALSE;

	}
	return TRUE;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CIEModalDialog::CHTMLElement& CIEModalDialog::CHTMLElement::operator = ( const CIEModalDialog::CHTMLElement& elem )
{
	if( this == &elem ){ return *this; }

	m_pBrowser = elem.m_pBrowser;
	m_Type = elem.m_Type;
	m_Id = elem.m_Id;
	m_dwConCookie = elem.m_dwConCookie;
	m_pDisp = elem.m_pDisp;
	m_IsCon = elem.m_IsCon;

	return *this;
}

//
// CIEModalDialog
//

const int CIEModalDialog::_CLICK = 0;
const int CIEModalDialog::_DOUBLECLICK = -1;

int CIEModalDialog::m_TimerID = TIMERID - 100;

BEGIN_MESSAGE_MAP(CIEModalDialog, CDialog)
	//{{AFX_MSG_MAP(CIEModalDialog)
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

BEGIN_EVENTSINK_MAP( CIEModalDialog, CDialog )
	ON_EVENT( CIEModalDialog, IDC_EXPLORER1, DISPID_BEFORENAVIGATE2, OnBeforeNavigate, VTS_DISPATCH VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PVARIANT VTS_PBOOL )
	ON_EVENT( CIEModalDialog, IDC_EXPLORER1, DISPID_DOCUMENTCOMPLETE, OnDocumentComplete, VTS_DISPATCH VTS_PVARIANT )
END_EVENTSINK_MAP()

BEGIN_INTERFACE_MAP( CIEModalDialog, CDialog )
	INTERFACE_PART( CIEModalDialog, DIID_HTMLElementEvents, Dispatch )
	INTERFACE_PART( CIEModalDialog, DIID_HTMLWindowEvents, Dispatch )
	INTERFACE_PART( CIEModalDialog, DIID_HTMLInputTextElementEvents, Dispatch )
END_INTERFACE_MAP()
	
BEGIN_DISPATCH_MAP( CIEModalDialog, CDialog )
	DISP_FUNCTION_ID( CIEModalDialog, "onclick", DISPID_HTMLELEMENTEVENTS_ONCLICK, OnClick, VT_EMPTY, VTS_NONE )
	DISP_FUNCTION_ID( CIEModalDialog, "ondoubleclick", DISPID_HTMLELEMENTEVENTS_ONDBLCLICK, OnDbClick, VT_EMPTY, VTS_NONE )
END_DISPATCH_MAP()


CIEModalDialog::CIEModalDialog(CWnd* pParent /*=NULL*/)
	: CDialog(CIEModalDialog::IDD, pParent)
{
	//{{AFX_DATA_INIT(CIEModalDialog)
	//}}AFX_DATA_INIT
	m_pBrowser = NULL;
	m_pDocument = NULL;
	m_pHtmlWindow = NULL;
	m_pXMLDocument = NULL;
	m_IsValid = FALSE;


	CoInitialize( NULL );
	EnableAutomation();
}


void CIEModalDialog::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CIEModalDialog)
	DDX_Control(pDX, IDC_EXPLORER1, m_Browser);
	//}}AFX_DATA_MAP
}

void CIEModalDialog::OnOK()
{


	CDialog::OnOK();
}

BOOL CIEModalDialog::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	CRect rect_browser;
	m_Browser.GetClientRect( &rect_browser );
	if( m_Width == -1 )
		m_Width = rect_browser.right - rect_browser.left;
	if( m_Height == -1 )
		m_Height = rect_browser.bottom - rect_browser.top;

	m_Browser.Navigate( (LPCSTR)m_Navigate );
	m_Browser.MoveWindow( 1, 1, m_Width, m_Height );

	SetWindowPos( NULL, 0, 0, m_Width + 9, m_Height + 23, SWP_NOMOVE );

	UINT flag = 0;
	CRect rect;
	m_pParent->GetWindowRect( &rect );

	CRect rect_dlg;
	GetWindowRect( &rect_dlg );
	int cx, cy;
	if( m_Position == "center" )
	{
		cx = ( rect.left + rect.right ) / 2 - ( rect_dlg.right - rect_dlg.left ) / 2;
		cy = ( rect.top  + rect.bottom ) / 2 - ( rect_dlg.bottom - rect_dlg.top ) /2;
	}
	else if( m_Position == "left-top" )
	{
		cx = rect.left;
		cy = rect.top;
	}
	else if( m_Position == "left-bottom" )
	{
		cx = rect.left;
		cy = rect.bottom - ( rect_dlg.bottom - rect_dlg.top );
	}
	else if( m_Position == "right-top" )
	{
		cx = rect.right - ( rect_dlg.right - rect_dlg.left );
		cy = rect.top;
	}
	else if( m_Position == "right-bottom" )
	{
		cx = rect.right - ( rect_dlg.right - rect_dlg.left );
		cy = rect.bottom - ( rect_dlg.bottom - rect_dlg.top );
	}
	else
	{
		flag = SWP_NOMOVE;
	}

	SetWindowPos( NULL, cx, cy, m_Width + 9, m_Height + 24, flag | SWP_NOSIZE );
	m_IsValid = TRUE;
	return TRUE;
}

BOOL CIEModalDialog::PreTranslateMessage(MSG* pMsg) 
{
	switch( pMsg->message )
	{
	case WM_TIMER :
		if( pMsg->wParam == m_MyTimerID )
		{
			if( !KillTimer( m_MyTimerID ) )
			{
				// error
			}
			CIEFrame* pFrame = (CIEFrame*)CWnd::GetParent();
			if( pFrame )
			{
				((CMainFrame*)m_pParent)->m_pMouseInput->Input( CMouseInput::_TYPE_TOUCH, CMouseInput::_EVENT_CLICK, (LPCSTR)m_ClickedObj, (LPCSTR)m_Target, m_Vars );
				m_Vars.Clear();	
				m_ClickedObj.Empty();
			}
		}
		break;
	default:
		break;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

void CIEModalDialog::OnBeforeNavigate( LPDISPATCH , VARIANT *URL, VARIANT *Flag, VARIANT *TargetName, VARIANT *PostData, VARIANT *Header, BOOL *Cancel )
{
	if( !ConnectionUnAdvise() )
	{
		// error
	}
}

void CIEModalDialog::OnDocumentComplete( LPDISPATCH /*lpDisp*/, VARIANT* pURL )
{
	if( !GetInterfaces() )
	{
		// error
	}

	if( !ConnectionAdvise() )
	{
		// error
	}

	m_Target = pURL->bstrVal;
	int idx = m_Target.Find( "#" );
	if( idx > 0 )
		m_Target = m_Target.Left( idx );

	((CMainFrame*)m_pParent)->OnBrowserEvent( NULL );
}

BOOL CIEModalDialog::GetInterfaces()
{
	HRESULT hr;
	IDispatch *pDisp;

	if ( m_pBrowser != NULL )
	{
		m_pBrowser->Release();
		m_pBrowser = NULL;
	}

	LPUNKNOWN lpUnk = m_Browser.GetControlUnknown();
	if ( lpUnk == NULL )
	{
		return FALSE;
	}

	hr = lpUnk->QueryInterface( IID_IWebBrowser2, (void**)&m_pBrowser );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}

	if( m_pDocument != NULL )
	{
		m_pDocument->Release();
		m_pDocument = NULL;
	}

	hr = m_pBrowser->get_Document( &pDisp );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}

	hr = pDisp->QueryInterface( IID_IHTMLDocument2, (void**)&m_pDocument );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}

	if( m_pHtmlWindow != NULL )
	{
		m_pHtmlWindow->Release();
		m_pHtmlWindow = NULL;
	}

	hr = m_pDocument->get_parentWindow( &m_pHtmlWindow );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}

	return TRUE;
}

BOOL CIEModalDialog::ConnectionAdvise()
{
	HRESULT hr;
	IHTMLElementCollection *pColl = NULL;
	long celem;
	int count;

	hr = m_pDocument->get_all( &pColl );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}

	hr = pColl->get_length( &celem );
	if( !SUCCEEDED( hr ) )
	{
		return FALSE;
	}

	for( count = 0; count < celem; count++ )
	{
		VARIANT varIndex;
		VARIANT var2;
		IDispatch *pDisp;
		CString strTag;

		varIndex.vt = VT_UINT;
		varIndex.lVal = count;
		VariantInit( &var2 );

		hr = pColl->item( varIndex, var2, &pDisp );
		if( !SUCCEEDED( hr ) )
		{
			return FALSE;
		}

		CHTMLElement* pElement;
		pElement = new CHTMLElement( this, pDisp );
		pElement->Connect();
		m_ElementList.push_back( pElement );
	}

	return TRUE;
}

BOOL CIEModalDialog::ConnectionUnAdvise()
{
	if( m_ElementList.size() > 0 )
	{
		list < CHTMLElement* > :: iterator ite = m_ElementList.begin();
		while( ite != m_ElementList.end() )
		{
			(*ite)->Disconnect();
			delete (*ite);
			ite++;
		}
		m_ElementList.clear();
	}
	return TRUE;
}

void CIEModalDialog::OnEvent( int event )
{
	IHTMLEventObj* pEvent = NULL;
	IHTMLElement* pElem = NULL;
	IHTMLElement* pElem2 = NULL;
	long cx, cy;
	HRESULT hr;
	BSTR bstr_id;
	CString str_id;

	hr = m_pHtmlWindow->get_event( &pEvent );
	if( SUCCEEDED( hr ) )
	{
		hr = pEvent->get_srcElement( &pElem );

		hr = pEvent->get_clientX( &cx );
		if( !SUCCEEDED( hr ) ){	cx = -1; }
		hr = pEvent->get_clientY( &cy );
		if( !SUCCEEDED( hr ) ){	cy = -1;}

		if( event == _CLICK )
		{
			do
			{
				pElem2 = pElem;
				pElem2->get_id( &bstr_id );
				m_ClickedObj = bstr_id;
				pElem = NULL;
				hr = pElem2->get_parentElement( &pElem );
				if( hr != S_OK || pElem == NULL )
				{
					return;
				}
			}while( m_ClickedObj == "" );

			char px[10];
			char py[10];
			ltoa( cx, px, 10 );
			ltoa( cy, py, 10 );
			m_Vars.Add( CMouseInput::_TEMPORARY_NAME_X, px, 0 );
			m_Vars.Add( CMouseInput::_TEMPORARY_NAME_Y, py, 1 );

			m_MyTimerID = SetTimer( ++m_TimerID, 300, NULL );
			if( m_MyTimerID == 0 )
			{
				// error
			}
		}
		else
		{
			if( !KillTimer( m_MyTimerID ) )
			{
				// error
			}
			((CMainFrame*)m_pParent)->m_pMouseInput->Input( CMouseInput::_TYPE_TOUCH, CMouseInput::_EVENT_CLICK, (LPCSTR)m_ClickedObj, (LPCSTR)m_Target, m_Vars );
			m_Vars.Clear();
			m_ClickedObj.Empty();
		}
	}
}

bool CIEModalDialog::SetValue( LPCSTR ObjID, LPCSTR value )
{
	IHTMLElement* pElem = GetObject( ObjID );
	if( !pElem )
	{
		return false;
	}

	BSTR bstr_tag_name;
	HRESULT hr;
	CString tag_name;

	hr = pElem->get_tagName( &bstr_tag_name );
	if( !SUCCEEDED( hr ) )
	{
		return false;
	}
	tag_name = bstr_tag_name;

	int nLen = lstrlen( value ) * 2;
	OLECHAR* oleChar = new OLECHAR[ nLen + 1 ];
	::MultiByteToWideChar( CP_ACP, 0, value, -1, oleChar, nLen + 1 );
	BSTR bstr_value = SysAllocString( oleChar );
	delete oleChar;

	if( tag_name == "TEXTAREA" )
	{
		IHTMLTextAreaElement* pTxtElem;
		hr = pElem->QueryInterface( IID_IHTMLTextAreaElement, (void**)&pTxtElem );
		if( SUCCEEDED( hr ) )
		{
			pTxtElem->put_value( bstr_value );
			SysFreeString( bstr_value );
			pTxtElem->Release();

			return true;
		}
	}
	else if( tag_name == "INPUT" )
	{
		MSHTML::IHTMLInputElement* pIptElem;
		hr = pElem->QueryInterface( MSHTML::IID_IHTMLInputElement, (void**)&pIptElem );
		if( SUCCEEDED( hr ) )
		{
			BSTR bstrType;
			CString type;
			pIptElem->get_type( &bstrType );
			type = bstrType;
			pIptElem->Release();

			if( type == "text" )
			{
				IHTMLInputTextElement *pITxtElem;
				hr = pElem->QueryInterface( IID_IHTMLInputTextElement, (void**)&pITxtElem );
				if( SUCCEEDED( hr ) )
				{
					pITxtElem->put_value( bstr_value );
					SysFreeString( bstr_value );
					pITxtElem->Release();
					
					return true;
				}
			}
		}
	}
	else
	{
	}
	return false;
}

CString CIEModalDialog::GetValue( LPCSTR  ObjID )
{
	IHTMLElement* pElem = GetObject( ObjID );
	if( !pElem )
	{
		return "";
	}

	BSTR bstr_tag_name;
	HRESULT hr;
	CString tag_name;

	hr = pElem->get_tagName( &bstr_tag_name );
	if( !SUCCEEDED( hr ) )
	{
		return "";
	}
	tag_name = bstr_tag_name;

	BSTR bstr_value;
	if( tag_name == "TEXTAREA" )
	{
		IHTMLTextAreaElement* pTxtElem;
		hr = pElem->QueryInterface( IID_IHTMLTextAreaElement, (void**)&pTxtElem );
		if( SUCCEEDED( hr ) )
		{
			pTxtElem->get_value( &bstr_value );
			pTxtElem->Release();
		}
	}
	else if( tag_name == "INPUT" )
	{
		MSHTML::IHTMLInputElement* pIptElem;
		hr = pElem->QueryInterface( MSHTML::IID_IHTMLInputElement, (void**)&pIptElem );
		if( SUCCEEDED( hr ) )
		{
			BSTR bstrType;
			CString type;
			pIptElem->get_type( &bstrType );
			type = bstrType;
			pIptElem->Release();

			if( type == "text" )
			{
				IHTMLInputTextElement *pITxtElem;
				hr = pElem->QueryInterface( IID_IHTMLInputTextElement, (void**)&pITxtElem );
				if( SUCCEEDED( hr ) )
				{
					pITxtElem->get_value( &bstr_value );
					pITxtElem->Release();					
				}
			}
		}
	}
	else
	{
	}
	CString ret = bstr_value;
	return ret;
}

IHTMLElement* CIEModalDialog::GetObject( LPCSTR object )
{
	IHTMLElementCollection *pColl = NULL;
	HRESULT hr;
	long elem_num;

	hr = m_pDocument->get_all( &pColl );
	if( !SUCCEEDED( hr ) )
	{
		return NULL;
	}

	hr = pColl->get_length( &elem_num );
	if( !SUCCEEDED( hr ) )
	{
		return NULL;
	}

	for( int count = 0; count < elem_num; count++ )
	{
		VARIANT varIndex;
		VARIANT var2;
		IDispatch *pDisp;
		IHTMLElement *pElem;
		CString strId;
		BSTR bstrId;

		varIndex.vt = VT_UINT;
		varIndex.lVal = count;
		VariantInit( &var2 );

		hr = pColl->item( varIndex, var2, &pDisp );
		if( !SUCCEEDED( hr ) )
		{
			return NULL;
		}

		hr = pDisp->QueryInterface( IID_IHTMLElement, (void**)&pElem );
		if( !SUCCEEDED( hr ) )
		{
		}

		hr = pElem->get_id( &bstrId );
		if( !SUCCEEDED( hr ) )
		{
		}
		strId = bstrId;
		if( strId == object )
		{
			pDisp->Release();
			return pElem;
		}
		pDisp->Release();
		pElem->Release();
	}
	return NULL;
}

void CIEModalDialog::Navigate()
{
	m_Browser.Navigate( (LPCSTR)m_Navigate );
}

void CIEModalDialog::OnClick()
{
	OnEvent( _CLICK );
}

void CIEModalDialog::OnDbClick()
{
	OnEvent( _DOUBLECLICK );
}

void CIEModalDialog::OnDestroy() 
{
	ConnectionUnAdvise();

	CDialog::OnDestroy();
	if( m_pHtmlWindow )
	{
		m_pHtmlWindow->Release();
		m_pHtmlWindow = NULL;
	}
	if( m_pDocument )
	{
		m_pDocument->Release();
		m_pDocument = NULL;
	}
	if( m_pBrowser )
	{
		m_pBrowser->Release();
		m_pBrowser = NULL;
	}
	m_IsValid = FALSE;
}

void CIEModalDialog::ResizeWnd( int width, int height )
{
	CRect rect_browser;
	m_Browser.GetClientRect( &rect_browser );
	if( width == -1 )
		m_Width = rect_browser.right - rect_browser.left;
	if( height == -1 )
		m_Height = rect_browser.bottom - rect_browser.top;

	m_Browser.MoveWindow( 1, 1, m_Width, m_Height );

	SetWindowPos( NULL, 0, 0, m_Width + 9, m_Height + 23, SWP_NOMOVE );
}

void CIEModalDialog::MoveWnd( LPCSTR pos )
{
	UINT flag = 0;
	CRect rect;
	m_pParent->GetWindowRect( &rect );

	CRect rect_dlg;
	GetWindowRect( &rect_dlg );
	int cx, cy;
	if( m_Position == "center" )
	{
		cx = ( rect.left + rect.right ) / 2 - ( rect_dlg.right - rect_dlg.left ) / 2;
		cy = ( rect.top  + rect.bottom ) / 2 - ( rect_dlg.bottom - rect_dlg.top ) /2;
	}
	else if( m_Position == "left-top" )
	{
		cx = rect.left;
		cy = rect.top;
	}
	else if( m_Position == "left-bottom" )
	{
		cx = rect.left;
		cy = rect.bottom - ( rect_dlg.bottom - rect_dlg.top );
	}
	else if( m_Position == "right-top" )
	{
		cx = rect.right - ( rect_dlg.right - rect_dlg.left );
		cy = rect.top;
	}
	else if( m_Position == "right-bottom" )
	{
		cx = rect.right - ( rect_dlg.right - rect_dlg.left );
		cy = rect.bottom - ( rect_dlg.bottom - rect_dlg.top );
	}
	else
	{
		flag = SWP_NOMOVE;
	}
	SetWindowPos( NULL, cx, cy, m_Width + 9, m_Height + 24, flag | SWP_NOSIZE );
}
