//
// MMIVXe Ver.1.1 tgGh
// ͊Ǘ
//
// InputAnalyzer.h / InputAnalyzer.cpp
//
// 2002/12/12 Thur. G
//
//
//

#include "stdafx.h"
#include "InputAnalyzer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;

//
// CInputAnalyzer
//

const char* CInputAnalyzer::ATTR_NAME_TYPE = "type";
const char* CInputAnalyzer::ATTR_NAME_EVENT = "event";
const char* CInputAnalyzer::ATTR_NAME_MATCH = "match";
const char* CInputAnalyzer::ATTR_NAME_TARGET = "target";
const char* CInputAnalyzer::ATTR_NAME_RETURN = "return";
const char* CInputAnalyzer::MSG_NODE_INPUTINFO = "input_info";
const char* CInputAnalyzer::MSG_ATTR_PATH = "path";

const char* CInputAnalyzer::ERROR_NO_XML = "`XMLł͂܂";
const char* CInputAnalyzer::ERROR_NO_INPUTINFO = "<input_info>vfȂ";
const char* CInputAnalyzer::ERROR_NO_PATH = "<input_info>vfpathȂ";
const char* CInputAnalyzer::ERROR_NO_INPUT = "<input>Ȃ";


//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputAnalyzer::CInputAnalyzer( CInputManager* manager ) : m_pMyManager( manager )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputAnalyzer::~CInputAnalyzer()
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputAnalyzer::Analyze( const string& msg, map < int, CInputInfoList >* inputinfolist )
{
	map < int, CInputInfoList > :: iterator ite = inputinfolist->begin();
	while( ite != inputinfolist->end() )
	{
		( ite->second ).Clear();
		ite++;
	}

	CXMLManager xml;
	if( xml.LoadXML( msg.c_str() ) != 0 )
	{
		m_pMyManager->Error( msg, ERROR_NO_XML );
		return;
	}

	XMLNodeArray array;
	int node_size = xml.FindNodesByTagName( MSG_NODE_INPUTINFO, array );
	if( node_size < 1 )
	{
		m_pMyManager->Error( msg, ERROR_NO_INPUTINFO );
		return;
	}

	for( int j = 0; j < node_size; j++ )
	{
		XMLNodeArray input_array;
		if( xml.GetChildNodes( array[j], input_array ) < 1 )
		{
			return;
		}
	}

	map < int, CInputModality* >& moda = m_pMyManager->GetRegistedModality();
	map < int, CInputModality* > :: iterator ite_moda = moda.begin();
	while( ite_moda != moda.end() )
	{
		(ite_moda->second)->OnBeforeUpdate();
		ite_moda++;
	}
	

	for( int i = 0; i < node_size;  i++ )
	{
		string path;
		XMLAttributeList attr;

		xml.GetAttributes( array[i], attr );
		XMLAttributeList :: const_iterator c_ite = attr.find( MSG_ATTR_PATH );
		if( c_ite == attr.end() )
		{
			m_pMyManager->Error( msg, ERROR_NO_PATH );
			return;
		}
		path = c_ite->second;

		XMLNodeArray input_array;
		if( xml.GetChildNodes( array[i], input_array ) < 1 )
		{
			m_pMyManager->Error( msg, ERROR_NO_INPUT );
			return;
		}

		for( int j = 0; j < input_array.size(); j++ )
		{
			CInputInfo info;
			int ModalityID;
			if( AnalyzeInputNode( path, static_cast< MSXML2::IXMLDOMNode* >( input_array[j] ), ModalityID, info ) )
			{
				info.m_Enable = true;
			}
			else
			{
				info.m_Enable = false;
			}

			map < int, CInputInfoList > :: iterator ite = inputinfolist->find( ModalityID );
			if( ite != inputinfolist->end() )
			{
				CInputInfoList& inputlist = (*inputinfolist)[ModalityID];
				inputlist.Add( info );
			}
		}
	}

	ite_moda = moda.begin();
	while( ite_moda != moda.end() )
	{
		(ite_moda->second)->OnUpdateFinished();
		ite_moda++;
	}
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CInputAnalyzer::AnalyzeInputNode( const string& path, MSXML2::IXMLDOMNode* pNode, int& ModalityID, CInputInfo& info )
{
	CXMLManager xml;
	XMLAttributeList attr;
	XMLAttributeList :: iterator ite;

	if( xml.GetAttributes( pNode, attr ) < 3 ){	return false; }

	ite = attr.find( ATTR_NAME_TYPE );
	if( ite == attr.end() )
	{
		return false;
	}
	info.SetTypeAttr( static_cast< string >( ite->second ) );

	ite = attr.find( ATTR_NAME_EVENT );
	if( ite == attr.end() )
	{
		return false;
	}
	info.SetEventAttr( static_cast< string >( ite->second ) );

	ite = attr.find( ATTR_NAME_MATCH );
	if( ite == attr.end() )
	{
		return false;
	}
	info.SetMatchAttr( static_cast< string >( ite->second ) );

	ite = attr.find( ATTR_NAME_TARGET );
	if( ite != attr.end() )
	{
		info.SetTargetAttr( static_cast< string >( ite->second ) );
	}

	ite = attr.find( ATTR_NAME_RETURN );
	if( ite != attr.end() )
	{
		int start = 0;
		int end = 0;
		int pos = 0;
		CVariables vars;
		string str_return = static_cast< string >( ite->second );
		if( str_return.size() != 0 )
		{
			string var_name;
			while( ( end = str_return.find_first_of( ",", start ) ) != string::npos )
			{
				if( start != end )
				{
					vars.Add( str_return.substr( start, end - start ), CVariables::_UNDEFINED, pos );
				}
				start = end +1 ;
				pos++;
			}
			if( start != str_return.size() )
			{
				vars.Add( str_return.substr( start ), CVariables::_UNDEFINED, pos );
			}
			info.SetVariables( vars );
		}
	}

	map < int, CInputModality* >& RegistedModality = m_pMyManager->GetRegistedModality();
	map < int, CInputModality* > :: iterator ite2 = RegistedModality.begin();
	CInputModality* pmoda = NULL;

	while( ite2 != RegistedModality.end() )
	{
		pmoda = static_cast< CInputModality* >( ite2->second );
		if( pmoda->GetTypeAttribute() == info.GetTypeAttr() )
		{
			ModalityID = pmoda->GetID();
			return pmoda->Analyze( path, info );
		}
		ite2++;
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CInputAnalyzer::Validate( int ModalityID, CInputInfo& info )
{
	CInputInfoManager* iim = m_pMyManager->GetInputInfoManager();
	if( iim == NULL )
	{
		return false;
	}

	for( int i = 0; i < 2; i++ )
	{
		CInputInfoList* inputlist = iim->GetInputList( ModalityID, i );
		if( !inputlist ){ return false; }

		if( inputlist->Exist( info ) )
		{
			CVariables* var_user = info.GetVariablesPtr();
			CVariables* var_org = inputlist->GetVariablesPtrByInputInfo( info );
			if( !var_org ){ return false; }
			if( var_org->GetSize() > 0 && var_org->GetSize() == var_user->GetSize() )
			{
				for( int j = 0; j < var_org->GetSize(); j++ )
				{
					var_user->SetName( j, *( var_org->GetName( j ) ) );
				}
			}
			return true;
		}
	}

	return false;
}


