//
// MMIVXe Ver.1.1 tgGh
// ͊Ǘ
//
// InputInfo.h / InputInfo.cpp
//
// 2002/12/11 Wed. G
//
//
//

#include "StdAfx.h"
#include "InputInfo.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;

//
// CInputInfo
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfo::CInputInfo()
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfo::CInputInfo( const string& type, const string& event, const string& match, const string& target ) : m_Type( type ), m_Event( event ), m_Match( match ), m_Target( target ), m_Varlist(), m_Enable( false )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfo::CInputInfo( const string& type, const string& event, const string& match, const string& target, const CVariables& vars ) : m_Type( type ), m_Event( event ), m_Match( match ), m_Target( target ), m_Varlist( vars ), m_Enable( false )
{
	
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfo::~CInputInfo()
{
	m_Varlist.Clear();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
const string& CInputInfo::GetTypeAttr() const
{
	return m_Type;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
const string& CInputInfo::GetEventAttr() const
{
	return m_Event;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
const string& CInputInfo::GetMatchAttr() const
{
	return m_Match;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
const string& CInputInfo::GetTargetAttr() const
{
	return m_Target;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CVariables CInputInfo::GetVariables() const
{
	return m_Varlist;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CVariables* CInputInfo::GetVariablesPtr()
{
	return &m_Varlist;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfo::SetTypeAttr( const string& type )
{
	m_Type = type;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfo::SetEventAttr( const string& event )
{
	m_Event = event;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfo::SetMatchAttr( const string& match )
{
	m_Match = match;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfo::SetTargetAttr( const string& target )
{
	m_Target = target;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfo::SetVariables( const CVariables& vars )
{
	m_Varlist = vars;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
int CInputInfo::GetVarSize() const
{
	return m_Varlist.GetSize();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CInputInfo:: operator == ( const CInputInfo& info )
{
	if( &info == this ){ return true; }

	// target̗LȂ̂ŁAłׂ͒Ȃ
	if( m_Type == info.m_Type && m_Event == info.m_Event &&	m_Match == info.m_Match	)
	{
		return true;
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CInputInfo:: operator != ( const CInputInfo& info )
{
	if( &info == this ){ return false; }

	// targetׂ͒Ȃ
	if( m_Type != info.m_Type || m_Event != info.m_Event ||	m_Match != info.m_Match	)
	{
		return true;		
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfo& CInputInfo:: operator = ( const CInputInfo& info )
{
	if( &info == this ){ return *this; }

	m_Type = info.m_Type;
	m_Event = info.m_Event;
	m_Match = info.m_Match;
	m_Target = info.m_Target;
	m_Varlist = info.m_Varlist;

	return *this;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
string CInputInfo::toXML()
{
	string input = "<input type=\"";
	input += m_Type + "\" event=\"";
	input += m_Event+ "\" match=\"";
	input += m_Match+ "\"";
	if( m_Target.length() > 0 )
	{
		input += " target=\"" + m_Target + "\"";
	}
	input += "/>";
	input += m_Varlist.toXML();

	return input;
}


//
// CInputInfoList
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfoList::CInputInfoList() : m_TypeID( -1 )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfoList::CInputInfoList( const CInputInfoList& infolist ) : m_TypeID( -1 ), m_Inputs( infolist.m_Inputs )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfoList::~CInputInfoList()
{
	m_Inputs.clear();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfoList::Clear()
{
	m_Inputs.clear();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfoList::Update( const list < CInputInfo >& infolist )
{
	m_Inputs.clear();
	m_Inputs.assign( infolist.begin(), infolist.end() );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfoList::Add( const CInputInfo& info )
{
	m_Inputs.push_back( info );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfoList::Add( const string& type, const string& event, const string& match, const string& target, const CVariables& vars )
{
	m_Inputs.push_back( CInputInfo( type, event, match, target, vars ) );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfoList::Remove( const CInputInfo& info )
{
	list < CInputInfo > :: iterator ite = m_Inputs.begin();
	while( ite != m_Inputs.end() )
	{
		if( static_cast< CInputInfo >( *ite ) == info )
			ite = m_Inputs.erase( ite );
		else
			ite++;
	}
}

//
// ֐ : 
// @  \ : 
//    : info - Ώ
// ߂l : 
//
bool CInputInfoList::Exist( const CInputInfo& info )
{
	list < CInputInfo > :: iterator ite = m_Inputs.begin();
	while( ite != m_Inputs.end() )
	{
		if( *ite == info )
		{
			return true;
		}
		ite++;
	}
	return false;
}

//
// ֐ : 
// @  \ : ƓCInputInfo̕ϐԂ
//    : 
// ߂l : 
//
CVariables* CInputInfoList::GetVariablesPtrByInputInfo( const CInputInfo& info )
{
	list < CInputInfo > :: iterator ite = m_Inputs.begin();
	while( ite != m_Inputs.end() )
	{
		if( static_cast< CInputInfo& >( *ite ) == info )
		{
			return (*ite).GetVariablesPtr();
		}
		ite++;
	}
	return NULL;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
list < CInputInfo >* CInputInfoList::GetList()
{
	return &m_Inputs;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CInputInfoList:: operator == ( const CInputInfoList& infolist )
{
	if( &infolist == this ){ return true; }

	if( m_Inputs.size() == infolist.m_Inputs.size() )
	{
		list < CInputInfo > :: iterator lhs = m_Inputs.begin();
		list < CInputInfo > :: iterator rhs = const_cast< CInputInfoList& >( infolist ).m_Inputs.begin();

		while( lhs != m_Inputs.end() )
		{
			if( *lhs != *rhs )
			{
				return false;
			}
			lhs++;
			rhs++;
		}
	}
	return true;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfoList& CInputInfoList:: operator = ( const CInputInfoList& infolist )
{
	if( &infolist == this ){ return *this; }
	
	m_TypeID = infolist.m_TypeID;
	m_Inputs.clear();
	m_Inputs.assign( infolist.m_Inputs.begin(), infolist.m_Inputs.end() );

	return *this;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
string CInputInfoList::toXML()
{
	string ret = "";
	list < CInputInfo > :: iterator ite = m_Inputs.begin();

	while( ite != m_Inputs.end() )
	{
		ret += (*ite).toXML();
		ret += "\r\n";
		ite++;
	}
	return ret;
}