//
// MMIVXe Ver.1.1 tgGh
// ͊Ǘ
//
// InputInfo.h / InputInfo.cpp
//
// 2002/12/11 Wed. G
//
//
//

#ifndef _INPUTINFO_H_
#define _INPUTINFO_H_

#pragma once

#include <string>
#include <map>
#include <list>

#include "Variables.h"

using namespace std;

//
// CInpuInfo
//
class CInputInfo
{
private:
	string m_Type;		 // typel
	string m_Event;		 // eventl
	string m_Match;		 // matchl
	string m_Target;	 // targetl
	CVariables m_Varlist; // ϐ

public:
	bool m_Enable;		 // Lȓ͂
	string m_Ext1;		 // g̈
	string m_Ext2;		 // g̈
	
public:
	CInputInfo();
	CInputInfo( const string& type, const string& event, const string& match, const string& target );
	CInputInfo( const string& type, const string& event, const string& match, const string& target, const CVariables& vars );
	virtual ~CInputInfo();

	const string& GetTypeAttr() const;
	const string& GetEventAttr() const;
	const string& GetMatchAttr() const;
	const string& GetTargetAttr() const;
	CVariables GetVariables() const;
	CVariables* GetVariablesPtr();

	void SetTypeAttr( const string& type );
	void SetEventAttr( const string& event );
	void SetMatchAttr( const string& match );
	void SetTargetAttr( const string& target );
	void SetVariables( const CVariables& vars );

	int GetVarSize() const;
	
	bool operator == ( const CInputInfo& info );
	bool operator != ( const CInputInfo& info );
	CInputInfo& operator = ( const CInputInfo& info );

	string toXML();

};


//
// CInputInfoList
//
class CInputInfoList  
{
private:
	int m_TypeID;
	list < CInputInfo > m_Inputs;

public:
	CInputInfoList();
	CInputInfoList( const CInputInfoList& infolist );
	virtual ~CInputInfoList();

	void Update( const list < CInputInfo >& inputs );
	void Clear();
	void Add( const CInputInfo& info );
	void Add( const string& type, const string& event, const string& match, const string& target, const CVariables& vars );
	void Remove( const CInputInfo& info );
	bool Exist( const CInputInfo& info );
	CVariables* GetVariablesPtrByInputInfo( const CInputInfo& info );
	list < CInputInfo >* GetList();

	bool operator == ( const CInputInfoList& infolist );
	CInputInfoList& operator = ( const CInputInfoList& infolist );

	string toXML();
};

#endif _INPUTINFO_H_