//
// MMIVXe Ver.1.1 tgGh
// ͊Ǘ
//
// InputInfoManager.h / InputInfoManager.cpp
//
// 2002/12/11 Wed. G
//
//
//

#include "StdAfx.h"
#include "InputInfoManager.h"

#include <fstream>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;

//
// CInputInfoManager
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfoManager::CInputInfoManager()
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfoManager::~CInputInfoManager()
{
	m_InputList[0].clear();
	m_InputList[1].clear();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CInputInfoManager::AddNormal( int ModalityID, const string& type, const string &event, const string &match, const string& target, const CVariables& vars )
{
	map < int, CInputInfoList > :: const_iterator c_ite = m_InputList[0].find( ModalityID );
	if( c_ite != m_InputList[0].end() )
	{
		static_cast< CInputInfoList >( c_ite->second ).Add( type, event, match, target, vars );
		return true;
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CInputInfoManager::AddNormal( int ModalityID, const CInputInfo& info )
{
	map < int, CInputInfoList > :: const_iterator c_ite = m_InputList[0].find( ModalityID );
	if( c_ite != m_InputList[0].end() )
	{
		static_cast< CInputInfoList >( c_ite->second ).Add( info );
		return true;
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CInputInfoManager::AddInterrupt( int ModalityID, const string& type, const string &event, const string &match, const string& target, const CVariables& vars )
{
	map < int, CInputInfoList > :: const_iterator c_ite = m_InputList[1].find( ModalityID );
	if( c_ite != m_InputList[1].end() )
	{
		static_cast< CInputInfoList >( c_ite->second ).Add( type, event, match, target, vars );
		return true;
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CInputInfoManager::AddInterrupt( int ModalityID, const CInputInfo& info )
{
	map < int, CInputInfoList > :: const_iterator c_ite = m_InputList[1].find( ModalityID );
	if( c_ite != m_InputList[1].end() )
	{
		static_cast< CInputInfoList >( c_ite->second ).Add( info );
		return true;
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfoManager::Clear()
{
	m_InputList[0].clear();
	m_InputList[1].clear();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfoManager::Clear( int index )
{
	if( index < 0 || 1 < index ){ return; }
	m_InputList[index].clear();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfoManager::ClearNormalInput()
{
	m_InputList[0].clear();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfoManager::ClearInterruptInput()
{
	m_InputList[1].clear();
}

//
// ֐ : 
// @  \ : 
//    : ModalityID - 擾郂_eBID
//        : idx - 0Ȃʏ́A1Ȃ犄荞ݗp̓͂Ԃ 
// ߂l : 
//
CInputInfoList* CInputInfoManager::GetInputList( int ModalityID, int idx )
{
	if( idx < 0 || 1 < idx ){ return NULL; }

	map < int, CInputInfoList > :: iterator c_ite = m_InputList[idx].begin();
	if( c_ite != m_InputList[idx].end() )
	{
		map < int, CInputInfoList > :: iterator ite = m_InputList[idx].begin();
		while( ite != m_InputList[idx].end() )
		{
			if( ite->first == ModalityID )
			{
				return &(ite->second);
			}
			ite++;
		}
	}
	return NULL;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfoList* CInputInfoManager::GetInputListN( int ModalityID ) const
{
	map < int, CInputInfoList > :: const_iterator c_ite = const_cast< map < int, CInputInfoList >& >( m_InputList[0] ).find( ModalityID );
	if( c_ite != m_InputList[0].end() )
	{
		return &( const_cast< map < int, CInputInfoList >& >( m_InputList[0] )[ModalityID] );
	}
	return NULL;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfoList* CInputInfoManager::GetInputListI( int ModalityID ) const
{
	map < int, CInputInfoList > :: const_iterator c_ite = const_cast< map < int, CInputInfoList >& >( m_InputList[1] ).find( ModalityID );
	if( c_ite != m_InputList[1].end() )
	{
		return &( const_cast< map < int, CInputInfoList >& >( m_InputList[1] ) )[ModalityID];
	}
	return NULL;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfoManager::UpdateNormal( const map < int, CInputInfoList > normal )
{
	map < int, CInputInfoList >& nor = const_cast< map < int, CInputInfoList >& >( normal );
	map < int, CInputInfoList > :: iterator ite = nor.begin();

	m_InputList[0].clear();
	while( ite != nor.end() )
	{
		m_InputList[0].insert( pair< int, CInputInfoList >( ite->first, ite->second ) );
		ite++;
	}
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfoManager::UpdateInterrupt( const map < int, CInputInfoList > interrupt )
{
	map < int, CInputInfoList >& inter = const_cast< map < int, CInputInfoList >& >( interrupt );
	map < int, CInputInfoList > :: iterator ite = inter.begin();

	m_InputList[1].clear();
	while( ite != inter.end() )
	{
		m_InputList[1].insert( pair< int, CInputInfoList >( static_cast< int >( ite->first ), static_cast< CInputInfoList >( ite->second ) ) );
		ite++;
	}
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
map < int, CInputInfoList >* CInputInfoManager::GetInput( int index )
{
	if( index < 0 || 1 < index ){ return NULL; }
	return &(m_InputList[index]);
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
map < int, CInputInfoList >& CInputInfoManager::GetNormalInput()
{
	return m_InputList[0];
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
map < int, CInputInfoList >& CInputInfoManager::GetInterruptInput()
{
	return m_InputList[1];
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfoManager::RegistModality( int ModalityID )
{
	m_InputList[0].insert( pair< int, CInputInfoList >( ModalityID, CInputInfoList() ) );
	m_InputList[1].insert( pair< int, CInputInfoList >( ModalityID, CInputInfoList() ) );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputInfoManager::UnregistModality( int ModalityID )
{
	m_InputList[0].erase( ModalityID );
	m_InputList[1].erase( ModalityID );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
#ifdef _DEBUG
void CInputInfoManager::toXML()
{

	fstream fs( "AcceptInput.txt", ios::app | ios::out );
	fs << "***** Update Input *****" << endl;
	fs << endl;

	for( int i = 0; i < 2; i++ )
	{
		fs << "- Normal Input List -" << endl;
		map < int, CInputInfoList > :: iterator ite = m_InputList[i].begin();
		while( ite != m_InputList[i].end() )
		{
			CInputInfoList& input_list = static_cast< CInputInfoList >( ite->second );
			fs << input_list.toXML();
			ite++;
		}
		fs << endl;
	}
	fs.close();

}
#endif _DEBUG