//
// MMIVXe Ver.1.1 tgGh
// ͊Ǘ
//
// InputInfoManager.h / InputInfoManager.cpp
//
// 2002/12/11 Wed. G
//
//
//

#ifndef _INPUTINFOMANAGER_H_
#define _INPUTINFOMANAGER_H_

#pragma once

#include "InputInfo.h"

using namespace std;

class CInputInfoManager  
{
private:
	map < int, CInputInfoList > m_InputList[2];

public:
	CInputInfoManager();
	virtual ~CInputInfoManager();

	bool AddNormal( int ModalityID, const CInputInfo& info );
	bool AddNormal( int ModalityID, const string& type, const string& event, const string& match, const string& target, const CVariables& vars );
	bool AddInterrupt( int ModalityID, const CInputInfo& info );
	bool AddInterrupt( int ModalityID, const string& type, const string& event, const string& match, const string& target, const CVariables& vars );

	void Clear();
	void ClearNormalInput();
	void ClearInterruptInput();
	void Clear( int index );

	void UpdateNormal( const map < int, CInputInfoList > normal );
	void UpdateInterrupt( const map < int, CInputInfoList > interrupt );

	map < int, CInputInfoList >& GetNormalInput();
	map < int, CInputInfoList >& GetInterruptInput();
	map < int, CInputInfoList >* GetInput( int index );

	CInputInfoList* GetInputListN( int ModalityID ) const;
	CInputInfoList* GetInputListI( int ModalityID ) const;
	CInputInfoList* GetInputList( int ModalityID, int idx );

	void RegistModality( int ModalityID );
	void UnregistModality( int ModalityID );

#ifdef _DEBUG
	void toXML();
#endif _DEBUG


};

#endif _INPUTINFOMANAGER_H_
