//
// MMIVXe Ver.1.1 tgGh
// ͊Ǘ
//
// InputManager.h / InputManager.cpp
//
// 2002/12/12 Thur. G
//
//
//

#include "StdAfx.h"
#include "InputManager.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;

//
// CInputManager
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputManager::CInputManager() : m_IIMngr(), m_RegistedModality(), m_pCommunicater( NULL ), m_pInputTracer( NULL ), m_pOutputManager( NULL ),m_pProcessTracer( NULL ), m_InputState( true )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputManager::~CInputManager()
{
	m_IIMngr.Clear();
	if( m_RegistedModality.size() > 0 )
	{
		CInputModality* pmoda = NULL;
		map < int, CInputModality* > :: iterator ite = m_RegistedModality.begin();
		while( ite != m_RegistedModality.end() )
		{
			delete static_cast< CInputModality* >( ite->second );
			ite++;
		}
		m_RegistedModality.clear();
	}
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputManager::Init( CCommunicater* pComm, COutputManager* pOM, CProcessTracer* process, CInputTracer* input )
{
	m_pCommunicater = pComm;
	m_pOutputManager = pOM;
	m_pProcessTracer = process;
	m_pInputTracer = input;
	m_InputState = true;

	m_IIMngr.Clear();
	m_RegistedModality.clear();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputManager::Analyze( bool flag, const string msg )
{
	m_pInputTracer->RemoveAll();


	CInputAnalyzer ana( this );

	if( flag )
	{
		ana.Analyze( msg, m_IIMngr.GetInput( 0 ) );
	}
	else
	{
		ana.Analyze( msg, m_IIMngr.GetInput( 1 ) );
	}

	for( int i = 0; i < 2; i++ )
	{
		map < int ,CInputInfoList >* input = m_IIMngr.GetInput( i );
		if( input )
		{
			map < int, CInputInfoList > :: iterator ite = input->begin();
			while( ite != input->end() )
			{
				list < CInputInfo >* info_list = (ite->second).GetList();
				list < CInputInfo > :: iterator ite_info = info_list->begin();
				while( ite_info != info_list->end() )
				{
					m_pInputTracer->AddInput( (*ite_info) );
					ite_info++;
				}
				ite++;
			}
		}
	}
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputManager::Validate( int ModalityID, CInputInfo& info )
{
	m_pProcessTracer->Write( "͊Ǘ", " - [U" );
	m_pProcessTracer->Append( " - " );
	m_pProcessTracer->AppendLine( info.toXML().c_str() );

	CInputAnalyzer ana( this );

	if( m_InputState )
	{
		if( m_pOutputManager->GetState() )
		{
			m_pOutputManager->Terminate();
		}

		if( ana.Validate( ModalityID, info ) )
		{
			NotifyInput( info );
		}
	}
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputManager::NotifyInput( CInputInfo& info )
{
	sndPlaySound( "chimes.wav", SND_ASYNC );
	m_pProcessTracer->Append( " - ʒm - " );
	m_pProcessTracer->AppendLine( info.toXML().c_str() );
	m_pCommunicater->Send( CCommunicater::_COMMAND_USER_INPUT, info.toXML() );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CInputManager::Regist( CInputModality* moda )
{
	int id = moda->GetID();
	map < int, CInputModality* > :: const_iterator c_ite = m_RegistedModality.find( id );
	if( c_ite == m_RegistedModality.end() )
	{
		m_RegistedModality.insert( pair< int, CInputModality* >( id, moda ) );
		m_IIMngr.RegistModality( id );
		return true;
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CInputManager::Release( CInputModality* moda )
{
	int id = moda->GetID();
	map < int, CInputModality* > :: const_iterator c_ite = m_RegistedModality.find( id );
	if( c_ite == m_RegistedModality.end() )
	{
		return false;
	}
	m_RegistedModality.erase( id );
	m_IIMngr.UnregistModality( id );
	return true;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputTracer* CInputManager::GetInputTracer()
{
	return m_pInputTracer;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CInputInfoManager* CInputManager::GetInputInfoManager()
{
	return &m_IIMngr;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
map < int, CInputModality* >& CInputManager::GetRegistedModality()
{
	return m_RegistedModality;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputManager::Error( const string& msg, const string& comment )
{
	
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CInputManager::SetState( bool state )
{
	m_InputState = state;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CInputManager::GetState()
{
	return m_InputState;
}



