//
// MMIVXe Ver.1.1 tgGh
// ͊Ǘ
//
// InputManager.h / InputManager.cpp
//
// 2002/12/11 Wed. G
//
//
//

#ifndef _INPUTMANAGER_H_
#define _INPUTMANAGER_H_

#pragma once

#include "InputInfo.h"
#include "InputInfoManager.h"
#include "InputModality.h"
#include "InputAnalyzer.h"
#include "Communicater.h"
#include "InputTracer.h"
#include "OutputManager.h"
#include "ProcessTracer.h"

using namespace std;

class COutputManager;
class CInputModality;
class CInputAnalyzer;
class CCommunicater;

class CInputManager
{
private:
	CInputInfoManager m_IIMngr;
	map < int, CInputModality* > m_RegistedModality;
	CCommunicater* m_pCommunicater;
	CInputTracer* m_pInputTracer;
	COutputManager* m_pOutputManager;
	CProcessTracer* m_pProcessTracer;
	bool m_InputState;

public:
	CInputManager();
	virtual ~CInputManager();

	void Init( CCommunicater* pComm, COutputManager* pOM, CProcessTracer* process, CInputTracer* input );
	void Analyze( bool flag, const string msg );
	void Validate( int ModalityID, CInputInfo& info );
	bool Regist( CInputModality* moda );
	bool Release( CInputModality* moda );
	void NotifyInput( CInputInfo& info );
	void Error( const string& msg, const string& comment );

public:
	CInputInfoManager* GetInputInfoManager();
	CInputTracer* GetInputTracer();
	void SetState( bool state = false );
	bool GetState();
	map < int, CInputModality* >& GetRegistedModality();

};

#endif _INPUTMANAGER_H_
