//
// MMIVXe Ver.1.1 tgGh
// GUI
//
// InputTracer.h / InputTracer.cpp
//
// 2002/10/25 Fri. G
//
//
//
#include "stdafx.h"
#include "Kiosk.h"
#include "InputTracer.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

BEGIN_MESSAGE_MAP( CInputTracer, baseCInputTracer )
	ON_WM_CREATE()
	ON_WM_SIZE()
END_MESSAGE_MAP()

CInputTracer::CInputTracer()
{

}

CInputTracer::~CInputTracer()
{

}

int CInputTracer::OnCreate( LPCREATESTRUCT lpCreateStruct )
{
	if( baseCInputTracer::OnCreate( lpCreateStruct ) == -1 )
	{
		return -1;
	}

	SetSCBStyle( GetSCBStyle() | SCBS_SIZECHILD );

	if( !m_ListCtrl.Create( WS_VISIBLE | WS_CHILD | LVS_REPORT, CRect( 0, 0, 0, 0 ), this, IDV_INPUTLIST ) )
	{
		return -1;
	}

	m_ListCtrl.ModifyStyleEx( 0, WS_EX_CLIENTEDGE );
	m_ListCtrl.SetExtendedStyle( LVS_EX_FULLROWSELECT | LVS_EX_ONECLICKACTIVATE );
	m_ListCtrl.Initialize();

	return 0;
}

void CInputTracer::OnSize( UINT nType, int cx, int cy )
{
	baseCInputTracer::OnSize( nType, cx, cy );
}

CInputListView& CInputTracer::GetListCtrlRef()
{
	return m_ListCtrl;
}

void CInputTracer::AddInput( const CInputInfo& info )
{
	m_ListCtrl.SetInput( const_cast< CInputInfo&>( info ) );
}

void CInputTracer::RemoveAll()
{
	m_ListCtrl.RemoveAll();
}