
#include "stdafx.h"
#include "Kiosk.h"

#include "MainFrame.h"
#include "IEFrame.h"
#include "IEModalDialog.h"

#include <winsock.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


BEGIN_MESSAGE_MAP(CKioskApp, CWinApp)
	//{{AFX_MSG_MAP(CKioskApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
	ON_COMMAND(ID_FILE_NEW, OnFileNew)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


CKioskApp::CKioskApp()
{
}

CKioskApp theApp;

BOOL CKioskApp::InitInstance()
{
	AfxEnableControlContainer();

#ifdef _AFXDLL
	Enable3dControls();
#else
	Enable3dControlsStatic();
#endif

	if(m_pszProfileName)
	{
		delete ((void*)m_pszProfileName);
		m_pszProfileName = new char [MAX_PATH];
		if(!m_pszProfileName)
		{
			AfxMessageBox("܂");
			return FALSE;
		}
		::GetCurrentDirectory(MAX_PATH,(LPTSTR)m_pszProfileName);
		strcat((LPTSTR)m_pszProfileName,"\\Galatea.ini");
	}

//	SetRegistryKey(_T("MMISystem Frontend for Kiosk Edition"));

	CMDIFrameWnd* pFrame = new CMainFrame;
	m_pMainWnd = pFrame;

	if (!pFrame->LoadFrame(IDR_MAINFRAME))
		return FALSE;

	HINSTANCE hInst = AfxGetResourceHandle();
	m_hMDIMenu  = ::LoadMenu( hInst, MAKEINTRESOURCE( IDR_MAINFRAME ) );
	m_hMDIAccel = ::LoadAccelerators( hInst, MAKEINTRESOURCE( IDR_MAINFRAME ) );

	pFrame->ShowWindow(m_nCmdShow);
	pFrame->UpdateWindow();

	// WinSock̏
//	int		nResult;
//	WORD	wRequireVersion;	// gpWinSock̃o[W
//	WSADATA	lpWSAData;			// WinSocǩ

	// WinSock2gpWinSock̃o[WƂĐݒ
//	wRequireVersion = MAKEWORD( 2, 0 );

	// WinSock̏sȂ
//	nResult = WSAStartup( wRequireVersion, &lpWSAData );
//	if( nResult != 0  )
//	{
//		cerr << "WinSock̏Ɏs" << endl;
//	}

	// WinSock̃o[Wv̂mF
//	if( lpWSAData.wVersion != wRequireVersion )
//	{
//		cerr << "vWinSock̃o[W擾ł܂ł" << endl;
//	}

	return TRUE;
}

int CKioskApp::ExitInstance() 
{
	if (m_hMDIMenu != NULL)
		FreeResource( m_hMDIMenu );
	if (m_hMDIAccel != NULL)
		FreeResource( m_hMDIAccel );

	if(m_pszProfileName)
	{
		delete ((void*)m_pszProfileName );
		m_pszProfileName = NULL;
	}

	WSACleanup();
	return CWinApp::ExitInstance();
}

void CKioskApp::OnFileNew() 
{
	/*
	CMainFrame* pFrame = STATIC_DOWNCAST( CMainFrame, m_pMainWnd );

	pFrame->CreateNewChild(	RUNTIME_CLASS( CIEFrame ), IDR_MAINFRAME, m_hMDIMenu, m_hMDIAccel );
	*/
}

CIEFrame* CKioskApp::CreateBrowser()
{
	CMainFrame *pMainFrame = STATIC_DOWNCAST( CMainFrame, m_pMainWnd );
	CIEFrame* pBrowser = ( CIEFrame* )pMainFrame->CreateNewChild( RUNTIME_CLASS( CIEFrame ), IDR_KIOSKTYPE, m_hMDIMenu, m_hMDIAccel );
	return pBrowser;	
}


class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);
	//}}AFX_VIRTUAL

protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CKioskApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

BOOL CKioskApp::PreTranslateMessage(MSG* pMsg) 
{
	static char key;
	static CVariables vars;
	switch( pMsg->message )
	{
	case WM_KEYDOWN :
		if( m_pKeyInput )
		{
			key = pMsg->wParam;
			vars.Add( CKeyInput::_TEMPORARY_NAME, &key, 0 );
			m_pKeyInput->Input( CKeyInput::_TYPE_KEY, CKeyInput::_EVENT_PRESS, &key, "", vars );
			vars.Clear();
		}
		break;
	default:
		break;
	}
	return CWinApp::PreTranslateMessage(pMsg);
}
