//
// MMIVXe Ver.1.1 tgGh
// GUI
//
// MessageTracer.h / MessageTracer.cpp
//
// 2002/10/25 Fri. G
//
//
//

#include "stdafx.h"
#include "kiosk.h"
#include "MessageTracer.h"

#include <string>

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;


//
// CMessageTracer
//

BEGIN_MESSAGE_MAP( CMessageTracer, baseCMessageTracer )
	ON_WM_CREATE()
	ON_WM_SIZE()
END_MESSAGE_MAP()


const char* CMessageTracer::_MESSAGE_ACCEPTED =	 " - Connection Accepted.\r\n";
const char* CMessageTracer::_MESSAGE_RECEIVED =	 " - Message Received.\r\n";
const char* CMessageTracer::_MESSAGE_CLOSED =		 " - Connection Closed.\r\n";
const char* CMessageTracer::_MESSAGE_SENDED = " - Message Sended.\r\n";


//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CMessageTracer::CMessageTracer()
{

}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
CMessageTracer::~CMessageTracer()
{

}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
void CMessageTracer::OnSize( UINT nType, int cx, int cy )
{
	m_Edit.MoveWindow( 0, 0, cx, cy );
	baseCMessageTracer::OnSize( nType, cx, cy );
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
int CMessageTracer::OnCreate( LPCREATESTRUCT lpCreateStruct )
{
	if( baseCMessageTracer::OnCreate( lpCreateStruct ) == -1 )
	{
		return -1;
	}

	SetBarStyle( GetSCBStyle() | SCBS_SIZECHILD );

	DWORD dwStyle = ES_AUTOVSCROLL | ES_MULTILINE | ES_WANTRETURN | ES_LEFT | ES_READONLY;
	if( !m_Edit.Create( dwStyle | WS_CHILD | WS_VISIBLE | WS_VSCROLL, CRect(0,0,0,0), this, IDV_EDITCTRL ) )
	{
		return -1;
	}

	m_Edit.ModifyStyleEx( 0, WS_EX_CLIENTEDGE );

	return 0;
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
void CMessageTracer::OnAccepted()
{
	CString log;
	m_Edit.GetWindowText( log );
	CTime time = CTime::GetCurrentTime();
	log += (LPCSTR)time.Format( "%H:%M:%S");
	log += _MESSAGE_ACCEPTED;
	m_Edit.SetWindowText( log );
	m_Edit.LineScroll( m_Edit.GetLineCount() );
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
void CMessageTracer::OnClosed()
{
	CString log;
	m_Edit.GetWindowText( log );
	CTime time = CTime::GetCurrentTime();
	log += (LPCSTR)time.Format( "%H:%M:%S");
	log += _MESSAGE_CLOSED;
	log += "\r\n\r\n";
	m_Edit.SetWindowText( log );
	m_Edit.LineScroll( m_Edit.GetLineCount() );
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
void CMessageTracer::OnSended( const string& sended )
{
	CString log;
	m_Edit.GetWindowText( log );
	CTime time = CTime::GetCurrentTime();
	log += (LPCSTR)time.Format( "%H:%M:%S");
	log += _MESSAGE_SENDED;
	log += sended.c_str();
	log += "\r\n";
	m_Edit.SetWindowText( log );
	m_Edit.LineScroll( m_Edit.GetLineCount() );
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
void CMessageTracer::OnReceived( const string& received )
{
	CString log;
	m_Edit.GetWindowText( log );
	CTime time = CTime::GetCurrentTime();
	log += (LPCSTR)time.Format( "%H:%M:%S");
	log += _MESSAGE_RECEIVED;
	log += received.c_str();
	log += "\r\n";
	m_Edit.SetWindowText( log );
	m_Edit.LineScroll( m_Edit.GetLineCount() );
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
void CMessageTracer::Append( LPCSTR str )
{
	CString log;
	m_Edit.GetWindowText( log );
	log += str;
	m_Edit.SetWindowText( log );
	m_Edit.LineScroll( m_Edit.GetLineCount() );
}

//
// ֐ : 
// @  \ : 
//    :
// ߂l :
//
void CMessageTracer::AppendLine( LPCSTR str )
{
	CString log;
	m_Edit.GetWindowText( log );
	log += str;
	log += "\r\n";
	m_Edit.SetWindowText( log );
	m_Edit.LineScroll( m_Edit.GetLineCount() );
}

