// OpenXisl.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "kiosk.h"
#include "OpenXisl.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COpenXisl _CAO


COpenXisl::COpenXisl(CWnd* pParent /*=NULL*/)
	: CDialog(COpenXisl::IDD, pParent)
{
	//{{AFX_DATA_INIT(COpenXisl)
	m_strXISL = _T("");
	//}}AFX_DATA_INIT
}


void COpenXisl::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COpenXisl)
	DDX_Control(pDX, IDC_COMBO_XISL, m_cmbXISL);
	DDX_CBString(pDX, IDC_COMBO_XISL, m_strXISL);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COpenXisl, CDialog)
	//{{AFX_MSG_MAP(COpenXisl)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


BOOL COpenXisl::OnInitDialog() 
{
	CDialog::OnInitDialog();

	CWinApp *pApp = AfxGetApp();

	CString strURINum;
	CString strURI;
	for(int i=0; i<5; i++)
	{
		strURINum.Format("DocURI%d",i);
		strURI = pApp->GetProfileString("RecentXISL",strURINum,"");
		if(strURI.IsEmpty())
			break;
		m_cmbXISL.AddString(strURI);
		m_slURI.AddTail(strURI);
	}
	UpdateData( FALSE );
	
	return FALSE;
}

void COpenXisl::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	UpdateData();

	CWinApp *pApp = AfxGetApp();

	int nSelect = m_cmbXISL.GetCurSel();
	if(nSelect == -1)
		m_slURI.AddHead(m_strXISL);
	else
	{
		POSITION pos = m_slURI.FindIndex(nSelect);
		m_slURI.AddHead(m_slURI.GetAt(pos));
		m_slURI.RemoveAt(pos);
	}

	if(m_slURI.GetCount() > 5)
		m_slURI.RemoveTail();

	CString strURINum;
	int nCount = m_slURI.GetCount();
	POSITION pos = m_slURI.GetHeadPosition();
	for(int i=0; i<nCount; i++)
	{
		strURINum.Format("DocURI%d",i);
		pApp->WriteProfileString("RecentXISL",strURINum,m_slURI.GetNext(pos));
	}
	CDialog::OnOK();
}
