//
// MMIVXetgGhVer1.1
// o͊Ǘ
//
// OutputModality.h / OutputModality.cpp
//
// 2002/12/12 Thur. G
//
//
//

#ifndef _OUTPUTMODALITY_H_
#define _OUTPUTMODALITY_H_

#pragma once

#include "OutputManager.h"
#include "OutputCommand.h"

using namespace std;
using namespace OUTPUT;

class COutputCommand;
class COutputManager;

class COutputModality  
{
protected:
	COutputManager* m_pMyManager;
	int m_ModalityID;
	bool m_State;
	list < COutputCommand* > m_Cmdlist;

public:
	COutputModality( COutputManager* manager, int ModalityID );
	virtual ~COutputModality();

	int GetID();
	virtual bool Regist();
	virtual bool Release();
	
	bool GetState();
	void SetState( bool state );

	virtual string GetTypeAttribute() = 0;
	virtual list < string > GetEventAttribute() = 0;
	virtual COutputCommand* StoreCommand( const string& msg ) = 0;
	virtual bool Execute();
	virtual bool Terminate() = 0;
	void Finish();
	void Error( COutputCommand* pcmd, const string& message );
	void Error( const string& msg );
	void Lock( bool state = false );

protected:
	void AddCommand( COutputCommand* pcmd );

	bool GetNodeValue( CXMLManager& xml, string& name, string& value );
	bool GetNodeAttr( CXMLManager& xml, string& node, string& attr, string& value );
	bool AnalyzeOutput( const string& msg, string& count, bool& bargein, string& path, string& event, CVariables& vars, list < COutputParam >& pars );
	void RemoveCommand();

};

#endif _OUTPUTMODALITY_H_
