// SSMClient.cpp: CSSMClient NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Kiosk.h"
#include "SSMClient.h"
#include "TTSCtrl.h"
#include "FSMCtrl.h"
#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
// O		:UINT CSSMClient::RecvThread( LPVOID pParam )
// @\		:MpXbh
// 		:*lpParam - gւ̃|C^
// ߂l	:Ȃ
//
UINT CSSMClient::RecvThread( LPVOID pParam )
{
//	cout << "Enter Thread." << endl;

	CSSMClient *pSSMClient = (CSSMClient*)pParam;

	int nRecv;						// MTCYێ
	string strMsg;					// Mf[^i[
	char szBuff[RECV_BUFFER_SIZE+1];		// Mpobt@
	
	TRACE("SSMMJn\n");
	while( 1 )
	{
		szBuff[0] = '\0';
		nRecv = pSSMClient->m_Socket.Recv( szBuff );

		if( nRecv == SOCKET_ERROR )
		{
			int ret = WSAGetLastError();
			TRACE("SSMMs\n");
			break;
		}

		strMsg.append( szBuff, nRecv );		

		int nIndex = strMsg.find("./\n",0);
		while(nIndex != -1)
		{
			string str = strMsg.substr(0,nIndex);
			pSSMClient->AnalyzeMsg(str.c_str());
			strMsg.erase(0,nIndex+3);
			nIndex = strMsg.find("./\n",0);
		}
	}

//	pSSMClient->m_Socket.Close();
//	WSACleanup();
	return 0;
}

CSSMClient::CSSMClient(CTTSCtrl *pTTSCtrl)
{
	m_pTTSCtrl = pTTSCtrl;
	m_bSpeaking = false;
	m_bWait = false;
	m_bPhoneme = false;
	m_pThread = NULL;
//	WinSockInit();
}

CSSMClient::~CSSMClient()
{

}

//
// O		:void CSSMClient::WinSockInit()
// @\		:WinSock̏
// 		:Ȃ
// ߂l	:Ȃ
//
void CSSMClient::WinSockInit()
{
	// WinSock̏
	int		nResult;
	WORD	wRequireVersion;	// gpWinSock̃o[W
	WSADATA	lpWSAData;			// WinSocǩ

	// WinSock2gpWinSock̃o[WƂĐݒ
	wRequireVersion = MAKEWORD( 2, 0 );

	// WinSock̏sȂ
	nResult = WSAStartup( wRequireVersion, &lpWSAData );
	if( nResult != 0  )
	{
//		cerr << "WinSock̏Ɏs" << endl;
	}

	// WinSock̃o[Wv̂mF
	if( lpWSAData.wVersion != wRequireVersion )
	{
//		cerr << "vWinSock̃o[W擾ł܂ł" << endl;
	}
}

//
// O		:void CSSMClient::Run()
// @\		:MpXbh̊Jn
// 		:Ȃ
// ߂l	:Ȃ
//
void CSSMClient::Run()
{
	if( m_Socket.IsValid() )
	{
		m_pThread = AfxBeginThread(RecvThread,(LPVOID)this);
//		m_dwThread = (DWORD)CreateThread( NULL, 0, CMsgServer::RecvThread,(LPVOID)this, 0, NULL );
		//m_dwThread = _beginthread( CMsgServer::RecvThread, 0, (LPVOID)this );
	}
}

//
// O		:void CSSMClient::Stop()
// @\		:MpXbh̒~
// 		:Ȃ
// ߂l	:Ȃ
//
void CSSMClient::Stop()
{
	SendMsg("set Run = EXIT./\n");
	// ڑҋ@p\Pbg
	m_Socket.Close();

	// XbhI܂őҋ@
	if(m_pThread != NULL)
		WaitForSingleObject( m_pThread->m_hThread, 2000 );

//	cout << "Thread End." << endl;
}

//
// O		:BOOL CSSMClient::Initialize()
// @\		:CX^X̏
// 		:
// ߂l	: - TRUE s - FALSE
//
BOOL CSSMClient::Initialize()
{
	CWinApp *pApp = AfxGetApp();
	CString strIP = pApp->GetProfileString("ENGINE","IP",NULL);
	int nPort = pApp->GetProfileInt("SSM","Port",10600);
	
	if( !m_Socket.IsValid() )
	{
		if(!m_Socket.Socket())
		{
			TRACE("\Pbg쐬s");
			return -1;
			//return FALSE;
		}
	}

	if(!m_Socket.Connect(strIP,nPort))
	{
		TRACE("ڑvs");
		return -2;
		//return FALSE;
	}
	return 0;
	//return TRUE;
}


//
// O		:BOOL CSSMClient::SendMsg( LPCTSTR lpszMsg )
// @\		:msg𑗐M
// 		:&msg - M郁bZ[W
// ߂l	: - TRUE s - FALSE
//
BOOL CSSMClient::SendMsg( LPCTSTR lpszMsg )
{
	// bZ[W̃TCY𒲂ׂāASMł܂łЂsend
	string msg = lpszMsg;
	size_t nSize = msg.length();
	size_t nRet = 0;
	m_Socket.Lock();
	int nRetBuf;
	while( 1 )
	{
		if( nRet >= nSize )
			break;
		nRetBuf = m_Socket.Send( &msg[nRet], nSize - nRet );
		if( nRetBuf == SOCKET_ERROR )
		{
			TRACE("SSM:Ms\n");
			break;
		}
		nRet += nRetBuf;
	}
	m_Socket.Unlock();
	return TRUE;
}

void CSSMClient::SetText(LPCTSTR lpszText,bool bWait)
{
	m_bWait = bWait;
	CString strCommand = "set Text = ";
	strCommand += lpszText;
	strCommand += "./\n";
	SendMsg(strCommand);
}

void CSSMClient::SetSpeaker(LPCTSTR lpszSpeaker)
{
	CString strCommand = "set Speaker =";
	strCommand += lpszSpeaker;
	strCommand += "./\n";
	SendMsg(strCommand);
}

void CSSMClient::Speak()
{
	SendMsg("set Speak = NOW./\n");
}

void CSSMClient::StopSpeak()
{
	SendMsg("set Speak = STOP./\n");
}


//rep Speak.stat = PROCESSING
//rep Text.text = ɂ
//rep Speak.text = ɂ
//rep Text.pho = sil[415] k[105] o[70] N[100] n[25] i[60] ch[100] i[50] w[60] a[95] sil[470]
//rep Speak.pho = sil[415] k[105] o[70] N[100] n[25] i[60] ch[100] i[50] w[60] a[95] sil[470]
//rep Text.dur = 1550
//rep Speak.dur = 1550
//rep Speak.stat = READY
//rep Speak.stat = SPEAKING
//rep Speak.len = 1550
//rep Speak.utt = sil[415] k[105] o[70] N[100] n[25] i[60] ch[100] i[50] w[60] a[95] sil[470]
//rep Speak.stat = IDLE
void CSSMClient::AnalyzeMsg(LPCTSTR lpszMsg)
{
	CString strMsg = lpszMsg;
	if(m_bPhoneme)
	{
		if(strMsg.Find("rep Text.dur") != -1)
		{
			strMsg.Remove(' ');
			int nIndex = strMsg.Find("=")+1;
			CString strDur = strMsg.Mid(nIndex,strMsg.GetLength()-nIndex);
			m_pTTSCtrl->OnSpeakReady(m_strPhoneme);
			m_pFSMCtrl->OnSpeakReady(m_strPhoneme,strDur);
			m_bPhoneme = false;
			return;
		}

		if(strMsg.Compare("phoneme_end\n") != 0)
		{
			strMsg.Replace("["," ");
			strMsg.Replace("]"," ");
			m_strPhoneme += strMsg;
		}
	}

	if(strMsg.Find("SPEAKING") != -1)
	{
		m_bSpeaking = true;
	}
	else if(strMsg.Find("READY") != -1)
	{
		if(!m_bWait)
			Speak();
	}
	else if(strMsg.Find("rep Speak.pho") != -1)
	{
		m_bPhoneme = true;
		m_strPhoneme.Empty();
	}
	else if(strMsg.Find("IDLE") != -1)
	{
		if(m_bSpeaking)
		{
			m_bSpeaking = false;
			m_pTTSCtrl->OnSpeakFinished();
//			m_pFSMCtrl->OnSpeakFinished();
		}
	}
}
