// SpeechOprDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "kiosk.h"
#include "SpeechOprDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern BOOL CALLBACK EnumWindowsProc(HWND hWnd, LPARAM lParam);
/////////////////////////////////////////////////////////////////////////////
// CSpeechOprDlg _CAO


CSpeechOprDlg::CSpeechOprDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSpeechOprDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSpeechOprDlg)
	m_strInfo = _T("");
	m_strSentence = _T("");
	//}}AFX_DATA_INIT
	Create(CSpeechOprDlg::IDD, pParent);
}


void CSpeechOprDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSpeechOprDlg)
	DDX_Text(pDX, IDC_EDIT_INFO, m_strInfo);
	DDX_Text(pDX, IDC_EDIT_SENTENCE, m_strSentence);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CSpeechOprDlg, CDialog)
	//{{AFX_MSG_MAP(CSpeechOprDlg)
	ON_WM_CTLCOLOR()
	ON_BN_CLICKED(IDC_BUTTON_REFRESH, OnButtonRefresh)
	ON_BN_CLICKED(IDC_BUTTON_STOP, OnButtonStop)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


void CSpeechOprDlg::AddNewGrm(LPCTSTR lpszGrmPath)
{
	m_lstGrmPath.push_back(string(lpszGrmPath));
	//GenerateSentence(lpszGrmPath);
}

void CSpeechOprDlg::ResetGrm()
{
	m_lstGrmPath.clear();
	m_strSentence.Empty();
	m_strInfo.Empty();
	UpdateData(FALSE);
}

void CSpeechOprDlg::GenerateSentence(LPCTSTR lpszGrmPath)
{
	//SECURITY_ATTRIBUTEݒ
	SECURITY_ATTRIBUTES securityAttr;
	securityAttr.nLength = sizeof( SECURITY_ATTRIBUTES );
	securityAttr.bInheritHandle = TRUE;
	securityAttr.lpSecurityDescriptor = NULL;
	//Wo͂Ҕ
	HANDLE hSaveStdout = GetStdHandle(STD_OUTPUT_HANDLE);
	HANDLE hSaveStderr = GetStdHandle(STD_ERROR_HANDLE);
	//qvZXւ̃pCvB
	HANDLE hChildStdoutWriteEnd;
	HANDLE hChildStdoutReadEnd;
	if (!CreatePipe(&hChildStdoutReadEnd, &hChildStdoutWriteEnd, &securityAttr, 0)) {
		return;
	}

	//qvZXN
//	PROCESS_INFORMATION procInfo;
	STARTUPINFO supInfo;
	ZeroMemory(&m_piExe, sizeof(PROCESS_INFORMATION));
	ZeroMemory(&supInfo, sizeof(STARTUPINFO));
	GetStartupInfo(&supInfo);
	supInfo.dwFlags		= STARTF_USESTDHANDLES | STARTF_USESHOWWINDOW;
	supInfo.wShowWindow = SW_SHOWMINNOACTIVE;
//	supInfo.wShowWindow = SW_MINIMIZE;
	supInfo.hStdOutput	= hChildStdoutWriteEnd;
	supInfo.hStdError	= hChildStdoutWriteEnd;

	CWinApp *pApp = AfxGetApp();
	CString strExe = pApp->GetProfileString("SRM","Generate",NULL);

//	CString strExe = "D:\\IPA\\engine\\SRM\\Galatea_SRM_Windows_0301\\bin\\generate.exe ";
	strExe += " ";
	strExe += lpszGrmPath;
//	strExe += " D:\\vO\\IPA\\SRM\\Galatea_SRM_Windows_alpha_021121\\GramJulian\\vfr\\vfr";

//	UpdateData(FALSE);
	if (!CreateProcess(NULL,
		strExe.GetBuffer(strExe.GetLength()),
		NULL, NULL, TRUE, 0, NULL, NULL,
		&supInfo,
		&m_piExe))
	{
		m_strSentence = "Can't execute! \"generate.exe\" ";
		GetDlgItem(IDC_EDIT_INFO)->SetWindowText(m_strInfo);
//		UpdateData(FALSE);
		return;
	}

	// ̃vZX̕Wo͂ɖ߂B
	if (!SetStdHandle(STD_OUTPUT_HANDLE, hSaveStdout)) {
		m_strSentence = "Can't Set StdHandle";
		GetDlgItem(IDC_EDIT_INFO)->SetWindowText(m_strInfo);
//		UpdateData(FALSE);
		return;
	}
	if (!SetStdHandle(STD_ERROR_HANDLE, hSaveStderr)) {
		m_strSentence = "Can't Set StdHandle";
		GetDlgItem(IDC_EDIT_INFO)->SetWindowText(m_strInfo);
//		UpdateData(FALSE);
		return;
	}
	//pCvǂݍޑOɏݒ[B
	if ( !CloseHandle( hChildStdoutWriteEnd ) ){
		m_strSentence = "Can't close handle";
		GetDlgItem(IDC_EDIT_INFO)->SetWindowText(m_strInfo);
//		UpdateData(FALSE);
		return;
	}

	//ǂݍ݂̃[v
	CString strResult;
	const	int		BUFSIZE = 16384;
	char	sBuffer[BUFSIZE];
	DWORD	dwRead;
	for (;;){
		if (!ReadFile(hChildStdoutReadEnd, sBuffer, BUFSIZE-1, &dwRead, NULL) || dwRead == 0) {
			break;
		} else {
			sBuffer[dwRead] = '\0';
			strResult += sBuffer;
		}
	}

	int nStart = strResult.Find("{");
	while(nStart != -1)
	{
		int nEnd = strResult.Find("}",nStart);
		strResult.Delete(nStart,nEnd-nStart+1);
		nStart = strResult.Find("{",nEnd);
	}

	int nIndex = strResult.Find("---");
	if(nIndex != -1)
	{
		strResult.Delete(0,nIndex);

		m_strSentence += strResult;
		m_strSentence.Replace("silB","");
		m_strSentence.Replace("silE","");

		nIndex = m_strSentence.Find("Reading",nIndex);
		if(nIndex != -1)
			m_strSentence.Delete(nIndex,m_strSentence.GetLength()-nIndex);

		m_strSentence.Replace("\n","\r\n");
	}
	else
		m_strSentence = "s";

	GetDlgItem(IDC_EDIT_SENTENCE)->SetWindowText(m_strSentence);

//	UpdateData(FALSE);

	// vZX̃^[R[h𒲂ׂ
//	GetExitCodeProcess(procInfo.hProcess, &pParam->dwReturnCode);
}

UINT CSpeechOprDlg::ThreadGenerateSentence(LPVOID pParam)
{
	CSpeechOprDlg *pSODlg = (CSpeechOprDlg*)pParam;
	pSODlg->GetDlgItem(IDC_BUTTON_STOP)->EnableWindow(TRUE);
	pSODlg->m_strInfo = "FDDD";
	pSODlg->GetDlgItem(IDC_EDIT_INFO)->SetWindowText(pSODlg->m_strInfo);

	list <string>::iterator ite = pSODlg->m_lstGrmPath.begin();
	while(ite != pSODlg->m_lstGrmPath.end())
	{
		pSODlg->GenerateSentence((*ite).c_str());
		ite++;
	}
	pSODlg->GetDlgItem(IDC_EDIT_INFO)->SetWindowText("");
	pSODlg->GetDlgItem(IDC_BUTTON_STOP)->EnableWindow(FALSE);

	return 0;
}

void CSpeechOprDlg::ViewSentence()
{
	if(!IsWindowVisible())
		return;

	m_strSentence.Empty();
	GetDlgItem(IDC_EDIT_SENTENCE)->SetWindowText("");

	if(m_lstGrmPath.size() != 0)
		AfxBeginThread(ThreadGenerateSentence, (void*)this);
	else
	{
		GetDlgItem(IDC_EDIT_INFO)->SetWindowText("@o^Ă܂");
	}
}

void CSpeechOprDlg::SetInfo(LPCTSTR lpszInfo)
{
	if(!IsWindowVisible())
		return;

	GetDlgItem(IDC_EDIT_INFO)->SetWindowText(lpszInfo);
}

/////////////////////////////////////////////////////////////////////////////
// CSpeechOprDlg bZ[W nh

void CSpeechOprDlg::PostNcDestroy() 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	delete this;
	CDialog::PostNcDestroy();
}

BOOL CSpeechOprDlg::PreTranslateMessage(MSG* pMsg) 
{
	// TODO: ̈ʒuɌŗL̏ǉ邩A܂͊{NXĂяoĂ
	if( pMsg->message == WM_KEYDOWN )
	{
        if(pMsg->wParam == VK_RETURN)
			return TRUE;
	}
	
	return CDialog::PreTranslateMessage(pMsg);
}

HBRUSH CSpeechOprDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor) 
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);
	
	// TODO: ̈ʒu DC ̃Agr[gύXĂ
	int nCtrlID = pWnd->GetDlgCtrlID();
	switch(nCtlColor)
	{
	case CTLCOLOR_STATIC:
		if(nCtrlID == IDC_EDIT_SENTENCE)
		{
			pDC->SetBkMode(OPAQUE);
			pDC->SetBkColor(RGB(0,80,0));// 
			pDC->SetTextColor(RGB(255,255,255));	// eLXgFݒ
			return (HBRUSH) m_brEdit;		// _~[uV
		}
		break;
	case CTLCOLOR_SCROLLBAR:
		pDC->SetBkMode(OPAQUE);
		pDC->SetBkColor(RGB(0,80,0));// 
		return (HBRUSH) m_brEdit;		// _~[uV
	default:
		break;
	}	
	// TODO: ftHg̃uV]݂̂̂łȂꍇɂ́AႤuVԂĂ
	return hbr;
}

BOOL CSpeechOprDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	m_brEdit.CreateSolidBrush(RGB(0,80,0));
	GetDlgItem(IDC_BUTTON_STOP)->EnableWindow(FALSE);
	
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CSpeechOprDlg::OnButtonRefresh() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	ViewSentence();
}

void CSpeechOprDlg::OnButtonStop() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	// R[obN֐̌ĂяoB
	EnumWindows(EnumWindowsProc, (LPARAM)&m_piExe);

	::CloseHandle(m_piExe.hThread);
	::CloseHandle(m_piExe.hProcess);
}
