// TTSCtrl.cpp: CTTSCtrl NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "kiosk.h"
#include "TTSCtrl.h"
#include "FSMCtrl.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

extern BOOL CALLBACK EnumWindowsProc(HWND hWnd, LPARAM lParam);

//
// CTTSCtrl::CCmdSpeech
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CTTSCtrl::CCmdSpeech::CCmdSpeech( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CTTSCtrl::CCmdSpeech::~CCmdSpeech()
{
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CTTSCtrl::CCmdSpeech::Execute()
{
	CTTSCtrl* pCtrl = static_cast< CTTSCtrl* >( m_pModality );
	pCtrl->Lock( true );

	string text,endsync;
	bool bEndsync;

	if( !GetParamValue( "name", "text", text ) )
	{
		Error( this, "o̓eLXgȂ" );
		return RESULT_FAILED;
	}
	if( !GetParamValue( "name", "endsync", endsync ) )
	{
		//ftHg"on"
		endsync = "on";
	}

	if(endsync.compare("on") == 0)
		bEndsync = true;
	else
	{
		SetEndState( COutputCommand::_ENDOUTPUT_NORMAL );
		pCtrl->SetState(true);
		bEndsync = false;
	}

	return pCtrl->Speak( text.c_str(), bEndsync );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CTTSCtrl::CCmdSpeech::Terminate()
{
	CTTSCtrl* pCtrl = static_cast< CTTSCtrl* >( m_pModality );
	if( pCtrl->IsSpeaking() )
	{
		pCtrl->Stop();
		m_EndState = _ENDOUTPUT_INTERRUPT;
	}	
	return RESULT_SUCCEEDED;
}

//
// CTTSCtrl::CCmdSpeaker
//

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CTTSCtrl::CCmdSpeaker::CCmdSpeaker( COutputModality* modality, const string& count, bool bargein, const string& path, const string& event, const CVariables& vars, list < COutputParam >& pars ) : COutputCommand( modality, count, bargein, path, event, vars, pars )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CTTSCtrl::CCmdSpeaker::~CCmdSpeaker()
{
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CTTSCtrl::CCmdSpeaker::Execute()
{
	CTTSCtrl* ctrl = static_cast< CTTSCtrl* >( m_pModality );
	ctrl->Lock ( true );

	string strSpeaker;
	if( !GetParamValue( "name", "speaker", strSpeaker ) ){ return RESULT_FAILED; }

	ctrl->SetSpeaker( strSpeaker.c_str() );

	m_EndState = _ENDOUTPUT_NORMAL;
	return RESULT_SUCCEEDED;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
EXECRESULT CTTSCtrl::CCmdSpeaker::Terminate()
{
	return RESULT_SUCCEEDED;
}

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////
const char* CTTSCtrl::_TYPE_TTS = "tts";
const char* CTTSCtrl::_EVENT_SPEECH = "speech";
const char* CTTSCtrl::_EVENT_SPEAKER = "speaker";

CTTSCtrl::CTTSCtrl( COutputManager* om, int ModalityID, CProcessTracer* tracer ) : COutputModality( om, ModalityID ), m_SSMClient(this), m_pProcessTracer( tracer )
{
	m_pProcessTracer->Write( "TTSǗ", " - " );
	if( Regist() )
	{
		m_pProcessTracer->AppendLine( " - o͊Ǘɓo^" );
	}
	m_pProcessTracer->AppendLine( " - gtalkN" );

	CWinApp *pApp = AfxGetApp();
	CString strGTalk = pApp->GetProfileString("SSM","Path",NULL);
	CString strCurrent = strGTalk.Left(strGTalk.ReverseFind('\\')+1);
	CString strSsmconf = pApp->GetProfileString("SSM","ConfigFile",NULL);
	int nPort = pApp->GetProfileInt("SSM","Port",0);
	CString strCmdLine;
	if(strSsmconf.Find("..\\..\\")==-1){
		//ssm.conf΃pXŐݒ肳ĂȂ
		strCmdLine.Format("%s -C %s -p %d ",strGTalk,strSsmconf,nPort);
	}
	else{
		//ssm.conf΃pXŐݒ肳Ă鎞
		strCmdLine.Format("%s -C ssm.conf -p %d ",strGTalk,nPort);
	}
	//strCmdLine.Format("%s -C \"C:\\Program Files\\gtalk\\ssm.conf\" -p %d",strGTalk,nPort);
	//strCmdLine.Format("%s -C ssm.conf -p %d",strGTalk,nPort);

	STARTUPINFO si;
    // CreateProcess()̈ݒ
    ZeroMemory(&si, sizeof(STARTUPINFO));
    ZeroMemory(&m_piSSM, sizeof(PROCESS_INFORMATION));
    si.cb = sizeof(STARTUPINFO);
    si.dwFlags = STARTF_USESHOWWINDOW;
    si.wShowWindow = SW_MINIMIZE;
//*
    if(!CreateProcess(NULL,
			strCmdLine.GetBuffer(strCmdLine.GetLength()),
//            _T("D:\\IPA\\engine\\SSM\\gtalk\\Release\\gtalk.exe"),
            NULL,
            NULL,  
            FALSE,  
            0,  
            NULL,  
            strCurrent,//_T("D:\\IPA\\engine\\SSM\\gtalk\\Release\\"),
            &si,  
            &m_piSSM)){
		pApp->WriteProfileInt("ENGINE","Validate",0);
        AfxMessageBox(_T("gtalkNł܂ł\nċNƐݒ_CAO\܂"));  
	}
	strCmdLine.ReleaseBuffer();
	strSsmconf.ReleaseBuffer();
	strGTalk.ReleaseBuffer();
	strCurrent.ReleaseBuffer();
//*/
	m_pProcessTracer->AppendLine( " - " );
}

CTTSCtrl::~CTTSCtrl()
{
	m_pProcessTracer->Write( "TTSǗ", " - ..." );
	if( Release() )
	{
		m_pProcessTracer->AppendLine( " - o͊Ǘ폜" );
	}
	m_pProcessTracer->AppendLine( " - " );
	m_SSMClient.Stop();

	// R[obN֐̌ĂяoB
//	EnumWindows(EnumWindowsProc, (LPARAM)&m_piSSM);

//	::CloseHandle(m_piSSM.hThread);
//	::CloseHandle(m_piSSM.hProcess);

	m_pProcessTracer->AppendLine( " - TTSGW~" );
	
	m_pProcessTracer->AppendLine( " - " );
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
COutputCommand* CTTSCtrl::StoreCommand( const string& msg )
{
	m_pProcessTracer->Write( "TTSǗ", "<output>̉" );
	m_pProcessTracer->AppendLine( msg.c_str() );

	// <parameter>...</parameter>
	string count, event, path;
	bool bargein;
	CVariables vars;
	list < COutputParam > pars;

	if( !AnalyzeOutput( msg, count, bargein, path, event, vars, pars ) ){ return NULL; }

	COutputCommand* pCmd = NULL;
	if( event == _EVENT_SPEECH )
	{
		CCmdSpeech* pSpeech = new CCmdSpeech( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = static_cast< COutputCommand* >( pSpeech );
	}
	else if( event == _EVENT_SPEAKER )
	{
		CCmdSpeaker* pSpeaker = new CCmdSpeaker( static_cast< COutputModality* >( this ), count, bargein, path, event, vars, pars );
		pCmd = pSpeaker;
	}
	else
	{
		m_pProcessTracer->AppendLine( " - <output>" );
		return NULL;
	}

	m_Cmdlist.push_back( pCmd );

	return pCmd;

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CTTSCtrl::Execute()
{
	m_pProcessTracer->Write( "TTSǗ", " - <output>̎s" );
	COutputModality::Execute();
//	list < COutputCommand* > :: iterator ite = m_Cmdlist.begin();
//	if( (*ite)->GetEndState() == COutputCommand::_ENDOUTPUT_NORMAL )
//	{
//		Finish();
//	}
	return true;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
bool CTTSCtrl::Terminate()
{
	if(m_Cmdlist.empty())
	{
		m_pProcessTracer->Write( "TTSǗ", " - ~<output>͂܂" );
		return true;
	}
	m_pProcessTracer->Write( "TTSǗ", " - <output>̋~" );
	(*m_Cmdlist.begin())->Terminate();
	return true;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
string CTTSCtrl::GetTypeAttribute()
{
	return _TYPE_TTS;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
list < string > CTTSCtrl::GetEventAttribute()
{
	list < string > event;
	event.push_back( _EVENT_SPEECH );
	event.push_back( _EVENT_SPEAKER );
	return event;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CTTSCtrl::OnSpeakFinished()
{
	if(m_Cmdlist.empty())
		return;

	list < COutputCommand* > :: iterator ite = m_Cmdlist.begin();
	COutputCommand* pCmd = ( *ite );

	if( pCmd->GetEndState() != COutputCommand::_ENDOUTPUT_INTERRUPT )
	{
		pCmd->SetEndState( COutputCommand::_ENDOUTPUT_NORMAL );
	}

	Finish();
}

void CTTSCtrl::OnSpeakReady(LPCTSTR lpszPho)
{
}

void CTTSCtrl::ConnectFSM(CFSMCtrl *pFSMCtrl)
{
	m_SSMClient.m_pFSMCtrl = pFSMCtrl;
	pFSMCtrl->m_pSSMClient = &m_SSMClient;
}

BOOL CTTSCtrl::ConnectEngine()
{
	m_pProcessTracer->Write( "SSǗ", " - gtalkɐڑ" );
	int nRet = m_SSMClient.Initialize();
	if(nRet == -1)
	{
		m_pProcessTracer->AppendLine( " - \Pbg쐬s" );
		return FALSE;
	}
	else if(nRet == -2)
	{
		m_pProcessTracer->AppendLine( " - ڑvs" );
		return FALSE;
	}

	m_SSMClient.Run();
//	m_SSMClient.SetText("<VOLUME LEVEL=\"0.1\">ɂ</VOLUME>",false);
//	Speak("ĂVXeւ悤",false);
	m_pProcessTracer->AppendLine( " - MXbhJn" );
	return TRUE;
}

EXECRESULT CTTSCtrl::Speak( LPCSTR lpszText, bool bEndsync )
{
	m_SSMClient.SetText(lpszText);
	if(bEndsync)
		return RESULT_CONTINUE;
	else
		return RESULT_SUCCEEDED;
}

EXECRESULT CTTSCtrl::SetSpeaker( LPCSTR lpszSpeaker )
{
	m_SSMClient.SetSpeaker(lpszSpeaker);
	return RESULT_SUCCEEDED;
}

BOOL CTTSCtrl::IsSpeaking()
{
	if(m_SSMClient.IsSpeaking())
		return TRUE;
	else
		return FALSE;
}

void CTTSCtrl::Stop()
{
	m_SSMClient.StopSpeak();
}
