//
// MMIVXe Ver.1.1 tgGh
// XISL̕ϐǗ
//
// Variable.h / Variable.cpp
//
// 2002/12/10 Tue. G
//
//
//

#include "StdAfx.h"
#include "Variables.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

using namespace std;

//
// CVariables
//

const char* CVariables::_UNDEFINED = "undefined";

//
// ֐ : CVariables::CVariavle()
// @  \ : 
//    : 
// ߂l : 
//
CVariables::CVariables() : m_VarName(), m_VarValue()
{

}

//
// ֐ : CVariables::CVariavle()
// @  \ : 
//    : 
// ߂l : 
//
CVariables::CVariables( const CVariables& variable ) : m_VarName( variable.m_VarName ), m_VarValue( variable.m_VarValue )
{

}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
CVariables::~CVariables()
{
	m_VarName.clear();
	m_VarValue.clear();
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : 
//
void CVariables::Clear()
{
	m_VarName.clear();
	m_VarValue.clear();
}

//
// ֐ : 
// @  \ : w肵ʒu̕ϐ擾
//    : index - wʒuireturn̋Lqj
// ߂l :  ϐ s NULL
//
const string* CVariables::GetName( const int index ) const
{
	if( index < 0 ){ return NULL; }

	map < int, string > :: const_iterator c_ite = m_VarName.find( index );
	if( c_ite == m_VarName.end() )
	{
		return NULL;
	}
	return &( c_ite->second );
}

//
// ֐ : 
// @  \ : w肵ʒu̕ϐ̒l擾
//    : index - wʒuireturn̋Lq
// ߂l :  ϐ̒l s NULL
//
const string* CVariables::GetValue( const int index ) const
{
	if( index < 0 ){ return NULL; }

	map < int, string > :: const_iterator c_ite = m_VarValue.find( index );
	if( c_ite == m_VarValue.end() )
	{
		return NULL;
	}
	return &( c_ite->second );
}

//
// ֐ : 
// @  \ : w肵ϐ̒l擾
//    : name - wϐ
// ߂l :  ϐ̒l s NULL
//
const string* CVariables::GetValue( const string& name ) const
{
	if( m_VarName.size() != m_VarValue.size() ){ return NULL; }
	
	int index = 0;
	map < int, string > :: iterator ite = const_cast< map < int, string >& >( m_VarName ).begin();
	while( ite != const_cast< map < int, string >& >( m_VarName ).end() && ite->second != name )
	{
		ite++;
		index++;
	}

	map < int, string > :: const_iterator c_ite = m_VarValue.find( index );
	if( c_ite != m_VarValue.end() )
	{
		return &( c_ite->second );
	}
	
	return NULL;
}

//
// ֐ : 
// @  \ : o^Ăϐ̐Ԃ
//    : 
// ߂l : 
//
int CVariables::GetSize() const
{
	if( m_VarName.size() != m_VarValue.size() )
	{
		return -1;
	}
	return m_VarName.size();	
}

//
// ֐ : 
// @  \ : Vϐǉ
//    : name - ϐ
//        : value - ϐ̒l
//        : position - returnł̈ʒu
// ߂l :  true s false
//
bool CVariables::Add( const string& name, const string& value, const int position )
{
	if( position < 0 ){ return false; }

	m_VarName.insert( pair< int, string >( position, name ) );
	m_VarValue.insert( pair< int, string >( position, value ) );

	if( m_VarName.size() != m_VarValue.size() )
	{
		return false;
	}
	return true;
}

//
// ֐ : 
// @  \ : w肵ϐ̒lZbg
//    : name - lZbgϐ
//		 F value - Zbgl
// ߂l : 
//
bool CVariables::SetValue( const string& name, const string& value )
{
	if( m_VarName.size() != m_VarValue.size() ){ return false; }
	
	int index = 0;
	map < int, string > :: iterator ite = m_VarName.begin();
	while( ite->second != name )
	{
		ite++;
		index++;
	}

	map < int, string > :: const_iterator c_ite = m_VarValue.find( index );
	if( c_ite == m_VarValue.end() )
	{
		return false;
	}
	m_VarValue[index] = value;
	return true;
}

//
// ֐ : 
// @  \ : w肵ʒu̕ϐ̖OZbg
//    : position - OZbgϐ̈ʒu
//		 F name - Zbg閼O
// ߂l : 
//
bool CVariables::SetName( const int position, const string& name )
{
	map < int, string > :: const_iterator c_ite = m_VarName.find( position );
	if( c_ite == m_VarName.end() )
	{
		return false;
	}
	m_VarName[position] = name;

	return true;
}

//
// ֐ : 
// @  \ : w肵ʒu̕ϐɒlZbg
//    : position - lZbgϐ̈ʒu
//		 F value - Zbgl
// ߂l : 
//
bool CVariables::SetValue( const int position, const string& value )
{
	map < int, string > :: const_iterator c_ite = m_VarValue.find( position );
	if( c_ite == m_VarValue.end() )
	{
		return false;
	}
	m_VarValue[position] = value;

	return true;
}

//
// ֐ : 
// @  \ : ϐƈʒû݂̔rZ
//    : 
// ߂l : 
//
bool CVariables::operator == ( const CVariables& variable )
{
	if( &variable == this ){ return true; }
	
	if( this->m_VarName.size() == variable.m_VarValue.size() )
	{
		map < int, string > :: iterator ite = m_VarName.begin();
		map < int, string > :: iterator ite2 = const_cast< CVariables& >( variable ).m_VarName.begin();

		while( ite != m_VarName.end() )
		{
			//if( static_cast< string& >( ite->second ) != static_cast< string& >( ite2->second ) )
			if( ite->second != ite2->second )
			{
				return false;
			}
			ite++;
			ite2++;
		}
		return true;	
	}
	return false;
}

//
// ֐ : 
// @  \ : 
//    : 
// ߂l : sint^̗O𓊓
//
CVariables& CVariables::operator = ( const CVariables& variable )
{
	if( &variable == this ){ return *this; }

	CVariables& var = const_cast< CVariables& >( variable );
	map < int, string > :: iterator ite_var = var.m_VarName.begin();
	map < int, string > :: iterator ite_pos = var.m_VarValue.begin();

	m_VarName.clear();
	m_VarValue.clear();

	while( ite_var != var.m_VarName.end() )
	{
		m_VarName.insert( pair< int, string >( ite_var->first, ite_var->second ) );
		ite_var++;
	}

	while( ite_pos != var.m_VarValue.end() )
	{
		m_VarValue.insert( pair< int, string >( ite_pos->first, ite_pos->second ) );
		ite_pos++;
	}

	if( m_VarName.size() != m_VarValue.size() )
	{
		throw -1;
	}

	return *this;
}

//
// ֐ : 
// @  \ : ϐXML`ŕԂ
//    : 
// ߂l : ϐꍇ͋string
//
string CVariables::toXML()
{
	if( m_VarName.size() == m_VarValue.size() && m_VarName.size() > 0 )
	{
		string ret = "<return_list>";
		string param;
		map < int, string > :: iterator ite_name = m_VarName.begin();
		map < int, string > :: iterator ite_value = m_VarValue.begin();

		while( ite_name != m_VarName.end() )
		{
			param = "<return name=\"" + static_cast< string& >( ite_name->second ) + "\">";
			param += static_cast< string& >( ite_value->second );
			param += "</return>";
			ret += param;
			ite_name++;
			ite_value++;
		}

		ret += "</return_list>";
		return ret;
	}
	return "";
}

//
// ֐ : 
// @  \ : ϐXISL̋Lq`ŕԂ
//    : blank - ϐȂreturnԂ 
// ߂l : ϐꍇ true return="" false string
//
string CVariables::toXISL( bool blank )
{
	string ret;
	map < int, string > :: iterator ite = m_VarName.begin();
	while( ite != m_VarName.end() )
	{
		ret += ite->second;
		ret += ",";
		ite++;
	}
	if( m_VarName.size() != 0 )
	{
		ret.replace( ret.find_last_of( "," ), 1, "\"" );
		ret.insert( 0, "return=\"" );
		return ret;
	}
	else if( blank )
		return "return=\"\"";
	else
		return "";
}
