#ifndef __CONTROLTIME_H__
#define __CONTROLTIME_H__

// Ԋl̂߂Include
#ifdef WIN32
#include <windows.h>
#include <process.h>
#include <mmsystem.h>
#else
#include <sys/time.h>
#include <unistd.h>
#endif

#ifdef WIN32
#pragma warning (disable: 4786)
#endif

#include <iostream>
#include <vector>
#include <string>

class ControlTime {

public:
	ControlTime();
	~ControlTime() {}

private:

#ifdef WIN32
	int m_dStartTime, m_dNowTime;
#else
	timeval m_dStartTime, m_dNowTime;
#endif

#ifndef WIN32
struct timezone m_tz; 
#endif

	int m_iDurTime;

public:
	void Initialize();

	void SetStartTime();
	void SetNowTime();
	void SetDurTime();
	void SetDurTime( int i ) { m_iDurTime = i; }

	int GetDurTime() { return m_iDurTime; }
	int GetDurTimeWithProcess() {
		SetNowTime();
		SetDurTime();
		return m_iDurTime;
	}

	void SleepTime(int ms);
	void GetStartTime(int &ms, int &ss, int &mm, int &hr, int &day);
};


#endif //__CONTROLTIME_H__