#ifndef __DIALOG_EDIT_H__
#define __DIALOG_EDIT_H__

#ifndef __CPOINT__
#define __CPOINT__

class CPoint
{
public:
	int x;
	int y;
};

#endif  __CPOINT__

class Document;

class DialogEdit
{

public:
	// user definition function
	void SetupWindow();
	void SetRenewalInfo() { m_bDocNew = m_bEyeCLFlg = true; }
	void SetRecreateEyeCallList() { m_bEyeCLFlg = true; }
	
	DialogEdit(Document *pDoc, int *w, int *h);
	~DialogEdit();
	
	int w() { return *m_pWidth; }
	int h() { return *m_pHeight; }

	void redraw();

	bool GetLButtonDown() { return m_bLButtonDown; }
	bool GetRButtonDown() { return m_bRButtonDown; }
	bool GetMButtonDown() { return m_bMButtonDown; }
	void GetPoint( int &x, int &y ) { x = m_point.x; y = m_point.y; }
	
	void SetLButtonDown(bool flag) { m_bLButtonDown = flag; }
	void SetRButtonDown(bool flag) { m_bRButtonDown = flag; }
	void SetMButtonDown(bool flag) { m_bMButtonDown = flag; }
	void SetPoint( int x, int y ) { m_point.x = x; m_point.y = y; }

		
	void LeftMousePushEvent(int x, int y, int status);
	void RightMousePushEvent(int x, int y, int status);
	void MidMousePushEvent(int x, int y, int status);
	void LeftMouseReleaseEvent(int x, int y, int status);
	void RightMouseReleaseEvent(int x, int y, int status);
	void MidMouseReleaseEvent(int x, int y, int status);
	void MouseDragEvent(int x, int y, int status);

	void ResetTrans() { 	
		m_trans[0] = m_trans[1] = m_trans[2] = m_rot[0] = m_rot[1] = m_rot[2] = 0.0;
		m_scale = 1.0;
	}


private:
	Document *m_pDoc;

	// window size
	int *m_pWidth;
	int *m_pHeight;

	// mouse status members
	CPoint m_point;								// mouse point
	bool   m_bLButtonDown, m_bRButtonDown, m_bMButtonDown;		// mouse button status
	bool   m_bDocNew;							// document new info
	bool   m_bDestroy;							// destroy flag
	bool   m_bEyeCLFlg;							// eye call list flag
	
	// GL list enumeration
	enum { 
		TEXTUER_RENEWAL_LIST = 500,
	EYE_RENEWAL_LIST,
	MOUTHWALL_RENEWAL_LIST,
	};
	
	// object position
	double m_trans[3];
	double m_rot[3];
	double m_scale;
	
	bool SetupViewport();
	bool SetupViewingFrustum(int cx, int cy);
	bool SetupViewingTransform();
	bool DrawOpenGL();
};

#endif //__DIALOG_EDIT_H__
