#ifndef __RESOURCE_EYE_H__
#define __RESOURCE_EYE_H__

#define EYE_SLIDER_WIDTH	90
#define EYE_SLIDER_HEIGHT	20
#define EYE_SLIDER_DUR		20
#define EYE_SLIDER_X_POS	EDITOR_WIDTH - (EYE_SLIDER_WIDTH + EYE_SLIDER_HEIGHT) * 2
#define EYE_SLIDER_Y_POS	(EYE_SLIDER_HEIGHT + EYE_SLIDER_DUR) * 5
#define EYE_SLIDER_FONT_COLOUR   1,1,1,1
#define EYE_SLIDER_BIG_BUTTON		80

#define EDITOR_BTN_WIDTH	90
#define EDITOR_BTN_HEIGHT	20
#define EDITOR_BTN_DUR		20

//////////
// Define Eye Editor 
void editor_eye_sld_trans_z_l_cb(puObject *);
void editor_eye_sld_trans_z_r_cb(puObject *);
void editor_eye_sld_rot_x_left_cb(puObject *);
void editor_eye_sld_rot_x_right_cb(puObject *);
void editor_eye_sld_rot_y_left_cb(puObject *);
void editor_eye_sld_rot_y_right_cb(puObject *);
void editor_eye_sld_scale_cb(puObject *);
void editor_eye_button_save_cb(puObject *);

static char *EDITOR_EYE_SLIDER_LABEL[] = {
	"LEFT", "RIGHT", 
};

static char *EDITOR_EYE_SLIDER_NAME[] = {
	"Trans - Z axis",
		"Rot - X axis",
		"Rot - Y axis",
		"Scale - Pupil",
};

static puCallback EDITOR_EYE_SLIDER_CB[] = 
{
	editor_eye_sld_trans_z_l_cb,
		editor_eye_sld_trans_z_r_cb,
		editor_eye_sld_rot_x_left_cb,
		editor_eye_sld_rot_x_right_cb,
		editor_eye_sld_rot_y_left_cb,
		editor_eye_sld_rot_y_right_cb,
		editor_eye_sld_scale_cb,
};
enum {
	EDITOR_EYE_SLIDER_TRANS_Z_LEFT,
		EDITOR_EYE_SLIDER_TRANS_Z_RIGHT,
		EDITOR_EYE_SLIDER_ROT_X_LEFT,
		EDITOR_EYE_SLIDER_ROT_X_RIGHT,
		EDITOR_EYE_SLIDER_ROT_Y_LEFT,
		EDITOR_EYE_SLIDER_ROT_Y_RIGHT,
		EDITOR_EYE_SLIDER_SCALE,
		EDITOR_EYE_SLIDER_NUM,
};

extern puText *editor_eye_text[2];
extern puSlider *editor_eye_sld[EDITOR_EYE_SLIDER_NUM];
extern puOneShot *eye_slider_button_save;
//  Define Eye Editor
//////////

//////////
// Define EDITOR_RESET_BUTTON
void editor_btn_close_editor_cb(puObject *);
void editor_btn_reset_trans_cb(puObject *);
void editor_btn_reset_window_cb(puObject *);


static char *EDITOR_BUTTON_NAME[] = {
	"Close Editor",
	"Reset Trans",
		"Reset Window",
};

static puCallback EDITOR_BUTTON_CB[] = {
	editor_btn_close_editor_cb,
	editor_btn_reset_trans_cb,
		editor_btn_reset_window_cb,
};

enum {
	EDITOR_BUTTON_CLOSE_EDITOR,
	EDITOR_BUTTON_RESET_TRANS,
		EDITOR_BUTTON_RESET_WINDOW,
		EDITOR_BUTTON_NUM,
};

extern puOneShot *editor_b[EDITOR_BUTTON_NUM];

// Define EDITOR_RESET_BUTTON
//////////



#endif //__RESOURCE_EYE_H__
